#include "StringBuffer.h"
#include <string.h>
#include "Log.h"

SINGLETON_STATIC_INSTANCE(StringBuffer)

StringBuffer::StringBuffer()
        :size(512), used(0), memReallocated(false)
{
        buffer = new char[size];
        memset(buffer, 0, size);
}

StringBuffer::StringBuffer(int allocateSize)
        :size(allocateSize), used(0), memReallocated(false)
{
        buffer = new char[size];
        memset(buffer, 0, size);
}

char * StringBuffer::addString(const char * src)
{
        int len = strlen(src) + 1;
        char * str;

        if (used + len > size) {
                if (size <= 0)
                        size = 512;
                else
                        size *= 2;

                char * tmp = new char[size];
                memset(tmp, 0, size);
                memcpy(tmp, buffer, used);
                delete []  buffer;
                for (std::map<char *, char *>::iterator it = stringAddrMap.begin(); it != stringAddrMap.end(); it++) {
                        it->second = tmp + (it->second - buffer);
                }
                buffer = tmp;
                memReallocated = true;
        }

        str = buffer + used;
        memcpy(str, src, len - 1);
        used += len;
        stringAddrMap[str] = str;
        return str;
}
