#include "ISHPressure.h"
#include "Log.h"

// LUID: 0031000100060002

struct pressure_raw {
        int64_t timestamp;
        int64_t timestamp0;
        uint32_t pressure;
} __attribute__ ((packed));

struct pressure_aware {
        int64_t timestamp;
        uint32_t pressure;
} __attribute__ ((packed));

ISHPressure::ISHPressure(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHPressure::ISHPressure(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHPressure::~ISHPressure()
{

}

void ISHPressure::initialize()
{
        if (information.scale_android.size() == 1) {
                scaleX = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scaleX);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
        }
}

size_t ISHPressure::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct pressure_raw);

        if (bufSize % sizeof(struct pressure_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct pressure_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct pressure_aware));

        const struct pressure_raw *pressure = reinterpret_cast<const struct pressure_raw *>(buf);
        struct pressure_aware *aware = reinterpret_cast<struct pressure_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = pressure[i].timestamp * US_TO_NS;
                aware[i].pressure = pressure[i].pressure;
        }

        return count * sizeof(struct pressure_aware);
}

size_t ISHPressure::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct pressure_raw);

        if (bufSize % sizeof(struct pressure_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct pressure_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct pressure_raw *pressure = reinterpret_cast<const struct pressure_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = pressure[i].timestamp * US_TO_NS;
                mEvents[i].pressure = pressure[i].pressure * scaleX;
        }
        return count;
}
