#include "ISHGeomagneticRotationVector.h"
#include "Log.h"

// LUID: 0201000000000000

struct geomagnetic_rotation_vector_raw {
        int64_t timestamp;
        int64_t timestamp0;
        short x;
        short y;
        short z;
        short w;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct geomagnetic_rotation_vector_data {
        int64_t timestamp;
        int64_t timestamp0;
        short x;
        short y;
        short z;
        short w;
} __attribute__ ((packed));


ISHGeomagneticRotationVector::ISHGeomagneticRotationVector(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHGeomagneticRotationVector::ISHGeomagneticRotationVector(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHGeomagneticRotationVector::~ISHGeomagneticRotationVector()
{

}

void ISHGeomagneticRotationVector::initialize()
{
        if (information.scale_android.size() == 4) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                scaleW = information.scale_android[3];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
                scaleW = 1.0;
        }
}

size_t ISHGeomagneticRotationVector::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct geomagnetic_rotation_vector_raw);

        if (bufSize % sizeof(struct geomagnetic_rotation_vector_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct geomagnetic_rotation_vector_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct geomagnetic_rotation_vector_raw *geomagnetic_rotation_vector = reinterpret_cast<const struct geomagnetic_rotation_vector_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = geomagnetic_rotation_vector[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = geomagnetic_rotation_vector[i].x * scaleX;
                mEvents[i].data[1] = geomagnetic_rotation_vector[i].y * scaleY;
                mEvents[i].data[2] = geomagnetic_rotation_vector[i].z * scaleZ;
                mEvents[i].data[3] = geomagnetic_rotation_vector[i].w * scaleW;
        }
        return count;
}
