#include "ISHInfraredGesture.h"
#include "Log.h"

// sc_sensor_type: 0x9be1

struct infrared_gesture_raw {
        int64_t timestamp;
        int64_t timestamp0;
        uint32_t infrared_gesture;
} __attribute__ ((packed));

ISHInfraredGesture::ISHInfraredGesture(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHInfraredGesture::ISHInfraredGesture(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHInfraredGesture::~ISHInfraredGesture()
{

}

void ISHInfraredGesture::initialize()
{
        if (information.scale_android.size() == 1) {
                scale = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scale);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scale = 1.0;
        }
}

size_t ISHInfraredGesture::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct infrared_gesture_raw);

        if (bufSize % sizeof(struct infrared_gesture_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct infrared_gesture_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct infrared_gesture_raw *infrared_gesture = reinterpret_cast<const struct infrared_gesture_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = infrared_gesture[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = infrared_gesture[i].infrared_gesture * scale;
        }

        return count;
}
