#include "ISHPulseOximetry.h"
#include "Log.h"

// sc_sensor_type: 0x222

struct _spo2_data_t {
        int64_t timestamp;
        int64_t timestamp0;
        uint16_t peripheral_oxygen_saturation;
}__attribute__ ((packed));

ISHPulseOximetry::ISHPulseOximetry(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHPulseOximetry::ISHPulseOximetry(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHPulseOximetry::~ISHPulseOximetry()
{

}

void ISHPulseOximetry::initialize()
{
        if (information.scale_android.size() == 1) {
                scale = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scale);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scale = 1.0;
        }
}

size_t ISHPulseOximetry::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct _spo2_data_t);

        if (bufSize % sizeof(struct _spo2_data_t) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct _spo2_data_t));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct _spo2_data_t *peripheral_oxygen_saturation = reinterpret_cast<const struct _spo2_data_t *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = peripheral_oxygen_saturation[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = peripheral_oxygen_saturation[i].peripheral_oxygen_saturation * scale;
        }

        return count;
}
