#ifndef _ISH_SENSOR_H_
#define _ISH_SENSOR_H_

#include "Sensor.h"
#include <string>
#include <set>
#include <vector>
#include <list>
#include <string.h>
#include "StringBuffer.h"
#include "ish/utils/smhi_client.h"

#define MAX_STRING_LENGTH 256

#define SENSOR_COLLECTION_DIR               "/sys/bus/platform/devices/sensor_collection/"
#define SENSOR_DIR_FORMAT                   SENSOR_COLLECTION_DIR "sensor_%X_def/"
#define SENSOR_PROP_DIR_FORMAT              SENSOR_DIR_FORMAT "properties/"
#define SENSOR_PROP_VALUE_FORMAT            SENSOR_PROP_DIR_FORMAT "%s/value"
#define SENSOR_PRIVATE_PROP_VALUE_FORMAT    SENSOR_PROP_DIR_FORMAT "custom-%X/value"
#define SENSOR_DATA_FIELDS_DIR_FORMAT       SENSOR_DIR_FORMAT "data_fields/"
#define SENSOR_FLUSH_NODE_FORMAT            SENSOR_DIR_FORMAT "flush"
#define PROPERTY_FRIENDLY_NAME              "property_friendly_name"
#define PROPERTY_MINIMUM_REPORT_INTERVAL    "property_minimum_report_interval"
#define PROPERTY_POWER_STATE                "property_power_state"
#define PROPERTY_REPORT_INTERVAL            "property_report_interval"
#define PROPERTY_REPORT_INTERVAL_RESOLUTION "property_report_interval_resolution"
#define PROPERTY_REPORTING_STATE            "property_reporting_state"
#define PROPERTY_SENSOR_CONNECTION_TYPE     "property_sensor_connection_type"
#define PROPERTY_SENSOR_DESCRIPTION         "property_sensor_description"
#define PROPERTY_SENSOR_MANUFACTURER        "property_sensor_manufacturer"
#define PROPERTY_SENSOR_MODEL               "property_sensor_model"
#define PROPERTY_SENSOR_SERIAL_NUMBER       "property_sensor_serial_number"
#define PROPERTY_SENSOR_STATE               "property_sensor_state"
#define PROPERTY_SHARED_FIFO_COUNT          "unknown-31A"
#define PROPERTY_SENSITIVITY_SUFFIX         "_chg_sensitivity_"

#define USAGE_SENSOR_PROPERTY_POWER_STATE_D0_FULL_POWER_ENUM            0x02
#define USAGE_SENSOR_PROPERTY_POWER_STATE_D1_LOW_POWER_ENUM             0x03

#define USAGE_SENSOR_PROPERTY_REPORTING_STATE_NO_EVENTS_ENUM            0x01
#define USAGE_SENSOR_PROPERTY_REPORTING_STATE_ALL_EVENTS_ENUM           0x02
#define USAGE_SENSOR_PROPERTY_REPORTING_STATE_ALL_EVENTS_WAKE_ENUM      0x05

#define PSEUSDO_EVENT_BIT  (1 << 31)
#define FLUSH_COMPLETE_BIT (1 << 0)

#define SENSITIVITY_DEFAULT (1)

struct sensor_colloection_data_t {
        unsigned int id;
        unsigned int size;
        char buf[0];
} __attribute__((packed));

struct ish_private_data_t {
        char luid_string[LUID_STRING_LENGTH + 1]; // 1 byte for string end.
        sc_sensor_luid luid;
        unsigned int serial_number;
        int sensitivity;
        unsigned int minimum_report_interval;
        std::string friendly_name;
        std::set<unsigned int> private_property_usage_ids;
        ish_private_data_t()
        {
                memset(luid_string, 0, LUID_STRING_LENGTH + 1);
                memset(&luid, 0, sizeof(sc_sensor_luid));
                serial_number = 0;
                sensitivity = SENSITIVITY_DEFAULT;
                minimum_report_interval = 0;
        }
};

#define ISH_PRIVATE_PROPERTY (1)
#define ISH_SMHI_PROPERTY    (2)

struct ish_private_property {
        unsigned int usage_id;
        int property_value;
} __attribute__ ((packed));

class ISHSensor : public Sensor {
protected:
        ish_private_data_t privateData;
        StringBuffer &mStringBuffer;
        char stringBuffer[MAX_STRING_LENGTH];
        char valueBuffer[MAX_STRING_LENGTH];
        sensors_meta_data_event_t metaEvent;
        static const std::set<std::string> propertySet;
        std::multimap<Session *, struct ish_private_property> privatePropertiesTable;
        std::list<struct ish_private_property> currentPrivateProperties;
        bool checkHIDCommonPropertyValid(const char *propertyName);
        bool setHIDCommonProperty(const char *propertyName, const char *propertyValue, int propertyLength);
        bool getHIDCommonProperty(const char *propertyName, std::string &propertyValue);
        bool arbitratePrivateProperty(Session *session, struct ish_private_property *private_property);
        bool setPrivateProperty();
        size_t getPrivateProperty(unsigned int usage_id, void **property);
        bool setSMHIProperty(unsigned char *buf, int len);
        virtual bool startStopImpl(bool start);
        bool  setSensitivity(const char *name, const unsigned int value);
        bool  setSensitivity(const unsigned int value);
public:
        ISHSensor(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data);
        ISHSensor(const Sensor * refSensor, const uint32_t serial_number);
        virtual bool startStreaming(Session * session, int64_t samplingPeriodUs, int64_t maxReportLatencyUs);
        virtual void removeSession(Session *session);
        virtual bool stopStreaming(Session * session);
        virtual bool flushStreaming(Session * session);
        virtual bool setProperty(Session * session, void * property, size_t size);
        virtual size_t getProperty(Session * session, void * command, size_t commandSize, void **property);
        virtual size_t convertToEvent(const char * buf, size_t bufSize) = 0;
        virtual size_t convertToStreaming(const char * buf, size_t bufSize);
        virtual void handleEvents(int fd);
        virtual void handleEvents(const char * buf, size_t bufSize);
        virtual void setHandle(int handle) {
                device.handle = handle;
                metaEvent.meta_data.sensor = handle;
        }
        virtual bool restartStreaming();
};

#endif
