#include "ISHStepDetector.h"
#include "Log.h"

// LUID: 0234000000000000

struct stepdetector_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int32_t step_event_counter;
        unsigned char step_type;
        int32_t step_count;
        int32_t step_duration;
        unsigned int custom_value_5;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct stepdetector_aware {
        int64_t timestamp;
        int32_t step_event_counter;
        unsigned char step_type;
        int32_t step_count;
        int32_t step_duration;
        unsigned int custom_value_5;
} __attribute__ ((packed));

ISHStepDetector::ISHStepDetector(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHStepDetector::ISHStepDetector(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHStepDetector::~ISHStepDetector()
{

}

void ISHStepDetector::initialize()
{
}

size_t ISHStepDetector::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct stepdetector_raw);

        if (bufSize % sizeof(struct stepdetector_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct stepdetector_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct stepdetector_aware));

        const struct stepdetector_raw *step_detector = reinterpret_cast<const struct stepdetector_raw *>(buf);
        struct stepdetector_aware *aware = reinterpret_cast<struct stepdetector_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = step_detector[i].timestamp * US_TO_NS;
                aware[i].step_event_counter = step_detector[i].step_event_counter;
                aware[i].step_type = step_detector[i].step_type;
                aware[i].step_count = step_detector[i].step_count;
                aware[i].step_duration = step_detector[i].step_duration;
                aware[i].custom_value_5 = step_detector[i].custom_value_5;
        }

        return count * sizeof(struct stepdetector_aware);
}

size_t ISHStepDetector::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct stepdetector_raw);

        if (bufSize % sizeof(struct stepdetector_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct stepdetector_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct stepdetector_raw *step_detector = reinterpret_cast<const struct stepdetector_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = step_detector[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = 1.0;
        }
        return count;
}
