#include "ISHUltraviolet.h"
#include "Log.h"

// sc_sensor_type: 0x250

struct _uv_data_t{
        int64_t timestamp;
        int64_t timestamp0;
	uint16_t ultraviolet;
}__attribute__ ((packed));

ISHUltraviolet::ISHUltraviolet(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHUltraviolet::ISHUltraviolet(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHUltraviolet::~ISHUltraviolet()
{

}

void ISHUltraviolet::initialize()
{

}

size_t ISHUltraviolet::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct _uv_data_t);

        if (bufSize % sizeof(struct _uv_data_t) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct _uv_data_t));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct _uv_data_t *ultraviolet = reinterpret_cast<const struct _uv_data_t *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = ultraviolet[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = ultraviolet[i].ultraviolet;
        }

        return count;
}
