#ifndef _SDT_INFO_H_
#define _SDT_INFO_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
        SC_SDT_BUS_INFO = 0,/**< Sensors are connected to ISH over different types of communication bus like I2C,SPI or UART.
                               This structure provides all the necessary information to sensor driver to configure the bus */
        SC_SDT_GPIO_INFO,/**< Sensors may want to use GPIOs for various purposes like data ready or threshold crossing. Information on exactly
                            how the specific GPIO has been configured is provided by this structure */
        SC_SDT_CALI_INFO,/**< Represents the calibration related information. Sensors are allowed to have calibration structures specific to
                            their own requirement. SC will only be responsible to pass on that structure to sensor from PDT*/
} sc_sdt_info_type_id;

typedef uint8_t sc_sdt_info_type;/**< Indicates the info type present in the SDT entry. Refer to #sc_sdt_info_type_id enum */

#pragma pack(1)

typedef struct _sc_sdt_info_entry {
        sc_sdt_info_type    info_id;   /**< SDT contains many different type of information like calibration Connectivity etc. Use values from sc_sdt_info_type_id enum */
        uint8_t reserved;   /**< reserved */
        uint16_t  data_length;   /**< Length of sdt_info_data in bytes */
        uint8_t  sdt_info_data[];   /**< Information data*/
} sc_sdt_info_entry;

#pragma pack()

#ifdef __cplusplus
}
#endif

#endif
