/*
 * CAToolsWindow.h
 *
 *  Created on: Oct 20, 2008
 *      Author: lifeng
 */

#ifndef CATOOLSWINDOW_H_
#define CATOOLSWINDOW_H_
#include <gtk/gtk.h>
#include "CAToolUtil.h"
#include "libsesdata.h"
using namespace LibSESData;
using namespace catool;
#include <glib/gi18n.h>

class CAToolsWindow
{
public:
	CAToolsWindow();
	~CAToolsWindow();

	static void OnWindowClosing(GtkDialog*, gint, gpointer);
	static void OnAssistantCloseCancel(GtkWidget*, gpointer);
	static void OnAssistantPrepare(GtkAssistant*, GtkWidget*, gpointer);
	static void SetFirstToggleActive(GtkToggleButton*, gpointer);
	static void ExportCallBack(GtkWidget*, gpointer data);

	static void BrowseCallBack(GtkWidget*, gpointer);
	static void SetEntryActive(GtkEntry*, gpointer);
	static void FirstPasswdEntryActive(GtkEntry*, gpointer);
	static void SecondPasswdEntryActive(GtkEntry*, gpointer);
	static void ExportActive(GtkEntry*, gpointer);

	void Init();
	void Run();
	void Release();
private:
	GtkWidget* m_gAssistant;
	GtkWidget* m_gUpperRadioBtn;
	GtkWidget* m_gLowerRadioBtn;
	GtkWidget* m_gSecondLabel;
	GtkWidget* m_gSecondBtn;
	GtkWidget* m_gPasswordEntry;
	GtkWidget* m_gPassWordAgainEntry;
	GtkWidget* m_gSecondVbox;
	GtkWidget* m_gCheckBtn;

	GtkWidget* m_gExportEntry;
	GtkWidget* m_gFifthLabel;
	GtkWidget* m_gFifthTitle;
	GtkWidget* m_gFifthDescription;
	GtkWidget* m_gFifthPath;
	GtkWidget* m_gFifthFiles;
	GtkWidget* m_gFifthDescriptionText;
	GtkWidget* m_gFifthPathText;
	GtkWidget* m_gFifthFilesText;

	//LibSESData::CSESDataTools* m_pCSESDataTools;
	void InitWindow();
	void CreateFirstPage(GtkWidget*);
	void CreateSecondPage(GtkWidget*);
	void CreateThirdPage(GtkWidget*);
	void CreateFourthPage(GtkWidget*);
	void CreateFifthPage(GtkWidget*);
	void TrimString(std::string& str);
	gint Close();
public:
	int m_iIsGenerateNewCA;
	CAToolUtil* m_pUtil;
	GtkWidget* m_gFilePathEntry;
	void DealWithFirstPagePrepare();
	gint DealWithSecondPagePrepare();
	gint DealWithThirdPagePrepare();
	gint DealWithFourthPagePrepare();
	void DealWithFifthPagePrepare();
};

#endif /* CATOOLSWINDOW_H_ */
