/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CSESLog.h

Description:

    This file defines class CSESLog.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Jin Xin  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __CSESLOG_H__
#define __CSESLOG_H__

#include <string>
#include "CSESLogData.h"

namespace LibSESData
{

class CSESLog
{
private:
	CSESLog();
	virtual ~CSESLog();

	static std::string getTime();

public:
	virtual void ImStatic() = 0;

public:
	enum LOGLEVEL
	{
		DEBUG_LEVEL = -1,
		TRACE = 0,
		WARNING = 1,
		ERROR = 2,
		FATAL = 3
	};

public:
	static void WriteLine(std::string msg, LOGLEVEL level = TRACE, std::string appName = "", bool bNeedMiliSeconds= false);
	static void WriteLine(int iMsg,std::string msg,bool bMillitm=false, LOGLEVEL level = TRACE, std::string appName= "");

	static void WriteLine(CSESLogData::FunctionTag Tag, std::string MethodTag, std::string szFormat = "", ...);

	static std::string FormateTime(time_t time);
	static std::string ParseInt2String(int iValue);

private:
	static std::string getTime(bool bNeedMiliSeconds);
	static std::string getLogDir();
	static void SetLogFileName(std::string strFileName);
	static void WriteLogFile(string& FileName, string& Content, LOGLEVEL level);
	static std::string GetLogFileName(CSESLogData::FunctionTag Tag);
	static int GetPriority();
private:
	static std::string m_FileName;
	static std::string m_FolderName;
	static int m_Priority;
};

}
#endif /* __CSESLOG_H__ */
