/******************************************************************************
 * File Name    : NewStudentConnectWindow.h
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : The header file of NewStudentConnectWindow
 ******************************************************************************/
#ifndef NEWSTUDENTCONNECTWINDOW_H_
#define NEWSTUDENTCONNECTWINDOW_H_
#include <gtk/gtk.h>
#include "seslib.h"
#include "libsesdata.h"

namespace ShellController
{

class ShellControllerWindow;
class NewStudentConnectWindow
{
public:
	explicit NewStudentConnectWindow(IPCAPI::tagStudent_t& student);
	~NewStudentConnectWindow();

public:
	int Init();
	int ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data);
	int IsAccept();
	int IsDeny();
	int IsAddToClass();

	int CloseDueToDisconnect();

	ShellControllerWindow* GetShellControllerWindow() { return m_pShellControllerWindow; };

public:
	static void OnAcceptButtonClick(GtkWidget* widget, gpointer data);
	static void OnDenyButtonClick(GtkWidget* widget, gpointer data);
	static void KeepSameOPCallBack(GtkToggleButtonClass*, gpointer data);
	static void OnSaveButtonClick(GtkWidget* widget, gpointer data);

public:
	IPCAPI::StudentInfo_t GetStudent();
	std::string GetStudentID() {return m_student.studentID;};

	void GetResult(int& isAllow, int& addToClass, int& saveToFile);

private:
	GtkWidget* m_gWindow;
	//GtkWidget* m_gCheckbtnHbox;
	GtkWidget* m_gAdd2ClassCheckBtn;
	GtkWidget* m_gKeepSameOPCheckBtn;

	int m_isAccept;
	//int m_isDeny;
	int m_isAddToClass;
	int m_isKeepSameOP;
	IPCAPI::tagStudent_t m_student;
	LibSESData::CSESSystemSettingData m_SystemSettingData;

	ShellControllerWindow* m_pShellControllerWindow;
	gulong	m_handlerID;
};

}

#endif /* NEWSTUDENTCONNECTWINDOW_H_ */
