/******************************************************************************
 * File Name    : SelectClassWindow.h
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : The header file of SelectClassWindow
 ******************************************************************************/
#ifndef SELECTCLASSWINDOW_H_
#define SELECTCLASSWINDOW_H_

#include <gtk/gtk.h>


#include "seslib.h"

#include "SESCommonDef.h"
#include "EditGroupWindow.h"
#include "ClassGroupData.h"
#include "PasswordWindow.h"
#include "ImportCAWindow.h"

namespace ShellController
{

class ShellControllerWindow;
class SelectClassWindow: public IPCAPI::CTeacherAPICallbackBase
{
public:
	//SelectClassWindow(IPCAPI::IPCTeacherAPI* pTeacherApiRef, LibSESData::CClassGroupData* pClassGroup,
	//		          LibSESData::CClassDef* pSelectedClass);

	SelectClassWindow(std::string selectedClass);

	~SelectClassWindow();

public:

	int Init();

	int ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data);

	int IsOpenForAll();

	int GetResult();

	int IsInitial();

	bool IsSelected();

	//LibSESData::CClassDef* GetSelectedClass();

	std::string GetSelectedClassName() {return m_SelectClass;} ;

	EditGroupWindow* GetEditGroupWindow();

	ClassSelectStatus GetClassSelectStatus() {return m_eClassSelectStatus;};

public:

	// GTK Handlers
	DECLEAR_GTK_EVENT(SelectClassWindow, EditGroup, gtkwidget, data)
    DECLEAR_GTK_EVENT(SelectClassWindow, RemoveGroup, gtkwidget, data)
	DECLEAR_GTK_EVENT(SelectClassWindow, AddGroup, gtkwidget, data)
	DECLEAR_GTK_EVENT(SelectClassWindow, CancelGroup, gtkwidget, data)
	DECLEAR_GTK_EVENT(SelectClassWindow, OKGroup, gtkwidget, data)
	DECLEAR_GTK_EVENT(SelectClassWindow, AddEditGroupClosed, gtkwidget, data)

	static bool OnWindowClosing(GtkWidget*, GdkEvent*, gpointer);

	static void SelectionChanged(GtkTreeView*, gpointer data);

private:

	GtkWidget* CreateTreeView(GtkWidget* parent);

	int InitRightButtons(GtkWidget* parent);

	int InitBottomButtons(GtkWidget* parent);

	int InitWindow();

	int InitClassGroup();

	int SaveClassInfo();

	//release pixbuf
	void ReleasePixbuf();

private:

	GtkWidget* m_gWindow;
	GtkWidget* m_gGtkTreeview;
	GtkWidget* m_gEditBtn;
	GtkWidget* m_gAddBtn;
	GtkWidget* m_gDeleteBtn;
	GdkPixbuf* m_pSelectClassPic;

private:

	std::string m_SelectClass;

	LibSESData::CClassGroupData m_ClassGroup;

	//LibSESData::CClassGroupData* m_pClassGroup;

//	LibSESData::CClassDef* m_pSelectedClass;
//	IPCAPI::IPCTeacherAPI* m_pTeacherApiRef;

	int m_iResult;
	int m_iInitail;
	int m_IsOpenForAll;
	int m_isSelection;

	ClassSelectStatus	m_eClassSelectStatus;

	EditGroupWindow* m_pEditGroupWindow;

	ShellControllerWindow* m_pShellControllerWindow;
};

}

#endif /*SELECTCLASS_H_*/
