/*
 * AutoLock.cpp
 *
 *  Created on: 2008-12-18
 *      Author: wang-l@neusoft.com
 */
#include "AutoLock.h"
AutoLock::AutoLock(LibSESData::CLockScheduleData& lockSchedule)
{
	this->m_pLockSchedule = &lockSchedule;
}
GtkWidget* AutoLock::CreateChild()
{
	GtkListStore *list_store;
	GtkTreeIter iter;
	GtkCellRenderer *renderer = NULL;
	GtkTreeViewColumn *column = NULL;
	list_store = gtk_list_store_new (2,
									   G_TYPE_STRING,
									   G_TYPE_STRING);

	m_pGtkWidget = gtk_tree_view_new_with_model (GTK_TREE_MODEL(list_store));
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Day"),
								 renderer,
								 "text",
								COLUMN_ITEM_DAY,
								 NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW(m_pGtkWidget), column);
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Lock Schedule"),
											 renderer,
											 "text",
											COLUMN_ITEM_TIME,
											 NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW(m_pGtkWidget), column);
	string day[]={"Mon","Tue","Wed","Thu","Fri","Sat","Sun"};
	string tempString = "Auto Policy\n";
	std::list<CLockTimeSection*>*  pLockTimeSection = m_pLockSchedule->GetPAutomaticLockTimeList();
	std::list<CLockTimeSection*>::iterator pre= pLockTimeSection->begin();
	std::list<CLockTimeSection*>::iterator post= pLockTimeSection->begin();
	post++;
	if(pre == pLockTimeSection->end())
	{
		m_pGtkWidget = gtk_text_view_new ();
		gtk_container_set_border_width(GTK_CONTAINER(m_pGtkWidget), 1);
		GtkTextBuffer* buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (m_pGtkWidget));
		gtk_text_view_set_editable(GTK_TEXT_VIEW(m_pGtkWidget),false);
		tempString += "unavailable";
		GtkTextIter iter;
		gtk_text_buffer_get_iter_at_offset (buffer, &iter, 0);
		gtk_text_buffer_insert (buffer, &iter, _(tempString.c_str()), -1);
		return m_pGtkWidget;
	}
	int day1 = (reinterpret_cast<CLockTimeSection*>(*pre))->GetDayOfWeek();
	int i=0;
	while(i<day1)
	{
		string tempString = day[i];
		tempString = tempString +":";
		//tempString = tempString + "\n";
		gtk_list_store_append (list_store, &iter);
		gtk_list_store_set(list_store,&iter,0,tempString.c_str(),-1);
		i++;
	}
	int preStartTime=(reinterpret_cast<CLockTimeSection*>(*pre))->GetStartTime();
	int preEndTime = (reinterpret_cast<CLockTimeSection*>(*pre))->GetEndTime();
	bool flag = true;
	while(pre != pLockTimeSection->end())
	{
		int day1 = (reinterpret_cast<CLockTimeSection*>(*pre))->GetDayOfWeek();
		if(post != pLockTimeSection->end())
		{
			int day2 = (reinterpret_cast<CLockTimeSection*>(*post))->GetDayOfWeek();
			if(day1 == day2)
			{

				int postStartTime = (reinterpret_cast<CLockTimeSection*>(*post))->GetStartTime();
				int postEndTime = (reinterpret_cast<CLockTimeSection*>(*post))->GetEndTime();
				if(preEndTime == postStartTime)
				{
					preEndTime = postEndTime;
				}
				else
				{
					stringstream sstr;
					string tempString,tempString1;
					if(flag)
					{
						tempString = day[day1] + ":";
					}
					flag = false;
					sstr<<(preStartTime<10?"0":"")<<preStartTime<<":00";
					sstr<< "~";
					sstr<<(preEndTime<10?"0":"")<<preEndTime<<":00";
					sstr<<" ";
					tempString1 += sstr.str();
					gtk_list_store_append (list_store, &iter);
				   gtk_list_store_set(list_store,&iter,COLUMN_ITEM_DAY,tempString.c_str(),COLUMN_ITEM_TIME,tempString1.c_str(), -1);
					preStartTime = (reinterpret_cast<CLockTimeSection*>(*post))->GetStartTime();
					preEndTime = (reinterpret_cast<CLockTimeSection*>(*post))->GetEndTime();
				}
			}
			else
			{
				stringstream sstr;
				string tempString,tempString1;
				if(flag)
				{
					tempString = day[day1]+":";
				}
				flag = true;
				sstr<<(preStartTime<10?"0":"")<<preStartTime<<":00";
				sstr<< "~";
				sstr<<(preEndTime<10?"0":"")<<preEndTime<<":00";
				tempString1 = sstr.str();
				gtk_list_store_append (list_store, &iter);
				gtk_list_store_set(list_store,&iter,COLUMN_ITEM_DAY,tempString.c_str(),COLUMN_ITEM_TIME,tempString1.c_str(),-1);
				preStartTime = (reinterpret_cast<CLockTimeSection*>(*post))->GetStartTime();
				preEndTime = (reinterpret_cast<CLockTimeSection*>(*post))->GetEndTime();
				while(day1+1<day2)
				{
					tempString = day[day1+1] + ":";
					gtk_list_store_append (list_store, &iter);
					gtk_list_store_set(list_store,&iter,0,tempString.c_str(),-1);
					day1 = day1+1;
				}
			}
			pre++;
			post++;
		}
		else
		{
			stringstream sstr;
			string tempString,tempString1;
			if(flag)
			{
				tempString = day[day1]+":";
			}
			sstr<<(preStartTime<10?"0":"")<<preStartTime<<":00";
			sstr<< "~";
			sstr<<(preEndTime<10?"0":"")<<preEndTime<<":00";
			tempString1 = sstr.str();
			gtk_list_store_append (list_store, &iter);
			gtk_list_store_set(list_store,&iter,COLUMN_ITEM_DAY,tempString.c_str(),COLUMN_ITEM_TIME,tempString1.c_str(),-1);
			day1 = day1 +1;
			while(day1<7)
			{
				tempString = day[day1];
				tempString += ":";
				gtk_list_store_append (list_store, &iter);
				gtk_list_store_set(list_store,&iter,COLUMN_ITEM_DAY,tempString.c_str(),-1);
				day1 = day1+1;
			}
			pre++;
		}
	}
	return m_pGtkWidget;
}


