/******************************************************************************
 * File Name    : ImportCAWindow.cpp
 * Created      : 2008/11/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  :
 ******************************************************************************/
#include<string>
#include <glib/gi18n.h>
#include "ImportCAWindow.h"
#include "PublicFunc.h"
#include "SESCommonDef.h"
#include "libsesdata.h"

#define CERTIFICATE_WINDOW_BORDER_WIDTH 1
#define CERTIFICATE_WINDOW_WIDTH 330
#define CERTIFICATE_WINDOW_HEIGHT 150
#define CERTIFICATE_WINDOW_ENTRY_WIDTH 215
#define CERTIFICATE_WINDOW_ENTRY_HEIGHT 25
using namespace LibSESData;

using namespace IPCAPI;
using namespace std;
using namespace LibSESGUI;
/******************************************************************************
 * Function Name: ImportCAWindow
 * Description  : Constructor of ImportCAWindow
 * Date         : 2008/11/14
 * Parameter    : VOID
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
ImportCAWindow::ImportCAWindow()
			: m_gWindow (NULL)
			, m_gEntry (NULL)
			, m_isPathTrue (0)

{
	CSESLog::WriteLine("ImportCAWindow::ImportCAWindow>>Start");
//	m_pPasswordWindow = NULL;
//	m_gWindow = NULL;
//	m_gEntry = NULL;
//	m_isPathTrue = 0;
	CSESLog::WriteLine("ImportCAWindow::ImportCAWindow<<End");
}
/******************************************************************************
 * Function Name: ImportCAWindow
 * Description  : Destructor of ImportCAWindow
 * Date         : 2008/11/14
 * Parameter    : VOID
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
ImportCAWindow::~ImportCAWindow()
{

}
/******************************************************************************
 * Function Name: Init
 * Description  : Init main ImportCA window
 * Date         : 2008/11/14
 * Parameter    : VOID
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ImportCAWindow::Init()
{
	InitWindow();
}
/******************************************************************************
 * Function Name: InitWindow
 * Description  : Init main window
 * Date         : 2008/11/14
 * Parameter    : VOID
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ImportCAWindow::InitWindow()
{
	CSESLog::WriteLine("ImportCAWindow::ImportCAWindow>>Start");
	GtkWidget* pVbox = NULL;
	GtkWidget* pHbox = NULL;
	GtkWidget* pLabel = NULL;
	GtkWidget* pButton = NULL;
	m_gWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(GTK_OBJECT(m_gWindow), "delete-event", G_CALLBACK(OnWindowClosing), this);
	gtk_container_set_border_width (GTK_CONTAINER (m_gWindow), CERTIFICATE_WINDOW_BORDER_WIDTH);
	gtk_window_set_position (GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_widget_set_size_request (GTK_WIDGET (m_gWindow), CERTIFICATE_WINDOW_WIDTH, CERTIFICATE_WINDOW_HEIGHT);
	gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_title(GTK_WINDOW (m_gWindow), _("Import New CA"));
	gtk_window_set_resizable(GTK_WINDOW(m_gWindow), FALSE);
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Import New CA"), "SES");

	string iconPath("");
    iconPath.append(SES_RESOURCE_IMAGE_PATH);
    iconPath.append("shellcontroller_main.png");

    GError** error = NULL;
    gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), SES_SHELL_CONTROLLER_ICON.c_str(), error);

	pVbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER (m_gWindow), pVbox);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);

	pLabel = gtk_label_new(_("Please select the path of certificate:"));
	gtk_widget_set_tooltip_text (pLabel, _("Please select the path of certificate:"));
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 10);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 15);

	m_gEntry = gtk_entry_new();
	gtk_widget_set_size_request(m_gEntry, CERTIFICATE_WINDOW_ENTRY_WIDTH, CERTIFICATE_WINDOW_ENTRY_HEIGHT);
	gtk_box_pack_start(GTK_BOX(pHbox), m_gEntry, FALSE, FALSE, 10);

	pButton = gtk_button_new_with_label(_("Browse..."));
	g_signal_connect(GTK_OBJECT(pButton), "clicked", G_CALLBACK(OpenFile), this);
	gtk_widget_set_tooltip_text (pButton, _("Browse"));
	gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), pButton, false, false, 10);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);

	pButton = gtk_button_new_with_label(_("OK"));
	g_signal_connect(GTK_OBJECT(pButton), "clicked", G_CALLBACK(OnOkCallBack), this);
	gtk_widget_set_tooltip_text (pButton, _("OK"));
	gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), pButton, FALSE, FALSE, 10);

	pButton = gtk_button_new_with_label(_("Cancel"));
	g_signal_connect(GTK_OBJECT(pButton), "clicked", G_CALLBACK(OnCancelCallBack), this);
	gtk_widget_set_tooltip_text (pButton, _("Cancel"));
	gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), pButton, FALSE, FALSE, 5);
	CSESLog::WriteLine("ImportCAWindow::ImportCAWindow<<End");
}
/******************************************************************************
 * Function Name: ShowModal
 * Description  : show main window
 * Date         : 2008/11/14
 * Parameter    : parentWindow		main window
 * 				  cb				Callback function
 * 				  data 				user data
 * Return Code  : 0			OK
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ImportCAWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("ImportCAWindow::ShowModal>>Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	if (NULL != cb)
	{
		g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
	}
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("ImportCAWindow::ShowModal<<End");
	return 0;
}
/******************************************************************************
 * Function Name: OpenFile
 * Description  : open file folder
 * Date         : 2008/11/14
 * Parameter    : gtkwidget			browse button
 * 				  data 				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ImportCAWindow::OpenFile(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ImportCAWindow::OpenFile>>Start");
	ImportCAWindow* ptr = (ImportCAWindow*)data;
	string compareString("");
	GtkWidget* dialog = NULL;
	dialog = gtk_file_chooser_dialog_new(_("Open File"),
								GTK_WINDOW(ptr->m_gWindow),
								GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
								GTK_STOCK_CANCEL,
								GTK_RESPONSE_CANCEL,
								GTK_STOCK_OPEN,
								GTK_RESPONSE_ACCEPT,
								NULL);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), "/");
	int response = gtk_dialog_run (GTK_DIALOG (dialog));
	string fileString("");
	fileString = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
	if(GTK_RESPONSE_ACCEPT == response)
	{
		gtk_entry_set_text(GTK_ENTRY(ptr->m_gEntry), fileString.c_str());
	}
	gtk_widget_destroy (dialog);
	CSESLog::WriteLine("ImportCAWindow::OpenFile<<End");
}
/******************************************************************************
 * Function Name: OnOkCallBack
 * Description  :
 * Date         : 2008/11/14
 * Parameter    : gtkwidget			OK button
 * 				  data 				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ImportCAWindow::OnOkCallBack(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ImportCAWindow::OnOkCallBack>>Start");
	ImportCAWindow* ptr = (ImportCAWindow*)data;
	string compareString("");
	string fileString("");
	fileString = gtk_entry_get_text(GTK_ENTRY(ptr->m_gEntry));
	if(0 != fileString.compare(compareString))
	{
		int errCode = 0;
		int verifyResult = ptr->m_pTeacherAPI->VerifyCertificate(fileString, errCode);
		if(SES_API_SUCCESS == verifyResult)
		{
			if(SES_API_SUCCESS == errCode)
			{
				ptr->m_isPathTrue = 1;
				ptr->m_CAPath = fileString;
				gtk_widget_destroy(ptr->m_gWindow);
			}
//			else if(SES_API_NEEDRESTART == verifyResult)
//            {
//			    string message(_("You should restart your computer!"));
//			    CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
//			    gtk_main_quit();
//
//                //PublicFunc::SESShowDialogAndQuit(_("You should restart your computer!"), ptr->m_gWindow);
//            }
			else
			{
				string message(_("The path of certificate is invalid!"));
				CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			}
		}
		else if(SES_API_TIME_OUT == verifyResult)
		{
			//PublicFunc::SESShowDialogAndQuit(_("Time out!"), ptr->m_gWindow);
		    string message(_("Time out!"));
		    CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
		    gtk_main_quit();
			CSESLog::WriteLine("ImportCAWindow::OnOkCallBack<<End");
		}
		else
		{
		    string message(_("Fail to verify certificate!"));
		    CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
		    gtk_main_quit();
			//PublicFunc::SESShowDialogAndQuit(_("Fail to verify certificate!"), ptr->m_gWindow);
			CSESLog::WriteLine("ImportCAWindow::OnOkCallBack<<End");
		}
	}
	else
	{
		string message(_("The path of certificate cannot be empty!"));
		CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
		CSESLog::WriteLine("ImportCAWindow::OnOkCallBack<<End");
	}
}
/******************************************************************************
 * Function Name: OnCancelCallBack
 * Description  :
 * Date         : 2008/11/14
 * Parameter    : gtkwidget			Cancel button
 * 				  data 				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ImportCAWindow::OnCancelCallBack(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ImportCAWindow::OnCancelCallBack>>Start");
	ImportCAWindow* ptr = (ImportCAWindow*)data;
//	GtkWidget* outDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//							   GTK_DIALOG_MODAL,
//							   GTK_MESSAGE_QUESTION,
//							   GTK_BUTTONS_YES_NO,
//							   _("Do you want to cancel importing certificate?"));
//	gtk_window_set_title(GTK_WINDOW(outDialog), "Information");
	string message(_("Do you want to cancel importing certificate?"));
	int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
	if(GTK_RESPONSE_YES == result)
	{
		//gtk_widget_destroy(outDialog);
		CSESLog::WriteLine("ImportCAWindow::OnCancelCallBack<<End");
		gtk_widget_destroy(ptr->m_gWindow);
	}
	else
	{
		//gtk_widget_destroy(outDialog);
		gtk_widget_grab_focus(ptr->m_gEntry);
		CSESLog::WriteLine("ImportCAWindow::OnCancelCallBack<<End");
	}
}
/******************************************************************************
 * Function Name: OnWindowClosing
 * Description  :
 * Date         : 2008/11/14
 * Parameter    : gtkwidget			main window
 * 				  event				delete-event
 * 				  data 				user data
 * Return Code  : False			close window
 * 				  True			dont close window
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool ImportCAWindow::OnWindowClosing(GtkWidget* gtkwidget, GdkEvent* event, gpointer data)
{
	CSESLog::WriteLine("ImportCAWindow::OnWindowClosing>>Start");
	ImportCAWindow* ptr = (ImportCAWindow*)data;
//	GtkWidget* outDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//							   GTK_DIALOG_MODAL,
//							   GTK_MESSAGE_QUESTION,
//							   GTK_BUTTONS_YES_NO,
//							   _("Do you want to leave?"));
//	gtk_window_set_title(GTK_WINDOW(outDialog), "Information");

	string message(_("Do you want to leave?"));
	int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
	if(GTK_RESPONSE_YES == result)
	{
		//gtk_widget_destroy(outDialog);
		CSESLog::WriteLine("ImportCAWindow::OnWindowClosing<<End");
		return false;
	}
	else
	{
		//gtk_widget_destroy(outDialog);
		gtk_widget_grab_focus(ptr->m_gEntry);
		CSESLog::WriteLine("ImportCAWindow::OnWindowClosing<<End");
		return true;
	}
}
/******************************************************************************
 * Function Name: IsPathTrue
 * Description  :
 * Date         : 2008/11/14
 * Parameter    : VOID
 * Return Code  : 0			OK
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ImportCAWindow::IsPathTrue()
{
	CSESLog::WriteLine("ImportCAWindow::IsPathTrue>>Start");
	CSESLog::WriteLine("ImportCAWindow::IsPathTrue<<End");
	return m_isPathTrue;
}
/******************************************************************************
 * Function Name: CAString
 * Description  :
 * Date         : 2008/11/14
 * Parameter    : VOID
 * Return Code  : string	The CA path string
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
string& ImportCAWindow::CAString()
{
	CSESLog::WriteLine("ImportCAWindow::CAString>>Start");
	CSESLog::WriteLine("ImportCAWindow::CAString<<End");
	return m_CAPath;
}
