/******************************************************************************
 * File Name    : LockStudentsWindow.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : Lock the selected students
 ******************************************************************************/
#include "LockStudentsWindow.h"
#include <stdlib.h>
#include <glib/gi18n.h>
#include "SESCommonDef.h"

using namespace std;
using namespace IPCAPI;
using namespace LibSESData;

#define LOCK_STUDENT_WINDOW_BORDER_WIDTH 1
#define LOCK_STUDENT_WINDOW_WIDTH 450
#define LOCK_STUDENT_WINDOW_HEIGHT 210
/******************************************************************************
 * Function Name: LockStudentsWindow
 * Description  : The constructor of LockStudentsWindow
 * Date         : 2008/9/10
 * Parameter    : studentlist	 the student list
 *                pTeacherAPI	 IPCTeacherAPI
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
LockStudentsWindow::LockStudentsWindow (list<tagStudent_t>& studentlist)
				: m_gWindow (NULL)
				, m_gNextMinuteCombo (NULL)
				, m_gMinuteCombo (NULL)
				, m_gHourCombo (NULL)
				, m_gNextHourCombo (NULL)
				, m_gUpperRadiobtn (NULL)
				, m_gLowerRadiobtn (NULL)
				, m_gCheckbtn (NULL)
{
	CSESLog::WriteLine("LockStudentsWindow::LockStudentsWindow >>Start");
	m_pstudentlist.assign(studentlist.begin(), studentlist.end());
	//m_pTeacherAPI = pTeacherAPI;
	//m_gWindow = NULL;
	//m_gNextMinuteCombo = NULL;
	//m_gMinuteCombo = NULL;
	//m_gHourCombo = NULL;
	//m_gNextHourCombo = NULL;
	//m_gUpperRadiobtn = NULL;
	//m_gLowerRadiobtn = NULL;
	//m_gCheckbtn = NULL;
	CSESLog::WriteLine("LockStudentsWindow::LockStudentsWindow <<End");
}
/******************************************************************************
 * Function Name: ~LockStudentsWindow
 * Description  : The destructor of LockStudentsWindow
 * Date         : 2008/9/10
 * Parameter    :
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
LockStudentsWindow::~LockStudentsWindow ()
{
}
/******************************************************************************
 * Function Name: Lock_Dialog
 * Description  : Show lock dialog window
 * Date         : 2008/9/10
 * Parameter    : gtkwidget			GtkWidget
 * 				  data				user data
 * Return Code  : OK		return 0
 * 				  ERROR		return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int LockStudentsWindow::LockDialog(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("LockStudentsWindow::Lock_Dialog >>Start");
	LockStudentsWindow* ptr = (LockStudentsWindow*)data;
	//GtkWidget* dialog = NULL;
	if (NULL != ptr)
	{
		CManualLock* pManualLock = ptr->m_LockScheduleData.GetPManualLockInfo();
		gboolean isRadioButtonLockChecked = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gUpperRadiobtn));

		GtkTreeIter iter;
		GtkTreeModel* model = NULL;
		char* strhour = NULL;
		char* strmin = NULL;
		int hour, min;
		gtk_combo_box_get_active_iter(GTK_COMBO_BOX(ptr->m_gHourCombo), &iter);
		model = gtk_combo_box_get_model(GTK_COMBO_BOX(ptr->m_gHourCombo));
		gtk_tree_model_get (model, &iter, 0, &strhour, -1);

		hour = atoi((const char*)strhour);

		gtk_combo_box_get_active_iter(GTK_COMBO_BOX(ptr->m_gMinuteCombo), &iter);
		model = gtk_combo_box_get_model(GTK_COMBO_BOX(ptr->m_gMinuteCombo));
		gtk_tree_model_get (model, &iter, 0, &strmin, -1);

		min = atoi((const char*)strmin);
		pManualLock->SetUnlockAfterDisconnect(hour*60 + min);

		gtk_combo_box_get_active_iter(GTK_COMBO_BOX(ptr->m_gNextHourCombo), &iter);
		model = gtk_combo_box_get_model(GTK_COMBO_BOX(ptr->m_gNextHourCombo));
		gtk_tree_model_get (model, &iter, 0, &strhour, -1);

		hour = atoi((const char*)strhour);

		gtk_combo_box_get_active_iter(GTK_COMBO_BOX(ptr->m_gNextMinuteCombo), &iter);
		model = gtk_combo_box_get_model(GTK_COMBO_BOX(ptr->m_gNextMinuteCombo));
		gtk_tree_model_get (model, &iter, 0, &strmin, -1);

		min = atoi((const char*)strmin);

		pManualLock->SetUnlockAfterConnect(hour*60 + min);
		time_t seconds;
		seconds = time (NULL);

		if(isRadioButtonLockChecked)
		{
			gboolean isCheckButtonChecked = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gCheckbtn));

			if(isCheckButtonChecked)
			{
				pManualLock->SetOption(1);
			}
			else
			{
				pManualLock->SetOption(0);
			}
		}
		else
		{
			pManualLock->SetOption(2);
		}

/*
		int hasAutomaticLockStudent = FALSE;

		for (list<StudentInfo_t>::iterator iter = ptr->m_pstudentlist.begin(); iter != ptr->m_pstudentlist.end(); ++iter)
		{
			StudentInfo_t studentinfo;
			int errCode;
			APIResult ret = ptr->m_pTeacherAPI->GetStudentStatus((*iter).studentID, studentinfo, errCode);
			if(SES_API_SUCCESS == errCode && SES_API_SUCCESS == ret)
			{
				if(studentinfo.status == SES_STU_AUTO_LOCK || studentinfo.status == SES_STU_AUTO_UNLOCK)
				{
					hasAutomaticLockStudent = TRUE;
					break;
				}
			}
			else
			{
				CSESLog::WriteLine("LockStudentsWindow::Lock_Dialog --GetStudentStatus failure!!!");
				//TODO Log Message here;
			}

		}

		if(hasAutomaticLockStudent)
		{
			dialog = gtk_message_dialog_new(GTK_WINDOW (data),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_WARNING,
					GTK_BUTTONS_YES_NO,
					"Are you sure you want to turn off Auto Lock mode\nand Lock the students manually?"
			);
			if (GTK_RESPONSE_ACCEPT == gtk_dialog_run (GTK_DIALOG (dialog)))
			{
				ptr->DoLockAction(ptr->m_pstudentlist, ptr->m_pTeacherAPI, ptr->m_LockScheduleData);
			}
		}
		else
		{
			ptr->DoLockAction(ptr->m_pstudentlist, ptr->m_pTeacherAPI, ptr->m_LockScheduleData);
		}
		//gtk_widget_destroy (dialog);
*/
		ptr->DoLockAction(ptr->m_pstudentlist, ptr->m_pTeacherAPI, ptr->m_LockScheduleData);
		gtk_widget_destroy (ptr->m_gWindow);
	}
	CSESLog::WriteLine("LockStudentsWindow::Lock_Dialog <<End");
	return 0;
}
/******************************************************************************
 * Function Name: DoLockAction
 * Description  : Lock students
 * Date         : 2008/9/10
 * Parameter    : studentlist			the selected students' list
 * 				  pTeacherAPI			IPCflTeacherAPI
 *				  lockScheduleData		schedule data
 * Return Code  : Void
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void LockStudentsWindow::DoLockAction(list<tagStudent_t>& studentlist,
		                              IPCTeacherAPI* pTeacherAPI,
		                              CLockScheduleData& lockScheduleData)
{
	CSESLog::WriteLine("LockStudentsWindow::DoLockAction >>Start");
	int AutoLock = lockScheduleData.IsAutoLockEnable();
	int ManualLock = lockScheduleData.IsManualLockEnable();
	int LockStatus = lockScheduleData.Islocked();

	lockScheduleData.SetAutoLock(FALSE);
	lockScheduleData.SetManualLock(TRUE);
	lockScheduleData.SetLockStatus(4);//4 is manually lock

	string lockPolicy("");

	lockScheduleData.Save2String(lockPolicy);

	std::list<std::string> studentList;
	for (list<StudentInfo_t>::iterator iter = studentlist.begin(); iter != studentlist.end(); ++iter)
	{
		studentList.push_back((*iter).studentID);
		//APIResult ret = pTeacherAPI->ManualLockRemotStudent((*iter).studentID, lockPolicy);
	}
	if(studentList.size() > 0)
	{
		CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"LockStudentsWindow::DoLockAction::DeploySchedulePolicy (Manually Lock)<<Start LOG_TEACHER_DEPLOYSCHDULE");
		int OID;
		APIResult ret = pTeacherAPI->DeploySchedulePolicy(studentList,lockPolicy,OID);
		CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"LockStudentsWindow::DoLockAction::DeploySchedulePolicy (Manually Lock)<<End LOG_TEACHER_DEPLOYSCHDULE");
		if(SES_API_SUCCESS != ret)
		{
			CSESLog::WriteLine("LockStudentsWindow::Lock_Dialog --ManualLockRemotStudent sends failure!!!");
			//TODO Log Message here;
		}
	}
	lockScheduleData.SetAutoLock(AutoLock);
	lockScheduleData.SetManualLock(ManualLock);
	lockScheduleData.SetLockStatus(LockStatus);

	lockScheduleData.Save2File((CONFIG_FILE_DIR + LOCK_SCHEDULE));
	CSESLog::WriteLine("LockStudentsWindow::DoLockAction <<End");
}
/******************************************************************************
 * Function Name: Init
 * Description  : Init LockStudentsWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int LockStudentsWindow::Init ()
{
	CSESLog::WriteLine("LockStudentsWindow::Init>>Start");
	GtkWidget* pMainVbox = NULL;
	GtkWidget* pTopHbox = NULL;
	GtkWidget* pTopLabel = NULL;
	GtkWidget* pMiddleVbox = NULL;
	GtkWidget* pMiddleHbox = NULL;
	GtkWidget* pMiddleLabelHbox = NULL;
	GtkWidget* pMiddleLabel = NULL;
	GtkWidget* pHourLabel = NULL;
	GtkWidget* pMiniteLabel = NULL;
	GtkWidget* pBottomHbox = NULL;
	GtkWidget* pOkBtn = NULL;
	GtkWidget* pCancelBtn = NULL;
	GtkWidget* pLabel = NULL;
	GtkTreeStore* pHourStore = NULL;
	GtkTreeStore* pMinuteStore = NULL;
	GtkCellRenderer* pRenderer = NULL;
	GtkTreeIter iter;

    m_gWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    //g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (gtk_main_quit), NULL);
    //g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (gtk_main_quit), NULL);
    gtk_window_set_title (GTK_WINDOW (m_gWindow), _("Lock Students"));
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Lock Students"), "SES");
    gtk_container_set_border_width (GTK_CONTAINER (m_gWindow), LOCK_STUDENT_WINDOW_BORDER_WIDTH);
    gtk_widget_set_size_request (m_gWindow, LOCK_STUDENT_WINDOW_WIDTH, LOCK_STUDENT_WINDOW_HEIGHT);
    gtk_window_set_resizable (GTK_WINDOW (m_gWindow), FALSE);
    gtk_window_set_position(GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
    gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);
    gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);

    string iconPath("");
    iconPath.append(SES_RESOURCE_IMAGE_PATH);
    iconPath.append("shellcontroller_main.png");

    GError** error = NULL;
    gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), SES_SHELL_CONTROLLER_ICON.c_str(), error);

    pMainVbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (m_gWindow), pMainVbox);


    pTopHbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (pMainVbox), pTopHbox, FALSE, FALSE, 0);


    pTopLabel = gtk_label_new (_("Shell Lock Settings"));
    gtk_widget_set_tooltip_text (pTopLabel, _("Shell Lock Settings"));
    gtk_box_pack_start (GTK_BOX (pTopHbox), pTopLabel, FALSE, FALSE, 10);


    pMiddleVbox = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (pMainVbox), pMiddleVbox, FALSE, FALSE, 0);



    m_LockScheduleData.LoadFromFile((CONFIG_FILE_DIR + LOCK_SCHEDULE));

    LibSESData::CLockScheduleData tmp;
    tmp.LoadFromFile((CONFIG_FILE_DIR + LOCK_SCHEDULE));

    //CManualLock* menualLock = m_LockScheduleData.GetPManualLockInfo();
    CManualLock* menualLock = tmp.GetPManualLockInfo();

    int option = menualLock->GetOption();
    int unlockAfterDisconnect = menualLock->GetUnlockAfterDisconnect();
    int hourDisconnect = (unlockAfterDisconnect/60)%24;
    int minuteDisconnect = unlockAfterDisconnect%60;
    int unlockAfterConnect = menualLock->GetUnlockAfterConnect();
    int hourConnect = (unlockAfterConnect/60)%24;
    int minuteConnect = unlockAfterConnect%60;

    int LockstudentCheck = 0;
    int checkButton = 0;

    if(0 == option)
    {
    	LockstudentCheck = 1;
    	checkButton = 0;
    }
    else if(1 == option)
    {
    	LockstudentCheck = 1;
    	checkButton = 1;
    }
    else
    {
    	LockstudentCheck = 0;
    	checkButton = 0;
    }

    m_gUpperRadiobtn = gtk_radio_button_new_with_label (NULL, _("Lock student manually"));
    g_signal_connect(G_OBJECT(m_gUpperRadiobtn), "toggled", G_CALLBACK(SetUpperActive), this);
    gtk_box_pack_start (GTK_BOX (pMiddleVbox), m_gUpperRadiobtn, FALSE, FALSE, 10);

    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (m_gUpperRadiobtn), LockstudentCheck);
    //g_signal_connect(G_OBJECT(m_gUpperRadiobtn), "toggled", G_CALLBACK(SetUpperActive), this);

    pMiddleHbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (pMiddleVbox), pMiddleHbox, FALSE, FALSE, 0);


    m_gCheckbtn = gtk_check_button_new_with_label (_("Unlock student automatically"));
    g_signal_connect(G_OBJECT(m_gCheckbtn), "toggled", G_CALLBACK(SetCheckBtn), this);
    gtk_box_pack_start (GTK_BOX (pMiddleHbox), m_gCheckbtn, FALSE, FALSE, 15);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_gCheckbtn), checkButton);


    GtkWidget* pHbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_end (GTK_BOX (pMiddleHbox), pHbox, FALSE, FALSE, 45);


    pMiniteLabel = gtk_label_new (_("mins"));
    gtk_box_pack_end (GTK_BOX (pHbox), pMiniteLabel, FALSE, FALSE, 0);

    const gchar* minite_array[60] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
        		"12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
        		"26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
        		"40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53",
        		"54", "55", "56", "57", "58", "59"};
	pMinuteStore = gtk_tree_store_new (1, G_TYPE_STRING);
	GtkTreeIter minite_iter;
	for (int j = 0; j < 60; j++)
	{
		gtk_tree_store_append(pMinuteStore, &minite_iter, NULL);
		gtk_tree_store_set(pMinuteStore, &minite_iter, 0, minite_array[j], -1);
	}
	m_gMinuteCombo = gtk_combo_box_new_with_model (GTK_TREE_MODEL( pMinuteStore));

	GtkCellRenderer* minite_renderer = NULL;
	minite_renderer = gtk_cell_renderer_text_new ();
	gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (m_gMinuteCombo), minite_renderer, TRUE);
	gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (m_gMinuteCombo), minite_renderer,
							"text", 0,  NULL);

	gtk_widget_set_size_request (m_gMinuteCombo, 60, 30);
	gtk_box_pack_end (GTK_BOX (pHbox), m_gMinuteCombo, FALSE, FALSE, 0);
	gtk_widget_show (m_gMinuteCombo);

	gtk_combo_box_set_active(GTK_COMBO_BOX(m_gMinuteCombo), minuteDisconnect);

	pHourLabel = gtk_label_new (_("hour"));
	gtk_box_pack_end (GTK_BOX (pHbox), pHourLabel, FALSE, FALSE, 0);



    const gchar* hour_array[24] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};

    pHourStore = gtk_tree_store_new (1, G_TYPE_STRING);

    for(int j = 0; j<24; j++)
    {
    	gtk_tree_store_append (pHourStore, &iter, NULL);
    	gtk_tree_store_set (pHourStore, &iter, 0, hour_array[j], -1);
    }
    m_gHourCombo = gtk_combo_box_new_with_model (GTK_TREE_MODEL(pHourStore));

    //m_gHourCombo = gtk_combo_box_new_text();
//    for(j = 0; j< 24; ++j)
//    {s
//        gtk_combo_box_append_text(GTK_COMBO_BOX(m_gHourCombo), hour_array[j]);
//    }
    //gtk_editable_set_editable((GtkEditable*)(GTK_COMBO(m_gHourCombo)->entry), false);
    //gtk_combo_box_append_text(GTK_COMBO_BOX(m_gHourCombo),);
    pRenderer = gtk_cell_renderer_text_new ();
    gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (m_gHourCombo), pRenderer, TRUE);
    gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (m_gHourCombo), pRenderer, "text", 0,  NULL);

    gtk_widget_set_size_request (m_gHourCombo, 60, 30);
    gtk_box_pack_end (GTK_BOX (pHbox), m_gHourCombo, FALSE, FALSE, 0);
    //gtk_combo_box_popup (GTK_COMBO_BOX(m_gHourCombo));
    //gtk_combo_box_set_add_tearoffs(GTK_COMBO_BOX(m_gHourCombo), TRUE);
    gtk_combo_box_set_active(GTK_COMBO_BOX(m_gHourCombo), hourDisconnect);



//    pHourLabel = gtk_label_new (_("hour"));
//    gtk_box_pack_end (GTK_BOX (pMiddleHbox), pHourLabel, FALSE, FALSE, 0);
//
//
//    const gchar* minite_array[60] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
//    		"12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
//    		"26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39",
//    		"40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53",
//    		"54", "55", "56", "57", "58", "59"};
//    pMinuteStore = gtk_tree_store_new (1, G_TYPE_STRING);
//    GtkTreeIter minite_iter;
//    for (j = 0; j < 60; j++)
//	{
//		gtk_tree_store_append(pMinuteStore, &minite_iter, NULL);
//		gtk_tree_store_set(pMinuteStore, &minite_iter, 0, minite_array[j], -1);
//	}
//    m_gMinuteCombo = gtk_combo_box_new_with_model (GTK_TREE_MODEL( pMinuteStore));
//
//	GtkCellRenderer* minite_renderer = NULL;
//    minite_renderer = gtk_cell_renderer_text_new ();
//    gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (m_gMinuteCombo), minite_renderer, TRUE);
//    gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (m_gMinuteCombo), minite_renderer,
//        				    "text", 0,  NULL);
//
//    gtk_widget_set_size_request (m_gMinuteCombo, 60, 30);
//    gtk_box_pack_end (GTK_BOX (pMiddleHbox), m_gMinuteCombo, FALSE, FALSE, 0);
//    gtk_widget_show (m_gMinuteCombo);
//
//    gtk_combo_box_set_active(GTK_COMBO_BOX(m_gMinuteCombo), minuteDisconnect);

//    pMiniteLabel = gtk_label_new (_("mins"));
//    gtk_box_pack_end (GTK_BOX (pMiddleHbox), pMiniteLabel, FALSE, FALSE, 0);



    pMiddleLabelHbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (pMiddleVbox), pMiddleLabelHbox, FALSE, FALSE, 0);


    pMiddleLabel = gtk_label_new (_("after students disconnect"));
    gtk_box_pack_start (GTK_BOX (pMiddleLabelHbox), pMiddleLabel, FALSE, FALSE, 20);
    gtk_widget_show (pMiddleLabel);

    GtkWidget* middle_bottom_hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(pMiddleVbox), middle_bottom_hbox, FALSE, FALSE, 15);


    m_gLowerRadiobtn = gtk_radio_button_new_with_label (gtk_radio_button_get_group (GTK_RADIO_BUTTON (m_gUpperRadiobtn)), "Lock students in the shell for following");
    g_signal_connect(G_OBJECT(m_gLowerRadiobtn), "toggled", G_CALLBACK(SetLowerActive), this);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (m_gLowerRadiobtn), !LockstudentCheck);
    gtk_box_pack_start (GTK_BOX (middle_bottom_hbox), m_gLowerRadiobtn, FALSE, FALSE, 1);



    m_gNextHourCombo = gtk_combo_box_new_with_model (GTK_TREE_MODEL(pHourStore));
    pRenderer = gtk_cell_renderer_text_new ();
    gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (m_gNextHourCombo), pRenderer, FALSE);
    gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (m_gNextHourCombo), pRenderer,
        				    "text", 0,  NULL);
    //gtk_combo_box_set_active (GTK_COMBO_BOX (next_hour_combo), 0);
    gtk_widget_set_size_request(m_gNextHourCombo, 60, 30);
	gtk_box_pack_start(GTK_BOX (middle_bottom_hbox), m_gNextHourCombo, FALSE, FALSE, 0);
	gtk_widget_show(m_gNextHourCombo);
	gtk_combo_box_set_active(GTK_COMBO_BOX(m_gNextHourCombo), hourConnect);

	pLabel = gtk_label_new(_("hour"));
	gtk_box_pack_start(GTK_BOX (middle_bottom_hbox), pLabel, FALSE, FALSE, 0);
	gtk_widget_show(pLabel);

	m_gNextMinuteCombo = gtk_combo_box_new_with_model (GTK_TREE_MODEL(pMinuteStore));
	pRenderer = gtk_cell_renderer_text_new ();
	gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (m_gNextMinuteCombo), pRenderer, TRUE);
	gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (m_gNextMinuteCombo), pRenderer,
	        				    "text", 0,  NULL);

	gtk_widget_set_size_request(m_gNextMinuteCombo, 60, 30);
	gtk_box_pack_start(GTK_BOX (middle_bottom_hbox), m_gNextMinuteCombo, FALSE, FALSE, 0);
	gtk_widget_show(m_gNextMinuteCombo);
	gtk_combo_box_set_active(GTK_COMBO_BOX(m_gNextMinuteCombo), minuteConnect);

	pLabel = gtk_label_new(_("mins"));
	gtk_box_pack_start(GTK_BOX (middle_bottom_hbox), pLabel, FALSE, FALSE, 0);
	gtk_widget_show(pLabel);

	if(0 == option)
	{
	    gtk_widget_set_sensitive(m_gNextHourCombo, FALSE);
	    gtk_widget_set_sensitive(m_gNextMinuteCombo, FALSE);
	    gtk_widget_set_sensitive(m_gHourCombo, FALSE);
	    gtk_widget_set_sensitive(m_gMinuteCombo, FALSE);
	}
	else if(1 == option)
	{
		gtk_widget_set_sensitive(m_gNextHourCombo, FALSE);
		gtk_widget_set_sensitive(m_gNextMinuteCombo, FALSE);
	}
	else if(2 == option)
	{
		gtk_widget_set_sensitive(m_gHourCombo, FALSE);
		gtk_widget_set_sensitive(m_gMinuteCombo, FALSE);
	}
    pBottomHbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (pMainVbox), pBottomHbox, FALSE, FALSE, 10);
    gtk_widget_show(pBottomHbox);

    pOkBtn = gtk_button_new_with_label (_("OK"));
    g_signal_connect (G_OBJECT (pOkBtn), "clicked", G_CALLBACK (LockDialog), this);
    gtk_widget_set_tooltip_text(pOkBtn, _("OK"));
    gtk_widget_set_size_request(pOkBtn, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
    gtk_box_pack_end (GTK_BOX (pBottomHbox), pOkBtn, FALSE, FALSE, 10);
    gtk_widget_show (pOkBtn);

    pCancelBtn = gtk_button_new_with_label (_("Cancel"));
    g_signal_connect(G_OBJECT(pCancelBtn), "clicked", G_CALLBACK(CancelLock), this);
    gtk_widget_set_tooltip_text(pCancelBtn, _("Cancel"));
    gtk_widget_set_size_request(pCancelBtn, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
    gtk_box_pack_end (GTK_BOX (pBottomHbox), pCancelBtn, FALSE, FALSE, 0);
    gtk_widget_show (pCancelBtn);

    CSESLog::WriteLine("LockStudentsWindow::Init<<End");
    return 0;
}
/******************************************************************************
 * Function Name: ShowModal
 * Description  : Make LockStudentsWindow in modal style
 * Date         : 2008/9/10
 * Parameter    : parentWindow		parent window
 * 				  cd				callback function
 * 				  data				user data
 * Return Code  : OK		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int LockStudentsWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("LockStudentsWindow::ShowModal>>Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	if (NULL != cb)
	{
		g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
	}
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("LockStudentsWindow::ShowModal<<End");
	return 0;
}

void LockStudentsWindow::SetUpperActive(GtkToggleButton *toggle, gpointer data)
{
	LockStudentsWindow* ptr = (LockStudentsWindow*)data;
	if(gtk_toggle_button_get_active (toggle))
	{
		gtk_widget_set_sensitive(ptr->m_gNextHourCombo, FALSE);
		gtk_widget_set_sensitive(ptr->m_gNextMinuteCombo, FALSE);
		gtk_widget_set_sensitive(ptr->m_gCheckbtn, TRUE);
		if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(ptr->m_gCheckbtn)))
		{
			gtk_widget_set_sensitive(ptr->m_gHourCombo, TRUE);
			gtk_widget_set_sensitive(ptr->m_gMinuteCombo, TRUE);
		}

	}
//	else
//	{
//		gtk_widget_set_sensitive(ptr->next_hour_combo, TRUE);
//		gtk_widget_set_sensitive(ptr->next_minute_combo, TRUE);
//		gtk_widget_set_sensitive(ptr->hour_combo, FALSE);
//		gtk_widget_set_sensitive(ptr->minite_combo, FALSE);
//		gtk_widget_set_sensitive(ptr->checkbutton, FALSE);
//	}
}

void LockStudentsWindow::SetLowerActive(GtkToggleButton *toggle, gpointer data)
{
	LockStudentsWindow* ptr = (LockStudentsWindow*)data;
	if(gtk_toggle_button_get_active (toggle))
	{
		gtk_widget_set_sensitive(ptr->m_gNextHourCombo, TRUE);
		gtk_widget_set_sensitive(ptr->m_gNextMinuteCombo, TRUE);
		gtk_widget_set_sensitive(ptr->m_gHourCombo, FALSE);
		gtk_widget_set_sensitive(ptr->m_gMinuteCombo, FALSE);
		gtk_widget_set_sensitive(ptr->m_gCheckbtn, FALSE);

	}
//	else
//	{
//		gtk_widget_set_sensitive(ptr->next_hour_combo, FALSE);
//		gtk_widget_set_sensitive(ptr->next_minute_combo, FALSE);
//		gtk_widget_set_sensitive(ptr->hour_combo, TRUE);
//		gtk_widget_set_sensitive(ptr->minite_combo, TRUE);
//		gtk_widget_set_sensitive(ptr->checkbutton, TRUE);
//
//	}
}


/******************************************************************************
 * Function Name: CancelLock
 * Description  : Cancel locking students
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void LockStudentsWindow::CancelLock(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("LockStudentsWindow::CancelLock>>Start");
	LockStudentsWindow* ptr = (LockStudentsWindow*)data;
	gtk_widget_destroy(ptr->m_gWindow);
	CSESLog::WriteLine("LockStudentsWindow::CancelLock<<End");
}

void LockStudentsWindow::SetCheckBtn(GtkToggleButton* toggle, gpointer data)
{
	LockStudentsWindow* ptr = (LockStudentsWindow*)data;
	if(gtk_toggle_button_get_active (toggle))
	{
		gtk_widget_set_sensitive(ptr->m_gHourCombo, TRUE);
		gtk_widget_set_sensitive(ptr->m_gMinuteCombo, TRUE);
	}
	else
	{
		gtk_widget_set_sensitive(ptr->m_gHourCombo, FALSE);
		gtk_widget_set_sensitive(ptr->m_gMinuteCombo, FALSE);
	}
}
