#include <glib/gi18n.h>
#include "PreferenceWindow.h"
#include "SESCommonDef.h"
#include "libsesgui.h"

#define PREFERENCE_WINDOW_BORDER_WIDTH 1
#define PREFERENCE_WINDOW_WIDTH 290
#define PREFERENCE_WINDOW_HEIGHT 145
#define PREFERENCE_WINDOW_ENTRY_WIDTH 200
#define PREFERENCE_WINDOW_ENTRY_HEIGHT 22

using namespace LibSESGUI;
using namespace LibSESData;
PreferenceWindow::PreferenceWindow()
{
    m_gWindow = NULL;
    m_gAutoDeployCheckBtn = NULL;
    m_gNewStudentDialogBtn = NULL;

    m_pSESSystemSettingData = new CSESSystemSettingData();
    m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
}
PreferenceWindow::~PreferenceWindow()
{

}
void PreferenceWindow::Init()
{
    InitWindow();
}
void PreferenceWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
    gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
    gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
    if (NULL != cb)
    {
        g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
    }
    gtk_widget_show_all(m_gWindow);
}
void PreferenceWindow::InitWindow()
{
    m_gWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    g_signal_connect (m_gWindow, "delete-event", G_CALLBACK (OnWindowClosing), this);
    gtk_container_set_border_width (GTK_CONTAINER (m_gWindow), 1);
    gtk_window_set_position (GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
    gtk_widget_set_size_request (GTK_WIDGET (m_gWindow), PREFERENCE_WINDOW_WIDTH,PREFERENCE_WINDOW_HEIGHT);
    gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
    gtk_window_set_resizable(GTK_WINDOW (m_gWindow), FALSE);
    gtk_window_set_title(GTK_WINDOW (m_gWindow), _("Preferences"));

    gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Preferences"), "SES");
    gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);


    string iconPath("");
    iconPath.append(SES_RESOURCE_IMAGE_PATH);
    iconPath.append("shellcontroller_main.png");

    GError** error = NULL;
    gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), SES_SHELL_CONTROLLER_ICON.c_str(), error);


    GtkWidget* pVbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(m_gWindow), pVbox);

    GtkWidget* pHbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 20);

    m_iAutoDeployData = m_pSESSystemSettingData->GetAutoDeployEnabled();
    m_gAutoDeployCheckBtn = gtk_check_button_new_with_label(_("Automatically deploy"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_gAutoDeployCheckBtn), m_iAutoDeployData);
    g_signal_connect (m_gAutoDeployCheckBtn, "toggled", G_CALLBACK (OnAutoDeployCheckBtn), this);
    gtk_box_pack_start(GTK_BOX(pHbox), m_gAutoDeployCheckBtn, FALSE, FALSE, 5);

    pHbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 0);

    m_iNewStudentDialog = m_pSESSystemSettingData->GetNewStudentConnectDialogEnable();
    m_gNewStudentDialogBtn = gtk_check_button_new_with_label(_("Show new student connect notify dialog"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_gNewStudentDialogBtn), m_iNewStudentDialog);
    g_signal_connect (m_gNewStudentDialogBtn, "toggled", G_CALLBACK (OnNewStudentDialogCheckBtn), this);
    gtk_box_pack_start(GTK_BOX(pHbox), m_gNewStudentDialogBtn, FALSE, FALSE, 5);

    pHbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_end(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);


    GtkWidget* pButton = gtk_button_new_with_label("OK");
    g_signal_connect (pButton, "clicked", G_CALLBACK (OnOKBtn), this);
    gtk_widget_set_tooltip_text (pButton, _("OK"));
    gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
    gtk_box_pack_end(GTK_BOX(pHbox), pButton, FALSE, FALSE, 10);

    pButton = gtk_button_new_with_label("Cancel");
    g_signal_connect (pButton, "clicked", G_CALLBACK (OnCancelBtn), this);
    gtk_widget_set_tooltip_text (pButton, _("Cancel"));
    gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
    gtk_box_pack_end(GTK_BOX(pHbox), pButton, FALSE, FALSE,0);





}

void PreferenceWindow::OnAutoDeployCheckBtn(GtkToggleButton* toggleBtn, gpointer data)
{
    PreferenceWindow* ptr = (PreferenceWindow*)data;

    //ptr->m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
    if(true == gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggleBtn)))
    {
        string message = _("Shell Settings will be automatically deployed to students once they connect to you. Are you sure you want to enable it?");
        int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_YES_NO);

//        GtkWidget* pDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//                           GtkDialogFlags(GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT),
//                           GTK_MESSAGE_INFO,
//                           GTK_BUTTONS_YES_NO,
//                           "You have selected automatically deploy settings, are you sure?");
//        //if(GTK_RESPONSE_YES == gtk_dialog_run(GTK_DIALOG(pDialog)))
        if( GTK_RESPONSE_YES == result )
        {
            ptr->m_pSESSystemSettingData->SetAutoDeployEnabled(1);
        }
        else
        {
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggleBtn), false);
        }
        //gtk_widget_destroy(pDialog);
    }
    else
    {
        ptr->m_pSESSystemSettingData->SetAutoDeployEnabled(0);
    }


}


void PreferenceWindow::OnNewStudentDialogCheckBtn(GtkToggleButton* toggleBtn, gpointer data)
{
    PreferenceWindow* ptr = (PreferenceWindow*)data;
    //ptr->m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
    //int newStudentConnectDialogValue = ptr->m_pSESSystemSettingData->GetNewStudentConnectDialogEnable();
    if(true == gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggleBtn)))
    {
      ptr->m_pSESSystemSettingData->SetNewStudentConnectDialogEnable(1);

    }
    else
    {
      ptr->m_pSESSystemSettingData->SetNewStudentConnectDialogEnable(0);
    }

}

void PreferenceWindow::OnOKBtn(GtkButton* button, gpointer data)
{
    PreferenceWindow* ptr = (PreferenceWindow*)data;
    ptr->m_pSESSystemSettingData->Save2File(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
    gtk_widget_destroy(ptr->m_gWindow);
}


void PreferenceWindow::OnCancelBtn(GtkButton* button, gpointer data)
{
    PreferenceWindow* ptr = (PreferenceWindow*)data;

    if((ptr->m_iAutoDeployData == ptr->m_pSESSystemSettingData->GetAutoDeployEnabled())
            &&(ptr->m_iNewStudentDialog == ptr->m_pSESSystemSettingData->GetNewStudentConnectDialogEnable()))
    {

    }
    else
    {
//        GtkWidget *outDialog = NULL;
//        outDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//                          GTK_DIALOG_MODAL,
//                          GTK_MESSAGE_QUESTION,
//                          GTK_BUTTONS_YES_NO,
//                          _("Do you want to save the data?"));
//        gtk_window_set_title(GTK_WINDOW(outDialog), "Information");
        string message(_("Do you want to save the data?"));
        int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
        if(GTK_RESPONSE_YES == result)
        {
           ptr->m_pSESSystemSettingData->Save2File(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
        }
        //gtk_widget_destroy(outDialog);

    }
    gtk_widget_destroy(ptr->m_gWindow);
}

bool PreferenceWindow::OnWindowClosing(GtkWindow* gtkwindow, GdkEvent* event, gpointer data)
{
    PreferenceWindow* ptr = (PreferenceWindow*)data;

    if((ptr->m_iAutoDeployData == ptr->m_pSESSystemSettingData->GetAutoDeployEnabled())
               &&(ptr->m_iNewStudentDialog == ptr->m_pSESSystemSettingData->GetNewStudentConnectDialogEnable()))
    {

    }
    else
    {
//       GtkWidget *outDialog = NULL;
//       outDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//                         GTK_DIALOG_MODAL,
//                         GTK_MESSAGE_QUESTION,
//                         GTK_BUTTONS_YES_NO,
//                         _("Do you want to save the data?"));
//       gtk_window_set_title(GTK_WINDOW(outDialog), "Information");

       string message(_("Do you want to save the data?"));
       int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
       if(GTK_RESPONSE_YES == result)
       {
          ptr->m_pSESSystemSettingData->Save2File(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
       }
       //gtk_widget_destroy(outDialog);
    }


    return false;

}
