/******************************************************************************
 * File Name    : ShellControllerWindow.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : Initialize and show ShellController
 ******************************************************************************/
#include <stdlib.h>
#include <dirent.h>
#include <vector>
#include <fcntl.h>
#include <glib/gi18n.h>

#include "ShellControllerWindow.h"

#include "CommonMessage.h"
#include "libsesdata.h"
#include "CAboutDlg.h"
#include "PublicFunc.h"

using namespace LibSESData;
using namespace LibSESGUI;
using namespace std;
using namespace IPCAPI;

namespace ShellController
{

#define SHELL_CONTROLLER_WINDOW_BORDER_WIDTH 1
#define SHELL_CONTROLLER_WINDOW_WINDOW_WIDTH 658
#define SHELL_CONTROLLER_WINDOW_WINDOW_HEIGHT 370


enum
{
	COLUMN_ITEM_NAME, 				//G_TYPE_STRING for iconview student display name
	COLUMN_ITEM_PIC, 				//GDK_TYPE_PIXBUF for display connected and locked status icon
	COLUMN_ITEM_POINTER,			//TODO G_TYPE_INT for store pointer of StudentInfo_t
	COLUMN_ITEM_CONNECTED,			//G_TYPE_BOOLEAN for store connected status
//	COLUMN_ITEM_LOCKED,				//G_TYPE_BOOLEAN for store locked status
//	COLUMN_ITEM_STUDENT_ID,			//G_TYPE_STRING for display student ID
//	COLUMN_ITEM_STUDENT_NAME,		//G_TYPE_STRING for display student name
//	COLUMN_ITEM_CONNECTED_DISPLAY,	//G_TYPE_STRING for display connected status string
//	COLUMN_ITEM_LOCKED_DISPLAY,		//G_TYPE_STRING for display locked status string
	COLUMN_ITEM_NUM,

	COLUMN_ITEM_SORT_ID,
	COLUMN_ITEM_SORT_NAME,
	COLUMN_ITEM_SORT_CONNECTED,
	COLUMN_ITEM_SORT_LOCKED
};

gchar* STRING_STUDENT_CONNECTED = _("Connected");
gchar* STRING_STUDENT_DISCONNECTED = _("Disconnected");
gchar* STRING_STUDENT_LOCKED = _("Locked");
gchar* STRING_STUDENT_UNLOCKED = _("Unlocked");
const gchar* STRING_STUDENT_EMPTY = "";



/******************************************************************************
 * Function Name: ShellControllerWindow
 * Description  : Construction of ShellControllerWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
ShellControllerWindow::ShellControllerWindow ()
{
	CSESLog::WriteLine("ShellControllerWindow::ShellControllerWindow >>Start");

	m_pScrolledWindow = NULL;
	m_gDeployBtn = NULL;
	m_gLockBtn = NULL;
	m_gUnlockBtn = NULL;
    m_gWindow = NULL;
    m_gStore = NULL;
    m_pSelectClassWindow = NULL;
    m_pPassWordWindow = NULL;
    m_pChangePassWordWindow = NULL;
   // m_pAutoDeployCheckItem = NULL;
    m_pAboutdialogWindow = NULL;
    m_pPreferenceWindow = NULL;

    m_gViewCheckbtn = NULL;

    m_mainViewOperation = NULL;
	m_mainIconVeiwOperation = NULL;
	m_mainTreeVeiwOperation = NULL;

    iInited = 0;
    m_iClassType = -1;

    m_eClassSelectStatus = NoClass;

    m_connectedAndLockedPixBuf = NULL;
	m_connectedAndUnlockedPixBuf = NULL;
	m_disconnectedPixBuf = NULL;

	m_connectedAndLockedExtendPixBuf = NULL;
	m_connectedAndUnLockExtendPixBuf = NULL;
	m_gClassLabel = NULL;
	m_pClassGroup = new CClassGroupData();
	m_pSelectedClass = NULL;
	m_pShellSetting = NULL;
	m_pSearchProgram = NULL;
	m_pLockStudentsWindow = NULL;
	m_pTeacherInfoWindow = NULL;
	m_pStudentDetailedWindow = NULL;
	m_pSESSystemSettingData = new CSESSystemSettingData();
	//m_gSearingProgramItem = NULL;
	//m_iStartControllerOK = 1;

	m_gAutoDeployLabel = NULL;

	m_gMasterClient = NULL;
	CSESLog::WriteLine("ShellControllerWindow::ShellControllerWindow <<End");
}
/******************************************************************************
 * Function Name: ~ShellControllerWindow
 * Description  : Destruction of ShellControllerWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
ShellControllerWindow::~ShellControllerWindow ()
{
	CSESLog::WriteLine("ShellControllerWindow::~ShellControllerWindow >>Start");
	Close();

	if(m_gStore != NULL)
	{
		g_object_unref((gpointer)m_gStore);
	}

	if(m_mainViewOperation != NULL)
	{
		m_mainViewOperation = NULL;
	}

	if(m_mainIconVeiwOperation != NULL)
	{
		delete m_mainIconVeiwOperation;
		m_mainIconVeiwOperation = NULL;
	}

	if(m_mainTreeVeiwOperation != NULL)
	{
		delete m_mainTreeVeiwOperation;
		m_mainTreeVeiwOperation = NULL;
	}


	if(m_pClassGroup != NULL)
	{
		delete m_pClassGroup;
		m_pClassGroup = NULL;
	}
	if(m_pShellSetting != NULL)
	{
		delete m_pShellSetting;
		m_pShellSetting = NULL;
	}
	if(m_pSESSystemSettingData != NULL)
	{
		delete m_pSESSystemSettingData;
		m_pSESSystemSettingData = NULL;
	}

	ReleasePixbuf();
	CSESLog::WriteLine("ShellControllerWindow::~ShellControllerWindow <<End");
}
/******************************************************************************
 * Function Name: InitWindow
 * Description  : Initialization of main window
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::InitWindow()
{
	CSESLog::WriteLine("ShellControllerWindow::InitWindow >>Start");
	GtkWidget* pMainVbox = NULL;
	GtkWidget* pHbox = NULL;
	GtkWidget* pScrolledVbox = NULL;
	GtkWidget* pTopHbox = NULL;
	//GtkWidget* pScrolledWindow = NULL;
	GtkWidget* pBtnVbox = NULL;
	//GtkWidget* pStatusVbox = NULL;
	m_gWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Shell Controller"), "SES");

	g_signal_connect(G_OBJECT (m_gWindow), "destroy", G_CALLBACK (gtk_main_quit), NULL);
	g_signal_connect(G_OBJECT (m_gWindow), "delete_event", G_CALLBACK (OnWindowClosing), this);
	gtk_window_set_title (GTK_WINDOW (m_gWindow), _("Shell Controller"));
	gtk_container_set_border_width (GTK_CONTAINER (m_gWindow), 0);
	gtk_window_set_position (GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER);
	gtk_widget_set_size_request (GTK_WIDGET (m_gWindow), SHELL_CONTROLLER_WINDOW_WINDOW_WIDTH ,SHELL_CONTROLLER_WINDOW_WINDOW_HEIGHT);
	gtk_window_set_resizable (GTK_WINDOW (m_gWindow), FALSE);
	string iconPath("");
	iconPath.append(SES_RESOURCE_IMAGE_PATH);
	iconPath.append("shellcontroller_main.png");
	GError** error = NULL;
	gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), iconPath.c_str(), error);
	if(NULL == error)
	{
		CSESLog::WriteLine("ShellControllerWindow::InitWindow --Load File Failure!");
	}
	gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	g_signal_connect (G_OBJECT (m_gWindow), "show", G_CALLBACK (WindowShow), this);

	pMainVbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (m_gWindow), pMainVbox);


	InitFileMenu(pMainVbox);

	pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pMainVbox), pHbox, FALSE, FALSE, 0);

//	GtkWidget* pMarginHbox = gtk_hbox_new(false, 0);
//    gtk_widget_set_size_request(pMarginHbox, 5, 300);
//    gtk_box_pack_start (GTK_BOX (pHbox), pMarginHbox, FALSE, FALSE, 0);


	pScrolledVbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pHbox), pScrolledVbox, FALSE, FALSE, 5);


	pTopHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pScrolledVbox), pTopHbox, FALSE, FALSE, 0);


	m_gClassLabel = gtk_label_new(_(""));

	gtk_label_set_max_width_chars(GTK_LABEL(m_gClassLabel), 20);
	gtk_label_set_justify(GTK_LABEL(m_gClassLabel), GTK_JUSTIFY_LEFT);
	gtk_label_set_ellipsize(GTK_LABEL(m_gClassLabel), PANGO_ELLIPSIZE_END);
	gtk_box_pack_start(GTK_BOX (pTopHbox), m_gClassLabel, FALSE, FALSE, 5);


	m_gViewCheckbtn = gtk_check_button_new_with_label(_("List View"));
	g_signal_connect (m_gViewCheckbtn, "toggled", G_CALLBACK (CheckButtonChangeView), this);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (m_gViewCheckbtn), FALSE);
	gtk_box_pack_end(GTK_BOX (pTopHbox), m_gViewCheckbtn, FALSE, FALSE, 0);

	m_gSelectAllCheckbtn = gtk_check_button_new_with_label(_("Select All"));
	g_signal_connect (m_gSelectAllCheckbtn, "toggled", G_CALLBACK (ShellControllerWindow::SelectAll), this);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (m_gSelectAllCheckbtn), FALSE);
	gtk_box_pack_end(GTK_BOX (pTopHbox), m_gSelectAllCheckbtn, FALSE, FALSE, 10);

//	GtkWidget* btn = gtk_button_new_with_label(_("Change View"));
//	g_signal_connect (G_OBJECT(btn), "clicked", G_CALLBACK (ShellControllerWindow::ChangeView), this);
//	//gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (m_gSelectAllCheckbtn), FALSE);
//	gtk_box_pack_end(GTK_BOX (pTopHbox), btn, FALSE, FALSE, 0);


	m_pScrolledWindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (m_pScrolledWindow), 0);
	gtk_widget_set_size_request (m_pScrolledWindow, 510, 300);
	gtk_box_pack_start (GTK_BOX (pScrolledVbox), m_pScrolledWindow, FALSE, FALSE, 0);


	m_gStore = gtk_list_store_new(COLUMN_ITEM_NUM, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_INT, G_TYPE_BOOLEAN);
	g_object_ref((gpointer)m_gStore);
	gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(m_gStore), COLUMN_ITEM_SORT_ID, StudentIdCompareFunc, this, NULL);
	gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(m_gStore), COLUMN_ITEM_SORT_NAME, StudentNameCompareFunc, this, NULL);
	gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(m_gStore), COLUMN_ITEM_SORT_CONNECTED, ConnectedStatusCompareFunc, this, NULL);
	gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(m_gStore), COLUMN_ITEM_SORT_LOCKED, LockedStatusCompareFunc, this, NULL);

	CreateIconView (m_gStore);
	CreateTreeView (m_gStore);

	m_mainViewOperation =  m_mainIconVeiwOperation;
	//gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (m_pScrolledWindow), m_gIconView);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (m_pScrolledWindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	//gtk_container_set_border_width(GTK_CONTAINER(m_pScrolledWindow), 1);
	//gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(m_pScrolledWindow), m_gTreeview);// m_gIconView);
	gtk_container_add(GTK_CONTAINER(m_pScrolledWindow), m_gIconView);

	pBtnVbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_end (GTK_BOX (pHbox), pBtnVbox, FALSE, FALSE, 5);


	InitButtons (pBtnVbox);

//	pStatusVbox = gtk_vbox_new(FALSE, 0);
//	gtk_box_pack_start(GTK_BOX (pMainVbox), pStatusVbox, FALSE, FALSE, 0);

	GtkWidget* pBottomHbox = gtk_hbox_new (FALSE, 0);
	//gtk_widget_set_size_request(pBottomHbox, 520, 20);
	gtk_box_pack_start (GTK_BOX (pMainVbox), pBottomHbox, FALSE, FALSE, 4);


	GtkWidget* pAlignment = gtk_alignment_new (0, 0, 0, 0);
	gtk_box_pack_start(GTK_BOX(pBottomHbox), pAlignment, false, false, 5);

	m_gAutoDeployLabel = gtk_label_new("");
	gtk_label_set_justify (GTK_LABEL(m_gAutoDeployLabel), GTK_JUSTIFY_LEFT);
	gtk_container_add(GTK_CONTAINER(pAlignment), m_gAutoDeployLabel);

	m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
	int iAutoDeployData = m_pSESSystemSettingData->GetAutoDeployEnabled();

	SetAutoDeployStatusOnBottom(iAutoDeployData);


//	if(1 == iAutoDeployData)
//	{
//	    string message("Automatically deploy is enabled!");
//	    gtk_label_set_text(GTK_LABEL(pDeployLabel), message.c_str());
//	}
//	else
//	{
//	    string message("Automatically deploy is enabled!");
//	    gtk_label_set_text(GTK_LABEL(pDeployLabel), message.c_str());
//	}


	string connectedAndLockedPath = SES_RESOURCE_IMAGE_PATH + "sc_ThisClass_Lock.png";//"gui_lock.png";//"sc_ThisClass_Lock.png";
	string connectedAndUnLockPath = SES_RESOURCE_IMAGE_PATH + "sc_ThisClass_Unlock.png";//"gui_unlock.png";//"sc_ThisClass_Unlock.png";
	string disconnectedPath = SES_RESOURCE_IMAGE_PATH + "sc_ThisClass_Unlock_Disconnect.png";//"gui_offline.png";//"sc_ThisClass_Unlock_Disconnect.png";

	string connectedAndLockedExtendPath = SES_RESOURCE_IMAGE_PATH + "sc_NotThisClass_Lock.png";
	string connectedAndUnLockExtendPath = SES_RESOURCE_IMAGE_PATH + "sc_NotThisClass_Unlock.png";

	m_connectedAndLockedPixBuf = gdk_pixbuf_new_from_file(connectedAndLockedPath.c_str(), NULL);
	m_connectedAndUnlockedPixBuf = gdk_pixbuf_new_from_file(connectedAndUnLockPath.c_str(), NULL);
	m_disconnectedPixBuf = gdk_pixbuf_new_from_file(disconnectedPath.c_str(), NULL);
	m_connectedAndLockedExtendPixBuf = gdk_pixbuf_new_from_file(connectedAndLockedExtendPath.c_str(), NULL);
	m_connectedAndUnLockExtendPixBuf = gdk_pixbuf_new_from_file(connectedAndUnLockExtendPath.c_str(), NULL);

	CSESLog::WriteLine("ShellControllerWindow::InitWindow <<End");
	return 0;
}
/******************************************************************************
 * Function Name: InitFileMenu
 * Description  : Create file menu
 * Date         : 2008/9/10
 * Parameter    : GtkWidget*, parent, parent GtkWidget
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return 1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::InitFileMenu(GtkWidget* parent)
{
	CSESLog::WriteLine("ShellControllerWindow::InitFileMenu >>Start");
	GtkWidget* pMenubar = NULL;
	GtkWidget* pRootMenu = NULL;
	GtkWidget* pItems = NULL;
	GtkWidget* pMenu = NULL;
	pMenubar = gtk_menu_bar_new ();
	gtk_box_pack_start(GTK_BOX (parent), pMenubar, FALSE, FALSE, 0);


	pRootMenu = gtk_menu_item_new_with_label(_("File"));
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenubar), pRootMenu);


	pMenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM (pRootMenu), pMenu);

	pItems = gtk_menu_item_new_with_label(_("Import New CA"));
	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::ImportNewCACallBack), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);


	pItems = gtk_menu_item_new_with_label(_("Import Shell Settings"));
	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::ImportShellSettings), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);


	pItems = gtk_menu_item_new_with_label(_("Export Shell Settings"));
	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::ExportShellSettings), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);


	pItems = gtk_menu_item_new_with_label(_("Exit"));
	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (gtk_main_quit), NULL);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);


	pRootMenu = gtk_menu_item_new_with_label(_("Tools"));
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenubar), pRootMenu);


	pMenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM (pRootMenu), pMenu);

	pItems = gtk_menu_item_new_with_label(_("Shell Settings"));
    g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::ShowShellSettings), this);
    gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);

	m_gDeploySettingsItems = gtk_menu_item_new_with_label(_("Deploy Settings"));
	g_signal_connect (G_OBJECT (m_gDeploySettingsItems), "activate", G_CALLBACK (DeploySettings), this);
	gtk_widget_set_sensitive(m_gDeploySettingsItems, false);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), m_gDeploySettingsItems);


	m_gLockItems = gtk_menu_item_new_with_label(_("Lock..."));
	g_signal_connect (G_OBJECT (m_gLockItems), "activate", G_CALLBACK (ShellControllerWindow::ShowLockDialog), this);
	gtk_widget_set_sensitive(m_gLockItems, false);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), m_gLockItems);


	m_gUnlockItems = gtk_menu_item_new_with_label(_("Unlock"));
	g_signal_connect (G_OBJECT (m_gUnlockItems), "activate", G_CALLBACK (ShowUnlockDialog), this);
	gtk_widget_set_sensitive(m_gUnlockItems, false);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), m_gUnlockItems);


//	m_gSearingProgramItem = gtk_menu_item_new_with_label(_("Search Program"));
//	g_signal_connect (G_OBJECT (m_gSearingProgramItem), "activate", G_CALLBACK (ShowProgramSearching), this);
//	gtk_widget_set_sensitive(m_gSearingProgramItem, false);
//	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), m_gSearingProgramItem);
//	gtk_widget_show(m_gSearingProgramItem);


	pRootMenu = gtk_menu_item_new_with_label(_("Settings"));
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenubar), pRootMenu);


	pMenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM (pRootMenu), pMenu);

//	m_pAutoDeployCheckItem =  gtk_check_menu_item_new_with_label(_("Automatically Deploy"));
//	g_signal_connect (G_OBJECT (m_pAutoDeployCheckItem), "activate", G_CALLBACK (ShellControllerWindow::AutoDeploy), this);
//	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(m_pAutoDeployCheckItem), m_pSESSystemSettingData->GetAutoDeployEnabled());
//	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), m_pAutoDeployCheckItem);
//	gtk_widget_show(m_pAutoDeployCheckItem);

//	pItems = gtk_menu_item_new_with_label(_("Shell Settings"));
//	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::ShowShellSettings), this);
//	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);
//	gtk_widget_show(pItems);

	pItems = gtk_menu_item_new_with_label(_("Select Class"));
	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::SelectClass), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);


	pItems = gtk_menu_item_new_with_label(_("Teacher Information"));
	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::ShowTeacherWindow), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);


	pItems =  gtk_menu_item_new_with_label(_("Change Password"));
	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::ChangePassword), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);


     pItems = gtk_menu_item_new_with_label(_("Preferences"));
     g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK (ShellControllerWindow::PreferenceWindowShow), this);
     gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);


	GSList* pGroup = NULL;

	pRootMenu = gtk_menu_item_new_with_label(_("View"));
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenubar), pRootMenu);


	pMenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM (pRootMenu), pMenu);

	m_gIconViewItem =  gtk_radio_menu_item_new_with_label(pGroup, _("Icon View"));
	g_signal_connect (G_OBJECT (m_gIconViewItem), "toggled", G_CALLBACK (RadioButtonChangeView), this);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(m_gIconViewItem), TRUE);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), m_gIconViewItem);


	pGroup = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (m_gIconViewItem));

	m_gListViewItem = gtk_radio_menu_item_new_with_label(pGroup, _("List View"));
	g_signal_connect (G_OBJECT (m_gListViewItem), "toggled", G_CALLBACK (RadioButtonChangeView), this);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(m_gListViewItem), FALSE);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), m_gListViewItem);



	pRootMenu = gtk_menu_item_new_with_label(_("Help"));
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenubar), pRootMenu);


	pMenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM (pRootMenu), pMenu);

	pItems = gtk_menu_item_new_with_label(_("Help Contents"));
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);
	gtk_widget_set_sensitive(pItems, false);


	pItems = gtk_menu_item_new_with_label(_("About"));
	g_signal_connect (G_OBJECT (pItems), "activate", G_CALLBACK(ShowAboutInfo), this);
	gtk_menu_shell_append(GTK_MENU_SHELL (pMenu), pItems);
	gtk_widget_set_sensitive(pItems, true);



	CSESLog::WriteLine("ShellControllerWindow::InitFileMenu <<End");
	return 0;
}

void ShellControllerWindow::CheckButtonChangeView(GtkToggleButton* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;



//changed by lfeng
	if(ptr->m_mainIconVeiwOperation && ptr->m_mainTreeVeiwOperation)
	{
		GList* glist = ptr->m_mainViewOperation->MainViewGetSelectedItems();

		if(FALSE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(gtkwidget)))
		{
			//if(ptr->m_mainViewOperation != ptr->m_mainIconVeiwOperation)
			//{
	//			gtk_container_remove(GTK_CONTAINER(widget), gtk_bin_get_child(GTK_BIN(widget)));
	//			gtk_container_add(GTK_CONTAINER(widget), ptr->m_gIconView);

				//gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), ptr->m_gIconView);
			if(ptr->m_mainViewOperation != ptr->m_mainIconVeiwOperation)
			{
				gtk_container_remove(GTK_CONTAINER(ptr->m_pScrolledWindow), gtk_bin_get_child(GTK_BIN(ptr->m_pScrolledWindow)));
				gtk_container_add(GTK_CONTAINER(ptr->m_pScrolledWindow), ptr->m_gIconView);

				ptr->m_mainViewOperation = ptr->m_mainIconVeiwOperation;

				gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

				ptr->m_mainViewOperation->MainViewUnselectAll();
				ptr->m_mainViewOperation->MainViewSelectPath(glist);

				gtk_widget_show(ptr->m_gIconView);

				gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(ptr->m_gIconViewItem), true);


			}
		}
		else
		{
//			else
//			{
				//gtk_container_remove(GTK_CONTAINER(ptr->m_pScrolledWindow), ptr->m_gIconView);//gtk_bin_get_child(GTK_BIN(ptr->m_pScrolledWindow)));
				//gtk_container_remove(GTK_CONTAINER(widget), gtk_bin_get_child(GTK_BIN(widget)));
				//gtk_container_add(GTK_CONTAINER(widget), ptr->m_gTreeview);

			if(ptr->m_mainViewOperation != ptr->m_mainTreeVeiwOperation)
			{
				gtk_container_remove(GTK_CONTAINER(ptr->m_pScrolledWindow), gtk_bin_get_child(GTK_BIN(ptr->m_pScrolledWindow)));
				gtk_container_add(GTK_CONTAINER(ptr->m_pScrolledWindow), ptr->m_gTreeview);

				ptr->m_mainViewOperation = ptr->m_mainTreeVeiwOperation;
				gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

				ptr->m_mainViewOperation->MainViewUnselectAll();

				ptr->m_mainViewOperation->MainViewSelectPath(glist);
				//gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), ptr->m_gTreeview);
				gtk_widget_show(ptr->m_gTreeview);

				gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM(ptr->m_gListViewItem), true);
			}
		}

		g_list_foreach (glist, (GFunc)gtk_tree_path_free, NULL);
		g_list_free (glist);

	}


//		if(ptr->m_mainViewOperation != ptr->m_mainIconVeiwOperation)
//		{
////			gtk_container_remove(GTK_CONTAINER(widget), gtk_bin_get_child(GTK_BIN(widget)));
////			gtk_container_add(GTK_CONTAINER(widget), ptr->m_gIconView);
//
//			//gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), ptr->m_gIconView);
//
//			gtk_container_remove(GTK_CONTAINER(ptr->m_pScrolledWindow), gtk_bin_get_child(GTK_BIN(ptr->m_pScrolledWindow)));
//			gtk_container_add(GTK_CONTAINER(ptr->m_pScrolledWindow), ptr->m_gIconView);
//
//			ptr->m_mainViewOperation = ptr->m_mainIconVeiwOperation;
//
//			gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
//
//			ptr->m_mainViewOperation->MainViewSelectPath(glist);
//
//			gtk_widget_show(ptr->m_gIconView);
//
//
//		}
//		else
//		{
//			//gtk_container_remove(GTK_CONTAINER(ptr->m_pScrolledWindow), ptr->m_gIconView);//gtk_bin_get_child(GTK_BIN(ptr->m_pScrolledWindow)));
//			//gtk_container_remove(GTK_CONTAINER(widget), gtk_bin_get_child(GTK_BIN(widget)));
//			//gtk_container_add(GTK_CONTAINER(widget), ptr->m_gTreeview);
//
//
//			gtk_container_remove(GTK_CONTAINER(ptr->m_pScrolledWindow), gtk_bin_get_child(GTK_BIN(ptr->m_pScrolledWindow)));
//			gtk_container_add(GTK_CONTAINER(ptr->m_pScrolledWindow), ptr->m_gTreeview);
//			ptr->m_mainViewOperation = ptr->m_mainTreeVeiwOperation;
//			gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
//
//			ptr->m_mainViewOperation->MainViewUnselectAll();
//
//			ptr->m_mainViewOperation->MainViewSelectPath(glist);
//			//gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), ptr->m_gTreeview);
//			gtk_widget_show(ptr->m_gTreeview);
//		}
//
//		g_list_foreach (glist, (GFunc)gtk_tree_path_free, NULL);
//		g_list_free (glist);
//
//	}
}

/******************************************************************************
 * Function Name: CreateTreeView
 * Description  : Create Iconview
 * Date         : 2008/12/9
 * Parameter    : GtkWidget*, parent, parent GtkWidget
 * Return Code  : OK		return 0
 *              : FAILURE	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::CreateTreeView(GtkListStore * gStore)
{
	CSESLog::WriteLine("ShellControllerWindow::CreateTreeView >>Start");
	//m_gStore = gtk_list_store_new(COLUMN_ITEM_NUM, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_INT, G_TYPE_BOOLEAN);
	m_gTreeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL(gStore));
	g_signal_connect(G_OBJECT(m_gTreeview), "row-activated", G_CALLBACK(ShowStuInfoTreeView), this);
	GtkTreeSelection*  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_gTreeview));
	g_signal_connect(G_OBJECT(selection), "changed", G_CALLBACK(HasSelected), this);
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	//gtk_tree_view_set_tooltip_column(GTK_TREE_VIEW(m_gTreeview), 0);
	//gtk_tree_view_set_tooltip_column(GTK_TREE_VIEW(m_gTreeview), 1);
	//gtk_tree_view_set_tooltip_column(GTK_TREE_VIEW(m_gTreeview), 2);
	//gtk_tree_view_set_tooltip_column(GTK_TREE_VIEW(m_gTreeview), 3);

	GtkCellRenderer *renderer = NULL;
	GtkTreeViewColumn *column = NULL;

	/* column for severities */
//	renderer = gtk_cell_renderer_pixbuf_new ();
//	column = gtk_tree_view_column_new_with_attributes ("",
//							 renderer,
//							 "pixbuf",
//							 COLUMN_ITEM_PIC,
//							 NULL);
//	//gtk_tree_view_column_set_sort_column_id (column, COLUMN_ITEM_PIC);
//	gtk_tree_view_append_column (GTK_TREE_VIEW(m_gTreeview), column);

//	renderer = gtk_cell_renderer_text_new ();
//	column = gtk_tree_view_column_new_with_attributes (_("Student"),
//							 renderer,
//							 "text",
//							 COLUMN_ITEM_NAME,
//							 NULL);
//	gtk_tree_view_column_set_sort_column_id (column, COLUMN_ITEM_NAME);
//	gtk_tree_view_append_column (GTK_TREE_VIEW(m_gTreeview), column);

//	renderer = gtk_cell_renderer_toggle_new();
//	g_object_set (renderer, "xalign", 0.0, NULL);
//	column = gtk_tree_view_column_new_with_attributes (_("IsConnected"),
//							 renderer,
//							 "active",
//							 COLUMN_ITEM_CONNECTED,
//							 NULL);
//	gtk_tree_view_append_column (GTK_TREE_VIEW(m_gTreeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes(_("Student ID"), renderer, NULL);
	gtk_tree_view_column_set_cell_data_func(column, renderer, StudentIdCellDataFunc, NULL, NULL);
	//gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column), true);
	gtk_tree_view_column_set_sizing(GTK_TREE_VIEW_COLUMN(column), GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width(GTK_TREE_VIEW_COLUMN(column), 120);
	g_object_set(renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_ITEM_SORT_ID);
	gtk_tree_view_append_column (GTK_TREE_VIEW(m_gTreeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes(_("Student Name"), renderer, NULL);
	gtk_tree_view_column_set_cell_data_func(column, renderer, StudentNameCellDataFunc, NULL, NULL);
	//gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column), true);
	gtk_tree_view_column_set_sizing(GTK_TREE_VIEW_COLUMN(column), GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width(GTK_TREE_VIEW_COLUMN(column), 130);
	g_object_set(renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_ITEM_SORT_NAME);
	gtk_tree_view_append_column (GTK_TREE_VIEW(m_gTreeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes(_("Connected Status"), renderer, NULL);
	gtk_tree_view_column_set_cell_data_func(column, renderer, ConnectedStatusCellDataFunc, NULL, NULL);
	//gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column), true);
	g_object_set(renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_ITEM_SORT_CONNECTED);
	gtk_tree_view_append_column (GTK_TREE_VIEW(m_gTreeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes(_("Locked Status"), renderer, NULL);
	gtk_tree_view_column_set_cell_data_func(column, renderer, LockedStatusCellDataFunc, NULL, NULL);
	//gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column), true);
	g_object_set(renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	gtk_tree_view_column_set_sort_column_id (column, COLUMN_ITEM_SORT_LOCKED);
	gtk_tree_view_append_column (GTK_TREE_VIEW(m_gTreeview), column);

	m_mainTreeVeiwOperation = new MainTreeVeiwOperation(m_gTreeview);

//	GtkTooltips pToolTip;
//	gtk_tooltip_set_text(GTK_TOOLTIP(pToolTip), "lifeng");
	//gtk_tree_view_set_tooltip_cell (GTK_TREE_VIEW(m_gTreeview), pToolTip, NULL, NULL, NULL);

	//gtk_tree_view_set_tooltip_column(GTK_TREE_VIEW(m_gTreeview), 0);
//	gtk_tree_view_set_tooltip_column(GTK_TREE_VIEW(m_gTreeview), 1);
//	gtk_tree_view_set_tooltip_column(GTK_TREE_VIEW(m_gTreeview), 2);
//	gtk_tree_view_set_tooltip_column(GTK_TREE_VIEW(m_gTreeview), 3);

	//gtk_widget_show(m_gTreeview);
	CSESLog::WriteLine("ShellControllerWindow::CreateTreeView <<End");
	return 0;
}

/******************************************************************************
 * Function Name: CreateIconView
 * Description  : Create Iconview
 * Date         : 2008/9/10
 * Parameter    : GtkWidget*, parent, parent GtkWidget
 * Return Code  : OK		return 0
 *              : FAILURE	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::CreateIconView(GtkListStore * gStore)
{
	CSESLog::WriteLine("ShellControllerWindow::CreateIconView >>Start");
	//m_gStore = gtk_list_store_new(COLUMN_ITEM_NUM, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_INT, G_TYPE_BOOLEAN);
	m_gIconView = gtk_icon_view_new_with_model(GTK_TREE_MODEL (gStore));
	g_signal_connect(G_OBJECT(m_gIconView), "item-activated", G_CALLBACK(ShowStuInfo), this);
	g_signal_connect(G_OBJECT(m_gIconView), "selection-changed", G_CALLBACK(HasSelected), this);
	gtk_icon_view_set_selection_mode(GTK_ICON_VIEW (m_gIconView), GTK_SELECTION_MULTIPLE);
	gtk_icon_view_set_orientation(GTK_ICON_VIEW (m_gIconView), GTK_ORIENTATION_VERTICAL);
	//gtk_icon_view_set_spacing(GTK_ICON_VIEW (m_gIconView), 1);
	gtk_icon_view_set_item_width(GTK_ICON_VIEW (m_gIconView), 0);
	//gtk_icon_view_set_margin(GTK_ICON_VIEW (m_gIconView), 1);
	//gtk_icon_view_set_column_spacing(GTK_ICON_VIEW (m_gIconView), 0);
	//gtk_icon_view_set_row_spacing(GTK_ICON_VIEW (m_gIconView), 0);
	//gtk_container_set_border_width(GTK_CONTAINER(m_pIconView),60);
	//gtk_widget_set_size_request(m_pIconView, 380, 210);
	//gtk_icon_view_set_columns(GTK_ICON_VIEW (m_gIconView), 4);
	gtk_icon_view_set_text_column (GTK_ICON_VIEW (m_gIconView), 0);
	gtk_icon_view_set_pixbuf_column (GTK_ICON_VIEW (m_gIconView), 1);
	//gtk_icon_view_set_text_column(GTK_ICON_VIEW (m_gIconView), 5);

	//gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (parent), m_gIconView);
	m_mainIconVeiwOperation = new MainIconVeiwOperation(m_gIconView);

	gtk_widget_show(m_gIconView);

	CSESLog::WriteLine("ShellControllerWindow::CreateIconView <<End");
	return 0;
}
/******************************************************************************
 * Function Name: HasSelected
 * Description  :
 * Date         : 2008/11/10
 * Parameter    : iconview			Gtk_Icon_View
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::HasSelected(GObject* iconview, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	//GList* list = gtk_icon_view_get_selected_items(iconview);

	GList* list = ptr->m_mainViewOperation->MainViewGetSelectedItems();

//	if(NULL == list)
//	{
//	    ptr->m_mainViewOperation->MainViewUnselectAll();
//	}

	ptr->SetMainUIButtonStatus(list);
	ptr->SetMainUIFileStatus(list);



//	if(NULL != list)
//	{
//		gtk_widget_set_sensitive(ptr->m_gSearingProgramItem, true);
//	}
//	else
//	{
//		gtk_widget_set_sensitive(ptr->m_gSearingProgramItem, false);
//	}





	g_list_foreach (list, (GFunc)gtk_tree_path_free, NULL);
	g_list_free (list);
}

void ShellControllerWindow::ShowStuInfoTreeView(GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data)
{
	ShowStuInfo(GTK_WIDGET(tree_view), path, user_data);
}

/******************************************************************************
 * Function Name: ShowStuInfo
 * Description  : Show details of selected student
 * Date         : 2008/9/10
 * Parameter    : GtkWidget*,	parent,		parent GtkWidget
 *              : GtkTreePath*,	path,		the path of gtkwidget
 *              : gpointer, data, user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ShowStuInfo(GtkWidget* gtkwidget, GtkTreePath* path, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::ShowStuInfo >>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	GtkTreeIter iter;
	GtkTreeModel* pModel = NULL;
	tagStudent_t* pClassStudent = NULL;
	pModel = ptr->m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model (GTK_ICON_VIEW (gtkwidget));
	gtk_tree_model_get_iter (pModel, &iter, path);
	gtk_tree_model_get(pModel, &iter, COLUMN_ITEM_POINTER, &pClassStudent, -1);

	ptr->m_pStudentDetailedWindow = new StudentDetailedInfoWindow(pClassStudent);
	ptr->m_pStudentDetailedWindow->Init();
	ptr->m_pStudentDetailedWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(ShellControllerWindow::StudentInfoWindowClosed), ptr);
	CSESLog::WriteLine("ShellControllerWindow::ShowStuInfo <<End");
}
/******************************************************************************
 * Function Name: StudentInfoWindowClosed
 * Description  : Delete the StudentDetailedInfoWindow pointer member when it
 *              : was closed
 * Date         : 2008/9/10
 * Parameter    : GtkWidget*, gtkwidget, the GtkWidget which triggers the event
 *              : GtkTreePath*, path, the path of gtkwidget
 *              : gpointer, data, user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::StudentInfoWindowClosed (GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::PrintClose >>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	delete (ptr->m_pStudentDetailedWindow);
	ptr->m_pStudentDetailedWindow = NULL;
	CSESLog::WriteLine("ShellControllerWindow::PrintClose <<End");
}
/******************************************************************************
 * Function Name: InitButtons
 * Description  : Initialization of buttons
 * Date         : 2008/9/10
 * Parameter    : GtkWidget*, parent, parent GtkWidget
 * Return Code  : Ok, 		return 0
 *              : FAILURE,	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::InitButtons(GtkWidget* parent)
{
	CSESLog::WriteLine("ShellControllerWindow::InitButtons >>Start");
	//GtkWidget* button = NULL;

//	m_gDeployBtn = gtk_button_new_with_mnemonic(_("Deploy Settings..."));
//	g_signal_connect (G_OBJECT (m_gDeployBtn), "clicked", G_CALLBACK (DeploySettings), this);
//	//gtk_widget_set_sensitive(m_gDeployBtn, FALSE);
//	gtk_widget_set_size_request(m_gDeployBtn, 120, 30);
//	gtk_box_pack_start(GTK_BOX (parent), m_gDeployBtn, FALSE, FALSE, 5);
//	gtk_widget_show(m_gDeployBtn);

	m_gLockBtn = gtk_button_new_with_mnemonic(_("Lock..."));
	g_signal_connect (G_OBJECT (m_gLockBtn), "clicked", G_CALLBACK (ShowLockDialog), this);
	gtk_widget_set_sensitive(m_gLockBtn, FALSE);
	gtk_widget_set_tooltip_text (m_gLockBtn, _("Lock"));
	gtk_widget_set_size_request(m_gLockBtn, 130, 30);
	gtk_box_pack_start(GTK_BOX (parent), m_gLockBtn, FALSE, FALSE, 20);


	m_gUnlockBtn = gtk_button_new_with_mnemonic(_("Unlock"));
	g_signal_connect (G_OBJECT (m_gUnlockBtn), "clicked", G_CALLBACK (ShellControllerWindow::ShowUnlockDialog), this);
	gtk_widget_set_sensitive(m_gUnlockBtn, FALSE);
	gtk_widget_set_tooltip_text (m_gUnlockBtn, _("UnLock"));
	gtk_widget_set_size_request(m_gUnlockBtn, 130, 30);
	gtk_box_pack_start(GTK_BOX (parent), m_gUnlockBtn, FALSE, FALSE, 0);


	m_gDeployBtn = gtk_button_new_with_mnemonic(_("Deploy Settings"));
	g_signal_connect (G_OBJECT (m_gDeployBtn), "clicked", G_CALLBACK (ShellControllerWindow::DeploySettings), this);
	gtk_widget_set_sensitive(m_gDeployBtn, FALSE);
	gtk_widget_set_tooltip_text (m_gDeployBtn, _("Deploy Settings"));
	gtk_widget_set_size_request(m_gDeployBtn, 130, 30);
	gtk_box_pack_end(GTK_BOX (parent), m_gDeployBtn, FALSE, FALSE, 0);


	m_gShellSettingsBtn = gtk_button_new_with_label(_("Shell Settings"));
	g_signal_connect (G_OBJECT (m_gShellSettingsBtn), "clicked", G_CALLBACK (ShellControllerWindow::ShowShellSettings), this);
	gtk_widget_set_size_request(m_gShellSettingsBtn, 130, 30);
	gtk_widget_set_tooltip_text (m_gShellSettingsBtn, _("Shell Settings"));
	gtk_box_pack_end(GTK_BOX (parent), m_gShellSettingsBtn, FALSE, FALSE, 20);



	CSESLog::WriteLine("ShellControllerWindow::InitButtons >>End");
	return 0;
}

/******************************************************************************
 * Function Name: Show
 * Description  : Show ShellControllerWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : Ok, 		return 0
 *              : FAILURE,	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::Show ()
{
	CSESLog::WriteLine("ShellControllerWindow::Show>>Start");
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("ShellControllerWindow::Show<<End");
	return 0;
}
/******************************************************************************
 * Function Name: Close
 * Description  : Close ShellControllerWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : Ok, 		return 0
 *              : FAILURE,	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
gint ShellControllerWindow::Close ()
{
//	if(1 == m_iSNormalClose)
//	{
//		if(NULL != m_gWindow)
//		{
//			gtk_widget_destroy(m_gWindow);
//		}
//	}

	//m_gWindow = NULL;	// TODO Jinxin review ? do not release.//Done
	//if(1 == m_iStartControllerOK)
	//{
		int errCode = 0;
		int result = 0;
		result = m_pTeacherAPI->StopController(errCode);
		if(SES_API_FAILURE == result)
		{
		    CSESLog::WriteLine("ShellControllerWindow::Close() StopController--Failure");
		}
		else if(SES_API_TIME_OUT == result)
		{
		    CSESLog::WriteLine("ShellControllerWindow::Close() StopController--Time out");
		}
	//}
	return 0;
}
/******************************************************************************
 * Function Name: ImportShellSettings
 * Description  : Import shellsettings
 * Date         : 2008/11/10
 * Parameter    : gtkwidget,	the GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ImportShellSettings (GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	GtkWidget* outDialog = gtk_file_chooser_dialog_new (_("Import Shell Settings"),
													GTK_WINDOW(ptr->m_gWindow),
													GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
													GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
													GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
													NULL);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(outDialog), "/");
    if (GTK_RESPONSE_ACCEPT == gtk_dialog_run (GTK_DIALOG (outDialog)))
    {
        string folder = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (outDialog));
        gtk_widget_destroy (outDialog);
        if(0 == folder.compare("/etc/SES"))
        {

        }
        else
        {
            if(ptr->IsShellSettingsExisted(folder))
            {
                if(ptr->IsShellSettingsExisted("/etc/SES"))
                {
                   string message( _("Would you like to replace the existing files?"));
                   int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
                   if(GTK_RESPONSE_YES == result)
                   {
                      //gtk_widget_destroy(pDialog);
                      ptr->DoImportShellSettingsAction(folder);
                   }
                }
                else
                {
                  ptr->DoImportShellSettingsAction(folder);
                }
            }
            else
            {
                string message(_("Cannot import Shell Settings!"));
                CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
            }
        }
    }
    else
    {
        gtk_widget_destroy(outDialog);
    }

}
/******************************************************************************
 * Function Name: ExportShellSettings
 * Description  : Export shellsettings
 * Date         : 2008/11/10
 * Parameter    : gtkwidget,	the GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ExportShellSettings(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	GtkWidget* dialog = gtk_file_chooser_dialog_new (_("Export Shell Settings"),
										GTK_WINDOW(ptr->m_gWindow),
										GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
										GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
										GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
										NULL);

	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), "/");
    if ( GTK_RESPONSE_ACCEPT == gtk_dialog_run (GTK_DIALOG (dialog)))
    {
        string folder = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (dialog));
        gtk_widget_destroy(dialog);
        if(0 == folder.compare("/etc/SES"))
        {

        }
        else
        {
            if(ptr->IsShellSettingsExisted("/etc/SES"))
            {
                if(ptr->IsShellSettingsExisted(folder))
                {
                    string message(_("Would you like to replace the existing files?"));
                    int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
                    if(GTK_RESPONSE_YES == result)
                    {
                        ptr->DoExportShellSettingsAction(folder);
                    }
                }
                else
                {
                    ptr->DoExportShellSettingsAction(folder);
                }
            }
            else
            {
                string message(_("Cannot export Shell Settings!"));
                CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
            }
        }
    }
    else
    {
        gtk_widget_destroy(dialog);
    }

}
/******************************************************************************
 * Function Name: ShowUnlockDialog
 * Description  : Show unlock dialog
 * Date         : 2008/9/10
 * Parameter    : GtkWidget*,	gtkwidget,	the GtkWidget which triggers the event
 * 				: gpointer,		data,		user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ShowUnlockDialog (GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::Show_Unlock_Dialog>>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	list<tagStudent_t> studentlist;
	list<tagStudent_t>::iterator studentiter;
	ptr->GetSelectedStudents(studentlist, ptr->m_gIconView, TRUE);
	if(studentlist.size() > 0)
	{
		int result = 0;
		for(studentiter = studentlist.begin(); studentiter!= studentlist.end(); ++studentiter)
		{
			if(1 == (*studentiter).bLocked)
			{
				result = 1;
				break;
			}
			else
			{
				result = 0;
			}
		}
		if(1 == result)
		{
//			GtkWidget* dialog = gtk_message_dialog_new(GTK_WINDOW (ptr->m_gWindow),
//							GTK_DIALOG_MODAL,
//							GTK_MESSAGE_INFO,
//							GTK_BUTTONS_YES_NO,
//							_("Do you want to unlock the students?")
//			);
//			gtk_window_set_title(GTK_WINDOW(dialog), "Information");

			string message(_("Do you want to unlock the students?"));
			int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_YES_NO);
			if (GTK_RESPONSE_YES == result)
			{
				std::list<std::string> studentList;
				for(studentiter = studentlist.begin(); studentiter!= studentlist.end(); ++studentiter)
				{
					if(1 == (*studentiter).bLocked)
					{
						//ptr->m_pTeacherAPI->ManualUnlockRemoteStudent((*studentiter).studentID);
						studentList.push_back((*studentiter).studentID);
					}
				}
				if(studentList.size() > 0)
				{
					string strDeployXML;
					CLockScheduleData lockScheduleData;
					lockScheduleData.LoadFromFile(CONFIG_FILE_DIR + LOCK_SCHEDULE);
					lockScheduleData.SetManualLock(0);
					lockScheduleData.SetAutoLock(0);
					lockScheduleData.SetLockStatus(SES_STU_MANUAL_UNLOCK);
					lockScheduleData.Save2String(strDeployXML);
					CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"ShellControllerWindow::ShowUnlockDialog::DeploySchedulePolicy (Manually Unlock)<<Start LOG_TEACHER_DEPLOYSCHEDULE");
					int OID;
					ptr->m_pTeacherAPI->DeploySchedulePolicy(studentList,strDeployXML,OID);
					CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"ShellControllerWindow::ShowUnlockDialog::DeploySchedulePolicy (Manually Unlock)<<End LOG_TEACHER_DEPLOYSCHEDULE");
				}
			}
			//gtk_widget_destroy (dialog);
		}
	}
	else
	{
		string message(_("Cannot apply settings to disconnect students!"));
		CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
	}
	CSESLog::WriteLine("ShellControllerWindow::Show_Unlock_Dialog<<End");

}
/******************************************************************************
 * Function Name: GetSelectedStudents
 * Description  : Get the selected students in iconview
 * Date         : 2008/9/10
 * Parameter    : tagStudentList		the selected student list
 * 				: data					user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::GetSelectedStudents(list<tagStudent_t>& tagStudentList,
		                                        GtkWidget* iconview, gboolean isOnlyConnected)
{
	CSESLog::WriteLine("ShellControllerWindow::GetSelectedStudents>>Start");
	GList* glist = m_mainViewOperation->MainViewGetSelectedItems();//gtk_icon_view_get_selected_items (GTK_ICON_VIEW(iconview));
	GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model (GTK_ICON_VIEW (iconview));
	GtkTreeIter Iter;
	tagStudent_t* pStudent = NULL;
	gboolean isConnected = FALSE;
	GtkTreePath* treepath = NULL;
	for(GList* tmpGlist = g_list_first(glist); NULL != tmpGlist; tmpGlist = g_list_next(tmpGlist))
	{
		treepath = (GtkTreePath*)(tmpGlist->data);
	    gtk_tree_model_get_iter(model, &Iter, treepath);
	    gtk_tree_model_get(model, &Iter, COLUMN_ITEM_POINTER, &pStudent, COLUMN_ITEM_CONNECTED, &isConnected, -1);
	    if(isConnected || (!isOnlyConnected))
	    {
	    	tagStudentList.push_back(*pStudent);
	    }
	}
	g_list_foreach (glist, (GFunc)gtk_tree_path_free, NULL);
	g_list_free (glist);
	CSESLog::WriteLine("ShellControllerWindow::GetSelectedStudents<<End");
}
/******************************************************************************
 * Function Name: ShowLockDialog
 * Description  : Show lock dialog
 * Date         : 2008/9/10
 * Parameter    : gtkwidget 		the GtkWidget which triggers the event
 * 				: data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ShowLockDialog (GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::Show_Lock_Dialog>>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	list<tagStudent_t> studentlist;
	list<tagStudent_t>::iterator studentiter;
	ptr->GetSelectedStudents(studentlist, ptr->m_gIconView, TRUE);
	if(studentlist.size() > 0)
	{
		ptr->m_pLockStudentsWindow = new LockStudentsWindow(studentlist);
		ptr->m_pLockStudentsWindow->Init();
		ptr->m_pLockStudentsWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(LockStudentsWindowDestroy), ptr);
	}
	else
	{
		string message(_("Cannot apply settings to disconnect students!"));
		CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
	}
	CSESLog::WriteLine("ShellControllerWindow::Show_Lock_Dialog<<End");
}
/******************************************************************************
 * Function Name: ShowShellSettings
 * Description  : Show lock dialog
 * Date         : 2008/9/10
 * Parameter    : gtkwidget 		the GtkWidget which triggers the event
 * 				: data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ShowShellSettings (GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::ShowShellSettings>>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if ( NULL != ptr)
	{
		if(NULL != ptr->m_pShellSetting)
		{
			delete ptr->m_pShellSetting;
			ptr->m_pShellSetting = NULL;
		}
		//ptr->m_pShellSetting = new LibSESGUI::CShellSettingCtrlForShellController(ptr->m_pTeacherAPI);
		ptr->m_pShellSetting = new LibSESGUI::CShellSettingCtrlForShellController();
		ptr->m_pShellSetting->Init();
		ptr->m_pShellSetting->ShowModal(ptr->m_gWindow, G_CALLBACK(ShellSettingsDestroy), ptr);
	}
	CSESLog::WriteLine("ShellControllerWindow::ShowShellSettings<<End");
}
/******************************************************************************
 * Function Name: ShellSettingsDestroy
 * Description  : ShellSettings window destroy callback function
 * Date         : 2008/11/10
 * Parameter    : gtkwidget 		the GtkWidget which triggers the event
 * 				: data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ShellSettingsDestroy(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::ShellSettingsDestroy>>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	ptr->m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
	CSESLog::WriteLine("ShellControllerWindow::Show_Shell_Settings<<End");
}
/******************************************************************************
 * Function Name: ShowProgramSearching
 * Description  : Show program searching window
 * Date         : 2008/9/10
 * Parameter    : gtkwidget 		the GtkWidget which triggers the event
 * 				: data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ShowProgramSearching (GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::ShowProgramSearching>>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(NULL != ptr)
	{
		if(NULL != ptr->m_pSearchProgram)
		{
			delete ptr->m_pSearchProgram;
			ptr->m_pSearchProgram = NULL;
		}
		ptr->m_pSearchProgram = new LibSESGUI::CSearchProgramForShellController();
		ptr->m_pSearchProgram->Init();
		ptr->m_pSearchProgram->ShowModal(ptr->m_gWindow, G_CALLBACK(ProgramSearchDestroy), ptr);
	}
	CSESLog::WriteLine("ShellControllerWindow::ShowProgramSearching<<End");
}
/******************************************************************************
 * Function Name: ProgramSearchDestroy
 * Description  : program search window destroy callback function
 * Date         : 2008/11/10
 * Parameter    : gtkwidget 		the GtkWidget which triggers the event
 * 				: data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ProgramSearchDestroy(GtkWidget* gtkwidget, gpointer data)
{

}
/******************************************************************************
 * Function Name: Init
 * Description  : Initialization of ShellControllerWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK			return 0
 * 				  FAILURE 		return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
gint ShellControllerWindow::Init ()
{
	CSESLog::WriteLine("ShellControllerWindow::Init>>Start");
	int ret = 1;

	int errCode = 0;
	m_pClassGroup->LoadFromFile(LibSESData::CONFIG_FILE_DIR + LibSESData::CLASS_GROUP);
	m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);

	InitWindow();
	string teacherInfoString("");
	CTeacherInfoData InfoData;
	InfoData.LoadFromFile(CONFIG_FILE_DIR + TEACHER_INFO);
	InfoData.Save2String(teacherInfoString);


	//init sessing, added by lfeng
	m_gMasterClient = gnome_master_client ();
	g_signal_connect (m_gMasterClient, "save_yourself", G_CALLBACK (HandleSessionDie), this);


	int updateTeacherResult = 0;
	updateTeacherResult = m_pTeacherAPI->UpdateTeacherInfo(teacherInfoString, errCode);
	if(SES_API_FAILURE == updateTeacherResult)
	{
		//m_iStartControllerOK = 0;
		ret = 0;
		string message(_("Fail to update teacher information, the application will quit!"));
		//string path = SES_SHELL_CONTROLLER_ICON;
		CMessageBox::Show(message, NULL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
		gtk_main_quit();
		//PublicFunc::SESShowDialogAndQuit(_("Fail to update teacher information, the application will quit!"), NULL);
		return 0;
	}
	else if(SES_API_TIME_OUT == updateTeacherResult)
	{
		//m_iStartControllerOK = 0;
		ret = 0;
		string message(_("Time out, the application will quit!"));
		//string path = SES_SHELL_CONTROLLER_ICON;
		CMessageBox::Show(message, NULL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
		gtk_main_quit();
		//PublicFunc::SESShowDialogAndQuit(message, NULL);
		return ret;
	}

	int registerResult = 0;
	registerResult = m_pTeacherAPI->RegisterCallBack(this);
	if(SES_API_FAILURE == registerResult)
	{
		//m_iStartControllerOK = 0;
		ret = 0;
		string message(_("Fail to register call back, the application will quit!"));
		//string path = SES_SHELL_CONTROLLER_ICON;
		CMessageBox::Show(message, NULL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
		gtk_main_quit();
		//PublicFunc::SESShowDialogAndQuit(_("Fail to register call back, the application will quit!"), NULL);
		return ret;
	}
	else if(SES_API_TIME_OUT == registerResult)
	{
		//m_iStartControllerOK = 0;
		ret = 0;
		string message(_("Time out, the application will quit!"));
		//string path = SES_SHELL_CONTROLLER_ICON;
		CMessageBox::Show(message, NULL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
		gtk_main_quit();
		//PublicFunc::SESShowDialogAndQuit(_("Time out, the application will quit!"), NULL);
		return ret;
	}


	// Check CA


	CSESLog::WriteLine("ShellControllerWindow::Init<<End");
    return ret;
}
/******************************************************************************
 * Function Name: SelectAll
 * Description  : Select or Unselect all items in iconview
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		the GtkWidget which triggers the event
 * 				  data	  		user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::SelectAll(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::Select_All>>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(gtkwidget)))
	{
		ptr->m_mainViewOperation->MainViewSelectAll();//gtk_icon_view_select_all(GTK_ICON_VIEW(ptr->m_gIconView));
	}
	else
	{
		ptr->m_mainViewOperation->MainViewUnselectAll();//gtk_icon_view_unselect_all(GTK_ICON_VIEW(ptr->m_gIconView));
	}
	CSESLog::WriteLine("ShellControllerWindow::Select_All<<End");
}
/******************************************************************************
 * Function Name: WindowShow
 * Description  : Show SelectClassWindow
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		the GtkWidget which triggers the event
 * 				  data	  		user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::WindowShow(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::Window_Show>>Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;

	ptr->EnterNoClassStatus();

	string stringPath("");
	int errCode = 0;
	int verifyResult = ptr->m_pTeacherAPI->VerifyCertificate(stringPath, errCode);
	if(SES_API_SUCCESS == verifyResult)
	{
		if(SES_API_SUCCESS == errCode)
		{
			string str("");
			ptr->m_pPassWordWindow = new PassWordWindow(str, 1);
			ptr->m_pPassWordWindow->Init();
			ptr->m_pPassWordWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(StartPasswordWindowDestroy), ptr);
		}
//		else if(SES_API_NEEDRESTART == errCode)
//		{
//		    string message(_("You should restart your computer!"));
//            CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
//            gtk_main_quit();
//		    //PublicFunc::SESShowDialogAndQuit(_("You should restart your computer!"), ptr->m_gWindow);
//		}
		else
		{
			//m_iStartControllerOK = 0;
			//PublicFunc::SESShowDialog(_("Fail to verify certificate, the application will quit!"), gtkwidget, GTK_BUTTONS_CLOSE);

			ptr->m_pImportWindow = new ImportCAWindow();
			ptr->m_pImportWindow->Init();
			ptr->m_pImportWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(StartImportCAWindowDestroy), ptr);
		}
	}
	else if(SES_API_TIME_OUT == verifyResult)
	{
	    string message(_("Time out, the application will quit!"));
        CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
        gtk_main_quit();
		//PublicFunc::SESShowDialogAndQuit(_("Time out, the application will quit!"), ptr->m_gWindow);
	}
	else
	{
	    string message(_("Fail to verify certificate, the application will quit!"));
        CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
        gtk_main_quit();
		//PublicFunc::SESShowDialogAndQuit(_("Fail to verify certificate, the application will quit!"), ptr->m_gWindow);
	}
	CSESLog::WriteLine("ShellControllerWindow::Window_Show<<End");
}
/******************************************************************************
 * Function Name: ClassSelectWinDestroy
 * Description  : Dealing with the data when SelectClassWindow is closed
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		the GtkWidget which triggers the event
 * 				  data	  		user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ClassSelectWinDestroy(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::ClassSelectWinDestroy >>Start");

	if (NULL == gtkwidget || NULL == data)
	{
		CSESLog::WriteLine("ShellControllerWindow::ClassSelectWinDestroy <<End");
		return;
	}

	ShellControllerWindow* ptr = (ShellControllerWindow*)data;

//	GtkTreeIter iter;
//	GdkPixbuf* pixbufLock = NULL;

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ptr->m_gSelectAllCheckbtn), FALSE);

//	int dialogResult = ptr->m_pSelectClassWindow->GetResult();

	SelectClassWindow* pSelectClassWnd 	= ptr->m_pSelectClassWindow;
//	CClassDef* pSelectClass	= pSelectClassWnd->GetSelectedClass();

	string SelectedClassName = pSelectClassWnd->GetSelectedClassName();
	ptr->m_SelectedClassName = SelectedClassName;

	// if OK, choose some class
	// if Cancel, do nothing
	if (BUTTON_CLICK_IS_OK == pSelectClassWnd->GetResult())
	{
		// if open for all , keep connection, switch to open for all status.
		// if no class is selected, close all connection, switch to no class status.
		// if specify some class, drop connected students, switch to new class.
//		if (NULL == pSelectClass)
//		{
//			if (pSelectClassWnd->IsOpenForAll())
//			{
//				// open for all students.
//				ptr->EnterOpenForAllStatus();
//			}
//			else
//			{
//				// no class.
//				ptr->EnterNoClassStatus();
//			}
//		}
//		else
//		{
//			// some class.
//			ptr->EnterSomeClassStatus(pSelectClass->GetName());
//		}

		// TODO: jinxin moveto member func.
		ptr->m_eClassSelectStatus = pSelectClassWnd->GetClassSelectStatus();
		switch (ptr->m_eClassSelectStatus)
		{
		case NoClass:
			ptr->EnterNoClassStatus();
			break;

		case SomeClass:
			ptr->EnterSomeClassStatus(SelectedClassName);
			break;

		case OpenForAll:
			ptr->EnterOpenForAllStatus();
			break;

		default:
			break;
		}

	}
	else if (BUTTON_CLICK_IS_CANCEL == pSelectClassWnd->GetResult())
	{
		// do nothing.
	}
	else
	{
		// assert.
		g_assert(0);
	}

#if 0
	if(BUTTON_CLICK_IS_OK == ptr->m_pSelectClassWindow->GetResult()&&-1 != ptr->m_pSelectClassWindow->IsOpenForAll())
	{
		list<tagStudent_t> tagStudent;
		gtk_list_store_clear(GTK_LIST_STORE(ptr->m_gStore));
		ptr->ClearList(ptr->m_pOnlineStudentList);
		int errorCode;
		APIResult ret = ptr->m_pTeacherAPI->GetStudentList(tagStudent, errorCode);
		if (SES_API_SUCCESS == ret)
		{
			ptr->m_pSelectedClass = NULL;
			if (1 == ptr->m_pSelectClassWindow->IsOpenForAll())
			{
				ptr->m_iClassType = 0;
				list<tagStudent_t>::iterator iterAllStudent;
				for (iterAllStudent = tagStudent.begin(); iterAllStudent != tagStudent.end(); ++iterAllStudent)
				{
					tagStudent_t* ptagStudent_t = new tagStudent_t(*iterAllStudent);
					ptr->m_pOnlineStudentList.push_back(ptagStudent_t);
					gtk_list_store_append(ptr->m_gStore, &iter);
					gboolean isConnected = TRUE;
					if(ptagStudent_t->bLocked)
					{
						pixbufLock = ptr->m_connectedAndLockedPixBuf;
					}
					else
					{
						pixbufLock = ptr->m_connectedAndUnlockedPixBuf;
					}



//					list<CStudentInfoData*>* CStudentList = ptr->m_pSelectedClass->GetPStudentsInfoList();
//					int size = CStudentList->size();
//					list<tagStudent_t> tagStudentList;
//					list<tagStudent_t*>::iterator tagIter;
//					list<CStudentInfoData*>::iterator cstudentIter;
//					for(tagIter = tagStudent->begin(); tagIter != CStudentList->end(); ++tagIter)
//					{
//						tagStudent_t tmpNewStudent;
//						tmpNewStudent.studentID = (*cstudentIter)->GetStudentID();
//						tmpNewStudent.username = (*cstudentIter)->GetStudentName();
//						tagStudentList.push_back(tmpNewStudent);
//					}


//
//					list<tagStudent_t>::iterator matchIter = find_if(tagStudent.begin(), tagStudent.end(),
//							ShellControllerWindow::CCompareStundentName(*iterAllStudent));
//					if(matchIter != tagStudent.end())
//					{
//						string idNamestring("");
//						idNamestring.append(ptagStudent_t->username);
//						idNamestring.append("\n");
//						idNamestring.append(ptagStudent_t->studentID);
//						gtk_list_store_set(ptr->m_gStore, &iter, COLUMN_ITEM_NAME, idNamestring.c_str(),
//													COLUMN_ITEM_PIC, pixbufLock, COLUMN_ITEM_POINTER, ptagStudent_t,
//													COLUMN_ITEM_CONNECTED, isConnected,-1);

//					}
//					else
//					{
						gtk_list_store_set(ptr->m_gStore, &iter, COLUMN_ITEM_NAME, ptagStudent_t->username.c_str(),
												COLUMN_ITEM_PIC, pixbufLock, COLUMN_ITEM_POINTER, ptagStudent_t,
												COLUMN_ITEM_CONNECTED, isConnected,-1);
						ptr->ReDrawIconView();
//					}
				}
				gtk_label_set_text(GTK_LABEL(ptr->m_gClassLabel), "All Students");
			}
			else
			{
				ptr->m_iClassType = 1;
				CClassDef* pShellControllerClass = ptr->m_pSelectClassWindow->GetSelectedClass();
				ptr->m_pSelectedClass = pShellControllerClass;
				list<CStudentInfoData*>::iterator iterClassStudent;
				for (iterClassStudent = pShellControllerClass->GetPStudentsInfoList()->begin(); iterClassStudent
						!= pShellControllerClass->GetPStudentsInfoList()->end(); ++iterClassStudent)
				{
					CStudentInfoData* pClassStudent = *iterClassStudent;
					tagStudent_t *ptagStudent_t = new tagStudent_t();
					ptr->m_pOnlineStudentList.push_back(ptagStudent_t);
					ptagStudent_t->studentID = pClassStudent->GetStudentID();
					ptagStudent_t->username = pClassStudent->GetStudentName();
					ptagStudent_t->bLocked = 0;
					ptagStudent_t->status = SES_STU_DISCONNECT;
					ptagStudent_t->IP = "";
					ptagStudent_t->hostname = "";
					ptagStudent_t->start_time = 0;
					list<tagStudent_t>::iterator iterTagStudent = std::find_if(tagStudent.begin(), tagStudent.end(),
							ShellControllerWindow::CCompareStundentInfo(*ptagStudent_t));
					gboolean isConnected = FALSE;
					if (iterTagStudent != tagStudent.end()) {
						ptagStudent_t->bLocked = (*iterTagStudent).bLocked;
						ptagStudent_t->status = (*iterTagStudent).status;
						ptagStudent_t->IP = (*iterTagStudent).IP;
						ptagStudent_t->hostname = (*iterTagStudent).hostname;
						ptagStudent_t->start_time = (*iterTagStudent).start_time;
						isConnected = TRUE;
						tagStudent.erase(iterTagStudent);
					}
					gtk_list_store_append(ptr->m_gStore, &iter);
					if (isConnected)
					{
						if(ptagStudent_t->bLocked)
						{
							pixbufLock = ptr->m_connectedAndLockedPixBuf;
						}
						else
						{
							ptr->iInited = TRUE;
							pixbufLock = ptr->m_connectedAndUnlockedPixBuf;
						}
					}
					else
					{
						pixbufLock = ptr->m_disconnectedPixBuf;
					}

					list<CStudentInfoData*>* CStudentList = ptr->m_pSelectedClass->GetPStudentsInfoList();
					list<tagStudent_t> tagStudentList;
					list<CStudentInfoData*>::iterator cstudentIter;
					for(cstudentIter = CStudentList->begin(); cstudentIter != CStudentList->end(); ++cstudentIter)
					{
						tagStudent_t tmpNewStudent;
						tmpNewStudent.studentID = (*cstudentIter)->GetStudentID();
						tmpNewStudent.username = (*cstudentIter)->GetStudentName();
						tagStudentList.push_back(tmpNewStudent);
					}


					gtk_list_store_set(ptr->m_gStore, &iter, COLUMN_ITEM_NAME, ptagStudent_t->username.c_str(),
											COLUMN_ITEM_PIC, pixbufLock, COLUMN_ITEM_POINTER, ptagStudent_t,
											COLUMN_ITEM_CONNECTED, isConnected,-1);
					ptr->ReDrawIconView();
				}
				list<tagStudent_t>::iterator iterAllStudent;
				for (iterAllStudent = tagStudent.begin(); iterAllStudent
						!= tagStudent.end(); ++iterAllStudent)
				{
					ptr->m_pTeacherAPI->KickOffStudent((*iterAllStudent).studentID);
				}
				string className = pShellControllerClass->GetName();
				gtk_label_set_text(GTK_LABEL(ptr->m_gClassLabel), className.c_str());
			}

			string configDir("");
			configDir.append(LibSESData::CONFIG_FILE_DIR);
			configDir.append(LibSESData::CLASS_GROUP);
			ptr->m_pClassGroup->Save2File(configDir);

			if(FALSE == ptr->iInited)
			{
				ptr->iInited = TRUE;
			}
		}
	}
	else if(-1 == ptr->m_pSelectClassWindow->IsOpenForAll()||BUTTON_CLICK_IS_CANCEL == ptr->m_pSelectClassWindow->GetResult())
	{
		string configDir("");
		configDir.append(LibSESData::CONFIG_FILE_DIR);
		configDir.append(LibSESData::CLASS_GROUP);
		ptr->m_pClassGroup->LoadFromFile(configDir);
		if((ptr->m_SelectedClassName) != "")
		{
			list<CClassDef*>* pClassList = ptr->m_pClassGroup->GetPClassInfoList();
			list<CClassDef*>::iterator classIter;
			for(classIter = pClassList->begin(); classIter != pClassList->end(); ++classIter)
			{
				if((*classIter)->GetName() == ptr->m_SelectedClassName)
				{
					ptr->m_pSelectedClass = *classIter;
				}
			}

			// this class has been deleted.
			if (classIter == pClassList->end())
			{
				CSESLog::WriteLine("Teacher choose a deleted class.");
				ptr->EnterNoClassStatus();
			}
		}


		if(FALSE == ptr->iInited)
		{
			gtk_label_set_text(GTK_LABEL(ptr->m_gClassLabel), "No Class");
		}
	}

//	if (NULL != ptr->m_pSelectClassWindow)
//	{
//		delete (ptr->m_pSelectClassWindow);
//		ptr->m_pSelectClassWindow = NULL;
//	}
#endif
	CSESLog::WriteLine("ShellControllerWindow::ClassSelectWinDestroy<<End");
}
/******************************************************************************
 * Function Name: EnterNoClassStatus
 * Description  : Enter No class style
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : 0			OK
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::EnterNoClassStatus()
{
	// Kick All Students
	// TODO jinxin review here maybe many callback.
	//int errCode;
	std::list<StudentInfo_t> studentList;
	std::list<StudentInfo_t>::iterator iter;

	//Added by lfeng
	//MakeSearchItemDisableStatus();

//	int getListResult = 0;
//	getListResult = m_pTeacherAPI->GetStudentList(studentList, errCode);
//	if(SES_API_FAILURE == getListResult)
//	{
//		PublicFunc::SESShowDialog("GetStudentList Service Failure!", m_gWindow);
//	}
//	else if(SES_API_TIME_OUT == getListResult)
//	{
//		PublicFunc::SESShowDialog("Time out!", m_gWindow);
//	}
//
//	for (iter = studentList.begin(); iter != studentList.end(); ++iter)
//	{
//		m_pTeacherAPI->KickOffStudent((*iter).studentID);
//	}
	//modify by wenqy. kickoff all student, not need get student list.
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_KICKOFFSTUDENT,	"ShellControllerWindow::EnterNoClassStatus::KickOffAllStudent >> Start LOG_TEACHER_KICKOFFSTUDENT");
	m_pTeacherAPI->KickOffAllStudent();
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_KICKOFFSTUDENT,	"ShellControllerWindow::EnterNoClassStatus::KickOffAllStudent >> End LOG_TEACHER_KICKOFFSTUDENT");

	// Update Internal Data
	// 1. student list
	std::list<IPCAPI::tagStudent_t*>::iterator iterStudent;
	for (iterStudent = m_pOnlineStudentList.begin(); iterStudent != m_pOnlineStudentList.end(); ++iterStudent)
	{
		if (NULL != *iterStudent )
		{
			delete *iterStudent;
		}
	}
	m_pOnlineStudentList.clear();

	//2.
	// TODO jinxin review clear resource.
	if (NULL != m_pSelectedClass)
	{
		delete m_pSelectedClass;
		m_pSelectedClass = NULL;
	}

	//3.
	iInited = FALSE;

	// Update GUI.
	// 1. check box
	gtk_label_set_text(GTK_LABEL(m_gClassLabel), _("No Class"));
	gtk_widget_set_tooltip_text(m_gClassLabel, _("No Class"));
	// 2. iconview
	//ReDrawIconView();
	gtk_list_store_clear(GTK_LIST_STORE(m_gStore));

	m_eClassSelectStatus 	= NoClass;
	m_SelectedClassName		= "";

	return 0;
}
/******************************************************************************
 * Function Name: EnterSomeClassStatus
 * Description  : Enter No class style
 * Date         : 2008/11/10
 * Parameter    : classname 		the name of some class
 * Return Code  : 1			change class
 * 				  0			no effect
 * 				  -1		invalid args
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////
//	1	change class.
//	0	no effect
//	-1 	invalid args
int ShellControllerWindow::EnterSomeClassStatus(std::string className)
{
	if (0 == className.size())
	{
		return -1;
	}

	// reload class info, confirm class existence.
	// if not exist, enter no class status.
	m_pClassGroup->LoadFromFile(LibSESData::CONFIG_FILE_DIR + LibSESData::CLASS_GROUP);
	if ( 0 == m_pClassGroup->IsClassExist(className) )
	{
		EnterNoClassStatus();
		return 0;
	}

	// if the wanna selected class is the current selected class, do nothing.
	// if the previous selected class is no class or open for all the m_pSelectedClass pointer will be NULL.
	if (NULL != m_pSelectedClass && m_pSelectedClass->GetName() == className)
	{
		//TODO redraw lfeng
		//return 0;
	}

	m_eClassSelectStatus 	= SomeClass;
	m_SelectedClassName 	= className;

	// Update GUI based on current class
	if (NULL != m_pSelectedClass)
	{
		delete m_pSelectedClass;
		m_pSelectedClass = NULL;
	}
	CClassDef* pTemp = NULL;
	//m_pClassGroup->GetClassInfo(className, &m_pSelectedClass);
	m_pClassGroup->GetClassInfo(className, &pTemp);

	std::list<CStudentInfoData*>* pStudentList = pTemp->GetPStudentsInfoList();

	// kick students which are not belong to current selected class.
	// TODO make sure m_tagStudentList maintains the lastest student list.
	// TODO jinxin need lock this resource.
	std::list<IPCAPI::StudentInfo_t*>::iterator iterStudent;
	std::list<std::string> studentIDList;
	for(iterStudent = m_pOnlineStudentList.begin(); iterStudent != m_pOnlineStudentList.end(); ++iterStudent)
	{
		std::list<CStudentInfoData*>::iterator iterResult = std::find_if(pStudentList->begin(), pStudentList->end(),
								ShellControllerWindow::CCompareStundentInfo(**iterStudent));

		if (iterResult == pStudentList->end())
		{
			studentIDList.push_back((*iterStudent)->studentID);
			//m_pTeacherAPI->KickOffStudent((*iterStudent)->studentID);
		}
	}
	if (true != studentIDList.empty())
	{
		CSESLog::WriteLine(CSESLogData::LOG_TEACHER_KICKOFFSTUDENT,	"ShellControllerWindow::EnterSomeClassStatus::KickOffStudent >> Start LOG_TEACHER_KICKOFFSTUDENT");
		m_pTeacherAPI->KickOffStudent(studentIDList);
		CSESLog::WriteLine(CSESLogData::LOG_TEACHER_KICKOFFSTUDENT,	"ShellControllerWindow::EnterSomeClassStatus::KickOffStudent >> End LOG_TEACHER_KICKOFFSTUDENT");
	}


	// Clear Data.
	gtk_list_store_clear(GTK_LIST_STORE(m_gStore));
	ClearList(m_pOnlineStudentList);

	// Dump Data Into m_tagStudentList
	std::list<CStudentInfoData*>::iterator iterNewStudent;
	for (iterNewStudent = pStudentList->begin(); iterNewStudent != pStudentList->end(); ++iterNewStudent)
	{
		CStudentInfoData* pNewStudent = *iterNewStudent;
		StudentInfo_t *pNewStudentInfo = new StudentInfo_t();

		pNewStudentInfo->studentID 	= pNewStudent->GetStudentID();
		pNewStudentInfo->username 	= pNewStudent->GetStudentName();
		pNewStudentInfo->displayName =  pNewStudent->GetStudentName();

		m_pOnlineStudentList.push_back(pNewStudentInfo);
	}

	// Fetch Now Online Students' Network Info
	list<tagStudent_t> connectedStudentList;
	int errorCode;
	int getStudentListResult = 0;
	getStudentListResult = m_pTeacherAPI->GetStudentList(connectedStudentList, errorCode);
	if (SES_API_SUCCESS == getStudentListResult )
	{
		//added by lfeng
//		if(0 != connectedStudentList.size())
//		{
//			MakeSearchItemAbleStatus();
//		}
//		else
//		{
//			MakeSearchItemDisableStatus();
//		}

		int isSave = 0;

		list<tagStudent_t>::iterator iterConnectedStudent;
		for (iterConnectedStudent = connectedStudentList.begin(); iterConnectedStudent != connectedStudentList.end(); ++iterConnectedStudent)
		{
			list<tagStudent_t*>::iterator iterResult = std::find_if(m_pOnlineStudentList.begin(), m_pOnlineStudentList.end(),
														  ShellControllerWindow::CCompareStundentInfo(*iterConnectedStudent));

			if (iterResult != m_pOnlineStudentList.end())
			{

				StudentInfo_t* pStudent = *iterResult;

				//For motify name in class group
				if(pStudent->username != (*iterConnectedStudent).username)
				{
					pStudent->username 	= (*iterConnectedStudent).username;
					pStudent->displayName =  pStudent->username;

					if(pTemp->UpdateStudentNameByID(pStudent->studentID, pStudent->username))
					{
						if(!isSave)
						{
							isSave = 1;
						}
					}
				}

				pStudent->bLocked = (*iterConnectedStudent).bLocked;
				pStudent->status = (*iterConnectedStudent).status;
				pStudent->IP = (*iterConnectedStudent).IP;
				pStudent->hostname = (*iterConnectedStudent).hostname;
				pStudent->start_time = (*iterConnectedStudent).start_time;
			}
		}

		if(isSave)
		{
			m_pClassGroup->Save2File(CONFIG_FILE_DIR + CLASS_GROUP);
			//TODO Notify EditClassWindow
		}
	}
	else if(SES_API_TIME_OUT == getStudentListResult)
	{
		string message(_("Time out!"));
		CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
	}
	else
	{
		string message(_("Cannot get student list!"));
		CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
	}

	m_pSelectedClass = pTemp->Clone();

	// Check Same Name
	MakeStudentNameUnique();

	// Draw on GUI.
	GtkTreeIter iter;
	GdkPixbuf* pixbufLock = NULL;
	gboolean isConnected = FALSE;
	std::list<IPCAPI::StudentInfo_t*>::iterator iterStudent2;
	for(iterStudent2 = m_pOnlineStudentList.begin(); iterStudent2 != m_pOnlineStudentList.end(); ++iterStudent2)
	{
		StudentInfo_t* pStudent = *iterStudent2;

		gtk_list_store_append(m_gStore, &iter);

		if (true == pStudent->IsConnected())
		{
			isConnected = TRUE;
//			if (true == pStudent->IsLocked())
//			{
//				pixbufLock = m_connectedAndLockedPixBuf;
//			}
//			else
//			{
//				pixbufLock = m_connectedAndUnlockedPixBuf;
//			}
		}
		else
		{
			isConnected = FALSE;
			//pixbufLock = m_disconnectedPixBuf;
		}

		pixbufLock = GetStudentStatusIcon(pStudent, pStudent->status);

		gtk_list_store_set(m_gStore, &iter,
							COLUMN_ITEM_NAME, pStudent->displayName.c_str(),
							COLUMN_ITEM_PIC, pixbufLock,
							COLUMN_ITEM_POINTER, pStudent,
							COLUMN_ITEM_CONNECTED, isConnected,
							-1);

	}

	//
	iInited = TRUE;

	//
	gtk_label_set_text(GTK_LABEL(m_gClassLabel), className.c_str());
	gtk_widget_set_tooltip_text(m_gClassLabel, className.c_str());

	return 0;
}
/******************************************************************************
 * Function Name: EnterOpenForAllStatus
 * Description  : Enter All students style
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : 1			change class
 * 				  0			no effect
 * 				  -1		invalid args
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::EnterOpenForAllStatus()
{
	// Clear Data.
	gtk_list_store_clear(GTK_LIST_STORE(m_gStore));
	ClearList(m_pOnlineStudentList);

	// Put All Connected Students in IconView.
	list<tagStudent_t> tagStudent;
	int errorCode;
	APIResult ret = m_pTeacherAPI->GetStudentList(tagStudent, errorCode);
	if (SES_API_SUCCESS == ret)
	{

		//Added by lfeng
//		if(0 != tagStudent.size())
//		{
//			gtk_widget_set_sensitive(m_gSearingProgramItem, true);
//		}
//		else
//		{
//			gtk_widget_set_sensitive(m_gSearingProgramItem, false);
//		}

		m_pSelectedClass = NULL;
		m_iClassType = 0;

		GtkTreeIter iter;
		GdkPixbuf* pixbufLock = NULL;

		list<tagStudent_t>::iterator iterAllStudent;

		for (iterAllStudent = tagStudent.begin(); iterAllStudent != tagStudent.end(); ++iterAllStudent)
		{
			StudentInfo_t* ptagStudent_t = new StudentInfo_t(*iterAllStudent);

			ptagStudent_t->displayName = (*iterAllStudent).username;

			m_pOnlineStudentList.push_back(ptagStudent_t);

			// Check Same Name
			MakeStudentNameUnique();

			gtk_list_store_append(m_gStore, &iter);

			//gboolean isConnected = TRUE;

//			if(ptagStudent_t->bLocked)
//			{
//				pixbufLock = m_connectedAndLockedPixBuf;
//			}
//			else
//			{
//				pixbufLock = m_connectedAndUnlockedPixBuf;
//			}

			pixbufLock = GetStudentStatusIcon(ptagStudent_t, ptagStudent_t->status);

			gtk_list_store_set(m_gStore, &iter,
							   COLUMN_ITEM_NAME, ptagStudent_t->displayName.c_str(),
							   COLUMN_ITEM_PIC, pixbufLock,
							   COLUMN_ITEM_POINTER, ptagStudent_t,
							   COLUMN_ITEM_CONNECTED, TRUE,
							   -1);

			//ReDrawIconView();
		}
	}

	gtk_label_set_text(GTK_LABEL(m_gClassLabel), _(OPEN_FOR_ALL_STUDENT.c_str()));
	gtk_widget_set_tooltip_text (m_gClassLabel, "Open for all students");


	iInited = TRUE;

	m_eClassSelectStatus 	= OpenForAll;
	m_SelectedClassName		= "";

	return 0;
}

/******************************************************************************
 * Function Name: ClearList
 * Description  : Clear the given list
 * Date         : 2008/9/10
 * Parameter    : tagList		the list which will be deleted
 * Return Code  : OK		return 0;
 * 				  FAILURE	return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::ClearList(list<tagStudent_t*>& tagList)
{
	CSESLog::WriteLine("ShellControllerWindow::ClearList>>Start");
	list<tagStudent_t*>::iterator iterClassStudent;
	for (iterClassStudent = tagList.begin(); iterClassStudent != tagList.end(); ++iterClassStudent)
	{
		if (NULL != (*iterClassStudent) )
		{
			delete (*iterClassStudent);
			(*iterClassStudent) = NULL;
		}
	}
	tagList.clear();
	CSESLog::WriteLine("ShellControllerWindow::ClearList<<End");
	return 0;
}
/******************************************************************************
 * Function Name: UpdateStudentStatus
 * Description  : Update the given student's status
 * Date         : 2008/9/10
 * Parameter    : studentID		student's ID
 * 				  iStatus		the status of the given student
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::UpdateStudentStatus(std::string studentID, int iStatus)
{
	CSESLog::WriteLine("ShellControllerWindow::UpdateStudentStatus>>Start");
	GtkTreeIter iter;
	tagStudent_t* ptagStudent_t = NULL;
	gboolean isConnected = FALSE;

//	if(SES_STU_DISCONNECT == iStatus)
//	{
//	    gtk_widget_set_sensitive(m_gSearingProgramItem, false);
//	}

	FindStudentInfoInIconView(studentID, &ptagStudent_t, iter);

	if (ptagStudent_t)
	{
		isConnected = IsStudentConnected(iStatus);
		if(isConnected)
		{
			ptagStudent_t->bLocked = IsStudentLocked(iStatus);
		}
		ptagStudent_t->status = iStatus;

		//StudentInfo_t tmp = *ptagStudent_t;
		GdkPixbuf* pixbufLock = GetStudentStatusIcon(ptagStudent_t, iStatus);

		//if(pixbufLock)
		{
			GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model (GTK_ICON_VIEW (m_gIconView));
			gtk_list_store_set((GtkListStore*)model, &iter, COLUMN_ITEM_PIC, pixbufLock,
					COLUMN_ITEM_POINTER, ptagStudent_t, COLUMN_ITEM_CONNECTED, isConnected, -1);
		}
	}
	CSESLog::WriteLine("ShellControllerWindow::UpdateStudentStatus<<End");
}


void ShellControllerWindow::UpdateStudentStatusAndName(tagStudent_t* pNewTagStudent_t)//std::string studentID, int iStatus, string name)
{
	CSESLog::WriteLine("ShellControllerWindow::UpdateStudentStatusAndName>>Start");
	GtkTreeIter iter;
	tagStudent_t* ptagStudent_t = NULL;
	gboolean isConnected = FALSE;

//	if(SES_STU_DISCONNECT == pNewTagStudent_t->status)
//	{
//	    gtk_widget_set_sensitive(m_gSearingProgramItem, false);
//	}

	FindStudentInfoInIconView(pNewTagStudent_t->studentID, &ptagStudent_t, iter);

	if (ptagStudent_t)
	{
		*ptagStudent_t = *pNewTagStudent_t;

		isConnected = IsStudentConnected(ptagStudent_t->status);
		if(isConnected)
		{
			ptagStudent_t->bLocked = IsStudentLocked(ptagStudent_t->status);
		}

		GdkPixbuf* pixbufLock = GetStudentStatusIcon(ptagStudent_t, ptagStudent_t->status);
		//if( oldName == pNewTagStudent_t)
		{
			GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model (GTK_ICON_VIEW (m_gIconView));
			gtk_list_store_set((GtkListStore*)model, &iter, COLUMN_ITEM_NAME, ptagStudent_t->username.c_str(), COLUMN_ITEM_PIC, pixbufLock,
					COLUMN_ITEM_POINTER, ptagStudent_t, COLUMN_ITEM_CONNECTED, isConnected, -1);
		}
	}
	CSESLog::WriteLine("ShellControllerWindow::UpdateStudentStatusAndName<<End");
}


/******************************************************************************
 * Function Name: AddStudentToIconView
 * Description  : Add student to iconview
 * Date         : 2008/9/10
 * Parameter    : student		the given student
 * Return Code  : OK		return 	0
 * 				  FAILURE	return	-1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::AddStudentToIconView(tagStudent_t& student)
{
	CSESLog::WriteLine("ShellControllerWindow::AddStudentToIconView>>Start");
	GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model (GTK_ICON_VIEW (m_gIconView));
	GtkTreeIter iter;

	GdkPixbuf *pixbufLock = GetStudentStatusIcon(&student, student.status);

	gboolean isConnected = IsStudentConnected(student.status);

	gtk_list_store_append(GTK_LIST_STORE(model), &iter);
	tagStudent_t* ptagStudent_t = new tagStudent_t(student);
	gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_NAME, (ptagStudent_t->username).c_str(), COLUMN_ITEM_PIC, pixbufLock,
							COLUMN_ITEM_POINTER, ptagStudent_t, COLUMN_ITEM_CONNECTED, isConnected, -1);
	m_pOnlineStudentList.push_back(ptagStudent_t);

	ReDrawIconView();

	CSESLog::WriteLine("ShellControllerWindow::AddStudentToIconView>>End");
	return TRUE;
}
/******************************************************************************
 * Function Name: FindStudentInfoInIconView
 * Description  : find the given student's info in iconview
 * Date         : 2008/9/10
 * Parameter    : studentID		student's ID
 *         		  pStudent		the student pointer stored in iconview
 *         		  iter			the iterator points to the student in iconview
 * Return Code  : OK		return 	0
 * 				  FAILURE	return	-1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::FindStudentInfoInIconView(string studentID, tagStudent_t** pStudent, GtkTreeIter& iter)
{
	CSESLog::WriteLine("ShellControllerWindow::FindStudentInfoInIconView<<Start");
	gboolean isValid = FALSE;
	GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model (GTK_ICON_VIEW (m_gIconView));
	gboolean isConnected = FALSE;
	isValid = gtk_tree_model_get_iter_first (model, &iter);

	*pStudent = NULL;

	while(isValid)
	{
		StudentInfo_t* pCurStudent = NULL;
		//gtk_tree_model_get (model, &iter, COLUMN_ITEM_POINTER, &pStudent, COLUMN_ITEM_CONNECTED, &isConnected, -1);
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_POINTER, &pCurStudent, COLUMN_ITEM_CONNECTED, &isConnected, -1);
		//if(pStudent)
		if (pCurStudent)
		{
			//if(pStudent->studentID == studentID)
			if(pCurStudent->studentID == studentID)
			{
				*pStudent = pCurStudent;
				break;
			}
//			else
//			{
//				*pStudent = NULL;
//			}
		}
		isValid = gtk_tree_model_iter_next (model, &iter);
	}
	CSESLog::WriteLine("ShellControllerWindow::FindStudentInfoInIconView>>End");
	return ( (NULL == *pStudent) ? FALSE : TRUE );
}

int ShellControllerWindow::RemoveStudent(std::string studentID)
{
	//CSESLog::WriteLine("ShellControllerWindow::FindStudentInfoInIconView<<Start");
	if (0 == studentID.size())
	{
		return -1;
	}

	int ret = 0;
	GtkTreeIter 	iter;
	StudentInfo_t*	pStudent = NULL;

	if (TRUE == FindStudentInfoInIconView(studentID, &pStudent, iter))
	{
		gtk_list_store_remove(m_gStore, &iter);
		if (NULL != pStudent)
		{
			m_pOnlineStudentList.remove(pStudent);
			delete pStudent;
			pStudent = NULL;
		}
		ret = 1;
	}

	return ret;
}


/******************************************************************************
 * Function Name: GetStudentStatusIcon
 * Description  : Get the Students' status icon
 * Date         : 2008/9/10
 * Parameter    : iStatus		student's status
 * Return Code  : OK		return 	GdkPixbuf pointer
 * 				  FAILURE	return 	//return what?
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
GdkPixbuf* ShellControllerWindow::GetStudentStatusIcon(const IPCAPI::StudentInfo_t* pStudentInfo, int iStatus)
{
	CSESLog::WriteLine("ShellControllerWindow::GetStudentStatusIcon<<Start");

	if ( NULL == pStudentInfo )
	{
		return NULL;
	}

	GdkPixbuf* pixbufLock = NULL;

	switch(iStatus)
	{
	case SES_STU_DISCONNECT:
			pixbufLock = m_disconnectedPixBuf;
		break;
	case SES_STU_LOCK:
	case SES_STU_AUTO_LOCK:
	case SES_STU_MANUAL_LOCK:
			if (SomeClass == m_eClassSelectStatus)
			{
				if ( 1 ==  IsStudentInSelectedClass(m_SelectedClassName, pStudentInfo->studentID) )
				{
					pixbufLock = m_connectedAndLockedPixBuf;
				}
				else
				{
					pixbufLock = m_connectedAndLockedExtendPixBuf;
				}
			}
			else if (OpenForAll == m_eClassSelectStatus)
			{
				pixbufLock = m_connectedAndLockedPixBuf;
			}
			else
			{
				// impossible.
			}
			//pixbufLock = m_connectedAndLockedPixBuf;
		break;
	case SES_STU_UNLOCK:
	case SES_STU_AUTO_UNLOCK:
	case SES_STU_MANUAL_UNLOCK:
		if (SomeClass == m_eClassSelectStatus)
		{
			if ( 1 ==  IsStudentInSelectedClass(m_SelectedClassName, pStudentInfo->studentID) )
			{
				pixbufLock = m_connectedAndUnlockedPixBuf;
			}
			else
			{
				pixbufLock = m_connectedAndUnLockExtendPixBuf;
			}
		}
		else if (OpenForAll == m_eClassSelectStatus)
		{
			pixbufLock = m_connectedAndUnlockedPixBuf;
		}
		else
		{
			// impossible.
		}
		//pixbufLock = m_connectedAndUnlockedPixBuf;
		break;
	default:

		CSESLog::WriteLine("Received Impossible Student Status.", CSESLog::ERROR);
		break;
	}
	CSESLog::WriteLine("ShellControllerWindow::GetStudentStatusIcon>>End");
	return pixbufLock;
}
/******************************************************************************
 * Function Name: GetStudentStatusIcon
 * Description  : Get the Students' status icon
 * Date         : 2008/9/10
 * Parameter    : iStatus		student's status
 * Return Code  : OK		return 	GdkPixbuf pointer
 * 				  FAILURE	return 	//return what?
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::IsStudentConnected(int iStatus)
{
	CSESLog::WriteLine("ShellControllerWindow::IsStudentConnected<<Start");
	int bIsConnected = FALSE;
	switch(iStatus)
	{
	case SES_STU_DISCONNECT:
		bIsConnected = FALSE;
		break;
	case SES_STU_LOCK:
	case SES_STU_AUTO_LOCK:
	case SES_STU_MANUAL_LOCK:
	case SES_STU_UNLOCK:
	case SES_STU_AUTO_UNLOCK:
	case SES_STU_MANUAL_UNLOCK:
		bIsConnected = TRUE;
		break;
	default:
		break;
	}
	CSESLog::WriteLine("ShellControllerWindow::IsStudentConnected>>End");
	return bIsConnected;
}
/******************************************************************************
 * Function Name: IsStudentLocked
 * Description  : Justify whether the student is locked or not
 * Date         : 2008/9/10
 * Parameter    : iStatus		student's status
 * Return Code  : Locked			return 	1
 * 				  unlocked			return 	0
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::IsStudentLocked(int iStatus)
{
	CSESLog::WriteLine("ShellControllerWindow::IsStudentLocked<<Start");
	int bIsLocked = FALSE;

	switch(iStatus)
	{
	case SES_STU_LOCK:
	case SES_STU_AUTO_LOCK:
	case SES_STU_MANUAL_LOCK:
		bIsLocked = TRUE;
		break;
	case SES_STU_UNLOCK:
	case SES_STU_AUTO_UNLOCK:
	case SES_STU_MANUAL_UNLOCK:
		bIsLocked = FALSE;
		break;
	default:
		break;
	}
	CSESLog::WriteLine("ShellControllerWindow::IsStudentLocked>>End");
	return bIsLocked;
}
/******************************************************************************
 * Function Name: NewStudentConnectWinDestroy
 * Description  : Deal with the data after new student window closed
 * Date         : 2008/9/10
 * Parameter    : gtkwidget		the GtkWidget which triggers the event
 * 				  data 			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::NewStudentConnectWinDestroy(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::NewStudentConnectWinDestroy<<Start");

	if ( NULL == data || NULL == gtkwidget )
	{
		return;
	}

//	ShellControllerWindowData* windowData = (ShellControllerWindowData*)data;
//
//	ShellControllerWindow* pShellControllerWindow = windowData->shellControllerWindow;
//	NewStudentConnectWindow* pNewStudentWindow = windowData->newStudentConnectWindow;

	NewStudentConnectWindow* pNewStudentWindow = (NewStudentConnectWindow* )data;
	ShellControllerWindow* pShellControllerWindow = pNewStudentWindow->GetShellControllerWindow();

//	pShellControllerWindow->m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);

//	int bIsAccept = windowData->newStudentConnectWindow->IsAccept();
//	int bIsDeny = windowData->newStudentConnectWindow->IsDeny();

	int isAllow		= 0;
	int addToClass	= 0;
	int saveToFile	= 0;


	//IPCTeacherAPI* pTeacherAPI = pShellControllerWindow->m_pTeacherAPI;

	tagStudent_t student = pNewStudentWindow->GetStudent();

	// Get User Selection
	pNewStudentWindow->GetResult(isAllow, addToClass, saveToFile);

	// Reload
	if (saveToFile)
	{
		pShellControllerWindow->ReloadSystemSetting();
	}

	bool isAdded = FALSE;
	list<IPCAPI::tagStudent_t*>::iterator tagStudentIter;
	tagStudentIter = find_if(pShellControllerWindow->m_pOnlineStudentList.begin(), pShellControllerWindow->m_pOnlineStudentList.end(), CCompareStundentInfo(student));
	if(pShellControllerWindow->m_pOnlineStudentList.end()!= tagStudentIter)
	{
		isAdded = TRUE;
	}

	// Add this student to current Class.
	if (addToClass)
	{
		// add to data
		if (NULL != pShellControllerWindow->m_pSelectedClass)
		{
			CStudentInfoData* pStudentInfoData = new CStudentInfoData();
			pStudentInfoData->SetStudentID(student.studentID);
			pStudentInfoData->SetStudentName(student.username);
			pShellControllerWindow->m_pSelectedClass->GetPStudentsInfoList()->push_back(pStudentInfoData);

			// find specified class & add to this class
			CClassDef* targetClass = NULL;
			pShellControllerWindow->m_pClassGroup->GetClassInfo(pShellControllerWindow->m_pSelectedClass->GetName(), &targetClass);
			if (NULL != targetClass)
			{
				CStudentInfoData* pStudentInfoData = new CStudentInfoData();
				pStudentInfoData->SetStudentID(student.studentID);
				pStudentInfoData->SetStudentName(student.username);

				targetClass->GetPStudentsInfoList()->push_back(pStudentInfoData);
				pShellControllerWindow->m_pClassGroup->Save2File(CONFIG_FILE_DIR + CLASS_GROUP);
			}
		}

		//pShellControllerWindow->m_pClassGroup->Save2File(CONFIG_FILE_DIR + CLASS_GROUP);

		// add to gui
//		int errCode;
//		if (SES_API_SUCCESS != pTeacherAPI->GetStudentStatus(student.studentID, student, errCode))
//		{
//			student.status = SES_STU_DISCONNECT;
//		}
//		pShellControllerWindow->AddStudentToIconView(student);

		// update other window
		if (NULL != pShellControllerWindow->m_pSelectClassWindow)
		{
			EditGroupWindow* pEditGroupWindow =	pShellControllerWindow->m_pSelectClassWindow->GetEditGroupWindow();
			if (NULL != pEditGroupWindow)
			{
				//tagStudent_t* newTagStudent(&student);
				//pEditGroupWindow->NewStudentMessage(NEW_STUDENT_SELECT_ONE, &student, pShellControllerWindow->m_pSelectedClass);
				pEditGroupWindow->UpdateStudentListOfCurrentClass(NEW_STUDENT_SELECT_ONE, pShellControllerWindow->m_SelectedClassName,  &student);
			}
		}
	}

	// Allow Connect & Deploy Policy.
	if(isAllow)
	{
		// allow connect.
		pShellControllerWindow->m_pTeacherAPI->ControlNewStudentConnect(student.studentID, TRUE);

		// add to gui.
		pShellControllerWindow->AddStudentToIconView(student);

		int autoDeploy = pShellControllerWindow->m_pSESSystemSettingData->GetAutoDeployEnabled();
		if(autoDeploy)
		{
			CLockScheduleData lockScheduleData;
			CTabNavigationData tabNavigationData;
			string lockScheduleString;
			string tabNaviString;

			lockScheduleData.LoadFromFile(CONFIG_FILE_DIR + LOCK_SCHEDULE);

			// make sure manually lock is disable.
			lockScheduleData.SetManualLock(0);
			if(true == lockScheduleData.IsAutoLockEnable())
			{
				lockScheduleData.SetLockStatus(SES_STU_AUTO_LOCK);
			}
			else
			{
				lockScheduleData.SetLockStatus(SES_STU_AUTO_UNLOCK);
			}

			tabNavigationData.LoadFromFile(CONFIG_FILE_DIR + TAB_NAVIGATION);

			lockScheduleData.Save2String(lockScheduleString);
			tabNavigationData.Save2String(tabNaviString);

//			CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"ShellControllerWindow::NewStudentConnectWinDestroy::DeploySchedulePolicy<<Start LOG_TEACHER_DEPLOYSCHEDULE");
//			pShellControllerWindow->m_pTeacherAPI->DeploySchedulePolicy(student.studentID, lockScheduleString);
//			CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"ShellControllerWindow::NewStudentConnectWinDestroy::DeploySchedulePolicy>>End LOG_TEACHER_DEPLOYSCHEDULE");

			CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,	"ShellControllerWindow::NewStudentConnectWinDestroy::DeployTabNavPolicy<<Start LOG_TEACHER_DEPLOYTABNAV");
			int iOID;
			list<string> studentlist;
			studentlist.push_back(student.studentID);
			pShellControllerWindow->m_pTeacherAPI->DeployTabNavPolicy(studentlist, lockScheduleString, tabNaviString, iOID);
			CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,	"ShellControllerWindow::NewStudentConnectWinDestroy::DeployTabNavPolicy>>End LOG_TEACHER_DEPLOYTABNAV");
		}

		// update other window
		if (NULL != pShellControllerWindow->m_pSelectClassWindow)
		{
			EditGroupWindow* pEditGroupWindow =	pShellControllerWindow->m_pSelectClassWindow->GetEditGroupWindow();
			if (NULL != pEditGroupWindow)
			{
				//tagStudent_t* newTagStudent(&student);
				//pEditGroupWindow->NewStudentMessage(NEW_STUDENT_SELECT_ONE, &student, pShellControllerWindow->m_pSelectedClass);
				pEditGroupWindow->UpdateStudentListInCandidateList(NEW_STUDENT_SELECT_ONE, pShellControllerWindow->m_SelectedClassName,  &student);
			}
		}

	}
	else
	{
		pShellControllerWindow->m_pTeacherAPI->ControlNewStudentConnect(student.studentID, FALSE);
	}



	// remove from list
	pShellControllerWindow->m_pNewStudentDialogList.remove(pNewStudentWindow);

//	delete (windowData->newStudentConnectWindow);
//	windowData->newStudentConnectWindow = NULL;
//
//	delete windowData;
//	windowData = NULL;

	delete pNewStudentWindow;
	pNewStudentWindow = NULL;

#if 0
	if(bIsAccept&&!isAdded)
	{
		int bIsAddToClass = windowData->newStudentConnectWindow->IsAddToClass();
		int errCode = 0;
		APIResult ret = pTeacherAPI->GetStudentStatus(student.studentID, student, errCode);

		if(student.username.size() == 0 || student.studentID.size() == 0)
		{
			string infolog;
			infolog.append("ShellControllerWindow::NewStudentConnectWinDestroy : Student ID or Name is empty  Student ID : ");
			infolog.append(student.studentID);
			infolog.append("  Student Name : ");
			infolog.append(student.username);
			CSESLog::WriteLine(infolog);
		}
		if (SES_API_SUCCESS != ret)
		{
			student.status = SES_STU_DISCONNECT;
		}

		pShellControllerWindow->AddStudentToIconView(student);

		if(bIsAddToClass)
		{
			if(NULL != pShellControllerWindow->m_pSelectedClass)
			{
				CStudentInfoData* pStudentInfoData = new CStudentInfoData();
				pStudentInfoData->SetStudentID(student.studentID);
				pStudentInfoData->SetStudentName(student.username);
				pShellControllerWindow->m_pSelectedClass->GetPStudentsInfoList()->push_back(pStudentInfoData);
				pShellControllerWindow->m_pClassGroup->Save2File(CONFIG_FILE_DIR + CLASS_GROUP);

				// sync with other windows
				if (NULL != pShellControllerWindow->m_pSelectClassWindow)
				{
					EditGroupWindow* pEditGroupWindow =	pShellControllerWindow->m_pSelectClassWindow->GetEditGroupWindow();
					if (NULL != pEditGroupWindow)
					{
						tagStudent_t* newTagStudent(&student);
						pEditGroupWindow->NewStudentMessage(NEW_STUDENT_SELECT_ONE, newTagStudent, pShellControllerWindow->m_pSelectedClass);
					}
				}
			}
		}
	}
	else if(bIsDeny)
	{
		pTeacherAPI->ControlNewStudentConnect(student.studentID, false);
	}

#endif

	CSESLog::WriteLine("ShellControllerWindow::NewStudentConnectWinDestroy>>End");
}


/******************************************************************************
 * Function Name:
 * Description  :
 * Date         :
 * Parameter    :	iOption 0 means allow; 1 means add to class;
 *
 * Return Code  :
 * Author       :
 ******************************************************************************/
int ShellControllerWindow::NotifyOtherWindowStudentChanged(const StudentInfo_t* pStudent, int iOption)
{
	if (NULL == pStudent)
	{
		return -1;
	}

	int ret = 0;

	// if edit class window is open,
	// main window needs to notify it.
	if (NULL != m_pSelectClassWindow)
	{
		EditGroupWindow* pEditGroupWindow =	m_pSelectClassWindow->GetEditGroupWindow();
		if (NULL != pEditGroupWindow)
		{
			// allow & add to class need call different API.
			if (0 == iOption)
			{
				// allow
				pEditGroupWindow->UpdateStudentListInCandidateList(NEW_STUDENT_SELECT_ONE, m_SelectedClassName, pStudent);

				ret = 0;
			}
			else if (1 == iOption)
			{
				// add to class
				pEditGroupWindow->UpdateStudentListOfCurrentClass(NEW_STUDENT_SELECT_ONE, m_SelectedClassName,  pStudent);

				ret = 1;
			}
			else if (2 == iOption)
			{
				// update student info
				pEditGroupWindow->UpdateStudentInfo(m_SelectedClassName,  pStudent);
			}
			else
			{
				g_assert(0);

				ret = -1;
			}

		}
	}

	return ret;
}


/******************************************************************************
 * Function Name:
 * Description  :
 * Date         :
 * Parameter    :
 *
 * Return Code  :
 * Author       :
 ******************************************************************************/
int ShellControllerWindow::CloseNewStudentDialogWhenTimeOut(string studentID, int status)
{
	if (0 == studentID.size())
	{
		return -1;
	}

	// preCondition : disconnect msg

	if (SES_STU_DISCONNECT != status)
	{
		return 0;
	}

	int ret = 0;

	std::list<NewStudentConnectWindow*>::iterator iter;
	for (iter = m_pNewStudentDialogList.begin(); iter != m_pNewStudentDialogList.end(); ++iter)
	{
		if (NULL != *iter && (*iter)->GetStudentID() == studentID )
		{
			(*iter)->CloseDueToDisconnect();
			delete (*iter);
			m_pNewStudentDialogList.erase(iter);

			break;
		}
	}

	return ret;
}

/******************************************************************************
 * Function Name: NotifyStudentStatusChanged
 * Description  : The CallBack Function
 * Date         : 2008/9/10
 * Parameter    : studentID			student ID
 * 				  status 			student status
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::NotifyStudentStatusChanged(string studentID, int iStatus)
{
	CSESLog::WriteLine("ShellControllerWindow::NotifyStudentStatusChanged<<Start");
	gdk_threads_enter();
	if(iInited)
	{
		UpdateStudentStatus(studentID, iStatus);

		// when time out , student will be disconnect automatically
		// the new student connect dialog will be close
		CloseNewStudentDialogWhenTimeOut(studentID, iStatus);

		// under open for all, some class
		// if student is disconnect , need remove from GUI.
		if (SES_STU_DISCONNECT == iStatus)
		{
			if (OpenForAll == m_eClassSelectStatus)
			{
				RemoveStudent(studentID);
			}
			else if (SomeClass == m_eClassSelectStatus)
			{
				if (NULL != m_pSelectedClass && 0 == IsStudentInSelectedClass(m_pSelectedClass->GetName(), studentID) )
				{
					RemoveStudent(studentID);
				}

//				if (NULL != m_pSelectedClass && false == m_pSelectedClass->IsStudentExist(studentID))
//				{
//					RemoveStudent(studentID);
//				}
			}
			else
			{
				// do nothing.
			}
		}
	}
	gdk_threads_leave();
	CSESLog::WriteLine("ShellControllerWindow::NotifyStudentStatusChanged>>End");
}
//new function, change student id
void ShellControllerWindow::NotifyStudentInfoChanged(string& OldStudentID, string& NewStudentID,
													string& NewStudentName, bool bNeedDelete)
{
//	gdk_threads_enter();
//	if(true == bNeedDelete)
//	{
//		GtkTreeIter iter;
//		GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_tree_view_get_model(GTK_TREE_VIEW(m_gIconView));
//		bool isInvalid = gtk_tree_model_get_iter_first(model, &iter);
//		tagStudent_t* ptagStudent = new tagStudent_t();
//		while(isInvalid)
//		{
//			gtk_tree_model_get (model, &iter, COLUMN_ITEM_POINTER, &ptagStudent, -1);
//			if(OldStudentID == ptagStudent->studentID)
//			{
//				//kick off student
//				gtk_list_store_remove(GTK_LIST_STORE (model), &iter);
//				m_pOnlineStudentList.remove(ptagStudent);
//			}
//			isInvalid = gtk_tree_model_iter_next(model, &iter);
//		}
//		CClassGroupData pClassGroup;
//		pClassGroup.LoadFromFile(CONFIG_FILE_DIR + CLASS_GROUP);
//		list<CClassDef*>::iterator classIter;
//		for(classIter = pClassGroup.GetPClassInfoList()->begin(); classIter != pClassGroup.GetPClassInfoList()->end(); ++classIter)
//		{
//			list<CStudentInfoData*>::iterator studentIter;
//			for(studentIter = (*classIter)->GetPStudentsInfoList()->begin(); studentIter != (*classIter)->GetPStudentsInfoList()->end(); ++studentIter)
//			{
//				if((*studentIter)->GetStudentID() == OldStudentID)
//				{
//					(*classIter)->GetPStudentsInfoList()->remove(*studentIter);
//				}
//			}
//		}
//
//	}
//	//change name
//	else
//	{
//
//	}
//
//	gdk_threads_leave();
}
/******************************************************************************
 * Function Name: ReloadSystemSetting
 * Description  : Reload SystemSettings
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ReloadSystemSetting()
{
	CSESLog::WriteLine(" ShellControllerWindow::ReloadSystemSetting >>Start");
	if (NULL != m_pSESSystemSettingData)
	{
		m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);
	}
	CSESLog::WriteLine(" ShellControllerWindow::ReloadSystemSetting <<End");
}
/******************************************************************************
 * Function Name: DeployPolicy
 * Description  : Deploy policy
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : 0				OK
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::DeployPolicy(std::string studentID)
{
	int ret = 0;

	if (0 == studentID.size())
	{
		return -1;
	}

	// Lock Data
	CLockScheduleData lockScheduleData;
	lockScheduleData.LoadFromFile(CONFIG_FILE_DIR + LOCK_SCHEDULE);
	lockScheduleData.SetManualLock(0);
	if(true == lockScheduleData.IsAutoLockEnable())
	{
		lockScheduleData.SetLockStatus(SES_STU_AUTO_LOCK);
	}
	else
	{
		lockScheduleData.SetLockStatus(SES_STU_AUTO_UNLOCK);
	}
	string lockScheduleString;
	lockScheduleData.Save2String(lockScheduleString);

	// TabNav Data
	CTabNavigationData tabNavigationData;
	tabNavigationData.LoadFromFile(CONFIG_FILE_DIR + TAB_NAVIGATION);
	string tabNaviString;
	tabNavigationData.Save2String(tabNaviString);

	// Call API to Deploy
//	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"ShellControllerWindow::DeployPolicy::DeploySchedulePolicy<<Start LOG_TEACHER_DEPLOYSCHEDULE");
//	m_pTeacherAPI->DeploySchedulePolicy(studentID, lockScheduleString);
//	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"ShellControllerWindow::DeployPolicy::DeploySchedulePolicy>>End LOG_TEACHER_DEPLOYSCHEDULE");

	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,	"ShellControllerWindow::DeployPolicy::DeployTabNavPolicy<<Start LOG_TEACHER_DEPLOYTABNAV");
	int iOID;
	list<string> studentlist;
	studentlist.push_back(studentID);
	m_pTeacherAPI->DeployTabNavPolicy(studentlist, lockScheduleString, tabNaviString, iOID);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,	"ShellControllerWindow::DeployPolicy::DeployTabNavPolicy>>End LOG_TEACHER_DEPLOYTABNAV");

	// TODO: return value.

	return ret;
}
/******************************************************************************
 * Function Name: AddStudentToCurrentClass
 * Description  : Add student to current class
 * Date         : 2008/11/10
 * Parameter    : studentInfo		the student which will be added to current class
 * 				  addToClass		justify whether adding to class or not
 * Return Code  : 0				OK
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::AddStudentToCurrentClass(StudentInfo_t studentInfo, bool addToClass)
{
	// 1.open for all only update gui
	// 2.if some class is selected need update class info.

	// Need update class info?
	if (true == addToClass)
	{
		CStudentInfoData* pStudentInfoData = new CStudentInfoData();
		pStudentInfoData->SetStudentID(studentInfo.studentID);
		pStudentInfoData->SetStudentName(studentInfo.username);

		CClassDef* targetClass = NULL;
		m_pClassGroup->GetClassInfo(m_pSelectedClass->GetName(), &targetClass);

		if (NULL != targetClass)
		{
			targetClass->GetPStudentsInfoList()->push_back(pStudentInfoData);
			m_pClassGroup->Save2File(CONFIG_FILE_DIR + CLASS_GROUP);
		}
	}

	// update gui.
	GtkTreeIter iter;
	GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model (GTK_ICON_VIEW (m_gIconView));

	int iStatus = studentInfo.status;
	GdkPixbuf *pixbufLock = GetStudentStatusIcon(&studentInfo, iStatus);
	tagStudent_t* ptagStudent_t = NULL;
	gboolean isConnected = IsStudentConnected(iStatus);

	gtk_list_store_append(GTK_LIST_STORE(model), &iter);

	ptagStudent_t = new tagStudent_t(studentInfo);
	gtk_list_store_set(GTK_LIST_STORE(model), &iter,
			COLUMN_ITEM_NAME, (ptagStudent_t->username).c_str(),
			COLUMN_ITEM_PIC, pixbufLock,
			COLUMN_ITEM_POINTER, ptagStudent_t,
			COLUMN_ITEM_CONNECTED, isConnected,
			-1);

	m_pOnlineStudentList.push_back(ptagStudent_t);

	ReDrawIconView();

	// Deploy Policy.
	if (m_pSESSystemSettingData->GetAutoDeployEnabled())
	{
		DeployPolicy(studentInfo.studentID);
	}


	return 0;
}

int ShellControllerWindow::IsStudentInSelectedClass(std::string className, std::string studentID)
{
	if (className.size() == 0 || studentID.size() == 0)
	{
		return 0;
	}

//	if (m_eClassSelectStatus == NoClass || m_eClassSelectStatus == OpenForAll)
//	{
//		return 0;
//	}

	int ret = 0;

	// no class or open for all are not acceptable.

	if (m_eClassSelectStatus == SomeClass && NULL != m_pClassGroup)
	{
		CClassDef* pTargetClass = NULL;
		m_pClassGroup->GetClassInfo(className, &pTargetClass);

		if (NULL != pTargetClass)
		{
			ret = pTargetClass->IsStudentExist(studentID);
		}
	}

	return ret;
}


/******************************************************************************
 * Function Name: UpdateStudentInClass
 * Description  : Update student in class
 * Date         : 2008/11/10
 * Parameter    : studentInfo		the student which will be added to current class
 * 				  addToClass		justify whether adding to class or not
 * Return Code  : 0				OK
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int ShellControllerWindow::UpdateStudentInClass(StudentInfo_t studentinfo)
{
	return 0;
}

/******************************************************************************
 * Function Name: NewStudentCallBack
 * Description  : The CallBack Function
 * Date         : 2008/9/10
 * Parameter    : studentInfo			student's infomation
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::NewStudentCallBack(const StudentInfo_t& studentInfo)
{
	CSESLog::WriteLine("ShellControllerWindow::NewStudentCallBack<<Start");

	if(studentInfo.username.size() == 0 || studentInfo.studentID.size() == 0)
	{
		CSESLog::WriteLine("student information is invalid!", CSESLog::ERROR);
		CSESLog::WriteLine("ShellControllerWindow::NewStudentCallBack>>End");
		return;
	}

	gdk_threads_enter();

	// TODO : jinxin review refactory
	// check class status
	// 1. no class	-- deny directly
	// 2. open for all	-- add directly
	// 3. some class	-- do more complex check.
	if (NoClass == m_eClassSelectStatus)
	{
		m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, FALSE);
//		MakeSearchItemDisableStatus();
	}
	else if (OpenForAll == m_eClassSelectStatus)
	{
		m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, TRUE);

		AddStudentToCurrentClass(studentInfo, false);
//		MakeSearchItemAbleStatus();
	}
	else if (SomeClass == m_eClassSelectStatus)
	{
		//1. student in current class, update GUI
		//2. prompt new student connect dialog
//		MakeSearchItemAbleStatus();
		CClassDef* classDef = NULL;
		m_pClassGroup->GetClassInfo(m_SelectedClassName, &classDef);

		if(classDef)
		{
			if (classDef->IsStudentExist(studentInfo.studentID))
			{
				m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, TRUE);

				if(classDef->UpdateStudentNameByID(studentInfo.studentID, studentInfo.username))
				{
					m_pClassGroup->Save2File(CONFIG_FILE_DIR + CLASS_GROUP);
					//TODO Notify EditClassWindow
				}

				// update gui
				//UpdateStudentStatus(studentInfo.studentID, studentInfo.status);
				tagStudent_t student(studentInfo);

				UpdateStudentStatusAndName(&student);

				NotifyOtherWindowStudentChanged(&studentInfo, 2);

				ReDrawIconView();

				// deploy
				if (m_pSESSystemSettingData->GetAutoDeployEnabled())
				{
					DeployPolicy(studentInfo.studentID);
				}
			}
			else
			{
				// no in current class
				int newStudentDialogEnable = m_pSESSystemSettingData->GetNewStudentConnectDialogEnable();
				if(1 == newStudentDialogEnable)
				{
					StudentInfo_t tmpStudent(studentInfo);

					NewStudentConnectWindow* studentWindow = new NewStudentConnectWindow(tmpStudent);
	//				ShellControllerWindowData* windowData = new ShellControllerWindowData();
	//				windowData->newStudentConnectWindow = studentWindow;
	//				windowData->shellControllerWindow = this;
					studentWindow->Init();
					//studentWindow->ShowModal(this->m_gWindow, G_CALLBACK(ShellControllerWindow::NewStudentConnectWinDestroy), windowData);
					studentWindow->ShowModal(this->m_gWindow, G_CALLBACK(ShellControllerWindow::NewStudentConnectWinDestroy), this);

					// save the window pointer.
					m_pNewStudentDialogList.push_back( studentWindow );

				}
				else
				{
					int connectPolicy = m_pSESSystemSettingData->GetConnectPolicyAllow();
					if(1 == connectPolicy)
					{
						m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, TRUE);

						int addToCurrentClass = m_pSESSystemSettingData->GetAddToCurrentClassAllow();
						if(1 == addToCurrentClass)
						{
							AddStudentToCurrentClass(studentInfo, true);
							NotifyOtherWindowStudentChanged(&studentInfo, 1);
						}
						else
						{
							AddStudentToCurrentClass(studentInfo, false);// TODO check RTM.
							NotifyOtherWindowStudentChanged(&studentInfo, 0);
						}
					}
					else
					{
						m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, FALSE);
					}
				}
			}

		}
		else
		{
			g_assert(0);
		}

	}
	else
	{
		g_assert(0);
	}

#if 0
	if(iInited)
	{
		tagStudent_t student;
		GtkTreeIter iter;
		gboolean isValid = FALSE;
		GtkTreeModel* model = gtk_icon_view_get_model (GTK_ICON_VIEW (m_gIconView));
		tagStudent_t* ptagStudent_t = NULL;
		gboolean isConnected = FALSE;
		isValid = gtk_tree_model_get_iter_first (model, &iter);//TODO nothing
		while(isValid)
		{
			gtk_tree_model_get (model, &iter, COLUMN_ITEM_POINTER, &ptagStudent_t, COLUMN_ITEM_CONNECTED, &isConnected, -1);
			if(ptagStudent_t)
			{
				if(ptagStudent_t->studentID == studentInfo.studentID)
				{
					break;
				}
				else
				{
					ptagStudent_t = NULL;
				}
			}
			isValid = gtk_tree_model_iter_next (model, &iter);
		}

		int iStatus = studentInfo.status;
		//m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, TRUE);
		GdkPixbuf *pixbufLock = GetStudentStatusIcon(iStatus);
		isConnected = IsStudentConnected(iStatus);


		CLockScheduleData lockScheduleData;
		CTabNavigationData tabNavigationData;
		lockScheduleData.LoadFromFile(CONFIG_FILE_DIR + LOCK_SCHEDULE);
		lockScheduleData.SetManualLock(0);
		if(true == lockScheduleData.IsAutoLockEnable())
		{
			lockScheduleData.SetLockStatus(SES_STU_AUTO_LOCK);
		}else
		{
			lockScheduleData.SetLockStatus(SES_STU_AUTO_UNLOCK);
		}

		tabNavigationData.LoadFromFile(CONFIG_FILE_DIR + TAB_NAVIGATION);
		string lockScheduleString("");
		string tabNaviString("");
		lockScheduleData.Save2String(lockScheduleString);
		tabNavigationData.Save2String(tabNaviString);

		int autoDeploy = m_pSESSystemSettingData->GetAutoDeployEnabled();

		if(NULL != ptagStudent_t)
		{
			ptagStudent_t->studentID = studentInfo.studentID;
			ptagStudent_t->username = studentInfo.username;
			ptagStudent_t->IP = studentInfo.IP;
			ptagStudent_t->bLocked = studentInfo.bLocked;
			ptagStudent_t->hostname = studentInfo.hostname;
			ptagStudent_t->status = studentInfo.status;
			ptagStudent_t->start_time = studentInfo.start_time;
			gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_NAME, studentInfo.username.c_str(), COLUMN_ITEM_PIC, pixbufLock,
					COLUMN_ITEM_POINTER, ptagStudent_t, COLUMN_ITEM_CONNECTED, isConnected, -1);
			ReDrawIconView();

			m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, TRUE);
			if(1 == autoDeploy)
			{
				m_pTeacherAPI->DeploySchedulePolicy(studentInfo.studentID, lockScheduleString);
				m_pTeacherAPI->DeployTabNavPolicy(studentInfo.studentID, tabNaviString);
			}
		}
		else
		{
			if(m_iClassType == 0)
			{
				gtk_list_store_append(GTK_LIST_STORE(model), &iter);
				ptagStudent_t = new tagStudent_t(studentInfo);
				gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_NAME, (ptagStudent_t->username).c_str(), COLUMN_ITEM_PIC, pixbufLock,
												COLUMN_ITEM_POINTER, ptagStudent_t, COLUMN_ITEM_CONNECTED, isConnected, -1);
				m_pOnlineStudentList.push_back(ptagStudent_t);
				ReDrawIconView();
				m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, TRUE);
				if(1 == autoDeploy)
				{
					m_pTeacherAPI->DeploySchedulePolicy(studentInfo.studentID, lockScheduleString);
					m_pTeacherAPI->DeployTabNavPolicy(studentInfo.studentID, tabNaviString);
				}
			}
			else
			{
				int newStudentDialogEnable = m_pSESSystemSettingData->GetNewStudentConnectDialogEnable();
				if(1 == newStudentDialogEnable)
				{
					StudentInfo_t tmpStudent(studentInfo);

					NewStudentConnectWindow* studentWindow = new NewStudentConnectWindow(tmpStudent);
					ShellControllerWindowData* windowData = new ShellControllerWindowData();
					windowData->newStudentConnectWindow = studentWindow;
					windowData->shellControllerWindow = this;
					studentWindow->Init();
					studentWindow->ShowModal(this->m_gWindow, G_CALLBACK(ShellControllerWindow::NewStudentConnectWinDestroy), windowData);
				}
				else
				{
					int connectPolicy = m_pSESSystemSettingData->GetConnectPolicyAllow();
					if(1 == connectPolicy)
					{
						int addToCurrentClass = m_pSESSystemSettingData->GetAddToCurrentClassAllow();
						if(1 == addToCurrentClass)
						{
							CStudentInfoData* pStudentInfoData = new CStudentInfoData();
							pStudentInfoData->SetStudentID(studentInfo.studentID);
							pStudentInfoData->SetStudentName(studentInfo.username);
							m_pSelectedClass->GetPStudentsInfoList()->push_back(pStudentInfoData);
							m_pClassGroup->Save2File(CONFIG_FILE_DIR + CLASS_GROUP);
						}
						gtk_list_store_append(GTK_LIST_STORE(model), &iter);
						ptagStudent_t = new tagStudent_t(studentInfo);
						gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_NAME, (ptagStudent_t->username).c_str(), COLUMN_ITEM_PIC, pixbufLock,
														COLUMN_ITEM_POINTER, ptagStudent_t, COLUMN_ITEM_CONNECTED, isConnected, -1);

						m_pOnlineStudentList.push_back(ptagStudent_t);
						ReDrawIconView();
						m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, TRUE);
						if(1 == autoDeploy)
						{
							m_pTeacherAPI->DeploySchedulePolicy(studentInfo.studentID, lockScheduleString);
							m_pTeacherAPI->DeployTabNavPolicy(studentInfo.studentID, tabNaviString);
						}
					}
					else
					{
						m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, false);
					}
				}
			}
		}
	}
	else
	{
		m_pTeacherAPI->ControlNewStudentConnect(studentInfo.studentID, false);
	}

#endif

	gdk_threads_leave();
	CSESLog::WriteLine("ShellControllerWindow::NewStudentCallBack>>End");
}
/******************************************************************************
 * Function Name: DeploySchedulePolicyCallBack
 * Description  : The CallBack Function
 * Date         : 2008/9/10
 * Parameter    : studentID			student's ID
 * 				  bSuccess			success status
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
//void ShellControllerWindow::DeploySchedulePolicyCallBack(string studentID, bool bSuccess)
//{
//}
/******************************************************************************
 * Function Name: DeploySchedulePolicyCallBack
 * Description  : The CallBack Function
 * Date         : 2008/9/10
 * Parameter    : studentID			student's ID
 * 				  iReturn			whether the data receiver is receiving the data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ManualUnLockRemotStudentCallBack(string studentID, int iReturn)
{
}
/******************************************************************************
 * Function Name: LockStudentsWindowDestroy
 * Description  : When LockStudentsWindow destroy, delete the pointer
 * Date         : 2008/9/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::LockStudentsWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::LockStudentsWindowDestroy<<Start");
	ShellControllerWindow *ptr = (ShellControllerWindow*)data;
	delete (ptr->m_pLockStudentsWindow);
	ptr->m_pLockStudentsWindow = NULL;
	CSESLog::WriteLine("ShellControllerWindow::LockStudentsWindowDestroy>>End");
}
/******************************************************************************
 * Function Name: DeploySettings
 * Description  : Deploy settings
 * Date         : 2008/9/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::DeploySettings(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::DeploySettings<<Start");
	ShellControllerWindow *ptr = (ShellControllerWindow*)data;
//
//
	list<tagStudent_t> tagStudentList;
	ptr->GetSelectedStudents(tagStudentList, ptr->m_gIconView, TRUE);
	list<string> studentList;
	list<tagStudent_t>::iterator tempIter;
	for(tempIter = tagStudentList.begin(); tempIter != tagStudentList.end(); ++tempIter)
	{
		studentList.push_back((*tempIter).studentID);
	}

	int iSelectStudentCount = 0;
	iSelectStudentCount = ptr->m_mainViewOperation->MainViewGetSelectedItemsCount();
	if(studentList.size() > 0)
	{
	    ptr->m_pDeploySettingsWindow = new DeployShellSettingsWindow(studentList, iSelectStudentCount);
        ptr->m_pDeploySettingsWindow->Init();
        ptr->m_pDeploySettingsWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(DeployShellSettingsWindowDestroy), ptr);
	}
	else
	{
	    string message("Cannot apply settings to disconnect students!");
	    CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
	}



//	string lockScheduleString("");
//	string tabNaviString("");
//	CLockScheduleData lockScheduleData;
//	CTabNavigationData tabNavigationData;
//	list<tagStudent_t> tagStudentList;
//	list<tagStudent_t>::iterator iter;
//	ptr->GetSelectedStudents(tagStudentList, ptr->m_gIconView, TRUE);
//	if(tagStudentList.size() > 0)
//	{
//		lockScheduleData.LoadFromFile(CONFIG_FILE_DIR + LOCK_SCHEDULE);
//		lockScheduleData.SetManualLock(0);
//		if(true == lockScheduleData.IsAutoLockEnable())
//		{
//			lockScheduleData.SetLockStatus(SES_STU_AUTO_LOCK);
//		}else
//		{
//			lockScheduleData.SetLockStatus(SES_STU_AUTO_UNLOCK);
//		}
//		tabNavigationData.LoadFromFile(CONFIG_FILE_DIR + TAB_NAVIGATION);
//		lockScheduleData.SetManualLock(0);
//		lockScheduleData.Save2String(lockScheduleString);
//		tabNavigationData.Save2String(tabNaviString);
//		std::list<std::string> studentList;
//		for(iter = tagStudentList.begin(); iter!= tagStudentList.end(); ++iter)
//		{
//			studentList.push_back((*iter).studentID);
//		}
//		int OID = 0;
//		if ( studentList.size() > 0 )
//		{
//			CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"ShellControllerWindow::DeploySettings::DeploySchedulePolicy<<Start LOG_TEACHER_DEPLOYSCHEDULE");
//
//			ptr->m_pTeacherAPI->DeploySchedulePolicy(studentList, lockScheduleString,OID);
//			CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,	"ShellControllerWindow::DeploySettings::DeploySchedulePolicy>>End LOG_TEACHER_DEPLOYSCHEDULE");
//
//			CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,	"ShellControllerWindow::DeploySettings::DeployTabNavPolicy<<Start LOG_TEACHER_DEPLOYTABNAV");
//			ptr->m_pTeacherAPI->DeployTabNavPolicy(studentList, tabNaviString);
//			CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,	"ShellControllerWindow::DeploySettings::DeployTabNavPolicy>>End LOG_TEACHER_DEPLOYTABNAV");
//
//		}
//		ptr->m_pDeploySettingsWindow = new DeployShellSettingsWindow(studentList, OID);
//        ptr->m_pDeploySettingsWindow->Init();
//        ptr->m_pDeploySettingsWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(DeployShellSettingsWindowDestroy), ptr);
//	}
//	else
//	{
//		string message(_("Please select some students!"));
//		CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
//		 //ptr->SESShowDialog("please select some students");
//	}
	CSESLog::WriteLine("ShellControllerWindow::DeploySettings>>End");
}



void ShellControllerWindow::DeployShellSettingsWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
    ShellControllerWindow* ptr = (ShellControllerWindow*)data;
    if(NULL != ptr->m_pDeploySettingsWindow)
    {
        delete ptr->m_pDeploySettingsWindow;
        ptr->m_pDeploySettingsWindow = NULL;
    }
}

/******************************************************************************
 * Function Name: ShowTeacherWindow
 * Description  : show the TeacherInfomation window
 * Date         : 2008/9/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ShowTeacherWindow(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::ShowTeacherWindow<<Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	ptr->m_pTeacherInfoWindow = new TeacherInfoWindow();
	ptr->m_pTeacherInfoWindow->Init();
	ptr->m_pTeacherInfoWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(ShellControllerWindow::TeacherWindowDestroy), ptr);
	CSESLog::WriteLine("ShellControllerWindow::ShowTeacherWindow>>End");
}
/******************************************************************************
 * Function Name: TeacherWindowDestroy
 * Description  : Delete the TeacherInfomation window
 * Date         : 2008/9/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::TeacherWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("ShellControllerWindow::TeacherWindowDestroy<<Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(NULL != ptr->m_pTeacherInfoWindow)
	{
		delete ptr->m_pTeacherInfoWindow;
		ptr->m_pTeacherInfoWindow = NULL;
	}
	CSESLog::WriteLine("ShellControllerWindow::TeacherWindowDestroy>>End");
}
/******************************************************************************
 * Function Name: AutoDeploy
 * Description  : Auto deploy shell settings
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
//void ShellControllerWindow::AutoDeploy(GtkWidget* gtkwidget, gpointer data)
//{
//	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
//	int deployValue = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(ptr->m_pAutoDeployCheckItem));
//	ptr->m_pSESSystemSettingData->SetAutoDeployEnabled(deployValue);
//	string systemSettingsConfigDir("");
//	systemSettingsConfigDir.append(CONFIG_FILE_DIR);
//	systemSettingsConfigDir.append(SES_SYSTEM_SETTING);
//	ptr->m_pSESSystemSettingData->Save2File(systemSettingsConfigDir);
//}
/******************************************************************************
 * Function Name: ImportNewCACallBack
 * Description  : Import new certificate call back function
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ImportNewCACallBack(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	ptr->m_pImportWindow = new ImportCAWindow();
	ptr->m_pImportWindow->Init();
	ptr->m_pImportWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(ImportNewCAWindowDestroy), ptr);
}
/******************************************************************************
 * Function Name: ChangePassWordWindowDestroy
 * Description  : Change password window destroy call back function
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ChangePassWordWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(NULL != ptr->m_pChangePassWordWindow)
	{
		delete ptr->m_pChangePassWordWindow;
		ptr->m_pChangePassWordWindow = NULL;
	}
}
/******************************************************************************
 * Function Name: ChangePassword
 * Description  : Init change password window
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ChangePassword(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	ptr->m_pChangePassWordWindow =  new ChangePasswordWindow();
	ptr->m_pChangePassWordWindow->Init();
	ptr->m_pChangePassWordWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(ChangePassWordWindowDestroy), ptr);

}
/******************************************************************************
 * Function Name: ImportNewCAWindowDestroy
 * Description  : Import New Certificate window destroy call back function
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ImportNewCAWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(1 == ptr->m_pImportWindow->IsPathTrue())
	{
		string str = ptr->m_pImportWindow->CAString();
		ptr->m_pPassWordWindow =  new PassWordWindow(str, 0);
		ptr->m_pPassWordWindow->Init();
		ptr->m_pPassWordWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(FilePassWordWindowDestroy), ptr);
	}
	if(NULL != ptr->m_pImportWindow)
	{
		delete (ptr->m_pImportWindow);
		ptr->m_pImportWindow = NULL;
	}
}
/******************************************************************************
 * Function Name: ShowAboutInfo
 * Description  : Show about window
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ShowAboutInfo(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(NULL != ptr)
	{
		if(NULL != ptr->m_pAboutdialogWindow)
		{
			delete ptr->m_pAboutdialogWindow;
			ptr->m_pAboutdialogWindow = NULL;
		}
	}
	string appString(_("Shell Controller"));
	string versionString(_("1.0"));
	string PicturePath = SES_SHELL_CONTROLLER_ICON;
	ptr->m_pAboutdialogWindow = new CAboutDlg(appString, PicturePath, versionString);
	ptr->m_pAboutdialogWindow->Init();
	ptr->m_pAboutdialogWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(AboutWindowDestroy), ptr);
}
/******************************************************************************
 * Function Name: AboutWindowDestroy
 * Description  : About window destroy call back
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the GtkWidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::AboutWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{

}
/******************************************************************************
 * Function Name: SelectClass
 * Description  : Show select class window
 * Date         : 2008/11/10
 * Parameter    : item				select class item
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::SelectClass(GtkMenuItem* item, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(NULL != ptr->m_pSelectedClass)
	{
		ptr->m_SelectedClassName = ptr->m_pSelectedClass->GetName();
	}
	else
	{
		ptr->m_SelectedClassName = "";
	}

	if (NULL != ptr->m_pSelectClassWindow )
	{
		delete ptr->m_pSelectClassWindow;
		ptr->m_pSelectClassWindow = NULL;
	}

	//ptr->m_pSelectClassWindow = new SelectClassWindow(ptr->m_pTeacherAPI, ptr->m_pClassGroup, ptr->m_pSelectedClass);

	ptr->m_pSelectClassWindow = new SelectClassWindow(ptr->m_SelectedClassName);

	if (NULL != ptr->m_pSelectClassWindow)
	{
		ptr->m_pSelectClassWindow->Init();
		ptr->m_pSelectClassWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(ClassSelectWinDestroy), ptr);
	}
}
/******************************************************************************
 * Function Name: FilePassWordWindowDestroy
 * Description  : Password window destroy call back
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the gtkwidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::FilePassWordWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	int iQuitStatus = ptr->m_pPassWordWindow->GetQuitStatus();
	if(SERVICE_FAILURE_QUIT == iQuitStatus || TIME_OUT_QUIT == iQuitStatus || RESTART_QUIT == iQuitStatus )
	{
	    gtk_main_quit();
	}
	else
	{
	    if(1 == ptr->m_pPassWordWindow->IsPasswordTrue())
        {
            string stringPath("");
            stringPath.append(ptr->m_pPassWordWindow->GetPath());
//            int errCode = 0;
//            int verifyResult = ptr->m_pTeacherAPI->VerifyCertificate(stringPath, errCode);
//            if(SES_API_SUCCESS == verifyResult)
//            {
//                if(SES_API_SUCCESS == errCode)
//                {
                    int errCode = SES_API_SUCCESS;
                    int importResult = SES_API_SUCCESS;

                    importResult = ptr->m_pTeacherAPI->ImportCertificate(stringPath, errCode);

                    if(SES_API_SUCCESS == importResult)
                    {
                        if(SES_API_SUCCESS == errCode)
                        {
                            string message(_("Certificate has been imported successfully, and then Shell Controller will restart!"
                                    "All students will be kicked off!"));
                            CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
                            int startResult = 0;
                            startResult = ptr->m_pTeacherAPI->StartController(errCode);
                            if(SES_API_SUCCESS == startResult)
                            {
                                if(SES_API_SUCCESS == errCode)
                                {
                                    //added by lfeng
                                    ptr->HandleReStartContrller();
    //




                                    ptr->m_CAPathString = stringPath;
                                }
                                else if(SES_API_ACCERT_ADDRESSINUSE == errCode)
                                {
                                    //ptr->m_iStartControllerOK = 0;
                                    string message(_("Port 8888 and 8889 are already in use, the application will quit!"));
                                    CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
                                    //PublicFunc::SESShowDialogAndQuit(_("Port 8888 and 8889 are already in use, the application will quit!"), ptr->m_gWindow);
                                }
                                else
                                {
                                    //ptr->m_iStartControllerOK = 0;
                                    string message(_("Shell Controller cannot launch, the application will quit!"));
                                    CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
                                    //PublicFunc::SESShowDialogAndQuit(_("Shell Controller cannot launch, the application will quit!"), ptr->m_gWindow);
                                }
                            }
                            else if(SES_API_TIME_OUT == startResult)
                            {
                                //ptr->m_iStartControllerOK = 0;
                                string message(_("Time out, the application will quit!"));
                                CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
                                //PublicFunc::SESShowDialogAndQuit(_("Time out, the application will quit!"), ptr->m_gWindow);
                            }
                            else
                            {
                                string message(_("Shell Controller cannot launch, the application will quit!"));
                                CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
                                //ptr->m_iStartControllerOK = 0;
                                //PublicFunc::SESShowDialogAndQuit(_("Shell Controller cannot launch, the application will quit!"), ptr->m_gWindow);
                            }
                        }
                        else
                        {
                            string message(_("Fail to import certificate, the application will quit!"));
                            CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
                            //PublicFunc::SESShowDialogAndQuit(_("Fail to import certificate, the application will quit!"), ptr->m_gWindow);
                        }
                    }
                    else
                    {
                        string message(_("Fail to import certificate, the application will quit!"));
                        CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
                        //PublicFunc::SESShowDialogAndQuit(_("Fail to import certificate, the application will quit!"), ptr->m_gWindow);
                    }
//                }
//                else if(SES_API_NEEDRESTART == verifyResult)
//                {
//                    PublicFunc::SESShowDialogAndQuit(_("You should restart your computer!"), ptr->m_gWindow);
//                }
//                else
//                {
//                    string message(_("Fail to verify certificate!"));
//                    CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
//                }
//            }
//            else if(SES_API_TIME_OUT == verifyResult)
//            {
//                string message(_("Time out, the application will quit!"));
//                CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
//                //PublicFunc::SESShowDialogAndQuit(_("Time out, the application will quit!"), ptr->m_gWindow);
//            }
//            else
//            {
//                string message(_("Fail to verify certificate, the application will quit!"));
//                CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
//                //PublicFunc::SESShowDialogAndQuit(_("Fail to verify certificate, the application will quit!"), ptr->m_gWindow);
//            }
        }
        else
        {

        }
	}
	if(NULL != ptr->m_pPassWordWindow)
	{	delete (ptr->m_pPassWordWindow);
		ptr->m_pPassWordWindow = NULL;
	}
}
/******************************************************************************
 * Function Name: StartImportCAWindowDestroy
 * Description  : Import certificate window destroy call back
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the gtkwidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::StartImportCAWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(1 == ptr->m_pImportWindow->IsPathTrue())
	{
		ptr->m_CAPathString = ptr->m_pImportWindow->CAString();


		ptr->m_pPassWordWindow = new PassWordWindow(ptr->m_CAPathString, 0);
		ptr->m_pPassWordWindow->Init();
		ptr->m_pPassWordWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(StartPasswordWindowDestroy), ptr);
	}
	else
	{
	    string message(_("Fail to import certificate, the application will quit!"));
        CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
        gtk_main_quit();
		//PublicFunc::SESShowDialogAndQuit(_("Fail to import certificate, the application will quit!"), ptr->m_gWindow);
	}

	if(NULL != ptr->m_pImportWindow)
	{
		delete (ptr->m_pImportWindow);
		ptr->m_pImportWindow = NULL;
	}
}
/******************************************************************************
 * Function Name: StartPasswordWindowDestroy
 * Description  : password window destroy call back
 * Date         : 2008/11/10
 * Parameter    : gtkwidget			the gtkwidget which triggers the event
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::StartPasswordWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	int iQuitStatus = ptr->m_pPassWordWindow->GetQuitStatus();
	int iClickResult = ptr->m_pPassWordWindow->GetResult();
	if(SERVICE_FAILURE_QUIT == iQuitStatus || TIME_OUT_QUIT == iQuitStatus || RESTART_QUIT == iQuitStatus
	        || PASSWORD_THREE_TIMES_QUIT == iQuitStatus || iClickResult == BUTTON_CLICK_IS_CANCEL)
	{
	    gtk_main_quit();
	}
	else
	{
	    if(1 == ptr->m_pPassWordWindow->IsPasswordTrue())
        {
            string stringPath("");
            stringPath.append(ptr->m_CAPathString);
//            int verifyErrCode = 0;
//            int verifyResult = ptr->m_pTeacherAPI->VerifyCertificate(stringPath, verifyErrCode);
//            if(SES_API_SUCCESS == verifyResult)
//            {
//                if(SES_API_SUCCESS == verifyErrCode)
//                {
                    int importErrCode = SES_API_SUCCESS;
                    int importResult = SES_API_SUCCESS;
                    if(stringPath.length() > 0)
                    {
                        importResult = ptr->m_pTeacherAPI->ImportCertificate(stringPath, importErrCode);
                    }
                    if(SES_API_SUCCESS == importResult)
                    {
                        if(SES_API_SUCCESS == importErrCode)
                        {

                            int startErrCode = 0;
                            int startResult = 0;
                            startResult = ptr->m_pTeacherAPI->StartController(startErrCode);
                            if(SES_API_SUCCESS == startResult)
                            {
                                if(SES_API_SUCCESS != startErrCode)
                                {
                                    //ptr->m_iStartControllerOK = 0;
                                    string message(_("Shell Controller cannot launch, the application will quit!"));
                                    CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
                                    gtk_main_quit();
                                    //PublicFunc::SESShowDialogAndQuit(_("Shell Controller cannot launch, the application will quit!"), ptr->m_gWindow);
                                }
                                else
                                {
                                    if(NULL != ptr->m_pSelectedClass)
                                    {
                                        ptr->m_SelectedClassName = ptr->m_pSelectedClass->GetName();
                                    }
                                    else
                                    {
                                        ptr->m_SelectedClassName = "";
                                    }
                                    //ptr->m_pSelectClassWindow = new SelectClassWindow(ptr->m_pTeacherAPI, ptr->m_pClassGroup, ptr->m_pSelectedClass);

                                    ptr->m_pSelectClassWindow = new SelectClassWindow(ptr->m_SelectedClassName);
                                    ptr->m_pSelectClassWindow->Init();
                                    ptr->m_pSelectClassWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(ClassSelectWinDestroy), ptr);
                                }
                            }
                            else if(SES_API_TIME_OUT == startResult)
                            {
                                //ptr->m_iStartControllerOK = 0;
                                string message(_("Time out, the application will quit!"));
                                CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
                                gtk_main_quit();
                                //PublicFunc::SESShowDialogAndQuit(_("Time out, the application will quit!"), ptr->m_gWindow);
                            }
                            else
                            {
                                //ptr->m_iStartControllerOK = 0;
                                string message(_("Shell Controller cannot launch, the application will quit!"));
                                CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
                                gtk_main_quit();
                                //PublicFunc::SESShowDialogAndQuit(_("Shell Controller cannot launch, the application will quit!"), ptr->m_gWindow);
                            }
                        }
                        else
                        {
                            string message(_("Fail to import certificate, the application will quit!"));
                            CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
                            gtk_main_quit();
                            //PublicFunc::SESShowDialogAndQuit(_("Fail to import certificate, the application will quit!"), ptr->m_gWindow);
                        }
                      }
                    else
                    {
                        string message(_("Fail to import certificate, the application will quit!"));
                        CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
                        gtk_main_quit();
                        //PublicFunc::SESShowDialogAndQuit(_("Fail to import certificate, the application will quit!"), ptr->m_gWindow);
                    }
//                  }
//                else if(SES_API_NEEDRESTART == verifyErrCode)
//                {
//                    PublicFunc::SESShowDialogAndQuit(_("You should restart your computer!"), ptr->m_gWindow);
//                }
//                else
//                {
//                    PublicFunc::SESShowDialogAndQuit(_("Fail to verify certificate, the application will quit!"), ptr->m_gWindow);
//                }
//            }
//            else
//            {
//                PublicFunc::SESShowDialogAndQuit(_("Fail to verify certificate, the application will quit!"), ptr->m_gWindow);
//            }
        }
        else
        {
            gtk_main_quit();
            //application quit action have been done in password window
        }
	}


	if(NULL != ptr->m_pPassWordWindow)
	{
		delete (ptr->m_pPassWordWindow);
		ptr->m_pPassWordWindow = NULL;
	}


}
/******************************************************************************
 * Function Name: ReDrawIconView
 * Description  : ReDraw iconview
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void ShellControllerWindow::ReDrawIconView()
{
	// update internal data.
	MakeStudentNameUnique();

	// update GUI.
	GtkTreeIter iter;
	GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model (GTK_ICON_VIEW (m_gIconView));
	gboolean isValid = FALSE;
	isValid = gtk_tree_model_get_iter_first (model, &iter);

	StudentInfo_t* pStudentInView = NULL;
	while(isValid)
	{
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_POINTER, &pStudentInView, -1);
		list<tagStudent_t*>::iterator studentIter;

		if (NULL != pStudentInView)
		{
			gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_NAME, pStudentInView->displayName.c_str(), -1);
		}

		isValid = gtk_tree_model_iter_next (model, &iter);
	}
}

// if exist students with the same name, display their name + id.

int  ShellControllerWindow::MakeStudentNameUnique()
{
	int ret = 0;

	list<tagStudent_t*>::iterator studentIter;
	list<tagStudent_t*>::iterator studentIter2;
	list<tagStudent_t*>::iterator internalFindBegin;

	// 1.first restore all display name to original status. otherwise if some same name student left.
	// the display name with id will not be restored.

	// 2.make name unique.
	for(studentIter = m_pOnlineStudentList.begin(); studentIter != m_pOnlineStudentList.end(); ++studentIter)
	{
		(*studentIter)->displayName = (*studentIter)->username;
	}

	for(studentIter = m_pOnlineStudentList.begin(); studentIter != m_pOnlineStudentList.end(); ++studentIter)
	{
		internalFindBegin = studentIter;
		internalFindBegin++;

		for (studentIter2 = internalFindBegin; studentIter2 != m_pOnlineStudentList.end(); ++studentIter2)
		{
			if ((*studentIter)->username == (*studentIter2)->username)
			{
				(*studentIter)->displayName = (*studentIter)->username + "\n" + (*studentIter)->studentID;
				(*studentIter2)->displayName = (*studentIter2)->username + "\n" + (*studentIter2)->studentID;

				ret = 1;
			}
		}
	}

	return ret;
}

// For Class Info Edit
int ShellControllerWindow::NotifyClassInfoChanged(std::string orgClassName, std::string newClassName)
{
	if ( 0 == orgClassName.size() || 0 == newClassName.size() )
	{
		return -1;
	}

	int ret = 0;

	if ( SomeClass == m_eClassSelectStatus )
	{
		// reload class info
		// if current select class is changed.
		if (NULL != m_pSelectedClass && m_pSelectedClass->GetName() == orgClassName )
		{
			ret = EnterSomeClassStatus(newClassName);
		}
	}
	else
	{
		//openforall & noclass do noting
	}

	return ret;
}

// For Class Info Is Deleted.
int ShellControllerWindow::NotifyClassIsDeleted(std::string className)
{
	int ret = 0;

	if (NULL != m_pSelectedClass && m_pSelectedClass->GetName() == className )
	{
		ret = EnterNoClassStatus();
	}

	return ret;
}

//Make Search program item in disable status
//void ShellControllerWindow::MakeSearchItemAbleStatus()
//{
//	gtk_widget_set_sensitive(m_gSearingProgramItem, true);
//}
//void ShellControllerWindow::MakeSearchItemDisableStatus()
//{
//	gtk_widget_set_sensitive(m_gSearingProgramItem, false);
//}

//After importing new ca successfully, deal with the UI
void ShellControllerWindow::HandleReStartContrller()
{
	if (SomeClass == m_eClassSelectStatus)
	{
		// make all students grey.
		StudentInfo_t tmp;
		GdkPixbuf *pixbufLock = GetStudentStatusIcon(&tmp, SES_STU_DISCONNECT);

		GtkTreeIter iter;
		GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model(GTK_ICON_VIEW(m_gIconView));
		gboolean isConnected = FALSE;
		bool isInvalid = gtk_tree_model_get_iter_first(model, &iter);
		tagStudent_t* ptagStudent_t = NULL;
		while(isInvalid)
		{
			gtk_tree_model_get (model, &iter, COLUMN_ITEM_POINTER, &ptagStudent_t, -1);
			list<tagStudent_t*>::iterator studentIter;
			if(SES_STU_DISCONNECT != ptagStudent_t->status)
			{
				ptagStudent_t->status = SES_STU_DISCONNECT;

				gtk_list_store_set(GTK_LIST_STORE(model), &iter,
						COLUMN_ITEM_PIC, pixbufLock,
						COLUMN_ITEM_CONNECTED, isConnected,
						-1);
			}
			isInvalid = gtk_tree_model_iter_next (model, &iter);
		}
	}
	else if (OpenForAll == m_eClassSelectStatus)
	{
		ClearList(m_pOnlineStudentList);
		gtk_list_store_clear(m_gStore);
	}
	else if (NoClass == m_eClassSelectStatus)
	{
		// do nothing.
	}
	else
	{
		g_assert(0);
	}

#if 0
	if(m_pSelectClassWindow->IsOpenForAll())
	{
		ClearList(m_pOnlineStudentList);
		gtk_list_store_clear(m_gStore);
	}
	else if(m_pSelectClassWindow->GetSelectedClass())
	{
		GdkPixbuf *pixbufLock = GetStudentStatusIcon(SES_STU_DISCONNECT);
		GtkTreeIter iter;
		GtkTreeModel* model = m_mainViewOperation->MainViewGetModel();//gtk_icon_view_get_model(GTK_ICON_VIEW(m_gIconView));
		gboolean isConnected = FALSE;
		bool isInvalid = gtk_tree_model_get_iter_first(model, &iter);
		tagStudent_t* ptagStudent_t = NULL;
		while(isInvalid)
		{
			gtk_tree_model_get (model, &iter, COLUMN_ITEM_POINTER, &ptagStudent_t, -1);
			list<tagStudent_t*>::iterator studentIter;
			if(SES_STU_DISCONNECT != ptagStudent_t->status)
			{
				ptagStudent_t->status = SES_STU_DISCONNECT;

				gtk_list_store_set(GTK_LIST_STORE(model), &iter,
									COLUMN_ITEM_PIC, pixbufLock,
									COLUMN_ITEM_CONNECTED, isConnected,
									-1);
			}
			isInvalid = gtk_tree_model_iter_next (model, &iter);
		}
	}
	else
	{
		//do nothing
	}

#endif

}

void ShellControllerWindow::OnWindowClosing(GtkWidget* gtkwidget, GdkEvent* event, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	if(NULL != ptr->m_gWindow)
	{
		gtk_widget_destroy(ptr->m_gWindow);
	}
}


void  ShellControllerWindow::StudentIdCellDataFunc(GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *tree_model, GtkTreeIter *iter, gpointer data)
{
	tagStudent_t* pStudent = NULL;
	gtk_tree_model_get(tree_model, iter, COLUMN_ITEM_POINTER, &pStudent, -1);//COLUMN_ITEM_CONNECTED, &isConnected, -1);

	if(pStudent != NULL)
	{
		g_object_set (cell, "text", pStudent->studentID.c_str(), NULL);
	}
	else
	{
		g_object_set (cell, "text", STRING_STUDENT_EMPTY, NULL);
	}
}

gint ShellControllerWindow::StudentIdCompareFunc(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data)
{
	gint ret = 0;

	tagStudent_t* pStudentA = NULL;
	tagStudent_t* pStudentB = NULL;

	gtk_tree_model_get(model, a, COLUMN_ITEM_POINTER, &pStudentA, -1);
	gtk_tree_model_get(model, b, COLUMN_ITEM_POINTER, &pStudentB, -1);
	if(pStudentA && pStudentB)
	{
		ret = pStudentA->studentID.compare(pStudentB->studentID);
	}

	return ret;
}

void  ShellControllerWindow::StudentNameCellDataFunc(GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *tree_model, GtkTreeIter *iter, gpointer data)
{
	tagStudent_t* pStudent = NULL;
	gtk_tree_model_get(tree_model, iter, COLUMN_ITEM_POINTER, &pStudent, -1);//COLUMN_ITEM_CONNECTED, &isConnected, -1);

	if(pStudent != NULL)
	{
		g_object_set (cell, "text", pStudent->username.c_str(), NULL);
	}
	else
	{
		g_object_set (cell, "text", STRING_STUDENT_EMPTY, NULL);
	}
}

gint ShellControllerWindow::StudentNameCompareFunc(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data)
{
	gint ret = 0;

	tagStudent_t* pStudentA = NULL;
	tagStudent_t* pStudentB = NULL;

	gtk_tree_model_get(model, a, COLUMN_ITEM_POINTER, &pStudentA, -1);
	gtk_tree_model_get(model, b, COLUMN_ITEM_POINTER, &pStudentB, -1);
	if(pStudentA && pStudentB)
	{
		ret = pStudentA->username.compare(pStudentB->username);
	}

	return ret;
}

void  ShellControllerWindow::ConnectedStatusCellDataFunc(GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *tree_model, GtkTreeIter *iter, gpointer data)
{
	gboolean isConnected = FALSE;
	gtk_tree_model_get(tree_model, iter, COLUMN_ITEM_CONNECTED, &isConnected, -1);//COLUMN_ITEM_CONNECTED, &isConnected, -1);

	if(isConnected)
	{
		g_object_set (cell, "text", STRING_STUDENT_CONNECTED, NULL);
	}
	else
	{
		g_object_set (cell, "text", STRING_STUDENT_DISCONNECTED, NULL);
	}
}

gint ShellControllerWindow::ConnectedStatusCompareFunc(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data)
{
	gint ret = 0;

	ShellControllerWindow* ptr = (ShellControllerWindow*)user_data;

	if(!ptr)
	{
		return ret;
	}

	int isConnectedA = FALSE;
	int isConnectedB = FALSE;

	tagStudent_t* pStudentA = NULL;
	tagStudent_t* pStudentB = NULL;

	gtk_tree_model_get(model, a, COLUMN_ITEM_POINTER, &pStudentA, -1);
	gtk_tree_model_get(model, b, COLUMN_ITEM_POINTER, &pStudentB, -1);

	if(pStudentA && pStudentB)
	{

		isConnectedA = ptr->IsStudentConnected(pStudentA->status);
		isConnectedB = ptr->IsStudentConnected(pStudentB->status);

		if(isConnectedA)
		{
			if(!isConnectedB)
			{
				ret = -1;
			}
		}
		else
		{
			if(isConnectedB)
			{
				ret = 1;
			}
		}
	}

	return ret;
}

void  ShellControllerWindow::LockedStatusCellDataFunc(GtkTreeViewColumn *tree_column, GtkCellRenderer *cell, GtkTreeModel *tree_model, GtkTreeIter *iter, gpointer data)
{
	tagStudent_t* pStudent = NULL;
	gtk_tree_model_get(tree_model, iter, COLUMN_ITEM_POINTER, &pStudent, -1);//COLUMN_ITEM_CONNECTED, &isConnected, -1);

	if(pStudent != NULL)
	{
		if(pStudent->bLocked)
		{
			g_object_set (cell, "text", STRING_STUDENT_LOCKED, NULL);
		}
		else
		{
			g_object_set (cell, "text", STRING_STUDENT_UNLOCKED, NULL);
		}
	}
	else
	{
		g_object_set (cell, "text", STRING_STUDENT_EMPTY, NULL);
	}
}

gint ShellControllerWindow::LockedStatusCompareFunc(GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data)
{
	gint ret = 0;

	tagStudent_t* pStudentA = NULL;
	tagStudent_t* pStudentB = NULL;

	gtk_tree_model_get(model, a, COLUMN_ITEM_POINTER, &pStudentA, -1);
	gtk_tree_model_get(model, b, COLUMN_ITEM_POINTER, &pStudentB, -1);
	if(pStudentA && pStudentB)
	{
		if(pStudentA->bLocked)
		{
			if(!pStudentB->bLocked)
			{
				ret = -1;
			}
		}
		else
		{
			if(pStudentB->bLocked)
			{
				ret = 1;
			}
		}
	}

	return ret;
}

void ShellControllerWindow::RadioButtonChangeView(GtkCheckMenuItem* item, gpointer data)
{
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;

	if(ptr->m_mainIconVeiwOperation && ptr->m_mainTreeVeiwOperation)
	{
		GList* glist = ptr->m_mainViewOperation->MainViewGetSelectedItems();

		if(TRUE == gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM(ptr->m_gIconViewItem)))
		{
			if(ptr->m_mainViewOperation != ptr->m_mainIconVeiwOperation)
			{
				gtk_container_remove(GTK_CONTAINER(ptr->m_pScrolledWindow), gtk_bin_get_child(GTK_BIN(ptr->m_pScrolledWindow)));
				gtk_container_add(GTK_CONTAINER(ptr->m_pScrolledWindow), ptr->m_gIconView);

				ptr->m_mainViewOperation = ptr->m_mainIconVeiwOperation;

				gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

				ptr->m_mainViewOperation->MainViewUnselectAll();

				ptr->m_mainViewOperation->MainViewSelectPath(glist);

				gtk_widget_show(ptr->m_gIconView);

				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ptr->m_gViewCheckbtn), false);
			}

		}
		else
		{
			if(ptr->m_mainViewOperation != ptr->m_mainTreeVeiwOperation)
			{
				gtk_container_remove(GTK_CONTAINER(ptr->m_pScrolledWindow), gtk_bin_get_child(GTK_BIN(ptr->m_pScrolledWindow)));
				gtk_container_add(GTK_CONTAINER(ptr->m_pScrolledWindow), ptr->m_gTreeview);

				ptr->m_mainViewOperation = ptr->m_mainTreeVeiwOperation;
				gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ptr->m_pScrolledWindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

				ptr->m_mainViewOperation->MainViewUnselectAll();

				ptr->m_mainViewOperation->MainViewSelectPath(glist);

				gtk_widget_show(ptr->m_gTreeview);
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ptr->m_gViewCheckbtn), true);
			}

		}

		g_list_foreach (glist, (GFunc)gtk_tree_path_free, NULL);
		g_list_free (glist);


	}
}

void ShellControllerWindow::PreferenceWindowShow(GtkWidget* gtkwidget, gpointer data)
{
    ShellControllerWindow* ptr = (ShellControllerWindow*)data;
    ptr->m_pPreferenceWindow = new PreferenceWindow();
    ptr->m_pPreferenceWindow->Init();
    ptr->m_pPreferenceWindow->ShowModal(ptr->m_gWindow, G_CALLBACK(PreferenceWindowDestroy), ptr);
}


void ShellControllerWindow::PreferenceWindowDestroy(GtkWidget* gtkwidget, gpointer data)
{
    ShellControllerWindow* ptr = (ShellControllerWindow*)data;
    if(NULL != ptr->m_pPreferenceWindow)
    {
        delete ptr->m_pPreferenceWindow;
        ptr->m_pPreferenceWindow = NULL;

    }
    ptr->m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);

    int iAutoDeployData = ptr->m_pSESSystemSettingData->GetAutoDeployEnabled();

    ptr->SetAutoDeployStatusOnBottom(iAutoDeployData);

}


void ShellControllerWindow::SetAutoDeployStatusOnBottom(int status)
{

    if(1 == status)
    {
        string message("Automatically deploy is enabled!");
        gtk_label_set_text(GTK_LABEL(m_gAutoDeployLabel), message.c_str());
    }
    else
    {
        string message("");
        gtk_label_set_text(GTK_LABEL(m_gAutoDeployLabel), message.c_str());
    }
}




int ShellControllerWindow::LoadAndSaveShellSettings(std::string original, std::string destination)
{
    string strXml("");
    int iretTabNavResult = 0;
    int iretScheduleResult = 0;
    int iretSystemResult = 0;
    int iretClassGroupResult = 0;
    bool bImportTabOK = true;
    bool bImportSchOK = true;
    bool bImportSysOK = true;
    bool bImportClassOK = true;
    CTabNavigationData pTabNavData;
    CLockScheduleData pScheduleData;
    CSESSystemSettingData pSystemData;
    CClassGroupData pClassGroupData;
    iretTabNavResult = pTabNavData.LoadFromFile(original + "/" + TAB_NAVIGATION);
    if(0 != iretTabNavResult)
    {
        bImportTabOK = false;
    }
    iretScheduleResult = pScheduleData.LoadFromFile(original + "/" + LOCK_SCHEDULE);
    if(0 != iretScheduleResult)
    {
        bImportSchOK = false;
    }
    iretSystemResult = pSystemData.LoadFromFile(original + "/" + SES_SYSTEM_SETTING);
    if(0 != iretSystemResult)
    {
        bImportSysOK = false;
    }
    iretClassGroupResult = pClassGroupData.LoadFromFile(original + "/" + CLASS_GROUP);
    if(0 != iretClassGroupResult)
    {
        bImportClassOK = false;
    }
    // Phase 2 Import real data.
    if(bImportTabOK && bImportSchOK && bImportSysOK && bImportClassOK)
    {
        //Save file
        iretTabNavResult = pTabNavData.Save2File(destination + "/"+TAB_NAVIGATION);
        if(LIBSESDATA_SUCCESS != iretTabNavResult)
        {
            bImportTabOK = false;
        }
        iretScheduleResult = pScheduleData.Save2File(destination + "/" +LOCK_SCHEDULE);
        if(LIBSESDATA_SUCCESS != iretScheduleResult)
        {
            bImportSchOK = false;
        }
        iretSystemResult = pSystemData.Save2File(destination + "/" +SES_SYSTEM_SETTING);
        if(LIBSESDATA_SUCCESS != iretSystemResult)
        {
            bImportSysOK = false;
        }
        iretClassGroupResult = pClassGroupData.Save2File(destination + "/" +CLASS_GROUP);
        if(LIBSESDATA_SUCCESS != iretClassGroupResult)
        {
            bImportClassOK = false;
        }
    }
    return (bImportTabOK && bImportSchOK && bImportSysOK && bImportClassOK);
}

void ShellControllerWindow::DoImportShellSettingsAction(string folder)
{
    int result = 0;
    string configFilePath("/etc/SES");
    result = LoadAndSaveShellSettings(folder, configFilePath);

    if (result)
    {
       string message(_("You have imported Shell Settings successfully!"));
       CMessageBox::Show(message,m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);

       m_pSESSystemSettingData->LoadFromFile(CONFIG_FILE_DIR + SES_SYSTEM_SETTING);



       m_pClassGroup->LoadFromFile(CONFIG_FILE_DIR + CLASS_GROUP);


       if (OpenForAll == m_eClassSelectStatus)
       {
           EnterOpenForAllStatus();
       }
       else if(SomeClass == m_eClassSelectStatus)
       {
          EnterSomeClassStatus(m_SelectedClassName);
       }
       else if(NoClass == m_eClassSelectStatus)
       {
           EnterNoClassStatus();
       }
    }
    else
    {
       string message(_("Cannot import Shell Settings!"));
       CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
    }
}


void ShellControllerWindow::DoExportShellSettingsAction(std::string folder)
{
    int result = 0;
    string path("/etc/SES");
    result = LoadAndSaveShellSettings(path, folder);
    if(result)
    {
      string message(_("You have exported Shell Settings successfully!"));
      CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
    }
    else
    {
      string message(_("Cannot export Shell Settings!"));
      CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
    }
}


void ShellControllerWindow::SetMainUIButtonStatus(GList* gList)
{
    if(NULL != gList)
    {
        gtk_widget_set_sensitive(m_gDeployBtn, true);
        gtk_widget_set_sensitive(m_gLockBtn, true);
        gtk_widget_set_sensitive(m_gUnlockBtn, true);
        //gtk_widget_set_sensitive(ptr->m_gShellSettingsBtn, true);
    }
    else
    {
        gtk_widget_set_sensitive(m_gDeployBtn, false);
        gtk_widget_set_sensitive(m_gLockBtn, false);
        gtk_widget_set_sensitive(m_gUnlockBtn, false);
        //gtk_widget_set_sensitive(ptr->m_gShellSettingsBtn, false);
    }
}

void ShellControllerWindow::SetMainUIFileStatus(GList* gList)
{
    if(NULL != gList)
    {
       gtk_widget_set_sensitive(m_gDeploySettingsItems, true);
       gtk_widget_set_sensitive(m_gLockItems, true);
       gtk_widget_set_sensitive(m_gUnlockItems, true);
       //gtk_widget_set_sensitive(ptr->m_gShellSettingsBtn, true);
    }
    else
    {
       gtk_widget_set_sensitive(m_gDeploySettingsItems, false);
       gtk_widget_set_sensitive(m_gLockItems, false);
       gtk_widget_set_sensitive(m_gUnlockItems, false);
       //gtk_widget_set_sensitive(ptr->m_gShellSettingsBtn, false);
    }
}

void ShellControllerWindow::ReleasePixbuf()
{
    if(m_connectedAndLockedPixBuf)
    {
        g_object_unref (m_connectedAndLockedPixBuf);
    }
    if(m_connectedAndUnlockedPixBuf)
    {
        g_object_unref (m_connectedAndUnlockedPixBuf);
    }
    if(m_disconnectedPixBuf)
    {
        g_object_unref (m_disconnectedPixBuf);
    }
    if(m_connectedAndLockedExtendPixBuf)
    {
        g_object_unref (m_connectedAndLockedExtendPixBuf);
    }
    if(m_connectedAndUnLockExtendPixBuf)
    {
        g_object_unref (m_connectedAndUnLockExtendPixBuf);
    }
}


bool ShellControllerWindow::IsShellSettingsExisted(std::string folder)
{
    int ret = 0;
    ret = CSESDataTools::FileExist(folder + "/" + TAB_NAVIGATION)||
                        CSESDataTools::FileExist(folder + "/" + LOCK_SCHEDULE)||
                        CSESDataTools::FileExist(folder + "/" +SES_SYSTEM_SETTING)||
                        CSESDataTools::FileExist(folder + "/" +CLASS_GROUP);
    return ret;
}


bool ShellControllerWindow::HandleSessionDie(GnomeClient* masterClient,
											gint                phase,
											GnomeSaveStyle      save_style,
											gboolean            shutdown,
											GnomeInteractStyle  interact_style,
											gboolean            fast,
											gpointer data)
{
    CSESLog::WriteLine("ShellControllerWindow::HandleSessionDie<<Start");
	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
	int errCode = 0;
	int result = 0;
	result = ptr->m_pTeacherAPI->StopController(errCode);
	if(SES_API_FAILURE == result)
	{
		CSESLog::WriteLine("ShellControllerWindow::HandleSessionDie StopController--Failure");
	}
	else if(SES_API_TIME_OUT == result)
	{
		CSESLog::WriteLine("ShellControllerWindow::HandleSessionDie StopController--Time out");
	}

//	string message(_("session exit"));
//
//	CMessageBox::Show(message, NULL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);

	gtk_main_quit();
	CSESLog::WriteLine("ShellControllerWindow::HandleSessionDie>>End");
	return true;
}

//gboolean ShellControllerWindow::client_save_yourself_cb (GnomeClient        *client,
//			 gint                phase,
//			 GnomeSaveStyle      save_style,
//			 gboolean            shutdown,
//			 GnomeInteractStyle  interact_style,
//			 gboolean            fast,
//			 gpointer            data)
//{
//	ShellControllerWindow* ptr = (ShellControllerWindow*)data;
//	string message(_("ShellController will exit!"));
//	CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
//	return TRUE;
//}



}
