#ifndef REQUBASE_H_
#define REQUBASE_H_

#include "IntfData.h"
#include <IPCTeacherDaemonAPI.h>
#define OP_TIME_OUT 180000;

class CStudentMgr;

class RequBase
{

public:
	RequBase();
	virtual ~RequBase();

	virtual bool CheckTimeOut();
	virtual bool RecvResp(IPCAPI::CIntfData& myData);

	virtual bool SendRequ(IPCAPI::CIntfData& myData);

	virtual int GetOperationID();

	virtual bool Disconnect(std::string studentID);

	//virtual void GetSentMessage(IPCAPI::CIntfData& myData);
	virtual bool isSameStudent(std::string studentID);
	virtual bool CancelOperation(int OID){return false;}
	void SetIPCTeacherDaemonAPI(IPCAPI::IPCTeacherDaemonAPI* TeacherDaemonAPI);

	void UpdateTeacherPolicyData(std::string StudentID);

	long int GetTimeOutPoint();

	void setTimeOutPoint(long int TimeOutPoint);
protected:
	long int m_TimeOutPoint;

	bool if_valid;
	CStudentMgr* pStudentMgr;
	int OperationID;
	//std::string MessageName;
	std::list<std::string> m_StudentIDList;
	//IPCAPI::CIntfData* sentMsg;
	IPCAPI::IPCTeacherDaemonAPI* TeacherDaemonAPI;
};



#endif /*REQUBASE_H_*/
