/******************************************************************************************
 * File Name  : NetSSLServerWrapper.h                                                     *
 * Created   : 08/09/16                                                                   *
 * Author   : ChenWei                                                                     *
 * Model   : TSD                                                                          *
 * Description  :                                        								  *
 ******************************************************************************************/

#ifndef _NETSSLSERVERWRAPPER_H_INCLUDED
#define _NETSSLSERVERWRAPPER_H_INCLUDED
#include <string>
//#include "ace/SSL/SSL_SOCK_Acceptor.h"
#include "TSDCommon.h"

#include <ace/SSL/SSL_SOCK_Acceptor.h>
#include <ace/OS.h>
#include <ace/Handle_Set.h>
#include <ace/Reactor.h>
class CNetSSLClientWrapper;
class CNetSSLServerWrapper: public ACE_Event_Handler
{
public:
	//CNetSSLServerWrapper();
	CNetSSLServerWrapper(int acc_port=8888, int out_time = 5);
	virtual ~CNetSSLServerWrapper();

public:
	virtual int handle_input(ACE_HANDLE handle);

	virtual ACE_HANDLE get_handle(void) const;

public:
	bool Open(int acc_port=0, int out_time = 5);
	//bool Open();
	bool Close();
	bool Accept(CNetSSLClientWrapper & client);
	std::string GetErrInfo();
	//ACE_HANDLE GetHandle(void) const;
	//For RegMgr
	int SetOption();
	void SetLlisten_port(int iPort)
	{
		mi_listen_port = iPort;
	}
	bool IsOpen()
	{
		return mb_if_listen;
	}
private:

	int mi_listen_port;
	int mi_out_time;
	bool mb_if_listen;
	std::string ms_err_info;

	ACE_SSL_SOCK_ACCEPTOR mc_acceptor;
};

#endif // _NETSSLSERVERWRAPPER_H_INCLUDED
