#! /usr/bin/perl
#

use Gtk2 -init;
use Locale::gettext;

# single instance lock.

$lock_file = "/tmp/SwitchToSES.lock";

die("locked\n") if (-e $lock_file);
system("touch $lock_file");

# localize strings.

bindtextdomain('SESSwitchApp', '/usr/share/locale/');
bind_textdomain_codeset('SESSwitchApp', "UTF-8");
textdomain('SESSwitchApp');

$title = gettext('Warning');
$text = gettext('All unsaved work will be lost. Are you sure you want to switch to SES now?');

# create message box.

$dialog = Gtk2::MessageDialog->new(undef, 'modal', 'warning', 'yes-no', $text);

$dialog->set_title($title);
$dialog->set_position('center');
$dialog->set_icon_from_file('/etc/SES/image/switchapplet_main.png');
#$dialog->set_skip_taskbar_hint(0);
$dialog->set_flags('GTK_CAN_FOCUS');

# register timeout callback.

sub timeout_cb
{
    if (!$dialog->is_active())
    {
        print("inactive\n");
        #dialog->present(); # Will faile after 'alt-tab'
        $dialog->window()->focus('GDK_CURRENT_TIME');
    }

    return 1;
}

$timeout_id = Glib::Timeout->add(1000, \&timeout_cb);

# show

system('/usr/bin/SES/MsgPoster switchtoses &') if ($dialog->run() eq 'yes');

# release all

Glib::Source->remove($timeout_id);
$dialog->destroy();
unlink($lock_file);

