/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementList;
import org.openrdf.sail.memory.model.MemValue;

public class MemLiteral
extends LiteralImpl
implements MemValue {
    private static final long serialVersionUID = 4288477328829845024L;
    private transient Object creator;
    private transient MemStatementList objectStatements = null;

    public MemLiteral(Object creator, String label) {
        super(label);
        this.creator = creator;
    }

    public MemLiteral(Object creator, String label, String lang) {
        super(label, lang);
        this.creator = creator;
    }

    public MemLiteral(Object creator, String label, URI datatype) {
        super(label, datatype);
        this.creator = creator;
    }

    public Object getCreator() {
        return this.creator;
    }

    public MemStatementList getObjectStatementList() {
        if (this.objectStatements == null) {
            return EMPTY_LIST;
        }
        return this.objectStatements;
    }

    public int getObjectStatementCount() {
        if (this.objectStatements == null) {
            return 0;
        }
        return this.objectStatements.size();
    }

    public void addObjectStatement(MemStatement st) {
        if (this.objectStatements == null) {
            this.objectStatements = new MemStatementList(1);
        }
        this.objectStatements.add(st);
    }

    public void removeObjectStatement(MemStatement st) {
        this.objectStatements.remove(st);
        if (this.objectStatements.isEmpty()) {
            this.objectStatements = null;
        }
    }

    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) {
        if (this.objectStatements != null) {
            this.objectStatements.cleanSnapshots(currentSnapshot);
            if (this.objectStatements.isEmpty()) {
                this.objectStatements = null;
            }
        }
    }
}

