var SpeedDial = {
  prefs: null,
  globalprefs: null,
  bundle: null,
  isFirefox3: false,
  isFennec: false,
  ioService: null,
  // Configuration parameters
  loadInNewWindow: false,
  loadInNewTab: false,
  loadInLastTab: false,
  clearURLBarOnLoad: false,
  showInTabContextMenu: false,
  showInAreaContextMenu: false,
  showInBookmarksMenu: false,
  overrideCtrlNumber: false,
  isSchedulerWindow: false,
  updateSchedules: null,
  prioritySchedules: null,
  scheduleTimer: null,
  processingPrioritySchedules: false,
  currentPrioritySchedule: -1,
  currentPriorityScheduleURL: "",
  defaultRefreshInterval: 0,
  captureDelay: 500,
  captureTimeout: 20000,
  disableBackgroundBrowserJavascript: false,
  defaultDialJavascript: false,
  disableBackgroundBrowserPlugins: true,
  disableBackgroundBrowserAuth: true,
  popupOptionsAccess: true,
  enableCache: true,
  imageFormat: "png",
  urlBarShortcuts: true,
  timeOutId: null,
  openExistingFirst: true,
  openOnBlankTab: true,
  useJava: false,
  preScaling: true,
  enableGroups: false,
  numGroups: 1,
  multikeyForSingleDigit: false,
  thumbnailGenerationListeners: [],
  multikeyOverlayWidthModifier: 60,
  currentMultikeyWindow: null,
  useKeyCapture: true,
  zeroStartsMultiKey: false,
  ignoreZeroKey: true,
  ignoreRedirects: true,
  errorWhenTimeout: true,
  useIframe: true,
  cloakEvents: true,
  buttonOpensInCurrentTab: true,
  focusElement: 0,
  currentLanguage: 'en',
  pendingSaves: new Array(),
  DEBUG: false,
  
  assignPopupShowing: function(event, showUnassigned) {
    var menu = event.target;

    if (menu.hasAttribute("group")) return true;
    
    if (!SpeedDial.enableGroups) {
      SpeedDial.createPopup(menu, 1, showUnassigned);
    } else {
      // Empty current
      while (menu.firstChild)
        menu.removeChild(menu.firstChild);
      
      for (var c=1; c<=SpeedDial.numGroups; c++) {
        var groupMenu =  document.createElement("menu");
        if (SpeedDial.prefs.prefHasUserValue("group-" + c + "-title")) {
          groupMenu.setAttribute("label", SpeedDial.prefs.getComplexValue("group-" + c + "-title", Components.interfaces.nsISupportsString).data);
        } else {
          groupMenu.setAttribute("label",  SpeedDial.bundle.getFormattedString("untitledGroup.label", [c]));
        }
        groupMenu.setAttribute("class", "menu-iconic bookmark-item");
        groupMenu.setAttribute("container", "true");
        var groupPopup = document.createElement("menupopup");
        groupPopup.setAttribute("onpopupshowing", "SpeedDial.assignGroupPopupShowing(event, " + showUnassigned + ");");
        groupPopup.setAttribute("group", c);
        groupMenu.appendChild(groupPopup);
        menu.appendChild(groupMenu);
      }
      if (SpeedDial.popupOptionsAccess) {
        var menuSeparator = document.createElement("menuseparator");
        menu.appendChild(menuSeparator);
        var optionsMenuItem = document.createElement("menuitem");
        optionsMenuItem.setAttribute("label", SpeedDial.bundle.getString("options.label"));
        menu.appendChild(optionsMenuItem);
      }
    }
    return true;
  },
  
  assignGroupPopupShowing: function(event, showUnassigned) {
    var menu = event.target;

    if (!menu.hasAttribute("group")) return true;

    var targetGroup = parseInt(menu.getAttribute("group"));
    SpeedDial.createPopup(menu, targetGroup, showUnassigned);
    return true;
  },
  
  createPopup: function(menu, targetGroup, showUnassigned) {
    var screenRows;
    var screenColumns;
    
    if (SpeedDial.prefs.prefHasUserValue("group-" + targetGroup + "-rows")) {
      screenRows = SpeedDial.prefs.getIntPref("group-" + targetGroup + "-rows");
    } else {
      screenRows = SpeedDial.prefs.getIntPref("rows");
    }
    if (SpeedDial.prefs.prefHasUserValue("group-" + targetGroup + "-columns")) {
      screenColumns = SpeedDial.prefs.getIntPref("group-" + targetGroup + "-columns");
    } else {
      screenColumns = SpeedDial.prefs.getIntPref("columns");
    }
    
    // Empty current
    while (menu.firstChild)
      menu.removeChild(menu.firstChild);

    var initialDial = SpeedDialUtils.getGroupFirstDialNumber(targetGroup);
    var populatedMenu = false;
    // Create new
    for (var c=0; c<(screenRows*screenColumns); c++) {
      var targetDial = initialDial + c;
      if (showUnassigned || SpeedDial.prefs.prefHasUserValue("thumbnail-" + targetDial + "-url")) {
        var menuitem = document.createElement("menuitem");
        populatedMenu = true;
        if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + targetDial + "-url")) {
          var thumbnailTitle = SpeedDial.prefs.getComplexValue("thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString).data;
          var thumbnailURL =  SpeedDial.prefs.getCharPref("thumbnail-" + targetDial + "-url");
          var thumbnailIcon = "";
          
          if (SpeedDial.isFirefox3) {
            thumbnailIcon =  SpeedDialUtils.getDialIcon(targetDial);
          } else {
            if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + targetDial + "-icon")) {
              thumbnailIcon =  SpeedDial.prefs.getCharPref("thumbnail-" + targetDial + "-icon");
              if (thumbnailIcon == "data:") {
                thumbnailIcon = "";
              }
            }
          }
          if (thumbnailTitle == "") {
            menuitem.setAttribute("label", "" + targetDial + " - " + SpeedDial.bundle.getString("untitled.label"));
          } else {
            menuitem.setAttribute("label", "" + targetDial + " - " + thumbnailTitle);
          }
          menuitem.setAttribute("tooltiptext", thumbnailURL);
          menuitem.setAttribute("image", thumbnailIcon);
        } else {
          menuitem.setAttribute("label", "" + targetDial + " - " + SpeedDial.bundle.getString("unassigned.label"));
        }
        if (targetDial < 10) {
          menuitem.setAttribute("accesskey", targetDial);
        } else if (targetDial == 10) {
          menuitem.setAttribute("accesskey", 0);
        }
        menuitem.setAttribute("speeddial", targetDial);
        menuitem.setAttribute("class", "menuitem-iconic bookmark-item");
        menu.appendChild(menuitem);
      }
    }
    
    if (!populatedMenu) {
      var menuitem = document.createElement("menuitem");
      menuitem.setAttribute("label", SpeedDial.bundle.getString("empty.label"));
      menuitem.setAttribute("disabled", "true");
      menu.appendChild(menuitem);
    }
    
    if (SpeedDial.popupOptionsAccess && !SpeedDial.enableGroups) {
      var menuSeparator = document.createElement("menuseparator");
      menu.appendChild(menuSeparator);
      var optionsMenuItem = document.createElement("menuitem");
      optionsMenuItem.setAttribute("label", SpeedDial.bundle.getString("options.label"));
      menu.appendChild(optionsMenuItem);
    }
  },

  setAsSpeedDial: function(event, targetTab) {
    var speedDial = event.target.getAttribute("speeddial");
    if (!speedDial) {
      if (SpeedDial.popupOptionsAccess) {
        // Must be options
        SpeedDialUtils.showOptions();
      }
      return false;
    }
    
    var browser;

    if (targetTab) {
      browser = targetTab.linkedBrowser;
    } else {
      browser = getBrowser().mCurrentBrowser;
    }

    if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + speedDial + "-url")) {
      if (!confirm(SpeedDial.bundle.getString("overwrite.warning"))) {
        return false;
      }
    }

    if (!SpeedDial.isFirefox3) {
      SpeedDial.prefs.setCharPref("thumbnail-" + speedDial + "-icon", "");
      if (browser.mIconURL) {
        SpeedDial.loadIcon(browser.mIconURL, speedDial);
      }
    }
    
    SpeedDial.prefs.setCharPref("thumbnail-" + speedDial + "-url", browser.contentDocument.location);

    var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
    str.data = browser.contentDocument.title;
    SpeedDial.prefs.setComplexValue("thumbnail-" + speedDial + "-label", Components.interfaces.nsISupportsString, str);

    SpeedDial.prefs.setBoolPref("thumbnail-" + speedDial + "-dynamictitle", false);
    
    if (SpeedDial.defaultRefreshInterval > 0) {
      SpeedDial.prefs.setIntPref("thumbnail-" + speedDial + "-refreshinterval", SpeedDial.defaultRefreshInterval);
    }
    
    SpeedDial.prefs.setBoolPref("thumbnail-" + speedDial + "-js", SpeedDial.defaultDialJavascript);
    
    // Take screenshot
    SpeedDial.saveSnapshot(browser, speedDial);
    
    // Make automatic backup
    SpeedDialUtils.automaticBackup();

    return true;
  },

  showWelcomeScreenIfNeeded: function() {
    var currentVersion = SpeedDial.prefs.getCharPref("currentVersion");

    if (currentVersion == "none") {
      // Detect screen resolution
      if (screen.width > 1600) {
        SpeedDial.prefs.setIntPref("thumbnailImageWidth", 800);
        SpeedDial.prefs.setIntPref("thumbnailImageHeight", 800);
        SpeedDial.prefs.setIntPref("maximumWidth", 2400);
      } else if (screen.width > 1280) {
        SpeedDial.prefs.setIntPref("thumbnailImageWidth", 600);
        SpeedDial.prefs.setIntPref("thumbnailImageHeight", 600);
        SpeedDial.prefs.setIntPref("maximumWidth", 1800);
      } else {
        SpeedDial.prefs.setIntPref("thumbnailImageWidth", 400);
        SpeedDial.prefs.setIntPref("thumbnailImageHeight", 400);
        SpeedDial.prefs.setIntPref("maximumWidth", 1200);
      }
      if (((screen.width / screen.height) > 1.4) && !SpeedDialUtils.isFennec()) {
        SpeedDial.prefs.setIntPref("widthModifier", 80);
      }
      
      if (SpeedDialUtils.isFennec()) {
        SpeedDial.prefs.setBoolPref("mouseOverThumbnailButtons", false);
        SpeedDial.prefs.setBoolPref("mouseOverThumbnailButtonsHighlight", false);
        SpeedDial.prefs.setBoolPref("hideThumbnailNumbers", true);
        SpeedDial.prefs.setIntPref("defaultRefreshInterval", 0);
        SpeedDial.prefs.setBoolPref("loadInNewTab", true);
      }
    }
    
    if (currentVersion != "0.9.5") {
      SpeedDial.prefs.setCharPref("currentVersion", "0.9.5");
      
      // Ensure groups have rows and columns
      var defaultRows = SpeedDial.prefs.getIntPref("rows");
      var defaultCols = SpeedDial.prefs.getIntPref("columns");
      
      for (var c=1; c<=SpeedDial.numGroups; c++) {
        if (!SpeedDial.prefs.prefHasUserValue("group-" + c + "-rows")) {
          SpeedDial.prefs.setIntPref("group-" + c + "-rows", defaultRows);
        }
        if (!SpeedDial.prefs.prefHasUserValue("group-" + c + "-columns")) {
          SpeedDial.prefs.setIntPref("group-" + c + "-columns", defaultCols);
        }
      }
      

      // Show first time configuration dialog
      if (currentVersion == "none") {
        if (SpeedDialUtils.isFennec()) {
          // Setup weather dial
          SpeedDialUtils.setupWeatherDial();
        } else {
          openDialog("chrome://speeddial/content/firstTimeConfig.xul", "",
                     "centerscreen,chrome,dialog,resizable,modal");
        }
      }

      if (!SpeedDialUtils.isFennec() && SpeedDial.prefs.getBoolPref("firstRunRedirection")) {
        var targetURL;
        if (currentVersion == "none") {
          targetURL = "http://speeddial.uworks.net/welcome.html";
        } else {
          targetURL = "http://speeddial.uworks.net/updated.html";
        }
        var newTab = getBrowser().addTab(targetURL);
        getBrowser().selectedTab = newTab;
      }
    }
  },
  
  addToolbarIcon: function() {
    SpeedDial.appendButtonInToolbar("btn_speeddial", "nav-bar");
    /*
    var toolbarId = "nav-bar";
    var buttonId = "btn_speeddial";
    
    var toolbar = document.getElementById(toolbarId);
    var toolbarButton = document.getElementById(buttonId);
    if (toolbar && !toolbarButton)
    {
      if ("insertItem" in toolbar) {
        toolbar.insertItem(buttonId, null, null, false);
      }
      var newSet = toolbar.getAttribute("currentset") + "," + buttonId;
      toolbar.setAttribute("currentset", newSet);
      toolbar.currentSet = newSet;
      document.persist(toolbarId, "currentset");
  
      try {
        BrowserToolboxCustomizeDone(true);
      } catch (e) {}
    }
    */
  },
  
  appendButtonInToolbar:function(buttonId, toolbarId) {
      var toolbar = document.getElementById(toolbarId);
      var button = document.getElementById(buttonId);
      if(button) {
          var parentBar = button.parentNode;              
          if(parentBar && parentBar != toolbar) {
              var newset = SpeedDial.removeButtonFromToolbarCurrentSet(parentBar,buttonId);              
          }
          toolbar.appendChild(button);
      }else{          
        if ("insertItem" in toolbar) {
          toolbar.insertItem(buttonId);
        }
      }
  
      SpeedDial.appendButtonInToolbarCurrentSet(toolbar,buttonId);
      try {
        BrowserToolboxCustomizeDone(true);
      } catch (e) {}
  },
  
  appendButtonInToolbarCurrentSet:function(toolbar, buttonId) {
      var oldset = toolbar.getAttribute("currentset");
      var newset = "";
      if(oldset && oldset!="") {
          newset = oldset + ",";
      }        
      newset += buttonId;        
      toolbar.setAttribute("currentset", newset);
      document.persist(toolbar.id,"currentset");
      return newset;
  },
  
  
  removeButtonFromToolbarCurrentSet:function(toolbar, buttonId) {
      var oldset = toolbar.getAttribute("currentset");
      if(!oldset || oldset=="" || oldset.indexOf(buttonId) == -1) return oldset;
      var reg = new RegExp(buttonId+",?", "gi");        
      var newset = oldset.replace(reg,"");
      if (newset.charAt(newset.length-1) == ",") {
         newset = newset.substring(0, newset.length - 1);
      }
  
      toolbar.setAttribute("currentset", newset);
      document.persist(toolbar.id,"currentset");
      return newset;
  },

  loadIcon: function(url, entry) {
    if (url.indexOf("data:") == 0) {
      SpeedDial.setSpeedDialIcon(url, entry);
      return;
    }
    var IOSVC = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
    var chan = IOSVC.newChannel(url, null, null);
    var listener = new SpeedDial.SpeedDialIconLoadListener(chan, entry);
    chan.notificationCallbacks = listener;
    chan.asyncOpen(listener, null);
  },

  openDialCheckMiddleClick: function(node, event) {
    if (event.button == 1) {
      var func = new Function("event",node.getAttribute("oncommand"));
      func.call(node,event);
      if ("tagName" in node) {
        if (node.namespaceURI == "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul" && (node.tagName == "menupopup" || node.tagName == "popup"))
          node.hidePopup();
      }
    }
  },

  openDial: function(event) {
    var where = whereToOpenLink(event);
    var targetSpeedDial = event.target.getAttribute("speeddial");
    SpeedDial.openDialImpl(targetSpeedDial, where);
  },
  
  openDialImpl: function(targetSpeedDial, where) {
    if (!targetSpeedDial) {
      if (SpeedDial.popupOptionsAccess) {
        // Must be options
        SpeedDialUtils.showOptions();
      }
      return false;
    }

    if (!SpeedDial.prefs.prefHasUserValue("thumbnail-" + targetSpeedDial + "-url"))
      return false;

    var targetUrl =  SpeedDial.prefs.getCharPref("thumbnail-" + targetSpeedDial + "-url");
    
    if (SpeedDialUtils.stringStartsWith(targetUrl, "weather:")) {
      var weatherLocation = '';
      if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + targetSpeedDial + "-extra")) {
        var thumbnailExtras =  SpeedDial.prefs.getCharPref("thumbnail-" + targetSpeedDial + "-extra").split('#');
        if ((thumbnailExtras[0]) && (thumbnailExtras[0] != '')) {
          weatherLocation = decodeURI(thumbnailExtras[0]);
        }
      }
      if (weatherLocation == '') {
        weatherLocation = targetUrl.substr("weather:".length);
        if (weatherLocation.indexOf('#') > -1) {
          weatherLocation = weatherLocation.substring(0, weatherLocation.indexOf('#'));
        }
      }
      if (weatherLocation != '') {
        targetUrl = 'http://www.actuweather.com/report/?poi=' + encodeURI(weatherLocation);
      } else {
        targetUrl = 'http://www.actuweather.com/';
      }
    } else if (SpeedDialUtils.stringStartsWith(targetUrl, "javascript:")) {
      SpeedDial.evaluateString(targetUrl.substr("javascript:".length));
      return true;
    } else if (SpeedDialUtils.stringStartsWith(targetUrl, "launch:")) {
      SpeedDialUtils.launch(targetUrl.substr("launch:".length));
      return true;
    } else if (SpeedDialUtils.stringStartsWith(targetUrl, "plugin:")) {
      targetUrl = targetUrl.substr("plugin:".length);
    } else if (SpeedDialUtils.stringStartsWith(targetUrl, "nothing:")) {
      return true;
    }
    
    var urls;
  
    // openUILinkIn doesn't handle loading multiple pages
    switch (where) {
      case "save":
        urls = SpeedDialUtils.getDistinctUrls(targetUrl);
        saveURL(urls[0], null, null, true);  // only save the first page
        break;
      case "current":
        SpeedDial.loadOneOrMoreURIs(targetUrl);
        break;
      case "tabshifted":
      case "tab":
        urls = SpeedDialUtils.getDistinctUrls(targetUrl);
        var loadInBackground = SpeedDial.globalprefs.getBoolPref("browser.tabs.loadBookmarksInBackground", false);
        getBrowser().loadTabs(urls, loadInBackground);
        break;
      case "window":
        var newWindow = OpenBrowserWindow();
        newWindow.addEventListener("DOMContentLoaded", function() { newWindow.arguments[0] = targetUrl; }, false);
        break;
    }
    
    return true;
  },
  
  loadOneOrMoreURIs: function(aURIString) {
    try {
      urls = SpeedDialUtils.getDistinctUrls(aURIString);
      if (SpeedDialUtils.isFennec()) {
        for (var c=0;c<urls.length; c++) {
          if (c == 0) {
            getBrowser().loadURI(urls[0], null, null, false);
          } else {
            Browser.addTab(urls[c], false);
          }
        }
      } else {
        getBrowser().loadTabs(urls, false, true);
      }
    } catch (e) {
      alert(e);
    }
  },

  setSpeedDialIcon: function(data, speedDial) {
    if (!SpeedDial.isFirefox3) {
      SpeedDial.prefs.setCharPref("thumbnail-" + speedDial + "-icon", data);
    }
  },

  saveSnapshot: function(browser, speedDial) {
    var isImage = false;
    var croppingValues = null;
    var imageDecoder;
    
    // Verify folder
    SpeedDial.verifySpeedDialThumbFolder();
    
    // Detect special types
    if (browser.contentDocument instanceof ImageDocument) {
      // Capture image
      isImage = true;
      imageDecoder = browser.contentDocument.imageRequest.decoderObserver;
    }
    
    if ((speedDial > 0) && SpeedDial.prefs.prefHasUserValue("thumbnail-" + speedDial + "-cropping")) {
      croppingValues = SpeedDial.prefs.getCharPref("thumbnail-" + speedDial + "-cropping").split(",");
    }

    var thumbnailWidth, thumbnailHeight;

    if (croppingValues != null) {
      thumbnailWidth = croppingValues[2];
      thumbnailHeight = croppingValues[3];
    } else if (isImage) {
      if (imageDecoder.naturalWidth) {
        thumbnailWidth = imageDecoder.naturalWidth;
      } else {
        thumbnailWidth = imageDecoder.width;
      }
      if (imageDecoder.naturalHeight) {
        thumbnailHeight = imageDecoder.naturalHeight;
      } else {
        thumbnailHeight = imageDecoder.height;
      }
    } else if (speedDial == 0) {
      thumbnailWidth = browser.contentWindow.innerWidth;
      thumbnailHeight = browser.contentWindow.innerHeight;
    } else {
      thumbnailWidth= SpeedDial.prefs.getIntPref("thumbnailImageWidth");
      thumbnailHeight = SpeedDial.prefs.getIntPref("thumbnailImageHeight");
    }
    
    if (thumbnailWidth < 1) thumbnailWidth = 1;
    if (thumbnailHeight < 1) thumbnailHeight = 1;
    
    var currentCanvas;
    
    if (speedDial > 0) {
      currentCanvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
    } else {
      currentCanvas = SpeedDial.thumbnailGenerationListeners[0].getTargetCanvas();
    }

    var ctx = currentCanvas.getContext("2d");
  
    if (isImage) {
      currentCanvas.width = thumbnailWidth;
      currentCanvas.height = thumbnailHeight;

      if (croppingValues != null) {
        var targetX = parseInt(croppingValues[0]);
        var targetY = parseInt(croppingValues[1]);
        var targetWidth = parseInt(croppingValues[2]);
        var targetHeight = parseInt(croppingValues[3]);
        var targetScaling = 100;
        if (croppingValues[4]) {
          targetScaling = parseInt(croppingValues[4]);
        }
        
        if (targetScaling != 100) {
          var factor = 100/targetScaling;
          targetX = Math.round(targetX * factor);
          targetY = Math.round(targetY * factor);
          targetWidth = Math.round(targetWidth * factor);
          targetHeight = Math.round(targetHeight * factor);
        }
        
        var targetImageWidth;
        var targetImageHeight;
        if (imageDecoder.naturalWidth) {
          targetImageWidth = imageDecoder.naturalWidth;
        } else {
          targetImageWidth = imageDecoder.width;
        }
        if (imageDecoder.naturalHeight) {
          targetImageHeight = imageDecoder.naturalHeight;
        } else {
          targetImageHeight = imageDecoder.height;
        }
        
        if (targetX < 0) targetX = 0;
        if (targetY < 0) targetY = 0;
        if (targetX > targetImageWidth) targetX = targetImageWidth - 1;
        if (targetY > targetImageHeight) targetY = targetImageHeight - 1;
        if ((targetX + targetWidth) > targetImageWidth) targetWidth = targetImageWidth - targetX;
        if ((targetY + targetHeight) > targetImageHeight) targetHeight = targetImageHeight - targetY;
        
        ctx.drawImage(imageDecoder, 
          targetX, targetY, targetWidth, targetHeight, 
          0, 0, thumbnailWidth, thumbnailHeight);
      } else {
        ctx.drawImage(imageDecoder, 0, 0, thumbnailWidth, thumbnailHeight);
      }
    } else {
      if (croppingValues != null) {
          currentCanvas.width = thumbnailWidth;
          currentCanvas.height = thumbnailHeight;
          
          if ((croppingValues[4]) && (croppingValues[4] != 100)) {
            ctx.save();
            var factor = croppingValues[4] / 100;
            ctx.scale(factor, factor);
            ctx.drawWindow(browser.contentWindow, 
                Math.round(croppingValues[0] / factor), 
                Math.round(croppingValues[1] / factor), 
                Math.round(croppingValues[2] / factor), 
                Math.round(croppingValues[3] / factor), 
                "rgb(255,255,255)");
            ctx.restore();
          } else {
            ctx.drawWindow(browser.contentWindow, 
                croppingValues[0], 
                croppingValues[1], 
                croppingValues[2], 
                croppingValues[3], 
                "rgb(255,255,255)");
          }
      } else {
        var scaleThumbnail = ((SpeedDial.isFirefox3 && !SpeedDial.preScaling) || (!SpeedDial.isFirefox3 && (!SpeedDial.useJava || !window.navigator.javaEnabled())));
    
        if (!scaleThumbnail && (speedDial > 0)) {
          currentCanvas.width = browser.contentWindow.innerWidth;
          currentCanvas.height = Math.floor((browser.contentWindow.innerWidth / SpeedDial.prefs.getIntPref("thumbnailImageWidth")) * SpeedDial.prefs.getIntPref("thumbnailImageHeight"));
        } else {
          currentCanvas.width = thumbnailWidth;
          currentCanvas.height = thumbnailHeight;
        }
          
        if (scaleThumbnail && (speedDial > 0)) {
          ctx.save();
          ctx.scale(currentCanvas.width/browser.contentWindow.innerWidth, currentCanvas.width/browser.contentWindow.innerWidth);
        }
        
        // bug 313178: when painting thumbnails without scroll, there's an important bug
        if (browser.contentWindow.scrollY != 0) {
          try {
            ctx.drawWindow(browser.contentWindow, 
                0, 
                0, 
                browser.contentWindow.innerWidth, 
                browser.contentWindow.innerHeight + browser.contentWindow.scrollMaxY, 
                "rgb(255,255,255)");
          } catch (e) {
            // Something failed. Try alternate method
            ctx.drawWindow(browser.contentWindow, 
                0, 
                0, 
                browser.contentWindow.innerWidth, 
                currentCanvas.height * browser.contentWindow.innerWidth / currentCanvas.width, 
                "rgb(255,255,255)");
          }
        } else {
          ctx.drawWindow(browser.contentWindow, 
              0, 
              0, 
              browser.contentWindow.innerWidth, 
              currentCanvas.height * browser.contentWindow.innerWidth / currentCanvas.width, 
              "rgb(255,255,255)");
        }
      
        if (speedDial > 0) {
          if (scaleThumbnail) {
            ctx.restore();
          } else if (SpeedDial.isFirefox3 && SpeedDial.preScaling && (croppingValues == null) && !isImage) {
            var finalCanvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
            finalCanvas.width = thumbnailWidth;
            finalCanvas.height = thumbnailHeight;
            
            ctx = finalCanvas.getContext("2d");
            ctx.drawImage(currentCanvas, 0, 0, currentCanvas.width, currentCanvas.height, 0, 0, finalCanvas.width, finalCanvas.height);
            currentCanvas = finalCanvas;
          }
        }
      }
    }

    if (speedDial > 0) {
      var saveTime = (new Date()).getTime();
  
      var file = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
      file.append(SpeedDialUtils.thumbFolder);
  
      // If there's a previous one, delete it
      SpeedDialUtils.removeThumbnailImage(speedDial);
  
      file.append("thumbnail-" + speedDial + "-" + saveTime + "." + SpeedDial.imageFormat);

      SpeedDial.saveCanvas(currentCanvas, file, speedDial, thumbnailWidth, thumbnailHeight, saveTime);
    } else {
      // Set style sizes
      currentCanvas.style.width = currentCanvas.width + "px";
      currentCanvas.style.height = currentCanvas.height + "px";
      currentCanvas.style.minWidth = currentCanvas.width + "px";
      currentCanvas.style.minHeight = currentCanvas.height + "px";
      currentCanvas.style.maxWidth = currentCanvas.width + "px";
      currentCanvas.style.maxHeight = currentCanvas.height + "px";
    }
    /*
    // Update preferences file
    try {
      var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                     .getService(Components.interfaces.nsIPrefService);
      prefService.savePrefFile(null);
    } catch (ex) {
    }
    */
  },
  
  addSpeedDialTabContextMenu: function() {
    // get strings 
    var menuLabel = SpeedDial.bundle.getString("speeddialCmd.label");
    var menuAccessKey = SpeedDial.bundle.getString("speeddialCmd.accesskey");

    // create new menu item
    var speedDialTabItem = document.createElement("menu");
    speedDialTabItem.setAttribute("id", "tabContextSpeedDial");
    speedDialTabItem.setAttribute("label", menuLabel);
    speedDialTabItem.setAttribute("accesskey", menuAccessKey);
    var speedDialTabMenu = document.createElement("menupopup");
    speedDialTabMenu.setAttribute("onpopupshowing", "return SpeedDial.assignPopupShowing(event, true);");
    speedDialTabMenu.setAttribute("oncommand", "SpeedDial.setAsSpeedDial(event,document.popupNode);");
    speedDialTabItem.appendChild(speedDialTabMenu);

    // add to tab context menu
    var tabbrowser = getBrowser();
    var tabMenu = document.getAnonymousElementByAttribute(tabbrowser,"anonid","tabContextMenu");

    var insertPos = document.getElementById("tabContextUndoCloseTab");

    if (!insertPos) {
      insertPos = tabMenu.lastChild.previousSibling;
    }
    tabMenu.insertBefore(speedDialTabItem, insertPos);

    speedDialTabItem.hidden = !SpeedDial.showInTabContextMenu;
  },

  verifySpeedDialThumbFolder: function() {
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties)
                     .get("ProfD", Components.interfaces.nsIFile);
    file.append(SpeedDialUtils.thumbFolder);
    if( !file.exists() || !file.isDirectory() ) {   // if it doesn't exist, create
      file.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0755);
    }
  },

  saveCanvas: function(canvas, destFile, targetDial, targetWidth, targetHeight, saveTime) {
    var useJava = !SpeedDial.isFirefox3 && SpeedDial.useJava && window.navigator.javaEnabled();
    if (useJava) {
      var imageData = canvas.toDataURL("image/png").substring("data:image/png;base64,".length);
      var imageBytes = new sun.misc.BASE64Decoder().decodeBuffer(imageData);
      var bais = new java.io.ByteArrayInputStream(imageBytes);
      var javaImage = Packages.javax.imageio.ImageIO.read(bais);

      var finalImage;
      var w = canvas.width;
      var h = canvas.height;
      do {
        if (w > targetWidth) {
          w /= 2;
          if (w < targetWidth) {
            w = targetWidth;
          }
        }

        if (h > targetHeight) {
          h /= 2;
          if (h < targetHeight) {
            h = targetHeight;
          }
        }
        finalImage = new java.awt.image.BufferedImage(w, h, java.awt.image.BufferedImage.TYPE_INT_RGB);
        var g2 = finalImage.createGraphics();
        g2.setRenderingHint(java.awt.RenderingHints.KEY_INTERPOLATION, java.awt.RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawImage(javaImage, 0, 0, w, h, null);
        g2.dispose();
        javaImage = finalImage;
      } while (w != targetWidth || h != targetHeight);
      
      Packages.javax.imageio.ImageIO.write(finalImage, SpeedDial.imageFormat, new java.io.File(destFile.path));

      // Store URL in cache...
      var URLSpec = Components.classes['@mozilla.org/network/protocol;1?name=file'] .createInstance(Components.interfaces.nsIFileProtocolHandler).getURLSpecFromFile(destFile);
  
      if (SpeedDial.enableCache) {
        SpeedDialUtils.updateCacheEntry(targetDial, URLSpec);
      }
      // Save preference, we've updated the thumbnail
      SpeedDial.prefs.setCharPref("thumbnail-" + targetDial + "-format", SpeedDial.imageFormat);
      SpeedDial.prefs.setCharPref("thumbnail-" + targetDial + "-lastsaved", saveTime);
    } else {
      // create a data url from the canvas and then create URIs of the source and targets  
      var io = Components.classes["@mozilla.org/network/io-service;1"]
                       .getService(Components.interfaces.nsIIOService);
      var mimeType;
      if (SpeedDial.imageFormat == "jpg") {
        mimeType = "image/jpeg";
      } else {
        mimeType = "image/png";
      }
      var dataURL = canvas.toDataURL(mimeType, "");

      var source = io.newURI(dataURL, "UTF8", null);
      var target = io.newFileURI(destFile)
  
      // prepare to save the canvas data
      var persist = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
                          .createInstance(Components.interfaces.nsIWebBrowserPersist);
  
      persist.persistFlags = Components.interfaces.nsIWebBrowserPersist.PERSIST_FLAGS_REPLACE_EXISTING_FILES;
      persist.persistFlags |= Components.interfaces.nsIWebBrowserPersist.PERSIST_FLAGS_AUTODETECT_APPLY_CONVERSION;
  
      // displays a download dialog (remove these 3 lines for silent download)
/*
      var xfer = Components.classes["@mozilla.org/transfer;1"]
                       .createInstance(Components.interfaces.nsITransfer);
      xfer.init(source, target, "", null, null, null, persist);
      persist.progressListener = xfer;
*/
      persist.progressListener = {
        onProgressChange: function(aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress) {
        },
        onStateChange: function(aWebProgress, aRequest, aFlag, aStatus) {
          // do something
          if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_STOP) {
            // Store URL in cache...
            var URLSpec = Components.classes['@mozilla.org/network/protocol;1?name=file'] .createInstance(Components.interfaces.nsIFileProtocolHandler).getURLSpecFromFile(destFile);
        
            if (SpeedDial.enableCache) {
      //        window.setTimeout(SpeedDialUtils.updateCacheEntry, 0, speedDial, URLSpec);
              SpeedDialUtils.updateCacheEntry(targetDial, URLSpec);
            }
            // Save preference, we've updated the thumbnail
            SpeedDial.prefs.setCharPref("thumbnail-" + targetDial + "-format", SpeedDial.imageFormat);
            SpeedDial.prefs.setCharPref("thumbnail-" + targetDial + "-lastsaved", saveTime);
            SpeedDial.pendingSaves[targetDial] = false;
          }
        }
      };
      
      SpeedDial.pendingSaves[targetDial] = true;
      
      // save the canvas data to the file
      persist.saveURI(source, null, null, null, null, destFile);
    }
  },

  contentAreaAttrListener: function(event) {
    var speedDialContext = document.getElementById("speeddialContext");
    
    if (!speedDialContext) return;
    
    if (!SpeedDial.showInAreaContextMenu) {
      speedDialContext.hidden = true;
      return;
    }

    if (event.attrName == "hidden") {
      if (event.attrChange != event.REMOVAL) {
        speedDialContext.hidden = event.newValue;
      } else {
        speedDialContext.hidden = false;
      }
    }
  },

  checkNewBrowser: function(attempts) {
    var domWindow = getBrowser().mCurrentBrowser.docShell
                            .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
                            .getInterface(Components.interfaces.nsIDOMWindow);
    var webNav = domWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
                            .getInterface(Components.interfaces.nsIWebNavigation);

    if (!webNav.currentURI && attempts) {
      window.setTimeout(SpeedDial.checkNewBrowser, 100, --attempts);
      return;
    }

    var uriToLoad = null;

    if ("arguments" in window && window.arguments[0])
       uriToLoad = window.arguments[0];
    
    var isLoadingBlank = (uriToLoad == "about:blank") || gIsLoadingBlank;
    
    if (isLoadingBlank && (getBrowser().mTabs.length < 2) && (webNav.currentURI.spec == "about:blank") && !webNav.canGoBack && !webNav.canGoForward && !getBrowser().mCurrentTab.hasAttribute("busy")) {
      webNav.loadURI("chrome://speeddial/content/speeddial.xul", null, null, null, null);
      getBrowser().mCurrentBrowser.userTypedValue = undefined;
      
      SpeedDial.doFocus();
    }
  },

  ctrlNumberSpeedDial: function (event) {
    if (event.altKey && event.keyCode == KeyEvent.DOM_VK_RETURN) {
      // XXXblake Proper fix is to just check whether focus is in the urlbar. However, focus with the autocomplete widget is all
      // hacky and broken and there's no way to do that right now. So this just patches it to ensure that alt+enter works when focus
      // is on a link.
      if (!(document.commandDispatcher.focusedElement instanceof HTMLAnchorElement)) {
        // Don't let winxp beep on ALT+ENTER, since the URL bar uses it.
        event.preventDefault();
        return;
      }
    }
/*
    if (!event.ctrlKey)
      return;

    var index = event.charCode - 48;

    if (index < 1 || index > 9)
    return;

    if (!SpeedDial.prefs.prefHasUserValue("thumbnail-" + index + "-url"))
      return;

    var thumbnailURL =  SpeedDial.prefs.getCharPref("thumbnail-" + index + "-url");
    if (thumbnailURL) {
      if (event.shiftKey) {
        openUILinkIn(thumbnailURL, "tab");
      } else {
        openUILinkIn(thumbnailURL, "current");
      }
    } else {
      return;
    }

    event.preventDefault();
    event.preventBubble();
    event.preventCapture();
    event.stopPropagation();
    */
  },
  
  BrowserLoadURL: function(aTriggeringEvent, aPostDataRef) {
    if (!gURLBar) return;
    
    var url;
    
    if (window.gIeTab) {
      url = gIeTab.getHandledURL(gURLBar.value, gURLBar.isModeIE);
    } else {
      url = gURLBar.value
    }

    if (url == ("" + parseInt(url))) {
      // Single number, check if it's a dial!
      if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + url + "-url")) {
        //gURLBar.value = SpeedDial.prefs.getCharPref("thumbnail-" + url + "-url");
        SpeedDial.openDialImpl(url, "current");
        return;
      }
    }
    
    window.originalBrowserLoadURL(aTriggeringEvent, aPostDataRef);
  },
  
  loadURI: function(uri, referrer, postData, allowThirdPartyFixup) {
    if (uri == ("" + parseInt(uri))) {
      // Single number, check if it's a dial!
      if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + uri + "-url")) {
        //gURLBar.value = SpeedDial.prefs.getCharPref("thumbnail-" + url + "-url");
        SpeedDial.openDialImpl(uri, "current");
        return;
      }
    }
    
    window.originalLoadURI(uri, referrer, postData, allowThirdPartyFixup);
  },
  
  multikeyDialSelected: function(number, targetAction) {
    if ((number < 1) || (number > SpeedDialUtils.getTotalDials())) {
      var statusTextFld = document.getElementById("statusbar-display");
      statusTextFld.label = SpeedDial.bundle.getString("outofrange.warning");
    } else if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + number + "-url")) {
      SpeedDial.performAction(number, targetAction, true)
    } else {
      var statusTextFld = document.getElementById("statusbar-display");
      statusTextFld.label = SpeedDial.bundle.getString("unassigned.warning");
    }
  },
  
  processKey: function(event, number) {
    if (MultiKey.showingMultiKey) {
      event.preventDefault();
      event.preventBubble();
      event.preventCapture();
      event.stopPropagation();
      return;
    }
    var targetAction = 0;
    var doMultiKey = false;

    if (event.ctrlKey) {
      if (event.shiftKey) {
        if ((event.altKey) || (event.metaKey)) {
          targetAction = SpeedDial.prefs.getIntPref("ctrlAltShiftShortcutAction");
          doMultiKey = SpeedDial.prefs.getBoolPref("ctrlAltShiftShortcutMultikey");
        } else {
          targetAction = SpeedDial.prefs.getIntPref("ctrlShiftShortcutAction");
          doMultiKey = SpeedDial.prefs.getBoolPref("ctrlShiftShortcutMultikey");
        }
      } else if (!event.altKey) {
        targetAction = SpeedDial.prefs.getIntPref("ctrlShortcutAction");
        doMultiKey = SpeedDial.prefs.getBoolPref("ctrlShortcutMultikey");
      }
    } else if ((event.altKey) || (event.metaKey)) {
      if (event.shiftKey) {
        targetAction = SpeedDial.prefs.getIntPref("altShiftShortcutAction");
        doMultiKey = SpeedDial.prefs.getBoolPref("altShiftShortcutMultikey");
      } else {
        targetAction = SpeedDial.prefs.getIntPref("altShortcutAction");
        doMultiKey = SpeedDial.prefs.getBoolPref("altShortcutMultikey");
      }
    }

    if (targetAction > 0) {
      if (doMultiKey && ((SpeedDialUtils.getTotalDials() > 10) || SpeedDial.multikeyForSingleDigit) && (targetAction != 6)
          && ((number != 0) || SpeedDial.zeroStartsMultiKey)) {
        // "centerscreen,chrome,dialog",
        MultiKey.initialNumber = number;
        MultiKey.numberThumbnails = SpeedDialUtils.getTotalDials();
        MultiKey.ctrlPressed = event.ctrlKey;
        MultiKey.shiftPressed = event.shiftKey;
        MultiKey.altPressed = ((event.altKey) || (event.metaKey));
        MultiKey.targetAction = targetAction;
        MultiKey.show();
      } else {
        if (number == 0) {
          if (SpeedDial.ignoreZeroKey) {
            return;
          } else {
            number = 10;
          }
        }
        SpeedDial.performAction(number, targetAction, false);
      }
      // Absorb key
      event.preventDefault();
      event.preventBubble();
      event.preventCapture();
      event.stopPropagation();
    }
  },
  
  performAction: function(number, targetAction, fromMultikey) {
    if (!fromMultikey) {
      if (number == 0) number = 10;
    }
    
    // Perform action
    if ((targetAction >= 1) && (targetAction <= 5)) {
      if (!SpeedDial.prefs.prefHasUserValue("thumbnail-" + number + "-url"))
        return;

      var targetUrl =  SpeedDial.prefs.getCharPref("thumbnail-" + number + "-url");

      if (SpeedDialUtils.stringStartsWith(targetUrl, "weather:")) {
        var weatherLocation = '';
        if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + number + "-extra")) {
          var thumbnailExtras =  SpeedDial.prefs.getCharPref("thumbnail-" + number + "-extra").split('#');
          if ((thumbnailExtras[0]) && (thumbnailExtras[0] != '')) {
            weatherLocation = decodeURI(thumbnailExtras[0]);
          }
        }
        if (weatherLocation == '') {
          weatherLocation = targetUrl.substr("weather:".length);
          if (weatherLocation.indexOf('#') > -1) {
            weatherLocation = weatherLocation.substring(0, weatherLocation.indexOf('#'));
          }
        }
        if (weatherLocation != '') {
          targetUrl = 'http://www.actuweather.com/report/?poi=' + encodeURI(weatherLocation);
        } else {
          targetUrl = 'http://www.actuweather.com/';
        }
      } else if (SpeedDialUtils.stringStartsWith(targetUrl, "javascript:")) {
        SpeedDial.evaluateString(targetUrl.substr("javascript:".length));
        return;
      } else if (SpeedDialUtils.stringStartsWith(targetUrl, "launch:")) {
        SpeedDialUtils.launch(targetUrl.substr("launch:".length));
        return;
      } else if (SpeedDialUtils.stringStartsWith(targetUrl, "plugin:")) {
        targetUrl = targetUrl.substr("plugin:".length);
      } else if (SpeedDialUtils.stringStartsWith(targetUrl, "nothing:")) {
        return;
      }

      if (targetUrl) {
        var urls;
        if (targetAction == 1) {
          // Open in current tab
          SpeedDial.loadOneOrMoreURIs(targetUrl);
        } else if (targetAction == 2) {
          // Open in tab
          urls = SpeedDialUtils.getDistinctUrls(targetUrl);
          getBrowser().loadTabs(urls, false);
        } else if (targetAction == 3) {
          // Open in background tab
          urls = SpeedDialUtils.getDistinctUrls(targetUrl);
          getBrowser().loadTabs(urls, true);
        } else if (targetAction == 4) {
          // Open in new window
          var newWindow = OpenBrowserWindow();
          newWindow.addEventListener("DOMContentLoaded", function() { newWindow.arguments[0] = targetUrl; }, false);
        } else if (targetAction == 5) {
          // Open Save
          urls = SpeedDialUtils.getDistinctUrls(targetUrl);
          saveURL(urls[0], null, null, true);  // only save the first page
        }
      } else {
        return;
      }
    } else if (targetAction == 6) {
      // Select tab

      // [Ctrl]+[9] always selects the last tab
      if ((number == 9) && (!fromMultikey)) {
        number = getBrowser().tabContainer.childNodes.length;
      } else if (number > getBrowser().tabContainer.childNodes.length) {
        return;
      }

      var tabbrowser = getBrowser();
      var oldTab = tabbrowser.selectedTab;
      var newTab = tabbrowser.tabContainer.childNodes[number-1];
      if (newTab != oldTab) {
        if (!SpeedDial.isFirefox3) {
          oldTab.selected = false;
        }
        tabbrowser.selectedTab = newTab;
      }
    }
  },

  fennecNewTab: function(aURI) {
    if ((!aURI || (aURI == "about:blank")) && SpeedDial.loadInNewTab) {
      aURI = "chrome://speeddial/content/speeddial.xul";
    }
    var returnTab =  BrowserUI.originalNewTab(aURI);
    if (aURI == "chrome://speeddial/content/speeddial.xul") {
      returnTab.load("about:blank");
      window.setTimeout(function() { returnTab.load(aURI); }, 0);
    }
    return returnTab;
  },
  
  fennecSetPage: function() {
    SpeedDial.globalprefs.setCharPref("browser.startup.homepage", "chrome://speeddial/content/speeddial.xul");
  },
  
  fennecRemovePage: function() {
    SpeedDial.globalprefs.clearUserPref("browser.startup.homepage");
  },
  
  fennecShowOrganizeGroups: function() {
    openDialog("chrome://speeddial/content/organizeGroups.xul", "",
               "centerscreen,chrome,dialog,resizable,dependent");
  },
  
  /*
  fennecTabLoad: function(targetTab, uri) {
    if (uri && SpeedDialUtils.stringStartsWith(uri, "chrome://speeddial/content/speeddial.xul")) {
      
      targetTab.originalLoad("about:blank");
      
      var flags = Components.interfaces.nsIWebNavigation.LOAD_FLAGS_ALLOW_THIRD_PARTY_FIXUP;
      targetTab._browser.loadURIWithFlags(uri, flags, null, null);
    } else {
      targetTab.originalLoad(uri);
    }
  },
  */
  
  browserOpenTab: function(event) {
    if (SpeedDial.loadInNewTab) {
      var newTab = gBrowser.loadOneTab("chrome://speeddial/content/speeddial.xul", null, null, null, false, false);
      newTab.linkedBrowser.userTypedValue = undefined;
      
      SpeedDial.doFocus();
    } else {
      window.originalBrowserOpenTab(event);
    }
  },
  
  doFocus: function() {
    if (SpeedDial.focusElement == 0) {
      if (gURLBar)
        setTimeout(function() { gURLBar.focus(); }, 0);
    } else if (SpeedDial.focusElement == 1) {
      var searchBar = document.getElementById("searchbar");
      if (searchBar && isElementVisible(searchBar)) {
        searchBar.select();
        searchBar.focus();
      }
    } // else do nothing
  },
  
  init: function () {
    if (SpeedDial.DEBUG) {
      SpeedDialUtils.log("init()");
    }
    SpeedDial.globalprefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2);
    SpeedDial.prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.speeddial.");
    SpeedDial.bundle = document.getElementById("bundle_speeddial");

    // Load settings
    SpeedDial.loadInNewWindow = SpeedDial.prefs.getBoolPref("loadInNewWindow");
    SpeedDial.loadInNewTab = SpeedDial.prefs.getBoolPref("loadInNewTab");
    SpeedDial.loadInLastTab = SpeedDial.prefs.getBoolPref("loadInLastTab");
    SpeedDial.clearURLBarOnLoad = SpeedDial.prefs.getBoolPref("clearURLBarOnLoad");
    SpeedDial.showInTabContextMenu = SpeedDial.prefs.getBoolPref("showInTabContextMenu");
    SpeedDial.showInAreaContextMenu = SpeedDial.prefs.getBoolPref("showInAreaContextMenu");
    SpeedDial.showInBookmarksMenu = SpeedDial.prefs.getBoolPref("showInBookmarksMenu");
    SpeedDial.overrideCtrlNumber = SpeedDial.prefs.getBoolPref("overrideCtrlNumber");
    SpeedDial.defaultRefreshInterval = SpeedDial.prefs.getIntPref("defaultRefreshInterval");
    SpeedDial.captureDelay = SpeedDial.prefs.getIntPref("captureDelay");
    SpeedDial.captureTimeout = SpeedDial.prefs.getIntPref("captureTimeout");
    SpeedDial.disableBackgroundBrowserJavascript = SpeedDial.prefs.getBoolPref("disableBackgroundBrowserJavascript");
    SpeedDial.defaultDialJavascript = SpeedDial.prefs.getBoolPref("defaultDialJavascript");
    SpeedDial.disableBackgroundBrowserPlugins = SpeedDial.prefs.getBoolPref("disableBackgroundBrowserPlugins");
    SpeedDial.disableBackgroundBrowserAuth = SpeedDial.prefs.getBoolPref("disableBackgroundBrowserAuth");
    SpeedDial.enableGroups = SpeedDial.prefs.getBoolPref("enableGroups");
    if (SpeedDial.enableGroups) {
      SpeedDial.numGroups = SpeedDial.prefs.getIntPref("numGroups");
    } else {
      SpeedDial.numGroups = 1;
    }
    SpeedDial.popupOptionsAccess = SpeedDial.prefs.getBoolPref("popupOptionsAccess");
    SpeedDial.enableCache = SpeedDial.prefs.getBoolPref("enableCache");
    SpeedDial.imageFormat = SpeedDial.prefs.getCharPref("imageFormat");
    SpeedDial.urlBarShortcuts = SpeedDial.prefs.getBoolPref("urlBarShortcuts");
    SpeedDial.openExistingFirst = SpeedDial.prefs.getBoolPref("openExistingFirst");
    SpeedDial.openOnBlankTab = SpeedDial.prefs.getBoolPref("openOnBlankTab");
    SpeedDial.useJava = SpeedDial.prefs.getBoolPref("useJava");
    SpeedDial.preScaling = SpeedDial.prefs.getBoolPref("preScaling");
    SpeedDial.multikeyForSingleDigit = SpeedDial.prefs.getBoolPref("multikeyForSingleDigit");
    SpeedDial.multikeyOverlayWidthModifier = SpeedDial.prefs.getIntPref("multikeyOverlayWidthModifier");
    SpeedDial.zeroStartsMultiKey = SpeedDial.prefs.getBoolPref("zeroStartsMultiKey");
    SpeedDial.ignoreZeroKey = SpeedDial.prefs.getBoolPref("ignoreZeroKey");
    SpeedDial.ignoreRedirects = SpeedDial.prefs.getBoolPref("ignoreRedirects");
    SpeedDial.errorWhenTimeout = SpeedDial.prefs.getBoolPref("errorWhenTimeout");
    SpeedDial.useIframe = SpeedDial.prefs.getBoolPref("useIframe");
    SpeedDial.cloakEvents = SpeedDial.prefs.getBoolPref("cloakEvents");
    SpeedDial.buttonOpensInCurrentTab = SpeedDial.prefs.getBoolPref("buttonOpensInCurrentTab");
    SpeedDial.focusElement = SpeedDial.prefs.getIntPref("focusElement");
    if (SpeedDial.DEBUG) {
      SpeedDialUtils.log("readed prefs");
    }
    
    // Detect language
    SpeedDial.currentLanguage = SpeedDial.globalprefs.getCharPref("general.useragent.locale");
    if (SpeedDial.currentLanguage.indexOf('-') > -1) {
      var parts = SpeedDial.currentLanguage.split('-');
      SpeedDial.currentLanguage = parts[0];
    }

    // Detect version
    SpeedDial.isFirefox3 = SpeedDialUtils.isFirefox3();
    SpeedDial.isFennec = SpeedDialUtils.isFennec();
    
    if (SpeedDial.DEBUG) {
      SpeedDialUtils.log("finished detection");
    }
    
    SpeedDial.ioService = Components.classes["@mozilla.org/network/io-service;1"]
                  .getService(Components.interfaces.nsIIOService);
    
    SpeedDialPrefObserver.addPrefObserver();
    if (SpeedDial.DEBUG) {
      SpeedDialUtils.log("initiated internals");
    }
    
    if (SpeedDial.isFennec) {
      try {
      // Blank url bar for Speed Dial
      eval("BrowserUI._editURI ="+BrowserUI._editURI.toString().replace(
         'urlString == "about:blank"',
         '\(urlString == "about:blank"\) || \(urlString == "chrome://speeddial/content/speeddial.xul"\)'
      ));
      } catch (e) { alert(e); }
      try {
      eval("BrowserUI.updateURI ="+BrowserUI.updateURI.toString().replace(
         'urlString == "about:blank"',
         '\(urlString == "about:blank"\) || \(urlString == "chrome://speeddial/content/speeddial.xul"\)'
      ));
      } catch (e) { alert(e); }
      /*
      try {
        if (SpeedDial.loadInNewWindow) {
          eval("Browser.startup ="+Browser.startup.toString().replace(
             'gPrefService.getCharPref\("browser.startup.homepage"\)',
             '"chrome://speeddial/content/speeddial.xul"'
          ));
        }
      } catch (e) { alert(e); }
      */
      try {
      BrowserUI.originalNewTab = BrowserUI.newTab;
      BrowserUI.newTab = SpeedDial.fennecNewTab;
      
      // New tab load tweak
      //Tab.prototype.originalLoad = Tab.prototype.load;
      //Tab.prototype.load = function(uri) { SpeedDial.fennecTabLoad(this, uri) };
      } catch (e) { alert(e); }
    } else {
      if (SpeedDial.isFirefox3) {
        SpeedDial.useKeyCapture = true;
      } else {
        SpeedDial.useKeyCapture = SpeedDial.prefs.getBoolPref("useKeyCapture");
      }
  
      // Register listeners
      var bookmarkContextItem = document.getElementById("context-bookmarkpage");
      bookmarkContextItem.addEventListener("DOMAttrModified", SpeedDial.contentAreaAttrListener, false);
  //    document.addEventListener("SSTabRestoring", SpeedDial.tabRestoringListener, false);
  
      // Register window observer
      var watcherService =
        Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
          .getService(Components.interfaces.nsIWindowWatcher);
      watcherService.registerNotification(SpeedDialWindowObserver);
      
      window.addEventListener("keyup", function(event) { SpeedDial.keyUpHandler(event); }, true);
      window.addEventListener("keydown", function(event) { SpeedDial.keyDownHandler(event); }, true);
  
      // Hide some things
      if (!SpeedDial.showInAreaContextMenu ) {
        try {
          document.getElementById("speeddialContext").hidden = true;
        } catch (e) { }
      }
      if (!SpeedDial.showInBookmarksMenu) {
        try {
          document.getElementById("speeddialBookmarksMenu").hidden = true;
        } catch (e) { }
      }
  
      // Add to tab context menu
      setTimeout(SpeedDial.addSpeedDialTabContextMenu, 100);
  
      // Substitute ctrl+number
      if (SpeedDial.overrideCtrlNumber) {
        if (window.BrowserNumberTabSelection) {
          window.originalCtrlNumberTabSelection = window.BrowserNumberTabSelection;
          window.BrowserNumberTabSelection = function(event, index) { if (!SpeedDial.useKeyCapture) { SpeedDial.processKey(event,index + 1); } };
        } else {
          window.originalCtrlNumberTabSelection = window.ctrlNumberTabSelection;
          window.ctrlNumberTabSelection = SpeedDial.ctrlNumberSpeedDial;
        }
      }
  
      // Substitute BrowserLoadURL
      if (SpeedDial.urlBarShortcuts) {
        window.setTimeout(function() {
          if (window.BrowserLoadURL) {
            window.originalBrowserLoadURL = window.BrowserLoadURL;
            window.BrowserLoadURL = SpeedDial.BrowserLoadURL;
          } else {
            window.originalLoadURI = window.loadURI;
            window.loadURI = SpeedDial.loadURI;
          }
        }, 0);
      }
      
      // Substitute last tab code
  //    if (SpeedDial.loadInLastTab) {
       
       if (getBrowser()._endRemoveTab) {
         eval("getBrowser()._endRemoveTab ="+getBrowser()._endRemoveTab.toString().replace(
            'this.addTab\("about:blank"\);',
            'if \(SpeedDial.loadInLastTab\) { this.addTab\("chrome://speeddial/content/speeddial.xul"\)} else { this.addTab\("about:blank"\)}'
         ));
       } else {
         eval("getBrowser().removeTab ="+getBrowser().removeTab.toString().replace(
            'this.addTab\("about:blank"\);',
            'if \(SpeedDial.loadInLastTab\) { this.addTab\("chrome://speeddial/content/speeddial.xul"\)} else { this.addTab\("about:blank"\)}'
         ));
       }
  //    }
  
      // Catch new tab
      if (window.TMP_BrowserOpenTab) {
        getBrowser().removeEventListener("NewTab", window.TMP_BrowserOpenTab, true);
        window.originalBrowserOpenTab = window.TMP_BrowserOpenTab;
        window.TMP_BrowserOpenTab = SpeedDial.browserOpenTab;
        getBrowser().addEventListener("NewTab", window.TMP_BrowserOpenTab, true);
      } else if (window.TBP_BrowserOpenTab) {
        getBrowser().removeEventListener("NewTab", window.TBP_BrowserOpenTab, true);
        window.originalBrowserOpenTab = window.TBP_BrowserOpenTab;
        window.TBP_BrowserOpenTab = SpeedDial.browserOpenTab;
        getBrowser().addEventListener("NewTab", window.TBP_BrowserOpenTab, true);
      } else {
        getBrowser().removeEventListener("NewTab", window.BrowserOpenTab, false);
        window.originalBrowserOpenTab = window.BrowserOpenTab;
        window.BrowserOpenTab = SpeedDial.browserOpenTab;
        getBrowser().addEventListener("NewTab", window.BrowserOpenTab, false);
      }
  
      if (SpeedDial.clearURLBarOnLoad) {
        if (!SpeedDial.isFirefox3) {
          var newLocationChange = nsBrowserStatusHandler.prototype.onLocationChange.toString();
          newLocationChange = newLocationChange.replace(/location == \"about:blank\"/g, "location == \"about:blank\" || (location.indexOf(\"chrome://speeddial/content\") == 0)");
          eval('nsBrowserStatusHandler.prototype.onLocationChange = ' + newLocationChange + ';');
        } else {
          var newLocationChange = window.URLBarSetURI.toString();
          newLocationChange = newLocationChange.replace(/aURI.spec == \"about:blank\"/g, "aURI.spec == \"about:blank\" || (aURI.spec.indexOf(\"chrome://speeddial/content\") == 0)");
          newLocationChange = newLocationChange.replace(/uri.spec == \"about:blank\"/g, "uri.spec == \"about:blank\" || (uri.spec.indexOf(\"chrome://speeddial/content\") == 0)");
          eval('window.URLBarSetURI = ' + newLocationChange + ';');
          if (window.gInitialPages) {
            window.gInitialPages.push("chrome://speeddial/content/speeddial.xul");
          }
        }
        // Check current window...
        if (SpeedDial.loadInNewWindow)
          setTimeout(SpeedDial.checkNewBrowser, 100, 10);
      }
      
      // Check current window...
      if (SpeedDial.loadInNewWindow) {
        setTimeout(SpeedDial.checkNewBrowser, 100, 10);
      }
    }
    
    setTimeout(function() {SpeedDial.showWelcomeScreenIfNeeded() }, 400);

    if (SpeedDial.DEBUG) {
      SpeedDialUtils.log("done non-mobile");
    }
    
    // Check if this window is the scheduler
    SpeedDial.checkWindow();
    if (SpeedDial.DEBUG) {
      SpeedDialUtils.log("done init()");
    }
  },

  unload: function () {
    SpeedDialPrefObserver.removePrefObserver();
    if (!SpeedDial.isFennec) {
      // Unregister listeners
      var bookmarkContextItem = document.getElementById("context-bookmarkpage");
      bookmarkContextItem.removeEventListener("DOMAttrModified", SpeedDial.contentAreaAttrListener, false);
  //    document.removeEventListener("SSTabRestoring", SpeedDial.tabRestoringListener, false);
  
      // Unregister window observer
      var watcherService =
        Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
          .getService(Components.interfaces.nsIWindowWatcher);
      watcherService.unregisterNotification(SpeedDialWindowObserver);
    }

    if (SpeedDial.isSchedulerWindow) {
      SpeedDial.stopScheduling();
    }
    
    SpeedDial.ioService = null;
  },
  
  keyDownHandler: function(event) {
    if (MultiKey.showingMultiKey) {
      MultiKey.keyDownHandler(event);
    }
    
    if (SpeedDial.useKeyCapture || MultiKey.showingMultiKey) {
      if ((event.keyCode >= 48) && (event.keyCode <= 57)) {
        if (MultiKey.showingMultiKey) {
          MultiKey.processKey(event, (event.keyCode - 48));
        } else {
          SpeedDial.processKey(event, (event.keyCode - 48));
        }
      } else if ((event.keyCode >= 96) && (event.keyCode <= 105)) {
        if (MultiKey.showingMultiKey) {
          MultiKey.processKey(event, (event.keyCode - 96));
        } else {
          SpeedDial.processKey(event, (event.keyCode - 96));
        }
      }
    }
  },

  keyUpHandler: function(event) {
    if (MultiKey.showingMultiKey) {
      MultiKey.keyUpHandler(event);
    }
  },


  unregisterBackgroundLoader: function() {
    var loaderBrowser = document.getElementById("speedDialLoaderBrowser");
    if (loaderBrowser) {
      try {
        if (SpeedDial.isFirefox3 && SpeedDial.useIframe) {
          loaderBrowser.removeEventListener("pageshow", SpeedDialBackgroundBrowserListener, true);
          loaderBrowser.removeEventListener("pagehide", SpeedDialBackgroundBrowserListener, true);
          loaderBrowser.removeEventListener("load", SpeedDialBackgroundBrowserListener, true);
          loaderBrowser.removeEventListener("unload", SpeedDialBackgroundBrowserListener, true);
          loaderBrowser.removeEventListener("beforeunload", SpeedDialBackgroundBrowserListener, true);
          loaderBrowser.removeEventListener("DOMSubtreeModified", SpeedDialBackgroundBrowserListener, true);
          loaderBrowser.removeEventListener("DOMLinkAdded", SpeedDialBackgroundBrowserListener, true);
        } else {
          loaderBrowser.removeProgressListener(SpeedDialBackgroundBrowserListener);
          if (!SpeedDial.isFirefox3) {
            loaderBrowser.removeEventListener("DOMLinkAdded", SpeedDialBackgroundBrowserListener, true);
          }
        }
        loaderBrowser.removeEventListener("DOMContentLoaded", SpeedDialBackgroundBrowserListener, true);
        if (loaderBrowser.contentDocument) {
          loaderBrowser.contentDocument.removeEventListener("DOMContentLoaded", SpeedDialBackgroundBrowserListener, true);
        }
      } catch (e) { Components.utils.reportError(e); }
    }
  },
  
  getLocationHostip: function() {
    var weatherLocation = '';
    var degreesType = '';
    var ipLocation = SpeedDialUtils.fetchURL('http://api.hostip.info/get_html.php?');
    if (ipLocation) {
      var reCountry = new RegExp("Country: .* \\((.*)\\)");
      var reCity = new RegExp("City: (.*)");
      var resultsCountry = reCountry.exec(ipLocation);
      var resultsCity = reCity.exec(ipLocation);
      if ((resultsCountry) && (resultsCountry[1]) && (resultsCountry[1] != '') &&
          (resultsCity) && (resultsCity[1]) && (resultsCity[1] != '')) {
        if (resultsCountry[1] == 'US') {
          degreesType = 'F';
        }
        weatherLocation = resultsCity[1] + ', ' + resultsCountry[1];
      }
    }
    return [ weatherLocation, degreesType ];
  },
    
  getLocationGeobytes: function() {
    var weatherLocation = '';
    var degreesType = '';
    var ipLocation = SpeedDialUtils.fetchURL('http://www.geobytes.com/IpLocator.htm?GetLocation&template=SpeedDial.txt');
    if (ipLocation) {
      var reCountry = new RegExp('"iso2":"(.*?)",');
      var reRegion = new RegExp('"region":"(.*?)",');
      var reCity = new RegExp('"city":"(.*?)",');
      var resultsCountry = reCountry.exec(ipLocation);
      var resultsCity = reCity.exec(ipLocation);
      var resultsRegion = reCity.exec(ipLocation);
      if ((resultsCountry) && (resultsCountry[1]) && (resultsCountry[1] != '') &&
          (resultsCity) && (resultsCity[1]) && (resultsCity[1] != '')) {
        if (resultsCountry[1] == 'US') {
          degreesType = 'F';
        }
        if ((resultsRegion) && (resultsRegion[1]) && (resultsRegion[1] != '')) {
          weatherLocation = resultsCity[1] + ',' + resultsRegion[1] + ',' + resultsCountry[1];
        } else {
          weatherLocation = resultsCity[1] + ',' + resultsCountry[1];
        }
      }
    }
    
    return [ weatherLocation, degreesType ];
  },

  startBackgroundLoad: function() {
    var targetURL;
    
    if (SpeedDial.currentPrioritySchedule > 0) {
      if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-thumbnailurl")) {
        targetURL = SpeedDial.prefs.getCharPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-thumbnailurl");
      } else {
        var targetURLs = SpeedDialUtils.getDistinctUrls(SpeedDial.prefs.getCharPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-url"));
        targetURL = targetURLs[0];
      }
    } else {
      targetURL = SpeedDial.thumbnailGenerationListeners[0].getTargetURL();
    }
    
    var loaderBrowser;
    if (SpeedDial.isFirefox3 && SpeedDial.useIframe) {
      loaderBrowser = document.createElement("iframe");
    } else {
      loaderBrowser = document.createElement("browser");
    }
    
    loaderBrowser.setAttribute("class", "speeddialBrowser");
    loaderBrowser.setAttribute("type", "content");
    loaderBrowser.setAttribute("disablehistory", "true");
    loaderBrowser.setAttribute("flex", "1");
    loaderBrowser.setAttribute("id", "speedDialLoaderBrowser");
    
    var backgroundBrowserWidth = SpeedDial.prefs.getIntPref("backgroundBrowserWidth");
    var backgroundBrowserHeight = SpeedDial.prefs.getIntPref("backgroundBrowserHeight");

    var speedDialLoaderSubBox = document.getElementById("speedDialLoaderSubBox");
    if (speedDialLoaderSubBox.firstChild) {
      SpeedDial.unregisterBackgroundLoader();
      speedDialLoaderSubBox.replaceChild(loaderBrowser, speedDialLoaderSubBox.firstChild);
    } else {
      speedDialLoaderSubBox.appendChild(loaderBrowser);
    }

//    loaderBrowser.addProgressListener(SpeedDialBackgroundBrowserListener, Components.interfaces.nsIWebProgress.NOTIFY_ALL);
    if (SpeedDial.isFirefox3 && SpeedDial.useIframe) {
      loaderBrowser.addEventListener("pageshow", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.addEventListener("pagehide", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.addEventListener("load", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.addEventListener("unload", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.addEventListener("beforeunload", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.addEventListener("DOMSubtreeModified", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.addEventListener("DOMLinkAdded", SpeedDialBackgroundBrowserListener, true);
    } else {
      loaderBrowser.addProgressListener(SpeedDialBackgroundBrowserListener, Components.interfaces.nsIWebProgress.NOTIFY_STATE_DOCUMENT);
      if (!SpeedDial.isFirefox3) {
        loaderBrowser.addEventListener("DOMLinkAdded", SpeedDialBackgroundBrowserListener, true);
      }
    }
    loaderBrowser.addEventListener("DOMContentLoaded", SpeedDialBackgroundBrowserListener, true);
    if (loaderBrowser.contentDocument) {
      loaderBrowser.contentDocument.addEventListener("DOMContentLoaded", SpeedDialBackgroundBrowserListener, true);
    }
    
    SpeedDialBackgroundBrowserListener.startTime = (new Date()).getTime();
    SpeedDialBackgroundBrowserListener.captureStarted();

    loaderBrowser.docShell.allowAuth = !SpeedDial.disableBackgroundBrowserAuth;
    
    var enableJs = null;
    if (SpeedDial.currentPrioritySchedule > 0) {
      if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-js")) {
        enableJs = SpeedDial.prefs.getBoolPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-js");
      } else {
        enableJs = !SpeedDial.disableBackgroundBrowserJavascript;
      }
    } else {
      enableJs = SpeedDial.thumbnailGenerationListeners[0].getJsEnabled();
    }
    
    loaderBrowser.docShell.allowJavascript = enableJs;
    loaderBrowser.docShell.allowPlugins = !SpeedDial.disableBackgroundBrowserPlugins;
    loaderBrowser.mIconURL = null;
    
    speedDialLoaderSubBox.setAttribute("width", backgroundBrowserWidth);
    speedDialLoaderSubBox.setAttribute("minwidth", backgroundBrowserWidth);
    speedDialLoaderSubBox.setAttribute("maxwidth", backgroundBrowserWidth);
    speedDialLoaderSubBox.setAttribute("height", backgroundBrowserHeight);
    speedDialLoaderSubBox.setAttribute("minheight", backgroundBrowserHeight);
    speedDialLoaderSubBox.setAttribute("maxheight", backgroundBrowserHeight);

    speedDialLoaderSubBox.style.width = backgroundBrowserWidth + "px !important";
    speedDialLoaderSubBox.style.maxWidth = speedDialLoaderSubBox.style.width;
    speedDialLoaderSubBox.style.minWidth = speedDialLoaderSubBox.style.width;
    speedDialLoaderSubBox.style.height = backgroundBrowserHeight + "px !important";
    speedDialLoaderSubBox.style.maxHeight = speedDialLoaderSubBox.style.height;
    speedDialLoaderSubBox.style.minHeight = speedDialLoaderSubBox.style.height;
    
    if (SpeedDialUtils.stringStartsWith(targetURL, "weather:")) {
      var weatherLocation = '';
      var degreesType = 'C';
      var checkCookieDegrees = true;
      var cachedTranslatedCity = null;
      
      if (SpeedDial.currentPrioritySchedule > -1) {
        if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-extra")) {
          var thumbnailExtras =  SpeedDial.prefs.getCharPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-extra").split('#');
          if ((thumbnailExtras[0]) && (thumbnailExtras[0] != '')) {
            weatherLocation = decodeURI(thumbnailExtras[0]);
          }
          if ((thumbnailExtras[1]) && (thumbnailExtras[1] != '')) {
            degreesType = thumbnailExtras[1];
          }
          if ((thumbnailExtras[3]) && (thumbnailExtras[3] != '')) {
            cachedTranslatedCity = decodeURI(thumbnailExtras[3]);
          }
        }
      } else {
        weatherLocation = targetURL.substr("weather:".length);
        if (weatherLocation == '') {
          weatherLocation = 'New York';
        }
      }
      
      if (weatherLocation == '') {
        weatherLocation = targetURL.substr("weather:".length);
        if (weatherLocation.indexOf('#') > -1) {
          var array = weatherLocation.split('#');
          weatherLocation = array[0];
          if (array[1].toLowerCase().charAt(0) == 'f') {
            degreesType = 'F';
          } else {
            degreesType = 'C';
          }
          checkCookieDegrees = false;
        }
      }
      
      var renderHTML = '';
      if (weatherLocation == '') {
        var geoLocation = [ '', '' ];
        geoLocation = SpeedDial.getLocationGeobytes();
        if (geoLocation[0] == '') {
          geoLocation = SpeedDial.getLocationHostip();
        }
        weatherLocation = geoLocation[0];
        if (geoLocation[1] != '') {
          degreesType = geoLocation[1];
        }
      }
      
      if (weatherLocation != '') {
        // Capture XML
        if (checkCookieDegrees) {
          var uri = SpeedDial.ioService.newURI("http://www.actuweather.com/report/", null, null);
          var cookieSvc =
             Components.classes["@mozilla.org/cookieService;1"]
                       .getService(Components.interfaces.nsICookieService);
          var cookie = cookieSvc.getCookieString(uri, null);
          if (cookie) {
            if (cookie.indexOf('options=F') > -1) {
              degreesType = 'F';
            } else if (cookie.indexOf('options=C') > -1) {
              degreesType = 'C';
            }
          }
        }
        
        if (SpeedDial.currentPrioritySchedule > 0) {
          var thumbnailExtras = encodeURI(weatherLocation) + '#' + degreesType + '#';
          SpeedDial.prefs.setCharPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-extra", thumbnailExtras);
        }
        
        var weatherUrl = 'http://www.google.com/ig/api?weather=' + encodeURI(weatherLocation);
        
        if (SpeedDial.currentLanguage != 'en') {
          weatherUrl += '&hl=' + SpeedDial.currentLanguage;
        }
        
        var weatherInfo = SpeedDialUtils.asyncFetchURL(weatherUrl, function(httpRequest) {
          switch(httpRequest.readyState) {
            case 1,2,3:
              break;
            case 4:
              if(httpRequest.status == 200) {
                SpeedDial.getWeatherInfo(loaderBrowser, httpRequest.responseText, weatherLocation, cachedTranslatedCity, degreesType);
              } else {
                var errorURL = SpeedDial.convertToURL('<html><head><title>' + SpeedDial.bundle.getString("unavailablereport.title") +'</title><body><div style="position: absolute; top:0;left:0;width:150px;height:40px;line-height:40px;text-align:center;font-style:italic;font-size:14px;font-family: Verdana, sans-serif;">' + SpeedDial.bundle.getString("unavailablereport.body") + '</div></body></html>');
                SpeedDial.setLoaderUrl(loaderBrowser, errorURL);
              }
              break;
          }
        });
        return;
      }
      
      targetURL = SpeedDial.convertToURL('<html><head><title>' + SpeedDial.bundle.getString("unavailablereport.title") +'</title><body><div style="position: absolute; top:0;left:0;width:150px;height:40px;line-height:40px;text-align:center;font-style:italic;font-size:14px;font-family: Verdana, sans-serif;">' + SpeedDial.bundle.getString("unavailablereport.body") + '</div></body></html>');
    } else if (SpeedDialUtils.stringStartsWith(targetURL, "javascript:")) {
      targetURL = "moz-icon://dummy?size=64&contentType=application/x-javascript";
    } else if (SpeedDialUtils.stringStartsWith(targetURL, "launch:")) {
      try {
        var obj = Components.classes["@mozilla.org/file/local;1"].
              createInstance(Components.interfaces.nsILocalFile);
        obj.initWithPath(targetURL.substr("launch:".length));
        targetURL = "moz-icon:" +  SpeedDial.ioService.newFileURI(obj).spec + "?size=64";
      } catch (e) {}
    } else if (SpeedDialUtils.stringStartsWith(targetURL, "mailto:")) {
      targetURL = "moz-icon://.EML?size=64";
    } else if (SpeedDialUtils.stringStartsWith(targetURL, "nothing:")) {
      targetURL = "about:blank";
    } else if (SpeedDialUtils.stringStartsWith(targetURL, "irc:")
      || SpeedDialUtils.stringStartsWith(targetURL, "plugin:")
      || SpeedDialUtils.stringStartsWith(targetURL, "telnet:")
      || SpeedDialUtils.stringStartsWith(targetURL, "bbs2chreader:")
      ) {
      targetURL = "chrome://speeddial/skin/plugin.png";
    }
    
    SpeedDial.setLoaderUrl(loaderBrowser, targetURL);
  },
  
  setLoaderUrl: function(loaderBrowser, targetURL) {
    targetURL = targetURL.replace('/\s+/g','');
    
    SpeedDial.currentPriorityScheduleURL = targetURL;
    
    loaderBrowser.setAttribute("src", targetURL);
  },
  
  convertToURL: function(renderHTML) {
    var processedHTML = '';
    for (var currentChar=0; currentChar<renderHTML.length;currentChar++) {
      var currentCharCode = renderHTML.charCodeAt(currentChar);
      if (currentCharCode < 128) {
        processedHTML += renderHTML.charAt(currentChar);
      } else {
        processedHTML += '&#' + currentCharCode + ';';
      }
    }
      
    return "data:text/html;base64," + btoa(processedHTML);
  },
  
  getWeatherInfo: function(loaderBrowser, weatherInfo, weatherLocation, cachedTranslatedCity, degreesType) {
    var renderHTML = null;
    try {
      var parser = new DOMParser();
      var doc = parser.parseFromString(weatherInfo, "text/xml");
      var city = doc.getElementsByTagName("city")[0].getAttribute('data');
      var originalCity = city;
      
      if (SpeedDial.currentLanguage != 'en') {
        if ((city == weatherLocation) && (cachedTranslatedCity)) {
          city = cachedTranslatedCity;
        } else {
          var translateUrl = 'http://ajax.googleapis.com/ajax/services/language/translate?v=1.0&q=' + encodeURI(city) + '&langpair=en%7C' + SpeedDial.currentLanguage;
          var translation = SpeedDialUtils.fetchURL(translateUrl);
          var reCity = new RegExp('"translatedText":"(.*?)"');
          var resultsCity = reCity.exec(translation);
          if ((resultsCity) && (resultsCity[1]) && (resultsCity[1] != '')) {
            city = resultsCity[1];
          }
        }
      }

      var currentConditions = doc.getElementsByTagName("current_conditions")[0];
      var tempC = currentConditions.getElementsByTagName("temp_c")[0].getAttribute('data');
      var tempF = currentConditions.getElementsByTagName("temp_f")[0].getAttribute('data');
      var condition = currentConditions.getElementsByTagName("condition")[0].getAttribute('data');
      var icon = currentConditions.getElementsByTagName("icon")[0].getAttribute('data');
      var forecastConditions = doc.getElementsByTagName("forecast_conditions")[0];
      if (condition == '') {
        condition = forecastConditions.getElementsByTagName("condition")[0].getAttribute('data');
      }
      if (icon == '') {
        icon = forecastConditions.getElementsByTagName("icon")[0].getAttribute('data');
      }
      var temp = null;
      if (degreesType == 'F') {
        temp = tempF;
      } else {
        temp = tempC;
      }
      
      // Set extras
      var reIcon = new RegExp("/images/weather/(.*).[a-zA-Z][a-zA-Z][a-zA-Z]");
      var resultsIcon = reIcon.exec(icon);

      var thumbnailExtras = encodeURI(originalCity) + '#' + degreesType + '#' + resultsIcon[1] + '#' + encodeURI(city);
      if (SpeedDial.currentPrioritySchedule > 0) {
        SpeedDial.prefs.setCharPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-extra", thumbnailExtras);
      }

      renderHTML = '<html><head><title>'
      + condition
      + ', '
      + temp 
      + '&deg;' + degreesType + ' ' + SpeedDial.bundle.getFormattedString("weatherreport.title", [city])
      + '</title><body style="font-family: Verdana, sans-serif"><div style="position: absolute; top: 0; left: 0;"><img src="http://www.google.com/ig/images/weather/' 
      + resultsIcon[1] 
      + '.png" width="40" height="40" /></div><div style="position: absolute; top: 0; left: 45px; font-size: 14px; line-height: 14px;">' 
      + condition 
      +  '</div><div style="position: absolute; top: 15px; left: 45px; font-size: 24px; line-height: 24px;">' 
      + temp 
      + '&deg;' + degreesType + '</div></body></html>';
    } catch (e) {
      renderHTML = '<html><head><title>' + SpeedDial.bundle.getString("unavailablereport.title") +'</title><body><div style="position: absolute; top:0;left:0;width:150px;height:40px;line-height:40px;text-align:center;font-style:italic;font-size:14px;font-family: Verdana, sans-serif;">' + SpeedDial.bundle.getString("unavailablereport.body") + '</div></body></html>';
    }
    
    SpeedDial.setLoaderUrl(loaderBrowser, SpeedDial.convertToURL(renderHTML));
  },

  backgroundIconLoaded: function(url) {
    if (SpeedDial.currentPrioritySchedule > 0) {
      var loaderBrowser = document.getElementById("speedDialLoaderBrowser");
      loaderBrowser.mIconURL = url;
      SpeedDial.loadIcon(url, SpeedDial.currentPrioritySchedule);
    }
  },

  openSpeedDial: function() {
    var tabbrowser = getBrowser();

    if (SpeedDial.openExistingFirst && ((!tabbrowser.selectedTab.linkedBrowser.currentURI) || (tabbrowser.selectedTab.linkedBrowser.currentURI.spec.indexOf("chrome://speeddial/content/") != 0))) {
      for (var i = 0; i < tabbrowser.mTabContainer.childNodes.length; i++) {
        var tab = tabbrowser.mTabContainer.childNodes[i];
        if (tab.linkedBrowser.currentURI && (tab.linkedBrowser.currentURI.spec.indexOf("chrome://speeddial/content/") == 0)) {
          tabbrowser.selectedTab = tab;
          return;
        }
      }
    }
    if ((SpeedDial.buttonOpensInCurrentTab) 
      || (tabbrowser.mCurrentBrowser.currentURI.spec == "about:blank")) {
      // Don't open a new tab
      tabbrowser.mCurrentBrowser.loadURI('chrome://speeddial/content/speeddial.xul');
    } else {
      var selectedTab = tabbrowser.addTab('chrome://speeddial/content/speeddial.xul');
      tabbrowser.selectedTab = selectedTab;
      selectedTab.linkedBrowser.userTypedValue = undefined;
    }
    
    SpeedDial.doFocus();
  },

  backgroundLoadFinished: function(event) {
//alert("entering backgroundLoadFinished");
    var loaderBrowser = document.getElementById("speedDialLoaderBrowser");
    if (SpeedDial.currentPrioritySchedule > -1) {
      try {
        // Get the IOService so we can make URIs
        var origURI = SpeedDial.ioService.newURI(loaderBrowser.contentDocument.documentURI, loaderBrowser.contentDocument.characterSet, null);

        // Verify that we still want to load the same URL
        var targetURL = "";
        if (SpeedDial.currentPrioritySchedule > 0) {
          if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-thumbnailurl")) {
            targetURL = SpeedDial.prefs.getCharPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-thumbnailurl");
          } else if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-url")) {
            var targetURLs = SpeedDialUtils.getDistinctUrls(SpeedDial.prefs.getCharPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-url"));
            targetURL = targetURLs[0];
          }
        } else if (SpeedDial.thumbnailGenerationListeners[0] != null) {
          targetURL = SpeedDial.thumbnailGenerationListeners[0].getTargetURL();
        }
        
        // Special treatments
        var forceLabel = null;
        var forceLocation = null;
        if (SpeedDialUtils.stringStartsWith(targetURL, "weather:")) {
          targetURL = SpeedDial.currentPriorityScheduleURL;
          forceLocation = "weather";
        } else if (SpeedDialUtils.stringStartsWith(targetURL, "javascript:")) {
          forceLabel = targetURL.substr("javascript:".length);
          targetURL = "moz-icon://dummy?size=64&contentType=application/x-javascript";
          // Set the favicon to the script, too
          if (!SpeedDial.isFirefox3) {
            SpeedDial.prefs.setCharPref("thumbnail-" + speedDial + "-icon", "moz-icon://dummy?size=16&contentType=application/x-javascript");
          }
        } else if (SpeedDialUtils.stringStartsWith(targetURL, "launch:")) {
          forceLabel = targetURL.substr("launch:".length);
          var iconURL = "moz-icon:";
          var obj = Components.classes["@mozilla.org/file/local;1"].
                  createInstance(Components.interfaces.nsILocalFile);
          obj.initWithPath(targetURL.substr("launch:".length));
          iconURL += SpeedDial.ioService.newFileURI(obj).spec;
          targetURL = iconURL + "?size=64";
          // Set the favicon to the script, too
          if (!SpeedDial.isFirefox3) {
            SpeedDial.prefs.setCharPref("thumbnail-" + speedDial + "-icon", iconURL + "?size=16");
          }
        } else if (SpeedDialUtils.stringStartsWith(targetURL, "nothing:")) {
          targetURL = "about:blank";
          forceLabel = "";
        } else if (SpeedDialUtils.stringStartsWith(targetURL, "mailto:")) {
          targetURL = "moz-icon://.EML?size=64";
          // Set the favicon to the script, too
          if (!SpeedDial.isFirefox3) {
            SpeedDial.prefs.setCharPref("thumbnail-" + speedDial + "-icon", "moz-icon://.EML?size=16");
          }
        } else if (SpeedDialUtils.stringStartsWith(targetURL, "irc:")
          || SpeedDialUtils.stringStartsWith(targetURL, "telnet:")
          || SpeedDialUtils.stringStartsWith(targetURL, "plugin:")
          || SpeedDialUtils.stringStartsWith(targetURL, "bbs2chreader:")
          ) {
          targetURL = "chrome://speeddial/skin/plugin.png";
          forceLabel = "";
          if (!SpeedDial.isFirefox3) {
            SpeedDial.prefs.setCharPref("thumbnail-" + speedDial + "-icon", "chrome://speeddial/skin/plugin16.png");
          }
        }
        
        targetURL = targetURL.replace('/\s+/g','');

        if (targetURL == SpeedDial.currentPriorityScheduleURL) {
          if (
              (origURI.spec.substr(0, "about:neterror".length) == "about:neterror")
            ||((origURI.spec.substr(0, "about:blank".length) == "about:blank") && (targetURL != "about:blank"))
            ||(SpeedDial.errorWhenTimeout && (SpeedDialBackgroundBrowserListener.finishedTime > (SpeedDialBackgroundBrowserListener.startTime + SpeedDial.captureTimeout)))
            ||(SpeedDial.ignoreRedirects && (SpeedDialUtils.getDomain(targetURL) != SpeedDialUtils.getDomain("" + loaderBrowser.contentDocument.location)))
            ) {
            if (origURI.spec.substr(0, "about:neterror".length) == "about:neterror") {
              SpeedDialUtils.log(targetURL + ' failed to load because of a network error');
            } else if ((origURI.spec.substr(0, "about:blank".length) == "about:blank") && (targetURL != "about:blank")) {
              SpeedDialUtils.log(targetURL + ' failed to load because the target page is about:blank');
            } else if (SpeedDial.errorWhenTimeout && (SpeedDialBackgroundBrowserListener.finishedTime > (SpeedDialBackgroundBrowserListener.startTime + SpeedDial.captureTimeout))) {
              SpeedDialUtils.log(targetURL + ' failed to load because it timed out');
            } else if (SpeedDial.ignoreRedirects && (SpeedDialUtils.getDomain(targetURL) != SpeedDialUtils.getDomain("" + loaderBrowser.contentDocument.location))) {
              SpeedDialUtils.log(targetURL + ' failed to load because the domain is different than ' + loaderBrowser.contentDocument.location);
            }
            if (SpeedDial.currentPrioritySchedule > 0) {
              if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-lastsaved")) {
                // Just set the saved time to now
                var saveTime = (new Date()).getTime();
                SpeedDialUtils.updateLastSaved(SpeedDial.currentPrioritySchedule, saveTime);
              } else {
                // It's the first time we've loaded the page.. place some error information
                if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-dynamictitle") &&
                    SpeedDial.prefs.getBoolPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-dynamictitle")) {
                  var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
                  if (forceLabel != null) {
                    str.data = forceLabel;
                  } else {
                    str.data = loaderBrowser.contentDocument.title;
                  }
                  SpeedDial.prefs.setComplexValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-label", Components.interfaces.nsISupportsString, str);
                }
                // Show thumbnail of error
                SpeedDial.saveSnapshot(loaderBrowser, SpeedDial.currentPrioritySchedule);
              }
            } else {
              SpeedDial.thumbnailGenerationListeners[0].thumbnailLoadError();
            }
          } else {
            if (forceLocation != null) {
              SpeedDialUtils.log('Loading successful for ' + forceLocation);
            } else {
              SpeedDialUtils.log('Loading successful for ' + loaderBrowser.contentDocument.location);
            }

            // Check if we've to get default icon
            if (!SpeedDial.isFirefox3 && !loaderBrowser.mIconURL && (SpeedDial.currentPrioritySchedule > 0) && !(loaderBrowser.contentDocument instanceof ImageDocument)) {
              if ((loaderBrowser.currentURI) && ("schemeIs" in loaderBrowser.currentURI) && (loaderBrowser.currentURI.schemeIs("http") || loaderBrowser.currentURI.schemeIs("https"))) {
                var url = loaderBrowser.currentURI.prePath + "/favicon.ico";
                SpeedDial.loadIcon(url, SpeedDial.currentPrioritySchedule);
              }
            }
  
            // Check if dynamic title...
            if ((SpeedDial.currentPrioritySchedule > 0) && SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-dynamictitle") &&
                 SpeedDial.prefs.getBoolPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-dynamictitle")) {
              var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
              if (forceLabel != null) {
                str.data = forceLabel;
              } else {
                str.data = loaderBrowser.contentDocument.title;
              }
              SpeedDial.prefs.setComplexValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-label", Components.interfaces.nsISupportsString, str);
            }
  
            SpeedDial.saveSnapshot(loaderBrowser, SpeedDial.currentPrioritySchedule);
            if (SpeedDial.currentPrioritySchedule == 0) {
              SpeedDial.thumbnailGenerationListeners[0].thumbnailLoadCompleted();
            }
          }
        }
        SpeedDial.finishCurrentBackgroundLoad();
      } catch (e) {
        Components.utils.reportError(e);
      }
    }
//alert("exiting backgroundLoadFinished");
  },
  
  finishCurrentBackgroundLoad: function() {
//alert("entering finishCurrentBackgroundLoad");
    // Remove manual refresh preference if necessary
    if (SpeedDial.currentPrioritySchedule == 0) {
      SpeedDial.thumbnailGenerationListeners.shift();
      if (SpeedDial.thumbnailGenerationListeners.length > 0) {
        SpeedDial.processingPrioritySchedules = false;
        SpeedDial.processPrioritySchedules();
        return;
      }
    } else {
      if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + SpeedDial.currentPrioritySchedule + "-manualrefresh")) {
        SpeedDial.prefs.clearUserPref("thumbnail-" + SpeedDial.currentPrioritySchedule + "-manualrefresh");
      }
    }
  
    SpeedDial.prioritySchedules.shift();
    SpeedDial.currentPrioritySchedule = -1;
    SpeedDial.processingPrioritySchedules = false;
    SpeedDial.processPrioritySchedules();
//alert("exiting finishCurrentBackgroundLoad");
  },

  checkWindow: function() {
    if (SpeedDial.isSchedulerWindow) return;

    var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
    var windowIter = wm.getEnumerator('navigator:browser');
   
    if (windowIter.hasMoreElements() && (window == windowIter.getNext())) {
      // We're the scheduler window now!
      setTimeout(SpeedDial.startScheduling, 0);
    }
  },

  startScheduling: function() {
    SpeedDial.isSchedulerWindow = true;
    
    // Add background browser
    var loaderBox = document.createElement("hbox");
    loaderBox.setAttribute("id", "speedDialLoaderBox");
    loaderBox.setAttribute("style", "overflow: hidden; visibility: hidden;");
    loaderBox.setAttribute("flex", "1");
    loaderBox.setAttribute("height", "0");
    loaderBox.setAttribute("maxheight", "0");
    loaderBox.setAttribute("minheight", "0");
    var loaderSubBox = document.createElement("vbox");
    loaderSubBox.setAttribute("id", "speedDialLoaderSubBox");
    loaderSubBox.setAttribute("id", "speedDialLoaderSubBox");
    loaderSubBox.setAttribute("flex", "0");
    loaderBox.appendChild(loaderSubBox);
    document.documentElement.appendChild(loaderBox);

    SpeedDial.scheduleTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
    SpeedDial.prioritySchedules = new Array();
    SpeedDial.updateSchedules = new Array();
    
    setTimeout(SpeedDial.checkThumbnailRefreshing, 0);
  },

  stopScheduling: function() {
    SpeedDial.isSchedulerWindow = false;

    SpeedDial.unregisterBackgroundLoader();

    SpeedDial.scheduleTimer.cancel();
    SpeedDial.scheduleTimer = null;
  },

  checkThumbnailRefreshing: function() {
//alert("entering checkThumbnailRefreshing");
    // Cancel current updates
    SpeedDial.scheduleTimer.cancel();

    SpeedDial.updateSchedules.length = 0;

    // Determine update and priority schedules
    var totalDials = SpeedDialUtils.getTotalDials();
    for (var c=1; c<=totalDials; c++) {
      if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + c + "-url")) {
        if (!SpeedDial.prefs.prefHasUserValue("thumbnail-" + c + "-lastsaved") || SpeedDial.prefs.prefHasUserValue("thumbnail-" + c + "-manualrefresh")) {
          SpeedDial.addPrioritySchedule(c);
        } else if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + c + "-refreshinterval")) {
          SpeedDial.updateSchedules.push(c);
        }
      }
    }
//alert("processed schedules: priority " + SpeedDial.prioritySchedules.length + ", updates " + SpeedDial.updateSchedules.length);

    if (SpeedDial.updateSchedules.length > 0) {
      // Calculate wait time
      var smallestWait = 0;
      var currentTime = (new Date()).getTime();
      
      for (var c=0; c<SpeedDial.updateSchedules.length; c++) {
        var lastSaved = parseInt(SpeedDial.prefs.getCharPref("thumbnail-" + SpeedDial.updateSchedules[c] + "-lastsaved"));
        var currentWait = lastSaved + SpeedDial.prefs.getIntPref("thumbnail-" + SpeedDial.updateSchedules[c] + "-refreshinterval") * 1000 - currentTime;
        
        if (currentWait < smallestWait) smallestWait = currentWait;
      }

      if (smallestWait < 100) smallestWait = 100;
//alert("smallestWait: " + smallestWait);
      SpeedDial.scheduleTimer.initWithCallback(SpeedDialTimerListener, smallestWait, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
    }
//alert("exiting checkThumbnailRefreshing");
  },

  addPrioritySchedule: function(targetDial) {
    if (SpeedDial.prioritySchedules.indexOf(targetDial) < 0) {
      SpeedDial.prioritySchedules.push(targetDial);
      if (!SpeedDial.processingPrioritySchedules) {
        SpeedDial.processPrioritySchedules();
      }
    }
  },

  processPrioritySchedules: function() {
    if (SpeedDial.prioritySchedules.length > 0) {
      SpeedDial.currentPrioritySchedule = SpeedDial.prioritySchedules[0];
//alert("" + SpeedDial.prioritySchedules[0] + "," + SpeedDial.processingPrioritySchedules);
      if (!SpeedDial.processingPrioritySchedules) {
        SpeedDial.processingPrioritySchedules = true;
        SpeedDial.startBackgroundLoad();
      }
    } else {
      SpeedDial.processingPrioritySchedules = false;
    }
  },

  checkSchedule: function() {
     if (SpeedDial.updateSchedules.length < 1) return;

     // Find our target
     var smallestWait = 0;
     var currentTime = (new Date()).getTime();
     
     for (var c=0; c<SpeedDial.updateSchedules.length; c++) {
       var targetIndex = SpeedDial.updateSchedules[c];
       if ((SpeedDial.prioritySchedules.indexOf(targetIndex) < 0) && !SpeedDial.pendingSaves[targetIndex]) {
         if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + targetIndex + "-url")) {
           var lastSaved = 0;
           if (SpeedDial.prefs.prefHasUserValue("thumbnail-" + targetIndex + "-lastsaved")) {
             lastSaved = parseInt(SpeedDial.prefs.getCharPref("thumbnail-" + targetIndex + "-lastsaved"));
           }
           var currentWait = lastSaved + SpeedDial.prefs.getIntPref("thumbnail-" + targetIndex + "-refreshinterval") * 1000 - currentTime;
           if (currentWait < 0) {
             SpeedDial.addPrioritySchedule(targetIndex);
           } else if (currentWait < smallestWait) {
             smallestWait = currentWait;
           }
         }
       }
     }

     if (smallestWait > 100) {
       SpeedDial.scheduleTimer.initWithCallback(SpeedDialTimerListener, smallestWait, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
     } else {
       // Re-check again
       SpeedDial.scheduleTimer.initWithCallback(SpeedDialTimerListener, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
     }
  },

  isBackgroundLoaderBusy: function() {
    // TODO: implement multiple browsers to do parallel background loading... future feature
    // It should show it's busy when all parallel browsers are working
    return SpeedDial.processingPrioritySchedules;
  },

  SpeedDialIconLoadListener: function(channel, speedDial) {
    this.mChannel = channel;
    this.mData = "";
    this.mSpeedDial = speedDial;
  },

  evaluateString: function(targetString) {
    try {
      eval(targetString);
    } catch (e) { alert(e); }
  }
};

SpeedDial.SpeedDialIconLoadListener.prototype =
{
    mCountRead: null,
    mChannel: null,
    mBytes: Array (),
    mStream: null,
    mData: null,
    mSpeedDial: -1,
    
    QueryInterface: function (iid)
    {
        if (!iid.equals(Components.interfaces.nsISupports) &&
            !iid.equals(Components.interfaces.nsIInterfaceRequestor) &&
            !iid.equals(Components.interfaces.nsIRequestObserver) &&
            !iid.equals(Components.interfaces.nsIProgressEventSink) &&
            !iid.equals(Components.interfaces.nsIStreamListener)) {
          throw Components.results.NS_ERROR_NO_INTERFACE;
        }
        return this;
    },
    
    getInterface: function(iid)
    {
        return this.QueryInterface(iid);
    },
    
    onStartRequest: function (aRequest, aContext)
    {
        this.mStream = Components.classes['@mozilla.org/binaryinputstream;1'].createInstance(Components.interfaces.nsIBinaryInputStream);
    },
    
    onStopRequest: function (aRequest, aContext, aStatusCode)
    {
      if (this.mChannel.contentType.match("^text/html")) {
        this.mData = "data:";
      } else {
       this.mData = "data:" + this.mChannel.contentType + ";base64," + btoa(String.fromCharCode.apply(null, this.mBytes));
      }
      SpeedDial.setSpeedDialIcon(this.mData, this.mSpeedDial);
      this. mChannel = null;
    },
    
    onDataAvailable: function (aRequest, aContext, aInputStream, aOffset, aCount)
    {
        this. mStream. setInputStream (aInputStream);
        var chunk = this. mStream. readByteArray (aCount);
        this. mBytes = this. mBytes. concat (chunk);
    },
    onProgress: function ( aRequest , aContext , aProgress , aProgressMax ) {},
    onStatus: function ( aRequest , aContext , aStatus , aStatusArg ) {}
}

var SpeedDialPrefObserver = 
{
  updateTimer: null,

  prefObserver : {
    observe: function(subject, topic, data) {
      // subject is the nsIPrefBranch we're observing (after appropriate QI)
      // data is the name of the pref that's been changed (relative to subject)
      if (topic == "nsPref:changed") {
        var updateThumbnailsNumber = false;
        
        if (data.indexOf("extensions.speeddial.thumbnail-") == 0) {
          // A thumbnail has been updated!
          if (SpeedDialPrefObserver.updateTimer == null) {
            SpeedDialPrefObserver.updateTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
          }
          SpeedDialPrefObserver.updateTimer.cancel();
          SpeedDialPrefObserver.updateTimer.initWithCallback(SpeedDialPrefObserver.prefObserver, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
        } else {
          switch (data) {
            case "extensions.speeddial.loadInNewWindow":
              SpeedDial.loadInNewWindow = SpeedDial.prefs.getBoolPref("loadInNewWindow");
              break;
            case "extensions.speeddial.loadInNewTab":
              SpeedDial.loadInNewTab = SpeedDial.prefs.getBoolPref("loadInNewTab");
              break;
            case "extensions.speeddial.loadInLastTab":
              SpeedDial.loadInLastTab = SpeedDial.prefs.getBoolPref("loadInLastTab");
              break;
            case "extensions.speeddial.clearURLBarOnLoad":
              SpeedDial.clearURLBarOnLoad = SpeedDial.globalprefs.getBoolPref("clearURLBarOnLoad");
              break;
            case "extensions.speeddial.showInTabContextMenu":
              SpeedDial.showInTabContextMenu = SpeedDial.prefs.getBoolPref("showInTabContextMenu");
              document.getElementById("tabContextSpeedDial").hidden = !SpeedDial.showInTabContextMenu;
              break;
            case "extensions.speeddial.showInAreaContextMenu":
              SpeedDial.showInAreaContextMenu = SpeedDial.prefs.getBoolPref("showInAreaContextMenu");
              try {
                document.getElementById("speeddialContext").hidden = !SpeedDial.showInAreaContextMenu;
              } catch (e) { }
              break;
            case "extensions.speeddial.showInBookmarksMenu":
              SpeedDial.showInBookmarksMenu = SpeedDial.prefs.getBoolPref("showInBookmarksMenu");
              try {
                document.getElementById("speeddialBookmarksMenu").hidden = !SpeedDial.showInBookmarksMenu;
              } catch (e) { }
              break;
            case "extensions.speeddial.overrideCtrlNumber":
              SpeedDial.overrideCtrlNumber = SpeedDial.prefs.getBoolPref("overrideCtrlNumber");
              
              if (window.BrowserNumberTabSelection) {
                if (SpeedDial.overrideCtrlNumber) {
                  if (!window.originalCtrlNumberTabSelection) {
                    window.originalCtrlNumberTabSelection = window.BrowserNumberTabSelection;
                  }
                  window.BrowserNumberTabSelection = function(event, index) { if (!SpeedDial.useKeyCapture) { SpeedDial.processKey(event,index + 1); } };
                } else {
                  if (window.originalCtrlNumberTabSelection) {
                    window.BrowserNumberTabSelection = window.originalCtrlNumberTabSelection;
                  }
                }
              } else {
                window.removeEventListener("keypress", window.ctrlNumberTabSelection, false);
  
                if (SpeedDial.overrideCtrlNumber) {
                  if (!window.originalCtrlNumberTabSelection)
                    window.originalCtrlNumberTabSelection = window.ctrlNumberTabSelection;
                  window.ctrlNumberTabSelection = SpeedDial.ctrlNumberSpeedDial;
                } else {
                  if (window.originalCtrlNumberTabSelection)
                    window.ctrlNumberTabSelection = window.originalCtrlNumberTabSelection;
                }
  
                window.addEventListener("keypress", window.ctrlNumberTabSelection, false);
              }
              break;
            case "extensions.speeddial.defaultRefreshInterval":
              SpeedDial.defaultRefreshInterval = SpeedDial.prefs.getIntPref("defaultRefreshInterval");
              break;
            case "extensions.speeddial.captureDelay":
              SpeedDial.captureDelay = SpeedDial.prefs.getIntPref("captureDelay");
              break;
            case "extensions.speeddial.captureTimeout":
              SpeedDial.captureTimeout = SpeedDial.prefs.getIntPref("captureTimeout");
              break;
            case "extensions.speeddial.defaultDialJavascript":
              SpeedDial.defaultDialJavascript = SpeedDial.prefs.getBoolPref("defaultDialJavascript");
              break;
            case "extensions.speeddial.disableBackgroundBrowserJavascript":
              SpeedDial.disableBackgroundBrowserJavascript = SpeedDial.prefs.getBoolPref("disableBackgroundBrowserJavascript");
              break;
            case "extensions.speeddial.disableBackgroundBrowserPlugins":
              SpeedDial.disableBackgroundBrowserPlugins = SpeedDial.prefs.getBoolPref("disableBackgroundBrowserPlugins");
              break;
            case "extensions.speeddial.disableBackgroundBrowserAuth":
              SpeedDial.disableBackgroundBrowserAuth = SpeedDial.prefs.getBoolPref("disableBackgroundBrowserAuth");
              break;
            case "extensions.speeddial.enableGroups":
              SpeedDial.enableGroups = SpeedDial.prefs.getBoolPref("enableGroups");
              updateThumbnailsNumber = true;
              break;
            case "extensions.speeddial.numGroups":
              updateThumbnailsNumber = true;
              break;
            case "extensions.speeddial.popupOptionsAccess":
              SpeedDial.popupOptionsAccess = SpeedDial.prefs.getBoolPref("popupOptionsAccess");
              break;
            case "extensions.speeddial.enableCache":
              SpeedDial.enableCache = SpeedDial.prefs.getBoolPref("enableCache");
              break;
            case "extensions.speeddial.imageFormat":
              SpeedDial.imageFormat = SpeedDial.prefs.getCharPref("imageFormat");
              break;
            case "extensions.speeddial.urlBarShortcuts":
              SpeedDial.urlBarShortcuts = SpeedDial.prefs.getCharPref("urlBarShortcuts");
              break;
            case "extensions.speeddial.openExistingFirst":
              SpeedDial.openExistingFirst = SpeedDial.prefs.getBoolPref("openExistingFirst");
              break;
            case "extensions.speeddial.openOnBlankTab":
              SpeedDial.openOnBlankTab = SpeedDial.prefs.getBoolPref("openOnBlankTab");
              break;
            case "extensions.speeddial.useJava":
              SpeedDial.useJava = SpeedDial.prefs.getBoolPref("useJava");
              break;
            case "extensions.speeddial.preScaling":
              SpeedDial.preScaling = SpeedDial.prefs.getBoolPref("preScaling");
              break;
            case "extensions.speeddial.multikeyForSingleDigit":
              SpeedDial.multikeyForSingleDigit = SpeedDial.prefs.getBoolPref("multikeyForSingleDigit");
              break;
            case "extensions.speeddial.multikeyOverlayWidthModifier":
              SpeedDial.multikeyOverlayWidthModifier = SpeedDial.prefs.getIntPref("multikeyOverlayWidthModifier");
              break;
            case "extensions.speeddial.zeroStartsMultiKey":
              SpeedDial.zeroStartsMultiKey = SpeedDial.prefs.getBoolPref("zeroStartsMultiKey");
              break;
            case "extensions.speeddial.ignoreZeroKey":
              SpeedDial.ignoreZeroKey = SpeedDial.prefs.getBoolPref("ignoreZeroKey");
              break;
            case "extensions.speeddial.useKeyCapture":
              if (!SpeedDial.isFirefox3) {
                SpeedDial.useKeyCapture = SpeedDial.prefs.getBoolPref("useKeyCapture");
              }
              break;
            case "extensions.speeddial.ignoreRedirects":
              SpeedDial.ignoreRedirects = SpeedDial.prefs.getBoolPref("ignoreRedirects");
              break;
            case "extensions.speeddial.errorWhenTimeout":
              SpeedDial.errorWhenTimeout = SpeedDial.prefs.getBoolPref("errorWhenTimeout");
              break;
            case "extensions.speeddial.useIframe":
              SpeedDial.useIframe = SpeedDial.prefs.getBoolPref("useIframe");
              break;
            case "extensions.speeddial.cloakEvents":
              SpeedDial.cloakEvents = SpeedDial.prefs.getBoolPref("cloakEvents");
              break;
            case "extensions.speeddial.buttonOpensInCurrentTab":
              SpeedDial.buttonOpensInCurrentTab = SpeedDial.prefs.getBoolPref("buttonOpensInCurrentTab");
              break;
            case "extensions.speeddial.focusElement":
              SpeedDial.focusElement = SpeedDial.prefs.getIntPref("focusElement");
              break;
          }
        }
        
        if (updateThumbnailsNumber) {
          if (SpeedDial.enableGroups) {
            SpeedDial.numGroups = SpeedDial.prefs.getIntPref("numGroups");
          } else {
            SpeedDial.numGroups = 1;
          }
        }
      }
    },

    QueryInterface : function (aIID) {
      if (aIID.equals(Components.interfaces.nsIObserver) || 
      aIID.equals(Components.interfaces.nsITimerCallback) ||
      aIID.equals(Components.interfaces.nsISupports) ||
      aIID.equals(Components.interfaces.nsISupportsWeakReference))
        return this;
      throw Components.results.NS_NOINTERFACE;
    },

    notify: function(timer) {
      SpeedDial.checkThumbnailRefreshing();
    }
  },

  addPrefObserver : function () {
    SpeedDial.globalprefs.addObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver, true);
  },

  removePrefObserver : function () {
    SpeedDial.globalprefs.removeObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver);
  }
};

// Window close observer
var SpeedDialWindowObserver = {
  observe: function(subject,topic,data){
    switch(topic){
      case 'domwindowclosed':
        setTimeout(SpeedDial.checkWindow, 0);
        break;
    }
  }
};

// Thumbnail scheduler
var SpeedDialTimerListener = {
    QueryInterface : function (aIID) {
      if (aIID.equals(Components.interfaces.nsITimerCallback) ||
      aIID.equals(Components.interfaces.nsISupports) ||
      aIID.equals(Components.interfaces.nsISupportsWeakReference))
        return this;
      throw Components.results.NS_NOINTERFACE;
    },

    notify: function(timer) {
      if (!SpeedDial.isSchedulerWindow) return;

      SpeedDial.checkSchedule();
    }
};

var SpeedDialBackgroundBrowserListener =
{
  alreadyLoaded: false,
  firstLoadTime: -1,
  finishedTime: -1,
  startTime: -1,
  currentTimeoutId: -1,
  loadFinished: false,

  QueryInterface: function(aIID)
  {
   if (aIID.equals(Components.interfaces.nsIDOMEventListener) ||
       aIID.equals(Components.interfaces.nsIWebProgressListener) ||
       aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
       aIID.equals(Components.interfaces.nsISupports))
     return this;
   throw Components.results.NS_NOINTERFACE;
  },

  handleEvent: function(event) {
    if (SpeedDialBackgroundBrowserListener.loadFinished) return;
    
  
    if ((event.type == "load") || (event.type == "pageshow")) {
      if (!SpeedDialBackgroundBrowserListener.alreadyLoaded) {
        if (event.currentTarget.contentDocument != event.originalTarget)
          return;
        /*
        try {
          // Get the IOService so we can make URIs
          var origURI = SpeedDial.ioService.newURI(event.currentTarget.contentDocument.documentURI, event.currentTarget.contentDocument.characterSet, null);
          if (origURI.spec.substr(0, "about:neterror".length) != "about:neterror") {
            if (origURI.spec.substr(0, "about:blank".length) == "about:blank") {
              if (event.currentTarget.getAttribute('src') != origURI.spec) {
                return;
              }
            }
          }
        } catch (e) {
          // Just ignore and finish
        }
        */
        SpeedDialBackgroundBrowserListener.alreadyLoaded = true;
        SpeedDialBackgroundBrowserListener.firstLoadTime = (new Date()).getTime();
      }
      SpeedDialBackgroundBrowserListener.resetTimer();
    } else if (event.type == "unload") {
      if (event.currentTarget.contentDocument == event.originalTarget) {
        SpeedDialBackgroundBrowserListener.alreadyLoaded = false;
        if (SpeedDialBackgroundBrowserListener.currentTimeoutId != -1) {
          clearTimeout(SpeedDialBackgroundBrowserListener.currentTimeoutId);
        }
        SpeedDialBackgroundBrowserListener.captureStarted();
      } else {
        SpeedDialBackgroundBrowserListener.resetTimer();
      }
    } else if (event.type == "DOMSubtreeModified") {
      if (SpeedDialBackgroundBrowserListener.alreadyLoaded) {
        SpeedDialBackgroundBrowserListener.resetTimer();
      }
    } else if ((!SpeedDial.isFirefox3) && (event.type == "DOMLinkAdded")) {
      if (!event.originalTarget.rel.match((/(?:^|\s)icon(?:\s|$)/i)))
        return;

      // We have an icon.
      var href = event.originalTarget.href;
      if (!href)
        return;

      SpeedDial.backgroundIconLoaded(href);
    } else if (event.type == "DOMContentLoaded") {
      if (event.currentTarget instanceof HTMLDocument) {
        var input_elements = event.currentTarget.getElementsByTagName('input');
        for (var i = 0; i < input_elements.length; i++) {
          input_elements[i].wrappedJSObject.focus = function() { };
        }
      }
    }
    
    // We're a stealth browser
    if (SpeedDial.cloakEvents) {
      event.stopPropagation();
    }
  },
  
  resetTimer: function() {
    if (SpeedDialBackgroundBrowserListener.currentTimeoutId != -1) {
      clearTimeout(SpeedDialBackgroundBrowserListener.currentTimeoutId);
      SpeedDialBackgroundBrowserListener.currentTimeoutId = -1;
    }
    if (!SpeedDialBackgroundBrowserListener.loadFinished) {
      var currentTime = (new Date()).getTime();
      if (currentTime > (SpeedDialBackgroundBrowserListener.startTime + SpeedDial.captureTimeout)) {
        // Just do it
        SpeedDialBackgroundBrowserListener.captureFinished();
      } else {
        SpeedDialBackgroundBrowserListener.currentTimeoutId = setTimeout(SpeedDialBackgroundBrowserListener.captureFinished, SpeedDial.captureDelay);
      }
    }
  },
  
  checkTimeout: function() {
  },
  
  captureStarted: function() {
    SpeedDialBackgroundBrowserListener.alreadyLoaded = false;
    SpeedDialBackgroundBrowserListener.loadFinished = false;
    SpeedDialBackgroundBrowserListener.firstLoadTime = (new Date()).getTime();
    
    if (SpeedDialBackgroundBrowserListener.currentTimeoutId != -1) {
      clearTimeout(SpeedDialBackgroundBrowserListener.currentTimeoutId);
      SpeedDialBackgroundBrowserListener.currentTimeoutId = -1;
    }
    var currentTime = (new Date()).getTime();
    SpeedDialBackgroundBrowserListener.currentTimeoutId = setTimeout(SpeedDialBackgroundBrowserListener.resetTimer, SpeedDial.captureTimeout - (currentTime - SpeedDialBackgroundBrowserListener.startTime));
  },
  
  captureFinished: function() {
    if (SpeedDialBackgroundBrowserListener.loadFinished) return;
    SpeedDialBackgroundBrowserListener.loadFinished = true;
    SpeedDialBackgroundBrowserListener.finishedTime = (new Date()).getTime();
    SpeedDial.backgroundLoadFinished();
  },
  
  onStateChange: function(aWebProgress, aRequest, aFlag, aStatus)
  {
    if (SpeedDialBackgroundBrowserListener.loadFinished) return;
    // If you use myListener for more than one tab/window, use
    // aWebProgress.DOMWindow to obtain the tab/window which triggers the state change
    if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_START) {
      if (aFlag & Components.interfaces.nsIWebProgress.NOTIFY_STATE_IS_WINDOW) {
        // This fires when the load event is initiated
        SpeedDialBackgroundBrowserListener.alreadyLoaded = false;
        if (SpeedDialBackgroundBrowserListener.currentTimeoutId != -1) {
          clearTimeout(SpeedDialBackgroundBrowserListener.currentTimeoutId);
        }
        SpeedDialBackgroundBrowserListener.captureStarted();
      }
    }
    if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_STOP)
    {
      if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_IS_WINDOW) {
        // This fires when the load finishes
        var loaderBrowser = document.getElementById("speedDialLoaderBrowser");
        if (!SpeedDialBackgroundBrowserListener.alreadyLoaded) {
          if (loaderBrowser && loaderBrowser.contentDocument &&
            ((loaderBrowser.contentDocument.location.toString() != 'about:blank') || (loaderBrowser.getAttribute("src") == 'about:blank'))
              ) {
            SpeedDialBackgroundBrowserListener.alreadyLoaded = true;
            SpeedDialBackgroundBrowserListener.firstLoadTime = (new Date()).getTime();
          }
        }
        
        if (SpeedDialBackgroundBrowserListener.alreadyLoaded) {
          var captureNow = false;
          if (loaderBrowser) {
            if (loaderBrowser.contentDocument instanceof ImageDocument) {
              captureNow = true;
            } else if (SpeedDialUtils.stringStartsWith(loaderBrowser.contentDocument.location.toString(), "data:")) {
              captureNow = true;
            } else if (loaderBrowser.contentDocument.location.toString() == "about:blank") {
              captureNow = true;
            }
          }
          if (captureNow) {
            SpeedDialBackgroundBrowserListener.captureFinished();
          } else {
            SpeedDialBackgroundBrowserListener.resetTimer();
          }
        }
      }
    }
    return 0;
  },

  onLocationChange: function(aProgress, aRequest, aURI)
  {
   // This fires when the location bar changes; i.e load event is confirmed
   // or when the user switches tabs. If you use myListener for more than one tab/window,
   // use aProgress.DOMWindow to obtain the tab/window which triggered the change.

   return 0;
  },

  // For definitions of the remaining functions see XULPlanet.com
  onProgressChange: function() {return 0;},
  onStatusChange: function() {return 0;},
  onSecurityChange: function() {return 0;},
  onLinkIconAvailable: function() {return 0;}
}


function SpeedDialTabListener(tab, eventCallback) {
  var _this = this;
  this.tab = tab;
  this.eventCallback = eventCallback;

  this.handleEvent = function(event) {
    _this.eventCallback(_this.tab);
    _this.tab.linkedBrowser.removeEventListener("pageshow", _this.handleEvent, false);
    _this.tab = null;
    _this.eventCallback = null;
    _this.handleEvent = null;
  }

  tab.linkedBrowser.addEventListener("pageshow", this.handleEvent, false);
}


window.addEventListener("load", function(e) { SpeedDial.init(); }, false);
window.addEventListener("unload", function(e) { SpeedDial.unload(); }, false);
