// Global vars
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var updateTimer = null;

var SHOWING_DIALS = 0;
var SHOWING_GROUPS = 1;
var showing;
var callbackType;

function Startup() {
  showing = window.arguments[0][0];
  callbackType = window.arguments[0][1];

  refreshEntityList();
  SpeedDialPrefObserver.addPrefObserver();
}

function onOK(event) {
  var list = document.getElementById("entityList");
  var outlist = new Array();
  
  for (var c=0; c<list.selectedItems.length;c++) {
    outlist[outlist.length] = parseInt(list.selectedItems[c].getAttribute("number"));
  }
  
  window.opener.processTargetSelectorOutput(callbackType, outlist);
  return true;
}

function onCancel(event) {
  return true;
}

function Unload() {
  SpeedDialPrefObserver.removePrefObserver();
}

function selectAll() {
  var list = document.getElementById("entityList");
  list.selectAll();
}

function selectNone() {
  var list = document.getElementById("entityList");
  list.clearSelection();
}

function refreshEntityList() {
  var list = document.getElementById("entityList");
  
  while (list.firstChild) {
    list.removeChild(list.firstChild);
  }

  var speedDialBundle = document.getElementById("bundle_speeddial");

  if (showing == SHOWING_GROUPS) {
    var numGroups = gPref.getIntPref("extensions.speeddial.numGroups");
    for (var b=1; b<=numGroups; b++) {
      var row = document.createElement("listitem");
      row.id = "";
      row.setAttribute("number", b);
      if (gPref.prefHasUserValue("extensions.speeddial.group-" + b + "-title")) {
        row.setAttribute("label", gPref.getComplexValue("extensions.speeddial.group-" + b + "-title", Components.interfaces.nsISupportsString).data);
      } else {
        row.setAttribute("label", speedDialBundle.getFormattedString("untitledGroup.label", [b]));
      }
      list.appendChild(row);
    }
  } else {
    var numDials = SpeedDialUtils.getTotalDials();
    for (var b=1; b<=numDials; b++) {
      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + b + "-url")) {
        var row = document.createElement("listitem");
        row.id = "";
        row.setAttribute("number", b);
        var label = "";
        if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + b + "-label")) {
          label = gPref.getComplexValue("extensions.speeddial.thumbnail-" + b + "-label", Components.interfaces.nsISupportsString).data;
        }
        if (label != "") {
          row.setAttribute("label", "" + b + " - " + label);
        } else {
          row.setAttribute("label", "" + b + " - " + speedDialBundle.getString("untitled.label"));
        }
        row.setAttribute("tooltiptext", gPref.getCharPref("extensions.speeddial.thumbnail-" + b + "-url"));
      }
      list.appendChild(row);
    }
  }
}

var SpeedDialPrefObserver = 
{
  prefObserver : {
    observe: function(subject, topic, data) {

    if (topic == "nsPref:changed") {
      if (((showing == SHOWING_GROUPS) && ((data.indexOf("extensions.speeddial.group-") == 0) || (data.indexOf("extensions.speeddial.numGroups") == 0) ) ) ||
          ((showing == SHOWING_DIALS) && (data.indexOf("extensions.speeddial.thumbnail-") == 0))) {
        if (updateTimer == null) {
          updateTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
        }
        updateTimer.cancel();
        updateTimer.initWithCallback(SpeedDialPrefObserver.prefObserver, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
      }
    }
  },

  QueryInterface : function (aIID) {
    if (aIID.equals(Components.interfaces.nsIObserver) || 
    aIID.equals(Components.interfaces.nsITimerCallback) ||
    aIID.equals(Components.interfaces.nsISupports) ||
    aIID.equals(Components.interfaces.nsISupportsWeakReference))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

    notify: function(timer) {
      refreshEntityList();
    }
  },
  
  addPrefObserver : function () {
    if (!gPref) return;
    gPref.addObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver, true);
  },

  removePrefObserver : function () {
    if (!gPref) return;
    gPref.removeObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver);
  }
};

