#!/bin/sh

# don't run inside a chroot environment
ischroot && exit || true

# set platfrom compatibility status in gsettings for watermark 
# can be retrieved through `gsettings get com.ubuntu.platform-compatibility status`
status=$(compatibilityChecker -r)
schema=/usr/share/glib-2.0/schemas/com.ubuntu.platform-compatibility.gschema.xml
qrcode=/var/log/platform-compatibility-qrcode.png
info=/var/log/platform-compatibility-info
summary=/var/log/platform-compatibility-summary

cat >$schema <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<schemalist>
  <schema id="com.ubuntu.platform-compatibility" path="/com/canonical/platform-compatibility/">
      <key type="s" name="status">
          <default>"${status}"</default>
          <summary>Platform compatibility status</summary>
          <description>OEM Platform compatibility status</description>
      </key>
  </schema>
</schemalist>
EOF
glib-compile-schemas /usr/share/glib-2.0/schemas/

# we need check the qrencode if exist, or it will exit with 127 error when bootup(LP: #1271801)
if [ -x /usr/bin/qrencode ]; then
	lspci -nn \
	| grep -E '00:00.0|VGA|3D controller|Network controller' \
	| sed 's/.*\[\(.*\):\(.*\)\].*/\1\2/' \
	| tr -d '\n' \
	| qrencode -v 1 -s 2 -m 1 -o $qrcode
fi

# When use dmidecode we need remove extra info when verion bigger than 2.7
# And we use unify getID.sh to get system id.
if :; then
	echo -n "BIOS: "
	cat /sys/class/dmi/id/bios_version | sed '/^#/d'

	echo -n "System ID: "
	/usr/share/sutton/getID.sh
	echo -n "status: $status"
fi >$info

if :; then
	compatibilityChecker -p
	tail -n1 /etc/buildstamp | grep -o '[^-]\+-[^-]\+$'
fi | paste -sd ' - ' >$summary
