#!/bin/sh
# Copyright (c) 2009 Synaptics Incorporated. All rights reserved.

if [ ! -d /opt/xandros ]; then
  if [ ! -x /usr/bin/xandrospwdinfo ]; then
    exit 0
  fi
fi

timeout=10

echo "">/proc/sys/kernel/hotplug
/sbin/udevd --daemon

function findtouchpad
{
  pushd /sys/class/input/
  for name in input*; do
    devname=$(cat $name/name)
    if [ "$devname" = "SynPS/2 Synaptics TouchPad" ]; then
      return 0
    fi
  done
  popd
  return 1
}

endtime=$(($(date +%s) + $timeout))

while [ $(date +%s) -le $endtime ]; do
  findtouchpad
  if [ $? -eq 0 ]; then
    #found touchpad
    /etc/init.d/synset start >& /dev/null
    break
  fi
done

/etc/init.d/dbus start
/etc/init.d/synaptics-dbus start
