//===========================================================================
// Copyright (c) 1996-2009 Synaptics Incorporated. All rights reserved.
//
// RCS Header - Do not delete or modify.
//
// $RCSfile: SynCom.h,v $
// $Source: /cvs/software/Driver/SynCom/SynCom/Linux/SynCom.h,v $
//===========================================================================
//---------------------------------------------------------------------------
// Linux SynCom.h
//---------------------------------------------------------------------------

#ifndef __SynCom_H__
#define __SynCom_H__

#include <string>
#include "WinDef.h"
#include "SynComDefs.h"
#include "Unknwn.h"
#include "SynError.h"
#include "SynComFactory.h"


#define ATL_NO_VTABLE

#define BEGIN_COM_MAP(x)
#define COM_INTERFACE_ENTRY(x)
#define END_COM_MAP()

#define DECLARE_REGISTRY_RESOURCEID(x)
#define DECLARE_PROTECT_FINAL_CONSTRUCT()

#ifndef __WinNT_H
#define STDMETHODCALLTYPE
#endif

#define STDMETHOD(method)  virtual HRESULT STDMETHODCALLTYPE method
#define SUCCEEDED(hr) ((HRESULT)(hr) >= 0)
#define FAILED(hr) ((HRESULT)(hr) < 0)

class ISynDevice;
class ISynDisplay;
class ISynPacket;
class ISynGroup;

class _ISynAPIEvents
{
public:
  virtual ~_ISynAPIEvents() {}
  virtual HRESULT STDMETHODCALLTYPE OnSynAPINotify(LONG lReason) = 0;
};

class _ISynDeviceEvents
{
public:
  virtual ~_ISynDeviceEvents() {}
  virtual HRESULT STDMETHODCALLTYPE OnSynDevicePacket(LONG lSequenceNumber) = 0;
};

class _ISynDisplayEvents
{
public:
  virtual ~_ISynDisplayEvents() {}
  virtual HRESULT STDMETHODCALLTYPE OnSynDisplayMessage(LONG lMessage) = 0;
};


class ISynAPI : public IUnknown
{
public:
  virtual ~ISynAPI() {}
  virtual HRESULT STDMETHODCALLTYPE Initialize(void) = 0;
  virtual HRESULT STDMETHODCALLTYPE FindDevice(LONG lConnectionType,
    LONG lDeviceType, LONG *ulHandle) = 0;
  virtual HRESULT STDMETHODCALLTYPE CreateDevice(LONG lHandle,
   ISynDevice **ppDevice) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetProperty(LONG lSpecifier,
    LONG *pValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetStringProperty(LONG lSpecifier,
    unsigned char *pBuffer, LONG *ulBufLen) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetProperty(LONG lSpecifier,
    LONG lValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetEventNotification(HANDLE hEvent) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetEventParameter(LONG *lParameter) = 0;
  virtual HRESULT STDMETHODCALLTYPE PersistState(LONG lStateFlags) = 0;
  virtual HRESULT STDMETHODCALLTYPE RestoreState(LONG lStateFlags) = 0;
  virtual HRESULT STDMETHODCALLTYPE HardwareBroadcast(LONG lAction) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetSynchronousNotification(
   _ISynAPIEvents *pCallbackInstance) = 0;
  virtual HRESULT STDMETHODCALLTYPE ForwardSystemMessage(UINT uMsg,
    WPARAM wParam, LPARAM lParam) = 0;
};

class ISynDevice : public IUnknown
{
public:
  virtual ~ISynDevice() {}

  virtual HRESULT STDMETHODCALLTYPE GetProperty(LONG lSpecifier,
    LONG *pValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetBooleanProperty(LONG lSpecifier,
    LONG *pValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetStringProperty(LONG lSpecifier,
    unsigned char *pBuffer, LONG *ulBufLen) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetProperty(LONG lSpecifier,
   LONG lValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetEventNotification(HANDLE hEvent) = 0;
  virtual HRESULT STDMETHODCALLTYPE CreatePacket(ISynPacket **ppPacket) = 0;
  virtual HRESULT STDMETHODCALLTYPE LoadPacket(ISynPacket *pPacket) = 0;
  virtual HRESULT STDMETHODCALLTYPE ForceMotion(LONG lDeltaX, LONG lDeltaY,
    LONG lButtonState) = 0;
  virtual HRESULT STDMETHODCALLTYPE ForcePacket(ISynPacket *pPacket) = 0;
  virtual HRESULT STDMETHODCALLTYPE Acquire(LONG lFlags) = 0;
  virtual HRESULT STDMETHODCALLTYPE Unacquire(void) = 0;
  virtual HRESULT STDMETHODCALLTYPE CreateDisplay(ISynDisplay **ppDisplay) = 0;
  virtual HRESULT STDMETHODCALLTYPE Select(LONG lHandle) = 0;
  virtual HRESULT STDMETHODCALLTYPE PeekPacket(LONG *plSequence) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetSynchronousNotification(
    _ISynDeviceEvents *pCallbackInstance) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetPropertyDefault(LONG lSpecifier,
    LONG *pValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE BulkTransaction(ULONG ulWriteLength,
    UCHAR *ucWriteBuffer, ULONG ulReadLength, UCHAR *ucReadBuffer) = 0;
  virtual HRESULT STDMETHODCALLTYPE DiagnosticTransaction(ULONG ulWriteLength,
    UCHAR *ucWriteBuffer, ULONG ulReadLength, UCHAR *ucReadBuffer) = 0;
  virtual HRESULT STDMETHODCALLTYPE DiagnosticSelect(LONG lHandle,
    LONG lFlags) = 0;
  virtual HRESULT STDMETHODCALLTYPE ForceMotionWithWheel(LONG lDeltaX,
    LONG lDeltaY, LONG lButtonState, LONG lWheelDelta) = 0;
  virtual HRESULT STDMETHODCALLTYPE ForceMotionWithHorizontalWheel(LONG lDeltaX,
    LONG lDeltaY, LONG lButtonState, LONG lWheelDelta) = 0;
  virtual HRESULT STDMETHODCALLTYPE ValidateProperty(LONG lSpecifier,
    LONG lSynAccessRightType) = 0;
  virtual HRESULT STDMETHODCALLTYPE ForceSecondaryFingerPacket(
    ISynPacket *pPacket) = 0;
  virtual HRESULT STDMETHODCALLTYPE ForceFingerCountPacket(ISynPacket
    *pPacket) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetZoneAction(DWORD dwZoneID,
    DWORD dwActionID, LPTSTR pszPlugInName) = 0;
  virtual HRESULT STDMETHODCALLTYPE ForceMotionWithWheelEx(LONG lDeltaX,
    LONG lDeltaY, LONG lButtonState, LONG lWheelDelta, LONG lFlags) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetBinaryProperty(LONG lSpecifier,
    WORD wSubCode, UCHAR *pucData, WORD nData) = 0;
  virtual HRESULT STDMETHODCALLTYPE CreateGroup(ISynGroup **ppGroup) = 0;
  virtual HRESULT STDMETHODCALLTYPE LoadGroup(ISynGroup *pGroup) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetBinaryProperty(LONG lSpecifier,
    WORD wSubCode, UCHAR *pucData, WORD nData) = 0;
};

class ISynPacket : public IUnknown
{
public:
  virtual ~ISynPacket() {}
  virtual HRESULT STDMETHODCALLTYPE GetProperty(LONG lSpecifier,
    LONG *pValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetProperty(LONG lSpecifier,
    LONG lValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetStringProperty(LONG lSpecifier,
    unsigned char *pBuffer, LONG *ulBufLen) = 0;
  virtual HRESULT STDMETHODCALLTYPE Copy(ISynPacket *pFrom) = 0;
};

class ISynGroup : public IUnknown
{
public:
  virtual ~ISynGroup() {}
  virtual HRESULT STDMETHODCALLTYPE GetProperty(LONG lSpecifier,
    LONG *pValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetProperty(LONG lSpecifier,
    LONG lValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetPropertyByIndex(LONG lSpecifier,
    LONG lIndex, LONG *pValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetPropertyByIndex(LONG lSpecifier,
    LONG lIndex, LONG lValue) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetPacketByIndex(LONG lIndex,
    ISynPacket *pPacket) = 0;
  virtual HRESULT STDMETHODCALLTYPE SetPacketByIndex(LONG lIndex,
    ISynPacket *pPacket) = 0;
  virtual HRESULT STDMETHODCALLTYPE GetPacketPointer(LONG lIndex, 
    ISynPacket **ppPacket) = 0;
  virtual HRESULT STDMETHODCALLTYPE Copy(ISynGroup *pFrom) = 0;
};

#endif //__SynCom_H__
