/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *

File Name:          ServerInfo.c

Description:

Environment (opt):
 
Notes (opt):
  =====================================================================
  Revision   Revision History		Author     Date
  =====================================================================
  
  =====================================================================
****************************************************************************/


#include <string.h>
#include <stdio.h>
#include "InfoMgmt/InfoBase.h"
#include "InfoMgmt/InfoMgmt.h"
#include "GUI/error.h"

/* Description: ServerAddress Operation
 * Module: Server Info
 * Parameter: paddr (the ServerAddress Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */
int ServerInfo_ServerAddress(char *paddr, char *cmd)
{
	/*parameter validity check*/
	if(paddr == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(SERVERINFO_SECTION, SERVERADDRESS_VALUE, "", paddr, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(SERVERINFO_SECTION, SERVERADDRESS_VALUE, paddr, get_tcagentconfig_path());
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}

/* Description: Proxy Address Operation
 * Module: Server Info
 * Parameter: paddr (the ProxyAddress Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int ServerInfo_ProxyAddress(char *paddr, char *cmd)
{
	/*parameter validity check*/
	if(paddr == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(SERVERINFO_SECTION, PROXYADDRESS_VALUE, "", paddr, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(SERVERINFO_SECTION, PROXYADDRESS_VALUE, paddr, get_tcagentconfig_path());
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}

/* Description: ProxyUser Operation
 * Module: Server Info
 * Parameter: puser (the Proxyuser Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int ServerInfo_ProxyUser(char *puser, char *cmd)
{
	/*parameter validity check*/
	if(puser == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(SERVERINFO_SECTION, PROXYUSER_VALUE, "", puser, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(SERVERINFO_SECTION, PROXYUSER_VALUE, puser, get_tcagentconfig_path());
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}

/* Description: ProxyPassword Operation
 * Module: Server Info
 * Parameter: ppwd (the ProxyPassword Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int ServerInfo_ProxyPwd(char *ppwd, char *cmd)
{
	/*parameter validity check*/
	if(ppwd == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(SERVERINFO_SECTION, PROXYPWD_VALUE, "", ppwd, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(SERVERINFO_SECTION, PROXYPWD_VALUE, ppwd, get_tcagentconfig_path());
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}

// Start add by Roc Zhang 2007-9-19
/* Description: UseProxy Operation
 * Module: Server Info
 * Parameter: puseproxy (the pointer of UseProxy Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int ServerInfo_UseProxy(int * puseproxy, char *cmd)
{
	char temp_value[10];
	int  ret;
	
        /*parameter validity check*/
        if(puseproxy == NULL || cmd == NULL)
        {
                WriteLog(INFOMGMT_ERR_PARAM);
                return INFOMGMT_ERR_PARAM;
        }

	if(!strcmp(cmd, "GET"))
	{
		ret =  Ini_ReadString(SERVERINFO_SECTION, USEPROXY_VALUE, STRING_FALSE, temp_value, get_tcagentconfig_path());
		if ( 0 == ret ) // SUCCEED
		{
			if ( strcasecmp( temp_value, STRING_TRUE ) == 0 )
				*puseproxy = 1;
			else
				*puseproxy = 0;
		}	
		return ret;	
	}
	else if(!strcmp(cmd, "SET"))
	{
		if ( *puseproxy )
			strcpy( temp_value, STRING_TRUE );
		else
			strcpy( temp_value, STRING_FALSE );
			
		return Ini_WriteString(SERVERINFO_SECTION, USEPROXY_VALUE, temp_value, get_tcagentconfig_path());	
	}       

	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}
// End add

/* Description: Construct Server Info from config file
 * Module: Server Info
 * Parameter: pSI (the ServerInfo structure which we need get)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int ServerInfo_Construct(ServerInfo *pSI)
{
	int ret = 0, err = 0;
	/*parameter validity check*/
	if(pSI == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	memset(pSI, 0, sizeof(ServerInfo));
	if(ret = Ini_ReadString(SERVERINFO_SECTION, SERVERADDRESS_VALUE, "", pSI->ServerAddress, get_tcagentconfig_path()))
	{        
#ifdef DEBUG             
printf("ServerInfoErrno1: %d\n", ret); 
#endif				
		err = ret;
	}
	if(ret = Ini_ReadString(SERVERINFO_SECTION, PROXYADDRESS_VALUE, "", pSI->ProxyAddress, get_tcagentconfig_path()))
	{        
#ifdef DEBUG             
printf("ServerInfoErrno2: %d\n", ret); 
#endif				
		err = ret;
	}

	if (pSI->ProxyAddress==NULL || strlen(pSI->ProxyAddress)<=0 || strcmp(pSI->ProxyAddress, "")==0)
	{
		ProxyInfo_Construct(pSI->ProxyAddress);
	}
	if(ret = Ini_ReadString(SERVERINFO_SECTION, PROXYUSER_VALUE, "", pSI->ProxyUser, get_tcagentconfig_path()))
        {        
#ifdef DEBUG             
printf("ServerInfoErrno3: %d\n", ret); 
#endif
		
		err = ret;
	}
	if(ret = Ini_ReadString(SERVERINFO_SECTION, PROXYPWD_VALUE, "", pSI->ProxyPwd, get_tcagentconfig_path()))
        {        
#ifdef DEBUG             
printf("ServerInfoErrno4: %d\n", ret); 
#endif
		err = ret;
	}

// Start add by Roc Zhang 2007-9-19
	if( ret = ServerInfo_UseProxy( &pSI->UseProxy, "GET") )
        {        
#ifdef DEBUG             
printf("ServerInfoErrno5: %d\n", ret); 
#endif
		err = ret;
	}
// End add
			

	if(err)
	{
		WriteLog(INFOMGMT_ERR_SERVERINFO);
		return INFOMGMT_ERR_SERVERINFO;
	}
	else
		return 0;
}


