# telepathy-butterfly - an MSN connection manager for Telepathy
#
# Copyright (C) 2010 Collabora Ltd.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import logging
import dbus

import telepathy

from tpufa.connection import UfAConnection

__all__ = ['UfAProtocol']

logger = logging.getLogger('UfA.Protocol')

class UfAProtocol(telepathy.server.Protocol):

    _proto = "ufa"
    _vcard_field = "tel"
    _english_name = "Ubuntu For Android"
    _icon = "im-ufa"

    _requestable_channel_classes = [
        ({telepathy.CHANNEL_INTERFACE + '.ChannelType': dbus.String(telepathy.CHANNEL_TYPE_TEXT),
          telepathy.CHANNEL_INTERFACE + '.TargetHandleType': dbus.UInt32(telepathy.HANDLE_TYPE_CONTACT)},
         [telepathy.CHANNEL_INTERFACE + '.TargetHandle',
          telepathy.CHANNEL_INTERFACE + '.TargetID']),

        ({telepathy.CHANNEL_INTERFACE + '.ChannelType': dbus.String(telepathy.CHANNEL_TYPE_CALL),
          telepathy.CHANNEL_INTERFACE + '.TargetHandleType': dbus.UInt32(telepathy.HANDLE_TYPE_CONTACT)},
         [telepathy.CHANNEL_INTERFACE + '.TargetHandle',
          telepathy.CHANNEL_INTERFACE + '.TargetID',
          telepathy.CHANNEL_TYPE_CALL + '.InitialAudio']),
    ]

    _supported_interfaces = [
            telepathy.CONNECTION_INTERFACE_ALIASING,
            telepathy.CONNECTION_INTERFACE_CAPABILITIES,
            telepathy.CONNECTION_INTERFACE_CONTACT_CAPABILITIES,
            telepathy.CONNECTION_INTERFACE_CONTACTS,
            telepathy.CONNECTION_INTERFACE_REQUESTS,
        ]

    def __init__(self, connection_manager):
        telepathy.server.Protocol.__init__(self, connection_manager, 'ufa')

    def create_connection(self, connection_manager, parameters):
        return UfAConnection(self, connection_manager, parameters)
