.pragma library


var PROTOCOL_LABEL_AIM      = "AIM";
var PROTOCOL_LABEL_MSN      = "Windows Live";
var PROTOCOL_LABEL_YAHOO    = "Yahoo";
var PROTOCOL_LABEL_SKYPE    = "Skype";
var PROTOCOL_LABEL_QQ       = "QQ";
var PROTOCOL_LABEL_GTALK    = "Google Talk";
var PROTOCOL_LABEL_ICQ      = "ICQ";
var PROTOCOL_LABEL_JABBER   = "Jabber";
var PROTOCOL_LABEL_OTHER    = "Other";

var PROTOCOL_TYPE_CUSTOM    = "im";
var PROTOCOL_TYPE_AIM       = "aim";
var PROTOCOL_TYPE_MSN       = "msn";
var PROTOCOL_TYPE_YAHOO     = "yahoo";
var PROTOCOL_TYPE_SKYPE     = "skype";
var PROTOCOL_TYPE_GTALK     = "google_talk";
var PROTOCOL_TYPE_ICQ       = "icq";
var PROTOCOL_TYPE_JABBER    = "jabber";
var PROTOCOL_TYPE_OTHER     = "other";

var ADDRESS_LABEL_HOME      = "Home";
var ADDRESS_LABEL_WORK      = "Work";
var ADDRESS_LABEL_OTHER     = "Other";

var ADDRESS_TYPE_HOME       = "home";
var ADDRESS_TYPE_WORK       = "work";
var ADDRESS_TYPE_OTHER      = "other";

var phoneSubTypes = [ "Mobile", "Home", "Work", "Work Fax", "Home Fax", "Pager", "Other" ];

var emailSubTypes = [ "Home", "Work", "Other" ];

var postalAddressSubTypes = [ ADDRESS_LABEL_HOME,
                              ADDRESS_LABEL_WORK,
                              ADDRESS_LABEL_OTHER ];

var IMSubTypes = [ PROTOCOL_LABEL_GTALK,
                   PROTOCOL_LABEL_AIM,
                   PROTOCOL_LABEL_MSN,
                   PROTOCOL_LABEL_YAHOO,
                   PROTOCOL_LABEL_SKYPE,
                   PROTOCOL_LABEL_QQ,
                   PROTOCOL_LABEL_ICQ,
                   PROTOCOL_LABEL_JABBER ];

var supportedTypes = [
            {
                name: "Phone",
                delegateSource: "TextContactDetailsDelegate.qml",
                items: "phoneNumbers",
                newItemText: "Add a phone number",
                newItemType: "ContactPhoneNumber",
                actionIcon: "../assets/contact_icon_message.png",
                displayField: "number",
                subTypes: phoneSubTypes,
                createOnNew: true
            },
            {
                name: "Email",
                delegateSource: "TextContactDetailsDelegate.qml",
                items: "emails",
                newItemText: "Add an email address",
                newItemType: "ContactEmailAddress",
                actionIcon: "../assets/contact_icon_email.png",
                displayField: "emailAddress",
                subTypes: emailSubTypes,
                createOnNew: true
            },
            {
                name: "Address",
                delegateSource: "AddressContactDetailsDelegate.qml",
                items: "addresses",
                newItemText: "Add a postal address",
                newItemType: "ContactAddress",
                actionIcon: "../assets/contact_icon_location.png",
                subTypes: postalAddressSubTypes
            },
            {
                name: "IM",
                delegateSource: "TextContactDetailsDelegate.qml",
                items: "onlineAccounts",
                newItemText: "Add an online account",
                displayField: "accountUri",
                newItemType: "ContactOnlineAccount",
                actionIcon: "../assets/contact_icon_IM.png",
                subTypes: IMSubTypes
            }
        ];

function getTypesWithNoItems(contact) {
    var result = [];
    for (var i = 0; i < supportedTypes.length; i++) {
        var currentType = supportedTypes[i];
        var detailsList = contact[currentType.items];
        /* In newly created contacts the "plural" detail properties (such as "emails")
           do not seem to exist, so allow adding new details for the type in that case. */
        if (detailsList === undefined || detailsList.length == 0) {
            result.push(currentType);
        }
    }
    return result;
}

function getDetailSubType(detail) {
    if (!detail) {
        return "";
    }
    /* Phone numbers have a special field for the subType */
    if (detail.definitionName == "PhoneNumber") {
        if (detail.subTypes.indexOf("home") > -1) {
            if (detail.subTypes.indexOf("voice") > -1) {
                return "Home";
            } else if (detail.subTypes.indexOf("fax") > -1) {
                return "Home Fax";
            }
        } else if (detail.subTypes.indexOf("work") > -1) {
            if (detail.subTypes.indexOf("voice") > -1) {
                return "Work";
            } else if (detail.subTypes.indexOf("fax") > -1) {
                return "Work Fax";
            } else if (detail.subTypes.indexOf("pref") > -1) {
                return "Company Main";
            } else if (detail.subTypes.indexOf("cell") > -1) {
                return "Work Mobile";
            } else if (detail.subTypes.indexOf("pager") > -1) {
                return "Work Pager";
            }
        } else if (detail.subTypes.indexOf("cell") > -1) {
            return "Mobile";
        } else if (detail.subTypes.indexOf("pager") > -1) {
            return "Pager";
        } else if (detail.subTypes.indexOf("other") > -1) {
            if (detail.subTypes.indexOf("fax") > -1) {
                return "Other Fax";
            } else {
                return "Other";
            }
        } else if (detail.subTypes.indexOf("callback") > -1) {
            return "Callback";
        } else if (detail.subTypes.indexOf("car") > -1) {
            return "Car";
        } else if (detail.subTypes.indexOf("isdn") > -1) {
            return "ISDN";
        } else if (detail.subTypes.indexOf("pref") > -1) {
            return "Main";
        } else if (detail.subTypes.indexOf("radio") > -1) {
            return "Radio";
        } else if (detail.subTypes.indexOf("telex") > -1) {
            return "Telex";
        } else if (detail.subTypes.indexOf("tty_tdd") > -1) {
            return "TTY TDD";
        } else if (detail.subTypes.indexOf("assistant") > -1) {
            return "Assistant";
        } else if (detail.subTypes.indexOf("msg") > -1) {
            return "MMS";
        } else {
            return detail.subTypes[0];
        }
    } else if (detail.definitionName == "OnlineAccount") {
        var protocol = detail.protocol;
        if (protocol == PROTOCOL_TYPE_CUSTOM) {
            if (detail.contexts.indexOf("PROTOCOL=QQ") > -1) {
                return PROTOCOL_LABEL_QQ;
            } else {
                return detail.contexts[0].split("PROTOCOL=")[1];
            }
        } else if (protocol == PROTOCOL_TYPE_AIM) {
            return PROTOCOL_LABEL_AIM;
        } else if (protocol == PROTOCOL_TYPE_MSN) {
            return PROTOCOL_LABEL_MSN;
        } else if (protocol == PROTOCOL_TYPE_YAHOO) {
            return PROTOCOL_LABEL_YAHOO;
        } else if (protocol == PROTOCOL_TYPE_SKYPE) {
            return PROTOCOL_LABEL_SKYPE;
        } else if (protocol == PROTOCOL_TYPE_GTALK) {
            return PROTOCOL_LABEL_GTALK;
        } else if (protocol == PROTOCOL_TYPE_ICQ) {
            return PROTOCOL_LABEL_ICQ;
        } else if (protocol == PROTOCOL_TYPE_JABBER) {
            return PROTOCOL_LABEL_JABBER;
        } else {
            console.log("Invalid protocol: " + protocol);
            return PROTOCOL_LABEL_OTHER;
        }
    } else if (detail.definitionName == "Address") {
        var subTypes = detail.subTypes
        if (subTypes.indexOf(ADDRESS_TYPE_HOME) > -1) {
            return ADDRESS_LABEL_HOME;
        } else if (subTypes.indexOf(ADDRESS_TYPE_WORK) > -1) {
            return ADDRESS_LABEL_WORK;
        } else if (subTypes.indexOf(ADDRESS_TYPE_OTHER) > -1) {
            return ADDRESS_LABEL_OTHER;
        } else {
            return subTypes[0];
        }
    } else {
        // The backend supports multiple types but we can just handle one,
        // so let's pick just the first
        var type = "";
        for (var i = 0; i < detail.contexts.length; i++) {
            if (detail.contexts[i].indexOf("type=") == 0) {
                type = detail.contexts[i].substring(5);
                break;
            }
        }

        if (type == "home") {
            return "Home";
        } else if (type == "work") {
            return "Work";
        } else if (type == "internet") {
            return "Mobile";
        } else if (type == "other") {
            return "Other";
        } else {
            return type;
        }
    }

    return "";
}

function updateContext(detail, key, values) {
    // We need a copy because QML list properties can't
    // be directly modified, they need to be reassigned a modified copy.
    var contexts = detail.contexts;
    for (var i = 0; i < contexts.length; i++) {
        if (contexts[i].indexOf(key) == 0) {
            // Modify the first value in the list, since we only check for the
            // first value during the parse phase.
            contexts[i] = key + values;
            detail.contexts = contexts;
            return;
        }
    }
    contexts.push(key + values);
    detail.contexts = contexts;
}

function setDetailSubType(detail, newSubType) {
    if (!detail) {
        return;
    }

    /* Phone numbers have a special field for the subType */
    if (detail.definitionName == "PhoneNumber") {
        if (newSubType == "Home") {
            detail.subTypes = [ "home", "voice" ];
        } else if (newSubType == "Work") {
            detail.subTypes = [ "work", "voice" ];
        } else if (newSubType == "Work Fax") {
            detail.subTypes = [ "work", "fax" ];
        } else if (newSubType == "Home Fax") {
            detail.subTypes = [ "home", "fax" ];
        } else if (newSubType == "Mobile") {
            detail.subTypes = [ "cell" ];
        } else if (newSubType == "Pager") {
            detail.subTypes = [ "pager" ];
        } else if (newSubType == "Other" ) {
            detail.subTypes = [ "other" ];
        } else if (newSubType == "Callback" ) {
            detail.subTypes = [ "callback" ];
        } else if (newSubType == "Car" ) {
            detail.subTypes = [ "car" ];
        } else if (newSubType == "Company Main" ) {
            detail.subTypes = [ "work", "pref" ];
        } else if (newSubType == "ISDN" ) {
            detail.subTypes = [ "isdn" ];
        } else if (newSubType == "Main" ) {
            detail.subTypes = [ "pref" ];
        } else if (newSubType == "Other Fax" ) {
            detail.subTypes = [ "other", "fax" ];
        } else if (newSubType == "Radio" ) {
            detail.subTypes = [ "radio" ];
        } else if (newSubType == "Telex" ) {
            detail.subTypes = [ "telex" ];
        } else if (newSubType == "TTY TDD" ) {
            detail.subTypes = [ "tty_tdd" ];
        } else if (newSubType == "Work Mobile" ) {
            detail.subTypes = [ "work", "cell" ];
        } else if (newSubType == "Work Pager" ) {
            detail.subTypes = [ "work", "pager" ];
        } else if (newSubType == "Assistant" ) {
            detail.subTypes = [ "assistant" ];
        } else if (newSubType == "MMS" ) {
            detail.subTypes = [ "msg" ];
        } else {
            detail.subTypes = [ newSubType ];
        }
    } else if (detail.definitionName == "OnlineAccount") {
        var protocol = newSubType;
        if (protocol == PROTOCOL_LABEL_AIM) {
            detail.protocol = PROTOCOL_TYPE_AIM;
        } else if (protocol == PROTOCOL_LABEL_MSN) {
            detail.protocol = PROTOCOL_TYPE_MSN;
        } else if (protocol == PROTOCOL_LABEL_YAHOO) {
            detail.protocol = PROTOCOL_TYPE_YAHOO;
        } else if (protocol == PROTOCOL_LABEL_SKYPE) {
            detail.protocol = PROTOCOL_TYPE_SKYPE;
        } else if (protocol == PROTOCOL_LABEL_QQ) {
            detail.protocol = PROTOCOL_TYPE_CUSTOM;
            updateContext(detail, "PROTOCOL=", "QQ");
        } else if (protocol == PROTOCOL_LABEL_GTALK) {
            detail.protocol = PROTOCOL_TYPE_GTALK;
        } else if (protocol == PROTOCOL_LABEL_ICQ) {
            detail.protocol = PROTOCOL_TYPE_ICQ;
        } else if (protocol == PROTOCOL_LABEL_JABBER) {
            detail.protocol = PROTOCOL_TYPE_JABBER;
        } else {
            detail.protocol = PROTOCOL_TYPE_CUSTOM;
            updateContext(detail, "PROTOCOL=", protocol);
        }
    } else if (detail.definitionName == "Address") {
        if (newSubType == ADDRESS_LABEL_HOME) {
            detail.subTypes = [ ADDRESS_TYPE_HOME ];
        } else if (newSubType == ADDRESS_LABEL_WORK) {
            detail.subTypes = [ ADDRESS_TYPE_WORK ];
        } else if (newSubType == ADDRESS_LABEL_OTHER) {
            detail.subTypes = [ ADDRESS_TYPE_OTHER ];
        } else {
            detail.subTypes [ newSubType ]; 
        }
    } else {
        var types = ""
        if (newSubType == "Home") {
            types = "home";
        } else if (newSubType == "Work") {
            types = "work";
        } else if (newSubType == "Mobile") {
            types = "internet";
        } else if (newSubType == "Other") {
            types = "other";
        } else {
            types = newSubType;
        }

        updateContext(detail, "type=", types);
    }
}

