#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <stdio.h>

#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gconf/gconf-client.h>

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

gboolean get_touchcruiser_mode ( void );
void     set_tooltip ( GtkStatusIcon * );
void     file_monitor_changed ( GFileMonitor *, GFile *, GFile *, GFileMonitorEvent, gpointer );
void     gconf_changed ( GConfClient *, guint, GConfEntry  *, gpointer );

gboolean iconflag;

int
main (int   argc,
      char *argv[])
{
    gboolean       rtn;
    GFile         *file;
    GtkStatusIcon *sys_t;
    GFileMonitor  *monitor;
	GConfClient   *client;

#ifdef HAVE_CONFIG_H
    bindtextdomain ( GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR );
    bind_textdomain_codeset ( GETTEXT_PACKAGE, "UTF-8" );
    textdomain ( GETTEXT_PACKAGE );
#endif

    gtk_init ( &argc, &argv );

	client = gconf_client_get_default ();

    sys_t = gtk_status_icon_new ();
    rtn = get_touchcruiser_mode ();
    if( rtn ){
        gtk_status_icon_set_from_file ( sys_t, "/usr/share/touchcruiser/cursormode32.png" );
        gtk_status_icon_set_tooltip ( sys_t, _("OPTICAL POINT：CURSOR MODE") );
    } else {
        gtk_status_icon_set_from_file ( sys_t, "/usr/share/touchcruiser/scrollmode32.png" );
        gtk_status_icon_set_tooltip ( sys_t, _("OPTICAL POINT：WHEEL MODE") );
    }
    gtk_status_icon_set_visible ( sys_t,TRUE );
    iconflag = rtn;

    file = g_file_new_for_path ( "/proc/oj6sh_wheel" );
    monitor = g_file_monitor_file ( file, G_FILE_MONITOR_NONE, NULL, NULL );
    g_signal_connect ( monitor, "changed",
                       G_CALLBACK (file_monitor_changed),
                       sys_t );

	gconf_client_add_dir ( client, "/apps/touchcruiser", GCONF_CLIENT_PRELOAD_NONE, NULL );
	gconf_client_notify_add ( client, "/apps/touchcruiser/value", 
                             (GConfClientNotifyFunc) gconf_changed, sys_t, NULL, NULL );

    gtk_main ();

    return 0;
}

gboolean
get_touchcruiser_mode (void)
{
    FILE *fp;
    char  mode;

    fp = fopen ( "/proc/oj6sh_wheel", "r" );
    if( fp == NULL ){
        return TRUE;
    }

    mode = getc ( fp );
    fclose ( fp );
    if( mode == '0' )
    {
        return TRUE;
    } else {
        return FALSE;
    }
}

void
file_monitor_changed ( GFileMonitor      *monitor,
                       GFile             *file,
                       GFile             *other_file,
                       GFileMonitorEvent  event,
                       gpointer           user_data )
{
    if( event == G_FILE_MONITOR_EVENT_CHANGED ||
        event == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT ||
        event == G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED ){
        set_tooltip ( user_data );
    }
}

void
gconf_changed ( GConfClient *client,
                guint        conn_id,
                GConfEntry  *entry,
                gpointer     user_data )
{
    set_tooltip ( user_data );
}

void
set_tooltip ( GtkStatusIcon *status_icon )
{
    gboolean rtn;

    rtn = get_touchcruiser_mode ();
    if( rtn ){
        if( iconflag == FALSE ){
            gtk_status_icon_set_from_file ( status_icon, "/usr/share/touchcruiser/cursormode32.png" );
            gtk_status_icon_set_tooltip ( status_icon, _("OPTICAL POINT：CURSOR MODE") );
            gtk_status_icon_set_visible ( status_icon, TRUE );
            iconflag = TRUE;
        }
    } else {
        if( iconflag == TRUE ){
            gtk_status_icon_set_from_file ( status_icon, "/usr/share/touchcruiser/scrollmode32.png" );
            gtk_status_icon_set_tooltip ( status_icon, _("OPTICAL POINT：WHEEL MODE") );
            gtk_status_icon_set_visible ( status_icon, TRUE );
            iconflag = FALSE;
        }
    }
}
