import unittest

from urecovery import grub

class TestCase(unittest.TestCase):
    #{{{def testSetter(self):
    def testSetter(self):
        opts = "priority=critical vga=normal quiet cdrom-detect/try-hdd=true file=/cdrom/install/recovery-preseed.cfg".split(' ')
        menuentry = grub.GrubMenuEntry(title="Restore Ubuntu to factory state", 
                                 disk_id=1, part_id=1, kopts=opts)
        self.assertFalse(menuentry.check())
    #}}}

    #{{{def testGrubCfg(self):
    def testGrubCfg(self):
        menu = grub.GrubCfg()
        menu.ver = 2
        self.assertTrue(menu.name == 'grub.cfg')
        menu.ver = 1
        self.assertTrue(menu.name == 'menu.lst')
        menu.addEntry(grub.GrubMenuEntry(title="Restore"))
        print menu.genStr()
        menu.ver = 2
        print menu.genStr()
        menu.addEntry(grub.GrubMenuEntry(title="Restore", chainload=True))
        print menu.genStr()
    #}}}
pass

if __name__ == '__main__':
    unittest.main()

