import unittest
import os
import sys

pwd = os.path.dirname(os.curdir)
fakelibdir = os.path.join(pwd, 'tests', 'fakelib')
if fakelibdir not in sys.path:
    sys.path.insert(0, fakelibdir)
    print('Added {0} to PYTHONPATH'.format(fakelibdir))

# load testsuites from module.
from tests import test_common, test_grubinstaller

def suite():
    suite = unittest.TestSuite()
    suite.addTest(test_common.suite())
    suite.addTest(test_grubinstaller.suite())
    return suite

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
