/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010-2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 *
 */

#ifndef __SYNCDAEMON_METADATA_H__
#define __SYNCDAEMON_METADATA_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_METADATA                (syncdaemon_metadata_get_type ())
#define SYNCDAEMON_METADATA(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_METADATA, SyncdaemonMetadata))
#define SYNCDAEMON_IS_METADATA(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_METADATA))
#define SYNCDAEMON_METADATA_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_METADATA, SyncdaemonMetadataClass))
#define SYNCDAEMON_IS_METADATA_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_METADATA))
#define SYNCDAEMON_METADATA_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_METADATA, SyncdaemonMetadataClass))

typedef struct _SyncdaemonMetadataPrivate SyncdaemonMetadataPrivate;

typedef struct {
	GObject parent;
	SyncdaemonMetadataPrivate *priv;
} SyncdaemonMetadata;

typedef struct {
	GObjectClass parent_class;
} SyncdaemonMetadataClass;

GType               syncdaemon_metadata_get_type (void);

SyncdaemonMetadata *syncdaemon_metadata_new (void);
SyncdaemonMetadata *syncdaemon_metadata_new_from_hash_table (GHashTable *hash);
const gchar        *syncdaemon_metadata_get_path (SyncdaemonMetadata *metadata);
void                syncdaemon_metadata_set_path (SyncdaemonMetadata *metadata, const gchar *path);
const gchar        *syncdaemon_metadata_get_local_hash (SyncdaemonMetadata *metadata);
void                syncdaemon_metadata_set_local_hash (SyncdaemonMetadata *metadata, const gchar *local_hash);
const gchar        *syncdaemon_metadata_get_server_hash (SyncdaemonMetadata *metadata);
void                syncdaemon_metadata_set_server_hash (SyncdaemonMetadata *metadata, const gchar *server_hash);
const gchar        *syncdaemon_metadata_get_share_id (SyncdaemonMetadata *metadata);
void                syncdaemon_metadata_set_share_id (SyncdaemonMetadata *metadata, const gchar *share_id);
const gchar        *syncdaemon_metadata_get_node_id (SyncdaemonMetadata *metadata);
void                syncdaemon_metadata_set_node_id (SyncdaemonMetadata *metadata, const gchar *node_id);
gboolean            syncdaemon_metadata_get_is_synced (SyncdaemonMetadata *metadata);
void                syncdaemon_metadata_set_is_synced (SyncdaemonMetadata *metadata, gboolean is_synced);

G_END_DECLS

#endif
