# ubuntuone.storageprotocol.tests.test_upload_offset -
#     tests for the offset argument of BeginContent messages of upload requests
#
# Author: John R. Lenton <john.lenton@canonical.com>
#
# Copyright (C) 2009 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License version 3,
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Tests for begin_content.offset"""

import unittest
from ubuntuone.storageprotocol.request import RequestHandler
from ubuntuone.storageprotocol.client import PutContent
from ubuntuone.storageprotocol import protocol_pb2
from contrib.mocker import Mocker, ANY

class TestOffset(unittest.TestCase):
    """
    Tests for BEGIN_CONTENT's offset attribute
    """
    def test_offset(self):
        """
        Test that, if the server's BEGIN_CONTENT message specifies an offset,
        the file to be uploaded is seek'ed to the right position.
        """
        offset = 23
        mocker = Mocker()
        transport = mocker.mock()
        transport.registerProducer(ANY, streaming=True)
        transport.write(ANY)
        mocker.count(1, None) # I don't really care how many times
        fd = mocker.mock()
        fd.seek(offset) # this is really all I care about
        fd.read(ANY)
        mocker.result('')
        mocker.replay()

        protocol = RequestHandler()
        protocol.transport = transport
        pc = PutContent(protocol, 'share', 'node', '', '', 0, 0, 0, fd)
        message = protocol_pb2.Message()
        message.type = protocol_pb2.Message.BEGIN_CONTENT
        message.begin_content.offset = offset
        pc.start()
        pc.processMessage(message)

    def test_offset_none(self):
        """
        Test that, if the server's BEGIN_CONTENT message does *not* specify an
        offset, the file to be uploaded is seek'ed to the right position.
        """
        mocker = Mocker()
        transport = mocker.mock()
        transport.registerProducer(ANY, streaming=True)
        transport.write(ANY)
        mocker.count(1, None) # I don't really care how many times
        fd = mocker.mock()
        fd.seek(0) # this is really all I care about
        fd.read(ANY)
        mocker.result('')
        mocker.replay()

        protocol = RequestHandler()
        protocol.transport = transport
        pc = PutContent(protocol, 'share', 'node', '', '', 0, 0, 0, fd)
        message = protocol_pb2.Message()
        message.type = protocol_pb2.Message.BEGIN_CONTENT
        pc.start()
        pc.processMessage(message)
