import Qt 4.7
import UnityApplications 1.0 /* Necessary for the ImageProvider serving image://icons/theme_name/icon_name */
import Unity2d 1.0 /* Necessary for QSortFilterProxyModelQML */
import gconf 1.0

Item {
    property variant model: PageModel {
        /* model.entrySearchQuery is copied over to all place entries's globalSearchQuery property */
        onEntrySearchQueryChanged: {
            for (var i = 0; i < dash.places.rowCount(); i++) {
                dash.places.get(i).globalSearchQuery = entrySearchQuery
            }
        }
    }

    /* Either globalSearch is shown or buttons are shown depending on globalSearchActive */
    property bool globalSearchActive: model.entrySearchQuery != ""

    ListViewWithScrollbar {
        id: globalSearch

        opacity: globalSearchActive ? 1 : 0
        anchors.fill: parent

        list.model: dash.places

        list.delegate: UnityDefaultRenderer {
            /* -2 is here because no rightMargin is set in ListViewWithScrollbar.list yet */
            width: ListView.view.width-2

            parentListView: list
            placeEntryModel: modelData
            displayName: modelData.name
            iconHint: modelData.icon

            /* Filter out results for which the corresponding group's renderer
               is 'UnityEmptySearchRenderer'.
               Each result has a column (the second one) containing the id of
               the group it belongs to (groupId).
            */
            model:  QSortFilterProxyModelQML {
                model: modelData.globalResultsModel

                /* FIXME: we ignore the groupId with renderer 'UnityEmptySearchRenderer'
                   by hardcoding it instead of looking it up in the Place's
                   groupsModel as Unity does.

                   Two solutions could be envisioned:
                   1) Actually looking for the row in the Place's groupsModel
                      that has in its first column 'UnityEmptySearchRenderer'.
                      That would require adding an API in libqtdee's DeeListModel.
                   2) Changing the behaviour of the place daemons so that the
                      Place's globalResultsModel is empty when there are no
                      results. The applications place does that but not the
                      files place.
                */
                property int ignoredGroupId: 5
                filterRole: 2 /* groupId column */
                filterRegExp: RegExp("^[^%1]$".arg(ignoredGroupId)) /* anything but the ignoredGroupId */
            }
        }
    }

    Flow {
        id: buttons

        opacity: globalSearchActive ? 0 : 1
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter

        width: 692
        height: 348
        spacing: 62

        HomeButton {
            label: u2d.tr("Office Apps")
            icon: "image://icons/office"
            onClicked: activatePlaceEntry("/usr/share/unity/places/applications.place", "Files", 5)
        }

        HomeButton {
            label: u2d.tr("Games")
            icon: "image://icons/unity-icon-theme/games"
            onClicked: activatePlaceEntry("/usr/share/unity/places/applications.place", "Files", 2)
        }

        HomeButtonApplication {
	    label: u2d.tr("Music")
            icon: "image://icons/unity-icon-theme/music"
	    desktopFile: "rhythmbox.desktop"
	}

        HomeButtonApplication {
	    label: u2d.tr("Photos")
            icon: "image://icons/unity-icon-theme/photos"
	    desktopFile: "shotwell.desktop"
	}

        HomeButton {
            label: u2d.tr("Multimedia Apps")
            icon: "/usr/share/icons/hicolor/128x128/apps/multimedia.svg"
            onClicked: activatePlaceEntry("/usr/share/unity/places/applications.place", "Files", 4)
        }

	HomeButtonApplication {
	    desktopFile: "voda.desktop"
	}

        HomeButton {
            label: u2d.tr("System Settings")
            icon: "/usr/share/icons/hicolor/128x128/apps/settings.svg"
            onClicked: activatePlaceEntry("/usr/share/unity/places/applications.place", "Files", 6)
        }

        HomeButton {
            icon: "image://icons/unity-icon-theme/softwarecentre"
            label: u2d.tr("Get New Apps")

            LauncherApplication {
                id: software_center
                desktop_file: "/usr/share/applications/ubuntu-software-center.desktop"
            }

            onClicked: {
                dashView.active = false
                software_center.activate()
            }
        }

    }
}
