/* spaces-manager.c generated by valac 0.10.0, the Vala compiler
 * generated from spaces-manager.vala, do not modify */

/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Jason Smith <jason.smith@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <unity-private.h>
#include <glib/gi18n-lib.h>
#include <clutter/clutter.h>
#include <mutter-plugins.h>
#include <math.h>
#include <float.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <unity.h>
#include <gee.h>
#include <gdk/gdk.h>


#define UNITY_TYPE_SPACES_BUTTON_CONTROLLER (unity_spaces_button_controller_get_type ())
#define UNITY_SPACES_BUTTON_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SPACES_BUTTON_CONTROLLER, UnitySpacesButtonController))
#define UNITY_SPACES_BUTTON_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SPACES_BUTTON_CONTROLLER, UnitySpacesButtonControllerClass))
#define UNITY_IS_SPACES_BUTTON_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SPACES_BUTTON_CONTROLLER))
#define UNITY_IS_SPACES_BUTTON_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SPACES_BUTTON_CONTROLLER))
#define UNITY_SPACES_BUTTON_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SPACES_BUTTON_CONTROLLER, UnitySpacesButtonControllerClass))

typedef struct _UnitySpacesButtonController UnitySpacesButtonController;
typedef struct _UnitySpacesButtonControllerClass UnitySpacesButtonControllerClass;
typedef struct _UnitySpacesButtonControllerPrivate UnitySpacesButtonControllerPrivate;

#define UNITY_TYPE_SPACES_MANAGER (unity_spaces_manager_get_type ())
#define UNITY_SPACES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SPACES_MANAGER, UnitySpacesManager))
#define UNITY_SPACES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SPACES_MANAGER, UnitySpacesManagerClass))
#define UNITY_IS_SPACES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SPACES_MANAGER))
#define UNITY_IS_SPACES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SPACES_MANAGER))
#define UNITY_SPACES_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SPACES_MANAGER, UnitySpacesManagerClass))

typedef struct _UnitySpacesManager UnitySpacesManager;
typedef struct _UnitySpacesManagerClass UnitySpacesManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_TYPE_WORKSPACE_CLONE (unity_workspace_clone_get_type ())
#define UNITY_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_WORKSPACE_CLONE, UnityWorkspaceClone))
#define UNITY_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_WORKSPACE_CLONE, UnityWorkspaceCloneClass))
#define UNITY_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_WORKSPACE_CLONE))
#define UNITY_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_WORKSPACE_CLONE))
#define UNITY_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_WORKSPACE_CLONE, UnityWorkspaceCloneClass))

typedef struct _UnityWorkspaceClone UnityWorkspaceClone;
typedef struct _UnityWorkspaceCloneClass UnityWorkspaceCloneClass;
typedef struct _UnityWorkspaceClonePrivate UnityWorkspaceClonePrivate;

#define UNITY_TYPE_PLUGIN (unity_plugin_get_type ())
#define UNITY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLUGIN, UnityPlugin))
#define UNITY_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLUGIN, UnityPluginClass))
#define UNITY_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLUGIN))
#define UNITY_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLUGIN))
#define UNITY_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLUGIN, UnityPluginClass))

typedef struct _UnityPlugin UnityPlugin;
typedef struct _UnityPluginClass UnityPluginClass;

#define UNITY_TYPE_EXPOSE_CLONE (unity_expose_clone_get_type ())
#define UNITY_EXPOSE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_EXPOSE_CLONE, UnityExposeClone))
#define UNITY_EXPOSE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_EXPOSE_CLONE, UnityExposeCloneClass))
#define UNITY_IS_EXPOSE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_EXPOSE_CLONE))
#define UNITY_IS_EXPOSE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_EXPOSE_CLONE))
#define UNITY_EXPOSE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_EXPOSE_CLONE, UnityExposeCloneClass))

typedef struct _UnityExposeClone UnityExposeClone;
typedef struct _UnityExposeCloneClass UnityExposeCloneClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

#define UNITY_TYPE_EXPOSE_MANAGER (unity_expose_manager_get_type ())
#define UNITY_EXPOSE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManager))
#define UNITY_EXPOSE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManagerClass))
#define UNITY_IS_EXPOSE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_EXPOSE_MANAGER))
#define UNITY_IS_EXPOSE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_EXPOSE_MANAGER))
#define UNITY_EXPOSE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManagerClass))

typedef struct _UnityExposeManager UnityExposeManager;
typedef struct _UnityExposeManagerClass UnityExposeManagerClass;
typedef struct _UnitySpacesManagerPrivate UnitySpacesManagerPrivate;
typedef struct _Block3Data Block3Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block4Data Block4Data;
typedef struct _UnityPluginPrivate UnityPluginPrivate;
typedef struct _Block6Data Block6Data;

struct _UnitySpacesButtonController {
	UnityLauncherScrollerChildController parent_instance;
	UnitySpacesButtonControllerPrivate * priv;
};

struct _UnitySpacesButtonControllerClass {
	UnityLauncherScrollerChildControllerClass parent_class;
};

struct _UnitySpacesButtonControllerPrivate {
	UnitySpacesManager* _parent;
};

struct _UnityWorkspaceClone {
	ClutterGroup parent_instance;
	UnityWorkspaceClonePrivate * priv;
};

struct _UnityWorkspaceCloneClass {
	ClutterGroupClass parent_class;
};

struct _UnityWorkspaceClonePrivate {
	gboolean gridded;
	UnityPlugin* plugin;
	MetaWorkspace* _workspace;
};

struct _UnitySpacesManager {
	GObject parent_instance;
	UnitySpacesManagerPrivate * priv;
};

struct _UnitySpacesManagerClass {
	GObjectClass parent_class;
};

struct _UnitySpacesManagerPrivate {
	ClutterGroup* selector_group;
	ClutterActor* background;
	GList* clones;
	UnityPlugin* plugin;
	UnityLauncherScrollerChild* _button;
	UnitySpacesButtonController* controller;
	guint _top_padding;
	guint _right_padding;
	guint _bottom_padding;
	guint _left_padding;
	guint _spacing;
	gboolean _showing;
};

struct _Block3Data {
	int _ref_count_;
	UnitySpacesManager * self;
	ClutterActor* clone;
	MetaWorkspace* cpy;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	guint32 time_;
	MetaWindow* meta;
};

struct _Block4Data {
	int _ref_count_;
	UnitySpacesManager * self;
	UnityExposeClone* clone;
};

struct _UnityPlugin {
	GObject parent_instance;
	UnityPluginPrivate * priv;
	GeeArrayList* backgrounds;
	GdkRectangle primary_monitor;
	UnityGestureDispatcher* gesture_dispatcher;
};

struct _UnityPluginClass {
	GObjectClass parent_class;
};

struct _Block6Data {
	int _ref_count_;
	UnitySpacesManager * self;
	ClutterActor* clone;
};


static gpointer unity_spaces_button_controller_parent_class = NULL;
static gpointer unity_workspace_clone_parent_class = NULL;
static gpointer unity_spaces_manager_parent_class = NULL;

GType unity_spaces_button_controller_get_type (void) G_GNUC_CONST;
GType unity_spaces_manager_get_type (void) G_GNUC_CONST;
#define UNITY_SPACES_BUTTON_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SPACES_BUTTON_CONTROLLER, UnitySpacesButtonControllerPrivate))
enum  {
	UNITY_SPACES_BUTTON_CONTROLLER_DUMMY_PROPERTY
};
UnitySpacesButtonController* unity_spaces_button_controller_new (UnitySpacesManager* _parent, UnityLauncherScrollerChild* _child);
UnitySpacesButtonController* unity_spaces_button_controller_construct (GType object_type, UnitySpacesManager* _parent, UnityLauncherScrollerChild* _child);
static void unity_spaces_button_controller_set_parent (UnitySpacesButtonController* self, UnitySpacesManager* value);
static UnitySpacesManager* unity_spaces_button_controller_get_parent (UnitySpacesButtonController* self);
static void unity_spaces_button_controller_on_notify_showing (UnitySpacesButtonController* self);
static void _unity_spaces_button_controller_on_notify_showing_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean unity_spaces_manager_get_showing (UnitySpacesManager* self);
static void unity_spaces_button_controller_real_activate (UnityLauncherScrollerChildController* base);
void unity_spaces_manager_hide_spaces_picker (UnitySpacesManager* self);
void unity_spaces_manager_show_spaces_picker (UnitySpacesManager* self);
static UnityLauncherQuicklistController* unity_spaces_button_controller_real_get_menu_controller (UnityLauncherScrollerChildController* base);
static void unity_spaces_button_controller_real_get_menu_actions (UnityLauncherScrollerChildController* base, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
static void unity_spaces_button_controller_real_get_menu_navigation (UnityLauncherScrollerChildController* base, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
static gboolean unity_spaces_button_controller_real_can_drag (UnityLauncherScrollerChildController* base);
static GObject * unity_spaces_button_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_spaces_button_controller_finalize (GObject* obj);
static void unity_spaces_button_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_spaces_button_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_workspace_clone_get_type (void) G_GNUC_CONST;
GType unity_plugin_get_type (void) G_GNUC_CONST;
#define UNITY_WORKSPACE_CLONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_WORKSPACE_CLONE, UnityWorkspaceClonePrivate))
enum  {
	UNITY_WORKSPACE_CLONE_DUMMY_PROPERTY,
	UNITY_WORKSPACE_CLONE_WORKSPACE
};
UnityWorkspaceClone* unity_workspace_clone_new (MetaWorkspace* wsp, UnityPlugin* plugin);
UnityWorkspaceClone* unity_workspace_clone_construct (GType object_type, MetaWorkspace* wsp, UnityPlugin* plugin);
static void unity_workspace_clone_set_workspace (UnityWorkspaceClone* self, MetaWorkspace* value);
static void _lambda7_ (UnityWorkspaceClone* self);
void unity_workspace_clone_grid (UnityWorkspaceClone* self);
static void __lambda7__clutter_container_actor_added (ClutterContainer* _sender, ClutterActor* actor, gpointer self);
static void _lambda8_ (UnityWorkspaceClone* self);
static void __lambda8__clutter_container_actor_removed (ClutterContainer* _sender, ClutterActor* actor, gpointer self);
static GList* unity_workspace_clone_toplevel_windows (UnityWorkspaceClone* self);
GType unity_expose_clone_get_type (void) G_GNUC_CONST;
ClutterActor* unity_expose_clone_get_source (UnityExposeClone* self);
static void _g_list_free_g_object_unref (GList* self);
GType unity_expose_manager_get_type (void) G_GNUC_CONST;
UnityExposeManager* unity_plugin_get_expose_manager (UnityPlugin* self);
void unity_expose_manager_position_windows_on_grid (UnityExposeManager* self, GList* _windows, gint top_buffer, gint left_buffer, gint right_buffer, gint bottom_buffer);
void unity_workspace_clone_ungrid (UnityWorkspaceClone* self);
MutterPlugin* unity_plugin_get_plugin (UnityPlugin* self);
void unity_expose_clone_restore_window_position (UnityExposeClone* self, gint active_workspace);
MetaWorkspace* unity_workspace_clone_get_workspace (UnityWorkspaceClone* self);
static void unity_workspace_clone_finalize (GObject* obj);
static void unity_workspace_clone_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_workspace_clone_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_SPACES_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SPACES_MANAGER, UnitySpacesManagerPrivate))
enum  {
	UNITY_SPACES_MANAGER_DUMMY_PROPERTY,
	UNITY_SPACES_MANAGER_BUTTON,
	UNITY_SPACES_MANAGER_TOP_PADDING,
	UNITY_SPACES_MANAGER_RIGHT_PADDING,
	UNITY_SPACES_MANAGER_BOTTOM_PADDING,
	UNITY_SPACES_MANAGER_LEFT_PADDING,
	UNITY_SPACES_MANAGER_SPACING,
	UNITY_SPACES_MANAGER_SHOWING
};
UnitySpacesManager* unity_spaces_manager_new (UnityPlugin* plugin);
UnitySpacesManager* unity_spaces_manager_construct (GType object_type, UnityPlugin* plugin);
static void unity_spaces_manager_workspace_switched (UnitySpacesManager* self, UnityPlugin* plugin, gint from, gint to, gint direction);
static void _unity_spaces_manager_workspace_switched_unity_plugin_workspace_switch_event (UnityPlugin* _sender, UnityPlugin* plugin, gint from, gint to, gint direction, gpointer self);
static void unity_spaces_manager_set_desktop_layout (UnitySpacesManager* self, gint columns, gint rows, gint num_workspace);
void unity_spaces_manager_set_padding (UnitySpacesManager* self, guint top, guint right, guint left, guint bottom);
void unity_spaces_manager_set_top_padding (UnitySpacesManager* self, guint value);
void unity_spaces_manager_set_right_padding (UnitySpacesManager* self, guint value);
void unity_spaces_manager_set_left_padding (UnitySpacesManager* self, guint value);
void unity_spaces_manager_set_bottom_padding (UnitySpacesManager* self, guint value);
static void unity_spaces_manager_select_workspace (UnitySpacesManager* self, MetaWorkspace* workspace);
static void unity_spaces_manager_set_showing (UnitySpacesManager* self, gboolean value);
static gboolean unity_spaces_manager_on_stage_capture_event (UnitySpacesManager* self, ClutterEvent* event);
static gboolean _unity_spaces_manager_on_stage_capture_event_clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static ClutterActor* unity_spaces_manager_workspace_clone (UnitySpacesManager* self, MetaWorkspace* workspace);
static gboolean _lambda13_ (Block3Data* _data3_);
static gboolean __lambda13__clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _lambda14_ (Block3Data* _data3_);
static gboolean __lambda14__clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _lambda15_ (Block3Data* _data3_);
static gboolean __lambda15__clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void unity_spaces_manager_layout_workspaces (UnitySpacesManager* self, GList* clones, MetaScreen* screen);
UnityLauncherScrollerChild* unity_spaces_manager_get_button (UnitySpacesManager* self);
static void unity_spaces_manager_unlayout_workspaces (UnitySpacesManager* self, GList* clones, MetaScreen* screen, gint focus);
UnityExposeClone* unity_expose_clone_new (ClutterActor* source);
UnityExposeClone* unity_expose_clone_construct (GType object_type, ClutterActor* source);
void unity_expose_clone_set_fade_on_close (UnityExposeClone* self, gboolean value);
void unity_expose_clone_set_darken (UnityExposeClone* self, guint8 value);
void unity_expose_clone_set_enable_dnd (UnityExposeClone* self, gboolean value);
static void _lambda10_ (ClutterActor* t, Block4Data* _data4_);
ClutterActor* unity_expose_clone_get_pre_drag_parent (UnityExposeClone* self);
float unity_expose_clone_get_pre_drag_scale_x (UnityExposeClone* self);
float unity_expose_clone_get_pre_drag_scale_y (UnityExposeClone* self);
static void __lambda10__unity_expose_clone_drag_dropped (UnityExposeClone* _sender, ClutterActor* onto, gpointer self);
static gboolean _lambda11_ (Block4Data* _data4_);
static gboolean _lambda12_ (Block5Data* _data5_);
static gboolean __lambda12__gsource_func (gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static gboolean __lambda11__clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda9_ (Block6Data* _data6_);
static void __lambda9__clutter_animation_completed (ClutterAnimation* _sender, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
guint unity_spaces_manager_get_left_padding (UnitySpacesManager* self);
guint unity_spaces_manager_get_right_padding (UnitySpacesManager* self);
guint unity_spaces_manager_get_spacing (UnitySpacesManager* self);
guint unity_spaces_manager_get_top_padding (UnitySpacesManager* self);
guint unity_spaces_manager_get_bottom_padding (UnitySpacesManager* self);
void unity_spaces_manager_set_spacing (UnitySpacesManager* self, guint value);
static GObject * unity_spaces_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_spaces_manager_finalize (GObject* obj);
static void unity_spaces_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_spaces_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void _unity_spaces_button_controller_on_notify_showing_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_spaces_button_controller_on_notify_showing (self);
}


UnitySpacesButtonController* unity_spaces_button_controller_construct (GType object_type, UnitySpacesManager* _parent, UnityLauncherScrollerChild* _child) {
	UnitySpacesButtonController * self;
	g_return_val_if_fail (_parent != NULL, NULL);
	g_return_val_if_fail (_child != NULL, NULL);
	self = (UnitySpacesButtonController*) g_object_new (object_type, "child", _child, NULL);
	unity_spaces_button_controller_set_parent (self, _parent);
	g_signal_connect_object ((GObject*) self->priv->_parent, "notify::showing", (GCallback) _unity_spaces_button_controller_on_notify_showing_g_object_notify, self, 0);
	unity_launcher_scroller_child_controller_set_name ((UnityLauncherScrollerChildController*) self, _ ("Workspaces"));
	unity_launcher_scroller_child_controller_load_icon_from_icon_name ((UnityLauncherScrollerChildController*) self, "workspace-switcher");
	return self;
}


UnitySpacesButtonController* unity_spaces_button_controller_new (UnitySpacesManager* _parent, UnityLauncherScrollerChild* _child) {
	return unity_spaces_button_controller_construct (UNITY_TYPE_SPACES_BUTTON_CONTROLLER, _parent, _child);
}


static void unity_spaces_button_controller_on_notify_showing (UnitySpacesButtonController* self) {
	g_return_if_fail (self != NULL);
	unity_launcher_scroller_child_set_active (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), unity_spaces_manager_get_showing (self->priv->_parent));
}


static void unity_spaces_button_controller_real_activate (UnityLauncherScrollerChildController* base) {
	UnitySpacesButtonController * self;
	self = (UnitySpacesButtonController*) base;
	if (unity_spaces_manager_get_showing (self->priv->_parent) == TRUE) {
		unity_spaces_manager_hide_spaces_picker (self->priv->_parent);
	} else {
		unity_spaces_manager_show_spaces_picker (self->priv->_parent);
	}
}


static UnityLauncherQuicklistController* unity_spaces_button_controller_real_get_menu_controller (UnityLauncherScrollerChildController* base) {
	UnitySpacesButtonController * self;
	UnityLauncherQuicklistController* result = NULL;
	self = (UnitySpacesButtonController*) base;
	result = (UnityLauncherQuicklistController*) unity_launcher_application_quicklist_controller_new ((UnityLauncherScrollerChildController*) self);
	return result;
}


static void unity_spaces_button_controller_real_get_menu_actions (UnityLauncherScrollerChildController* base, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target) {
	UnitySpacesButtonController * self;
	self = (UnitySpacesButtonController*) base;
	callback (NULL, callback_target);
}


static void unity_spaces_button_controller_real_get_menu_navigation (UnityLauncherScrollerChildController* base, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target) {
	UnitySpacesButtonController * self;
	self = (UnitySpacesButtonController*) base;
	callback (NULL, callback_target);
}


static gboolean unity_spaces_button_controller_real_can_drag (UnityLauncherScrollerChildController* base) {
	UnitySpacesButtonController * self;
	gboolean result = FALSE;
	self = (UnitySpacesButtonController*) base;
	result = FALSE;
	return result;
}


static UnitySpacesManager* unity_spaces_button_controller_get_parent (UnitySpacesButtonController* self) {
	UnitySpacesManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parent;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_spaces_button_controller_set_parent (UnitySpacesButtonController* self, UnitySpacesManager* value) {
	UnitySpacesManager* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_parent = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_parent), _tmp0_);
}


static GObject * unity_spaces_button_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnitySpacesButtonController * self;
	parent_class = G_OBJECT_CLASS (unity_spaces_button_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SPACES_BUTTON_CONTROLLER (obj);
	{
		unity_launcher_scroller_child_set_group_type (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_PLACE);
	}
	return obj;
}


static void unity_spaces_button_controller_class_init (UnitySpacesButtonControllerClass * klass) {
	unity_spaces_button_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitySpacesButtonControllerPrivate));
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->activate = unity_spaces_button_controller_real_activate;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_controller = unity_spaces_button_controller_real_get_menu_controller;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_actions = unity_spaces_button_controller_real_get_menu_actions;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_navigation = unity_spaces_button_controller_real_get_menu_navigation;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->can_drag = unity_spaces_button_controller_real_can_drag;
	G_OBJECT_CLASS (klass)->get_property = unity_spaces_button_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_spaces_button_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_spaces_button_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_spaces_button_controller_finalize;
}


static void unity_spaces_button_controller_instance_init (UnitySpacesButtonController * self) {
	self->priv = UNITY_SPACES_BUTTON_CONTROLLER_GET_PRIVATE (self);
}


static void unity_spaces_button_controller_finalize (GObject* obj) {
	UnitySpacesButtonController * self;
	self = UNITY_SPACES_BUTTON_CONTROLLER (obj);
	_g_object_unref0 (self->priv->_parent);
	G_OBJECT_CLASS (unity_spaces_button_controller_parent_class)->finalize (obj);
}


GType unity_spaces_button_controller_get_type (void) {
	static volatile gsize unity_spaces_button_controller_type_id__volatile = 0;
	if (g_once_init_enter (&unity_spaces_button_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitySpacesButtonControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_spaces_button_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitySpacesButtonController), 0, (GInstanceInitFunc) unity_spaces_button_controller_instance_init, NULL };
		GType unity_spaces_button_controller_type_id;
		unity_spaces_button_controller_type_id = g_type_register_static (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, "UnitySpacesButtonController", &g_define_type_info, 0);
		g_once_init_leave (&unity_spaces_button_controller_type_id__volatile, unity_spaces_button_controller_type_id);
	}
	return unity_spaces_button_controller_type_id__volatile;
}


static void unity_spaces_button_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnitySpacesButtonController * self;
	self = UNITY_SPACES_BUTTON_CONTROLLER (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_spaces_button_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnitySpacesButtonController * self;
	self = UNITY_SPACES_BUTTON_CONTROLLER (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _lambda7_ (UnityWorkspaceClone* self) {
	if (self->priv->gridded) {
		unity_workspace_clone_grid (self);
	}
}


static void __lambda7__clutter_container_actor_added (ClutterContainer* _sender, ClutterActor* actor, gpointer self) {
	_lambda7_ (self);
}


static void _lambda8_ (UnityWorkspaceClone* self) {
	if (self->priv->gridded) {
		unity_workspace_clone_grid (self);
	}
}


static void __lambda8__clutter_container_actor_removed (ClutterContainer* _sender, ClutterActor* actor, gpointer self) {
	_lambda8_ (self);
}


UnityWorkspaceClone* unity_workspace_clone_construct (GType object_type, MetaWorkspace* wsp, UnityPlugin* plugin) {
	UnityWorkspaceClone * self;
	UnityPlugin* _tmp0_;
	g_return_val_if_fail (wsp != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	unity_workspace_clone_set_workspace (self, wsp);
	self->priv->plugin = (_tmp0_ = _g_object_ref0 (plugin), _g_object_unref0 (self->priv->plugin), _tmp0_);
	g_signal_connect_object ((ClutterContainer*) self, "actor-added", (GCallback) __lambda7__clutter_container_actor_added, self, 0);
	g_signal_connect_object ((ClutterContainer*) self, "actor-removed", (GCallback) __lambda8__clutter_container_actor_removed, self, 0);
	return self;
}


UnityWorkspaceClone* unity_workspace_clone_new (MetaWorkspace* wsp, UnityPlugin* plugin) {
	return unity_workspace_clone_construct (UNITY_TYPE_WORKSPACE_CLONE, wsp, plugin);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static GList* unity_workspace_clone_toplevel_windows (UnityWorkspaceClone* self) {
	GList* result = NULL;
	GList* windows;
	g_return_val_if_fail (self != NULL, NULL);
	windows = NULL;
	{
		GList* actor_collection;
		GList* actor_it;
		actor_collection = clutter_container_get_children ((ClutterContainer*) self);
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor;
			actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
			{
				gboolean _tmp0_ = FALSE;
				if (UNITY_IS_EXPOSE_CLONE (actor)) {
					ClutterActor* _tmp1_;
					_tmp0_ = MUTTER_IS_WINDOW (unity_expose_clone_get_source ((_tmp1_ = actor, UNITY_IS_EXPOSE_CLONE (_tmp1_) ? ((UnityExposeClone*) _tmp1_) : NULL)));
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					windows = g_list_prepend (windows, _g_object_ref0 (actor));
				}
				_g_object_unref0 (actor);
			}
		}
		_g_list_free0 (actor_collection);
	}
	result = windows;
	return result;
}


void unity_workspace_clone_grid (UnityWorkspaceClone* self) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->gridded = TRUE;
	unity_expose_manager_position_windows_on_grid (unity_plugin_get_expose_manager (self->priv->plugin), _tmp0_ = unity_workspace_clone_toplevel_windows (self), 50, 50, 50, 50);
	__g_list_free_g_object_unref0 (_tmp0_);
}


void unity_workspace_clone_ungrid (UnityWorkspaceClone* self) {
	gint active_workspace;
	g_return_if_fail (self != NULL);
	self->priv->gridded = FALSE;
	active_workspace = meta_screen_get_active_workspace_index (mutter_plugin_get_screen (unity_plugin_get_plugin (self->priv->plugin)));
	{
		GList* actor_collection;
		GList* actor_it;
		actor_collection = unity_workspace_clone_toplevel_windows (self);
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor;
			actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
			{
				if (UNITY_IS_EXPOSE_CLONE (actor)) {
					ClutterActor* _tmp0_;
					unity_expose_clone_restore_window_position ((_tmp0_ = actor, UNITY_IS_EXPOSE_CLONE (_tmp0_) ? ((UnityExposeClone*) _tmp0_) : NULL), active_workspace);
				}
				_g_object_unref0 (actor);
			}
		}
		__g_list_free_g_object_unref0 (actor_collection);
	}
}


MetaWorkspace* unity_workspace_clone_get_workspace (UnityWorkspaceClone* self) {
	MetaWorkspace* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_workspace;
	return result;
}


static void unity_workspace_clone_set_workspace (UnityWorkspaceClone* self, MetaWorkspace* value) {
	g_return_if_fail (self != NULL);
	self->priv->_workspace = value;
	g_object_notify ((GObject *) self, "workspace");
}


static void unity_workspace_clone_class_init (UnityWorkspaceCloneClass * klass) {
	unity_workspace_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityWorkspaceClonePrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_workspace_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_workspace_clone_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_workspace_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_WORKSPACE_CLONE_WORKSPACE, g_param_spec_pointer ("workspace", "workspace", "workspace", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_workspace_clone_instance_init (UnityWorkspaceClone * self) {
	self->priv = UNITY_WORKSPACE_CLONE_GET_PRIVATE (self);
}


static void unity_workspace_clone_finalize (GObject* obj) {
	UnityWorkspaceClone * self;
	self = UNITY_WORKSPACE_CLONE (obj);
	_g_object_unref0 (self->priv->plugin);
	G_OBJECT_CLASS (unity_workspace_clone_parent_class)->finalize (obj);
}


GType unity_workspace_clone_get_type (void) {
	static volatile gsize unity_workspace_clone_type_id__volatile = 0;
	if (g_once_init_enter (&unity_workspace_clone_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityWorkspaceCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_workspace_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityWorkspaceClone), 0, (GInstanceInitFunc) unity_workspace_clone_instance_init, NULL };
		GType unity_workspace_clone_type_id;
		unity_workspace_clone_type_id = g_type_register_static (CLUTTER_TYPE_GROUP, "UnityWorkspaceClone", &g_define_type_info, 0);
		g_once_init_leave (&unity_workspace_clone_type_id__volatile, unity_workspace_clone_type_id);
	}
	return unity_workspace_clone_type_id__volatile;
}


static void unity_workspace_clone_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityWorkspaceClone * self;
	self = UNITY_WORKSPACE_CLONE (object);
	switch (property_id) {
		case UNITY_WORKSPACE_CLONE_WORKSPACE:
		g_value_set_pointer (value, unity_workspace_clone_get_workspace (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_workspace_clone_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityWorkspaceClone * self;
	self = UNITY_WORKSPACE_CLONE (object);
	switch (property_id) {
		case UNITY_WORKSPACE_CLONE_WORKSPACE:
		unity_workspace_clone_set_workspace (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _unity_spaces_manager_workspace_switched_unity_plugin_workspace_switch_event (UnityPlugin* _sender, UnityPlugin* plugin, gint from, gint to, gint direction, gpointer self) {
	unity_spaces_manager_workspace_switched (self, plugin, from, to, direction);
}


UnitySpacesManager* unity_spaces_manager_construct (GType object_type, UnityPlugin* plugin) {
	UnitySpacesManager * self;
	UnityPlugin* _tmp0_;
	gint num_workspaces;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (UnitySpacesManager*) g_object_new (object_type, NULL);
	self->priv->plugin = (_tmp0_ = _g_object_ref0 (plugin), _g_object_unref0 (self->priv->plugin), _tmp0_);
	g_signal_connect_object (self->priv->plugin, "workspace-switch-event", (GCallback) _unity_spaces_manager_workspace_switched_unity_plugin_workspace_switch_event, self, 0);
	num_workspaces = meta_prefs_get_num_workspaces ();
	if (num_workspaces <= 4) {
		unity_spaces_manager_set_desktop_layout (self, 2, 2, 2 * 2);
	} else {
		gint width;
		gint height;
		width = (gint) ceil (sqrt ((double) num_workspaces));
		height = 1;
		while (TRUE) {
			if (!((width * height) < num_workspaces)) {
				break;
			}
			height++;
		}
		unity_spaces_manager_set_desktop_layout (self, width, height, num_workspaces);
	}
	return self;
}


UnitySpacesManager* unity_spaces_manager_new (UnityPlugin* plugin) {
	return unity_spaces_manager_construct (UNITY_TYPE_SPACES_MANAGER, plugin);
}


static void unity_spaces_manager_set_desktop_layout (UnitySpacesManager* self, gint columns, gint rows, gint num_workspace) {
	Display* display;
	gulong data[4] = {0};
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	display = NULL;
	if (columns < 1) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = rows < 1;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = num_workspace > (columns * rows);
	}
	if (_tmp0_) {
		return;
	}
	display = mutter_plugin_get_xdisplay (unity_plugin_get_plugin (self->priv->plugin));
	meta_prefs_set_num_workspaces (num_workspace);
	data[0] = (gulong) 0;
	data[1] = (gulong) columns;
	data[2] = (gulong) rows;
	data[3] = (gulong) 0;
	XChangeProperty (display, DefaultRootWindow (display), XInternAtom (display, "_NET_DESKTOP_LAYOUT", FALSE), XA_CARDINAL, 32, (gint) PropModeReplace, (guchar*) data, 4);
}


static void unity_spaces_manager_workspace_switched (UnitySpacesManager* self, UnityPlugin* plugin, gint from, gint to, gint direction) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	mutter_plugin_switch_workspace_completed (unity_plugin_get_plugin (self->priv->plugin));
}


void unity_spaces_manager_set_padding (UnitySpacesManager* self, guint top, guint right, guint left, guint bottom) {
	g_return_if_fail (self != NULL);
	unity_spaces_manager_set_top_padding (self, top);
	unity_spaces_manager_set_right_padding (self, right);
	unity_spaces_manager_set_left_padding (self, left);
	unity_spaces_manager_set_bottom_padding (self, bottom);
}


void unity_spaces_manager_hide_spaces_picker (UnitySpacesManager* self) {
	g_return_if_fail (self != NULL);
	unity_spaces_manager_select_workspace (self, NULL);
}


static gboolean _unity_spaces_manager_on_stage_capture_event_clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_spaces_manager_on_stage_capture_event (self, event);
	return result;
}


static gboolean _lambda13_ (Block3Data* _data3_) {
	UnitySpacesManager * self;
	gboolean result = FALSE;
	self = _data3_->self;
	unity_spaces_manager_select_workspace (self, _data3_->cpy);
	result = TRUE;
	return result;
}


static gboolean __lambda13__clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = _lambda13_ (self);
	return result;
}


static gboolean _lambda14_ (Block3Data* _data3_) {
	UnitySpacesManager * self;
	gboolean result = FALSE;
	self = _data3_->self;
	clutter_actor_set_opacity (_data3_->clone, (guint8) 255);
	clutter_actor_raise_top (_data3_->clone);
	result = TRUE;
	return result;
}


static gboolean __lambda14__clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = _lambda14_ (self);
	return result;
}


static gboolean _lambda15_ (Block3Data* _data3_) {
	UnitySpacesManager * self;
	gboolean result = FALSE;
	self = _data3_->self;
	clutter_actor_set_opacity (_data3_->clone, (guint8) 200);
	result = TRUE;
	return result;
}


static gboolean __lambda15__clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = _lambda15_ (self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->clone);
		g_slice_free (Block3Data, _data3_);
	}
}


void unity_spaces_manager_show_spaces_picker (UnitySpacesManager* self) {
	ClutterStage* _tmp0_;
	ClutterColor _tmp1_ = {0};
	ClutterColor _tmp2_;
	ClutterActor* _tmp3_;
	ClutterGroup* _tmp4_;
	MetaScreen* screen;
	GList* workspaces;
	ClutterActor* _tmp5_;
	ClutterContainer* window_group;
	MetaRectangle _tmp6_ = {0};
	MetaRectangle rect;
	GList* windows;
	g_return_if_fail (self != NULL);
	if (self->priv->_showing) {
		return;
	}
	unity_spaces_manager_set_showing (self, TRUE);
	unity_shell_add_fullscreen_request ((UnityShell*) self->priv->plugin, (GObject*) self);
	g_signal_connect_object ((ClutterActor*) (_tmp0_ = unity_shell_get_stage (unity_global_shell)), "captured-event", (GCallback) _unity_spaces_manager_on_stage_capture_event_clutter_actor_captured_event, self, 0);
	_g_object_unref0 (_tmp0_);
	unity_shell_hide_unity (unity_global_shell);
	if (CLUTTER_IS_ACTOR (self->priv->background)) {
		clutter_actor_destroy (self->priv->background);
	}
	if (CLUTTER_IS_ACTOR (self->priv->selector_group)) {
		clutter_actor_destroy ((ClutterActor*) self->priv->selector_group);
	}
	self->priv->background = (_tmp3_ = (ClutterActor*) g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new_with_color ((_tmp2_ = (_tmp1_.red = (guint8) 0, _tmp1_.green = (guint8) 0, _tmp1_.blue = (guint8) 0, _tmp1_.alpha = (guint8) 255, _tmp1_), &_tmp2_))), _g_object_unref0 (self->priv->background), _tmp3_);
	self->priv->selector_group = (_tmp4_ = g_object_ref_sink ((ClutterGroup*) clutter_group_new ()), _g_object_unref0 (self->priv->selector_group), _tmp4_);
	screen = mutter_plugin_get_screen (unity_plugin_get_plugin (self->priv->plugin));
	workspaces = meta_screen_get_workspaces (screen);
	window_group = (_tmp5_ = mutter_plugin_get_normal_window_group (unity_plugin_get_plugin (self->priv->plugin)), CLUTTER_IS_CONTAINER (_tmp5_) ? ((ClutterContainer*) _tmp5_) : NULL);
	rect = (_tmp6_.height = 0, _tmp6_.width = 0, _tmp6_.x = 0, _tmp6_.y = 0, _tmp6_);
	meta_screen_get_monitor_geometry (screen, 0, &rect);
	clutter_actor_set_size (self->priv->background, (float) rect.width, (float) rect.height);
	clutter_container_add_actor ((ClutterContainer*) self->priv->selector_group, self->priv->background);
	clutter_actor_raise_top (self->priv->background);
	clutter_actor_set_reactive (self->priv->background, TRUE);
	{
		GList* workspace_collection;
		GList* workspace_it;
		workspace_collection = workspaces;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* workspace;
			workspace = (MetaWorkspace*) workspace_it->data;
			{
				Block3Data* _data3_;
				_data3_ = g_slice_new0 (Block3Data);
				_data3_->_ref_count_ = 1;
				_data3_->self = g_object_ref (self);
				_data3_->clone = unity_spaces_manager_workspace_clone (self, workspace);
				self->priv->clones = g_list_append (self->priv->clones, _g_object_ref0 (_data3_->clone));
				clutter_container_add_actor ((ClutterContainer*) self->priv->selector_group, _data3_->clone);
				clutter_actor_set_reactive (_data3_->clone, TRUE);
				clutter_actor_raise_top (_data3_->clone);
				clutter_actor_show (_data3_->clone);
				clutter_actor_set_opacity (_data3_->clone, (guint8) 200);
				_data3_->cpy = workspace;
				g_signal_connect_data (_data3_->clone, "button-release-event", (GCallback) __lambda13__clutter_actor_button_release_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
				g_signal_connect_data (_data3_->clone, "enter-event", (GCallback) __lambda14__clutter_actor_enter_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
				g_signal_connect_data (_data3_->clone, "leave-event", (GCallback) __lambda15__clutter_actor_leave_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
				block3_data_unref (_data3_);
			}
		}
	}
	clutter_container_add_actor (window_group, (ClutterActor*) self->priv->selector_group);
	clutter_actor_raise_top ((ClutterActor*) self->priv->selector_group);
	unity_spaces_manager_layout_workspaces (self, self->priv->clones, screen);
	windows = mutter_plugin_get_windows (unity_plugin_get_plugin (self->priv->plugin));
	{
		GList* w_collection;
		GList* w_it;
		w_collection = windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MutterWindow* w;
			w = _g_object_ref0 ((MutterWindow*) w_it->data);
			{
				MutterWindow* _tmp7_;
				clutter_actor_set_opacity ((_tmp7_ = w, CLUTTER_IS_ACTOR (_tmp7_) ? ((ClutterActor*) _tmp7_) : NULL), (guint8) 0);
				_g_object_unref0 (w);
			}
		}
	}
}


static gboolean unity_spaces_manager_on_stage_capture_event (UnitySpacesManager* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).type == CLUTTER_BUTTON_RELEASE) {
		gboolean _tmp0_ = FALSE;
		if ((*event).button.y <= unity_shell_get_panel_height_foobar (unity_global_shell)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = (*event).button.x <= unity_shell_get_launcher_width_foobar (unity_global_shell);
		}
		if (_tmp0_) {
			float x = 0.0F;
			float y = 0.0F;
			float w = 0.0F;
			float h = 0.0F;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			clutter_actor_get_transformed_position ((ClutterActor*) unity_spaces_manager_get_button (self), &x, &y);
			clutter_actor_get_transformed_size ((ClutterActor*) unity_spaces_manager_get_button (self), &w, &h);
			if ((*event).button.x < x) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = (*event).button.x > (x + w);
			}
			if (_tmp2_) {
				gboolean _tmp3_ = FALSE;
				if ((*event).button.y < y) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = (*event).button.y > (y + h);
				}
				_tmp1_ = _tmp3_;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				unity_spaces_manager_select_workspace (self, NULL);
			}
		}
	}
	result = FALSE;
	return result;
}


static void unity_spaces_manager_select_workspace (UnitySpacesManager* self, MetaWorkspace* workspace) {
	GList* _tmp0_;
	guint time_;
	ClutterStage* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	if (workspace == NULL) {
		workspace = meta_screen_get_active_workspace (mutter_plugin_get_screen (unity_plugin_get_plugin (self->priv->plugin)));
	}
	unity_spaces_manager_unlayout_workspaces (self, self->priv->clones, mutter_plugin_get_screen (unity_plugin_get_plugin (self->priv->plugin)), meta_workspace_index (workspace));
	self->priv->clones = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->priv->clones), _tmp0_);
	time_ = (guint) meta_display_get_current_time (meta_screen_get_display (meta_workspace_get_screen (workspace)));
	meta_workspace_activate (workspace, (guint32) time_);
	unity_shell_remove_fullscreen_request ((UnityShell*) self->priv->plugin, (GObject*) self);
	unity_spaces_manager_set_showing (self, FALSE);
	g_signal_parse_name ("captured-event", CLUTTER_TYPE_ACTOR, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) (_tmp1_ = unity_shell_get_stage (unity_global_shell)), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _unity_spaces_manager_on_stage_capture_event_clutter_actor_captured_event, self);
	_g_object_unref0 (_tmp1_);
}


static void _lambda10_ (ClutterActor* t, Block4Data* _data4_) {
	UnitySpacesManager * self;
	ClutterActor* _tmp0_;
	UnityWorkspaceClone* new_parent;
	float x = 0.0F;
	float y = 0.0F;
	ClutterActor* _tmp3_;
	self = _data4_->self;
	g_return_if_fail (t != NULL);
	new_parent = _g_object_ref0 ((_tmp0_ = unity_expose_clone_get_pre_drag_parent (_data4_->clone), UNITY_IS_WORKSPACE_CLONE (_tmp0_) ? ((UnityWorkspaceClone*) _tmp0_) : NULL));
	while (TRUE) {
		if (!(!CLUTTER_IS_STAGE (t))) {
			break;
		}
		if (UNITY_IS_WORKSPACE_CLONE (t)) {
			ClutterActor* _tmp1_;
			UnityWorkspaceClone* _tmp2_;
			new_parent = (_tmp2_ = _g_object_ref0 ((_tmp1_ = t, UNITY_IS_WORKSPACE_CLONE (_tmp1_) ? ((UnityWorkspaceClone*) _tmp1_) : NULL)), _g_object_unref0 (new_parent), _tmp2_);
			break;
		}
		t = clutter_actor_get_parent (t);
	}
	clutter_actor_move_anchor_point_from_gravity ((ClutterActor*) _data4_->clone, CLUTTER_GRAVITY_CENTER);
	clutter_actor_transform_stage_point ((ClutterActor*) new_parent, clutter_actor_get_x ((ClutterActor*) _data4_->clone), clutter_actor_get_y ((ClutterActor*) _data4_->clone), &x, &y);
	clutter_actor_set_scale ((ClutterActor*) _data4_->clone, (double) unity_expose_clone_get_pre_drag_scale_x (_data4_->clone), (double) unity_expose_clone_get_pre_drag_scale_y (_data4_->clone));
	clutter_actor_set_position ((ClutterActor*) _data4_->clone, x, y);
	clutter_actor_move_anchor_point_from_gravity ((ClutterActor*) _data4_->clone, CLUTTER_GRAVITY_NORTH_WEST);
	clutter_actor_reparent ((ClutterActor*) _data4_->clone, (ClutterActor*) new_parent);
	meta_window_change_workspace_by_index (mutter_window_get_meta_window ((_tmp3_ = unity_expose_clone_get_source (_data4_->clone), MUTTER_IS_WINDOW (_tmp3_) ? ((MutterWindow*) _tmp3_) : NULL)), meta_workspace_index (unity_workspace_clone_get_workspace (new_parent)), TRUE, unity_shell_get_current_time ((UnityShell*) self->priv->plugin));
	_g_object_unref0 (new_parent);
}


static void __lambda10__unity_expose_clone_drag_dropped (UnityExposeClone* _sender, ClutterActor* onto, gpointer self) {
	_lambda10_ (onto, self);
}


static gboolean _lambda12_ (Block5Data* _data5_) {
	Block4Data* _data4_;
	UnitySpacesManager * self;
	gboolean result = FALSE;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	meta_window_activate (_data5_->meta, _data5_->time_);
	result = FALSE;
	return result;
}


static gboolean __lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda12_ (self);
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		block4_data_unref (_data5_->_data4_);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _lambda11_ (Block4Data* _data4_) {
	UnitySpacesManager * self;
	gboolean result = FALSE;
	Block5Data* _data5_;
	ClutterActor* _tmp0_;
	self = _data4_->self;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->_data4_ = block4_data_ref (_data4_);
	clutter_actor_raise_top ((ClutterActor*) _data4_->clone);
	_data5_->meta = mutter_window_get_meta_window ((_tmp0_ = unity_expose_clone_get_source (_data4_->clone), MUTTER_IS_WINDOW (_tmp0_) ? ((MutterWindow*) _tmp0_) : NULL));
	_data5_->time_ = meta_display_get_current_time (meta_window_get_display (_data5_->meta));
	meta_workspace_activate (meta_window_get_workspace (_data5_->meta), _data5_->time_);
	meta_window_activate (_data5_->meta, _data5_->time_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, __lambda12__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	result = FALSE;
	block5_data_unref (_data5_);
	return result;
}


static gboolean __lambda11__clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = _lambda11_ (self);
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->clone);
		g_slice_free (Block4Data, _data4_);
	}
}


static ClutterActor* unity_spaces_manager_workspace_clone (UnitySpacesManager* self, MetaWorkspace* workspace) {
	ClutterActor* result = NULL;
	UnityWorkspaceClone* wsp;
	GList* windows;
	UnityWorkspaceClone* _tmp0_;
	UnityTestingBackground* _tmp5_;
	UnityExposeClone* _tmp6_;
	UnityExposeClone* background_clone;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (workspace != NULL, NULL);
	wsp = NULL;
	windows = NULL;
	windows = mutter_plugin_get_windows (unity_plugin_get_plugin (self->priv->plugin));
	wsp = (_tmp0_ = g_object_ref_sink (unity_workspace_clone_new (workspace, self->priv->plugin)), _g_object_unref0 (wsp), _tmp0_);
	{
		GList* window_collection;
		GList* window_it;
		window_collection = windows;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MutterWindow* window;
			window = _g_object_ref0 ((MutterWindow*) window_it->data);
			{
				gboolean _tmp1_ = FALSE;
				if (meta_window_is_on_all_workspaces (mutter_window_get_meta_window (window))) {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = mutter_window_get_workspace (window) == meta_workspace_index (workspace);
				}
				if (_tmp1_) {
					Block4Data* _data4_;
					gboolean _tmp2_ = FALSE;
					gboolean _tmp3_ = FALSE;
					gboolean _tmp4_ = FALSE;
					_data4_ = g_slice_new0 (Block4Data);
					_data4_->_ref_count_ = 1;
					_data4_->self = g_object_ref (self);
					if (mutter_window_get_window_type (window) == META_COMP_WINDOW_NORMAL) {
						_tmp4_ = TRUE;
					} else {
						_tmp4_ = mutter_window_get_window_type (window) == META_COMP_WINDOW_DIALOG;
					}
					if (_tmp4_) {
						_tmp3_ = TRUE;
					} else {
						_tmp3_ = mutter_window_get_window_type (window) == META_COMP_WINDOW_MODAL_DIALOG;
					}
					if (_tmp3_) {
						_tmp2_ = TRUE;
					} else {
						_tmp2_ = mutter_window_get_window_type (window) == META_COMP_WINDOW_UTILITY;
					}
					if (!_tmp2_) {
						block4_data_unref (_data4_);
						_g_object_unref0 (window);
						continue;
					}
					_data4_->clone = g_object_ref_sink (unity_expose_clone_new ((ClutterActor*) window));
					unity_expose_clone_set_fade_on_close (_data4_->clone, FALSE);
					clutter_actor_set_reactive ((ClutterActor*) _data4_->clone, TRUE);
					unity_expose_clone_set_darken (_data4_->clone, (guint8) 25);
					unity_expose_clone_set_enable_dnd (_data4_->clone, TRUE);
					g_signal_connect_data (_data4_->clone, "drag-dropped", (GCallback) __lambda10__unity_expose_clone_drag_dropped, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
					clutter_container_add_actor ((ClutterContainer*) wsp, (ClutterActor*) _data4_->clone);
					clutter_actor_set_size ((ClutterActor*) _data4_->clone, clutter_actor_get_width ((ClutterActor*) window), clutter_actor_get_height ((ClutterActor*) window));
					clutter_actor_set_position ((ClutterActor*) _data4_->clone, clutter_actor_get_x ((ClutterActor*) window), clutter_actor_get_y ((ClutterActor*) window));
					g_signal_connect_data ((ClutterActor*) _data4_->clone, "button-release-event", (GCallback) __lambda11__clutter_actor_button_release_event, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
					clutter_actor_show ((ClutterActor*) _data4_->clone);
					block4_data_unref (_data4_);
				}
				_g_object_unref0 (window);
			}
		}
	}
	background_clone = (_tmp6_ = g_object_ref_sink (unity_expose_clone_new ((ClutterActor*) (_tmp5_ = (UnityTestingBackground*) gee_abstract_list_get ((GeeAbstractList*) self->priv->plugin->backgrounds, 0)))), _g_object_unref0 (_tmp5_), _tmp6_);
	unity_expose_clone_set_fade_on_close (background_clone, FALSE);
	clutter_container_add_actor ((ClutterContainer*) wsp, (ClutterActor*) background_clone);
	clutter_actor_lower_bottom ((ClutterActor*) background_clone);
	clutter_actor_show ((ClutterActor*) background_clone);
	unity_workspace_clone_grid (wsp);
	clutter_actor_set_size ((ClutterActor*) wsp, clutter_actor_get_width ((ClutterActor*) background_clone), clutter_actor_get_height ((ClutterActor*) background_clone));
	result = (ClutterActor*) wsp;
	_g_object_unref0 (background_clone);
	return result;
}


static void _lambda9_ (Block6Data* _data6_) {
	UnitySpacesManager * self;
	GList* windows;
	self = _data6_->self;
	clutter_actor_destroy (_data6_->clone);
	if (self->priv->background != NULL) {
		ClutterActor* _tmp0_;
		clutter_actor_destroy (self->priv->background);
		self->priv->background = (_tmp0_ = NULL, _g_object_unref0 (self->priv->background), _tmp0_);
	}
	windows = mutter_plugin_get_windows (unity_plugin_get_plugin (self->priv->plugin));
	{
		GList* w_collection;
		GList* w_it;
		w_collection = windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MutterWindow* w;
			w = _g_object_ref0 ((MutterWindow*) w_it->data);
			{
				MutterWindow* _tmp1_;
				clutter_actor_set_opacity ((_tmp1_ = w, CLUTTER_IS_ACTOR (_tmp1_) ? ((ClutterActor*) _tmp1_) : NULL), (guint8) 255);
				_g_object_unref0 (w);
			}
		}
	}
}


static void __lambda9__clutter_animation_completed (ClutterAnimation* _sender, gpointer self) {
	_lambda9_ (self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->clone);
		g_slice_free (Block6Data, _data6_);
	}
}


static void unity_spaces_manager_unlayout_workspaces (UnitySpacesManager* self, GList* clones, MetaScreen* screen, gint focus) {
	guint length;
	gint width;
	gint height;
	MetaRectangle _tmp0_ = {0};
	MetaRectangle rect;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	length = g_list_length (clones);
	width = (gint) ceil (sqrt ((double) length));
	height = 1;
	while (TRUE) {
		if (!((width * height) < length)) {
			break;
		}
		height++;
	}
	rect = (_tmp0_.height = 0, _tmp0_.width = 0, _tmp0_.x = 0, _tmp0_.y = 0, _tmp0_);
	meta_screen_get_monitor_geometry (screen, 0, &rect);
	{
		gint y;
		y = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					y++;
				}
				_tmp1_ = FALSE;
				if (!(y < height)) {
					break;
				}
				{
					gint x;
					x = 0;
					{
						gboolean _tmp2_;
						_tmp2_ = TRUE;
						while (TRUE) {
							Block6Data* _data6_;
							gint index;
							gint xoffset;
							gint yoffset;
							ClutterAnimation* anim;
							ClutterActor* _tmp3_;
							_data6_ = g_slice_new0 (Block6Data);
							_data6_->_ref_count_ = 1;
							_data6_->self = g_object_ref (self);
							if (!_tmp2_) {
								x++;
							}
							_tmp2_ = FALSE;
							if (!(x < width)) {
								block6_data_unref (_data6_);
								break;
							}
							index = (y * width) + x;
							xoffset = (x - (focus % width)) * rect.width;
							yoffset = (y - (focus / width)) * rect.height;
							_data6_->clone = _g_object_ref0 (CLUTTER_ACTOR ((ClutterActor*) g_list_nth_data (clones, (guint) index)));
							anim = _g_object_ref0 (clutter_actor_animate (_data6_->clone, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) xoffset, "y", (float) yoffset, "scale-x", 1.0f, "scale-y", 1.0f, NULL));
							unity_workspace_clone_ungrid ((_tmp3_ = _data6_->clone, UNITY_IS_WORKSPACE_CLONE (_tmp3_) ? ((UnityWorkspaceClone*) _tmp3_) : NULL));
							g_signal_connect_data (anim, "completed", (GCallback) __lambda9__clutter_animation_completed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
							_g_object_unref0 (anim);
							block6_data_unref (_data6_);
						}
					}
				}
			}
		}
	}
}


static void unity_spaces_manager_layout_workspaces (UnitySpacesManager* self, GList* clones, MetaScreen* screen) {
	guint length;
	gint width;
	gint height;
	MetaRectangle _tmp0_ = {0};
	MetaRectangle rect;
	gint active;
	gint xoffset;
	gint yoffset;
	guint item_width;
	float item_scale;
	guint item_height;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	length = g_list_length (clones);
	width = (gint) ceil (sqrt ((double) length));
	height = 1;
	while (TRUE) {
		if (!((width * height) < length)) {
			break;
		}
		height++;
	}
	rect = (_tmp0_.height = 0, _tmp0_.width = 0, _tmp0_.x = 0, _tmp0_.y = 0, _tmp0_);
	meta_screen_get_monitor_geometry (screen, 0, &rect);
	active = meta_screen_get_active_workspace_index (screen);
	xoffset = (-(active % width)) * rect.width;
	yoffset = (-(active / width)) * rect.height;
	item_width = (((rect.width - self->priv->_left_padding) - self->priv->_right_padding) - ((width - 1) * self->priv->_spacing)) / width;
	item_scale = ((float) item_width) / ((float) rect.width);
	item_height = (guint) (rect.height * item_scale);
	{
		gint y;
		y = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					y++;
				}
				_tmp1_ = FALSE;
				if (!(y < height)) {
					break;
				}
				{
					gint x;
					x = 0;
					{
						gboolean _tmp2_;
						_tmp2_ = TRUE;
						while (TRUE) {
							gint index;
							ClutterActor* clone;
							if (!_tmp2_) {
								x++;
							}
							_tmp2_ = FALSE;
							if (!(x < width)) {
								break;
							}
							index = (y * width) + x;
							clone = _g_object_ref0 (CLUTTER_ACTOR ((ClutterActor*) g_list_nth_data (clones, (guint) index)));
							clutter_actor_set_scale (clone, (double) 1.0f, (double) 1.0f);
							clutter_actor_set_x (clone, (((float) rect.width) * x) + xoffset);
							clutter_actor_set_y (clone, (((float) rect.height) * y) + yoffset);
							clutter_actor_animate (clone, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", ((float) self->priv->_left_padding) + ((item_width + self->priv->_spacing) * x), "y", ((float) self->priv->_top_padding) + ((item_height + self->priv->_spacing) * y), "scale-x", item_scale, "scale-y", item_scale, NULL);
							_g_object_unref0 (clone);
						}
					}
				}
			}
		}
	}
}


UnityLauncherScrollerChild* unity_spaces_manager_get_button (UnitySpacesManager* self) {
	UnityLauncherScrollerChild* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!UNITY_LAUNCHER_IS_SCROLLER_CHILD (self->priv->_button)) {
		UnityLauncherScrollerChild* _tmp0_;
		UnitySpacesButtonController* _tmp1_;
		self->priv->_button = (_tmp0_ = g_object_ref_sink (unity_launcher_scroller_child_new ()), _g_object_unref0 (self->priv->_button), _tmp0_);
		self->priv->controller = (_tmp1_ = unity_spaces_button_controller_new (self, self->priv->_button), _g_object_unref0 (self->priv->controller), _tmp1_);
	}
	result = self->priv->_button;
	return result;
}


guint unity_spaces_manager_get_top_padding (UnitySpacesManager* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_top_padding;
	return result;
}


void unity_spaces_manager_set_top_padding (UnitySpacesManager* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_top_padding = value;
	g_object_notify ((GObject *) self, "top-padding");
}


guint unity_spaces_manager_get_right_padding (UnitySpacesManager* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_right_padding;
	return result;
}


void unity_spaces_manager_set_right_padding (UnitySpacesManager* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_right_padding = value;
	g_object_notify ((GObject *) self, "right-padding");
}


guint unity_spaces_manager_get_bottom_padding (UnitySpacesManager* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_bottom_padding;
	return result;
}


void unity_spaces_manager_set_bottom_padding (UnitySpacesManager* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_bottom_padding = value;
	g_object_notify ((GObject *) self, "bottom-padding");
}


guint unity_spaces_manager_get_left_padding (UnitySpacesManager* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_left_padding;
	return result;
}


void unity_spaces_manager_set_left_padding (UnitySpacesManager* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_left_padding = value;
	g_object_notify ((GObject *) self, "left-padding");
}


guint unity_spaces_manager_get_spacing (UnitySpacesManager* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_spacing;
	return result;
}


void unity_spaces_manager_set_spacing (UnitySpacesManager* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_spacing = value;
	g_object_notify ((GObject *) self, "spacing");
}


gboolean unity_spaces_manager_get_showing (UnitySpacesManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_showing;
	return result;
}


static void unity_spaces_manager_set_showing (UnitySpacesManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_showing = value;
	g_object_notify ((GObject *) self, "showing");
}


static GObject * unity_spaces_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnitySpacesManager * self;
	parent_class = G_OBJECT_CLASS (unity_spaces_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SPACES_MANAGER (obj);
	{
		unity_spaces_manager_set_padding (self, (guint) 50, (guint) 50, (guint) 50, (guint) 50);
		unity_spaces_manager_set_spacing (self, (guint) 15);
	}
	return obj;
}


static void unity_spaces_manager_class_init (UnitySpacesManagerClass * klass) {
	unity_spaces_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitySpacesManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_spaces_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_spaces_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_spaces_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_spaces_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SPACES_MANAGER_BUTTON, g_param_spec_object ("button", "button", "button", UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SPACES_MANAGER_TOP_PADDING, g_param_spec_uint ("top-padding", "top-padding", "top-padding", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SPACES_MANAGER_RIGHT_PADDING, g_param_spec_uint ("right-padding", "right-padding", "right-padding", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SPACES_MANAGER_BOTTOM_PADDING, g_param_spec_uint ("bottom-padding", "bottom-padding", "bottom-padding", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SPACES_MANAGER_LEFT_PADDING, g_param_spec_uint ("left-padding", "left-padding", "left-padding", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SPACES_MANAGER_SPACING, g_param_spec_uint ("spacing", "spacing", "spacing", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SPACES_MANAGER_SHOWING, g_param_spec_boolean ("showing", "showing", "showing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_spaces_manager_instance_init (UnitySpacesManager * self) {
	self->priv = UNITY_SPACES_MANAGER_GET_PRIVATE (self);
}


static void unity_spaces_manager_finalize (GObject* obj) {
	UnitySpacesManager * self;
	self = UNITY_SPACES_MANAGER (obj);
	_g_object_unref0 (self->priv->selector_group);
	_g_object_unref0 (self->priv->background);
	__g_list_free_g_object_unref0 (self->priv->clones);
	_g_object_unref0 (self->priv->plugin);
	_g_object_unref0 (self->priv->_button);
	_g_object_unref0 (self->priv->controller);
	G_OBJECT_CLASS (unity_spaces_manager_parent_class)->finalize (obj);
}


GType unity_spaces_manager_get_type (void) {
	static volatile gsize unity_spaces_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unity_spaces_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitySpacesManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_spaces_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitySpacesManager), 0, (GInstanceInitFunc) unity_spaces_manager_instance_init, NULL };
		GType unity_spaces_manager_type_id;
		unity_spaces_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnitySpacesManager", &g_define_type_info, 0);
		g_once_init_leave (&unity_spaces_manager_type_id__volatile, unity_spaces_manager_type_id);
	}
	return unity_spaces_manager_type_id__volatile;
}


static void unity_spaces_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnitySpacesManager * self;
	self = UNITY_SPACES_MANAGER (object);
	switch (property_id) {
		case UNITY_SPACES_MANAGER_BUTTON:
		g_value_set_object (value, unity_spaces_manager_get_button (self));
		break;
		case UNITY_SPACES_MANAGER_TOP_PADDING:
		g_value_set_uint (value, unity_spaces_manager_get_top_padding (self));
		break;
		case UNITY_SPACES_MANAGER_RIGHT_PADDING:
		g_value_set_uint (value, unity_spaces_manager_get_right_padding (self));
		break;
		case UNITY_SPACES_MANAGER_BOTTOM_PADDING:
		g_value_set_uint (value, unity_spaces_manager_get_bottom_padding (self));
		break;
		case UNITY_SPACES_MANAGER_LEFT_PADDING:
		g_value_set_uint (value, unity_spaces_manager_get_left_padding (self));
		break;
		case UNITY_SPACES_MANAGER_SPACING:
		g_value_set_uint (value, unity_spaces_manager_get_spacing (self));
		break;
		case UNITY_SPACES_MANAGER_SHOWING:
		g_value_set_boolean (value, unity_spaces_manager_get_showing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_spaces_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnitySpacesManager * self;
	self = UNITY_SPACES_MANAGER (object);
	switch (property_id) {
		case UNITY_SPACES_MANAGER_TOP_PADDING:
		unity_spaces_manager_set_top_padding (self, g_value_get_uint (value));
		break;
		case UNITY_SPACES_MANAGER_RIGHT_PADDING:
		unity_spaces_manager_set_right_padding (self, g_value_get_uint (value));
		break;
		case UNITY_SPACES_MANAGER_BOTTOM_PADDING:
		unity_spaces_manager_set_bottom_padding (self, g_value_get_uint (value));
		break;
		case UNITY_SPACES_MANAGER_LEFT_PADDING:
		unity_spaces_manager_set_left_padding (self, g_value_get_uint (value));
		break;
		case UNITY_SPACES_MANAGER_SPACING:
		unity_spaces_manager_set_spacing (self, g_value_get_uint (value));
		break;
		case UNITY_SPACES_MANAGER_SHOWING:
		unity_spaces_manager_set_showing (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




