/* unity-favorites.c generated by valac 0.10.0, the Vala compiler
 * generated from unity-favorites.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Gordon Allott <gord.allott@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf.h>
#include <config.h>
#include <glib/gstdio.h>


#define UNITY_TYPE_FAVORITES (unity_favorites_get_type ())
#define UNITY_FAVORITES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_FAVORITES, UnityFavorites))
#define UNITY_FAVORITES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_FAVORITES, UnityFavoritesClass))
#define UNITY_IS_FAVORITES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_FAVORITES))
#define UNITY_IS_FAVORITES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_FAVORITES))
#define UNITY_FAVORITES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_FAVORITES, UnityFavoritesClass))

typedef struct _UnityFavorites UnityFavorites;
typedef struct _UnityFavoritesClass UnityFavoritesClass;
typedef struct _UnityFavoritesPrivate UnityFavoritesPrivate;

#define UNITY_TYPE_GCONF_FAVORITES (unity_gconf_favorites_get_type ())
#define UNITY_GCONF_FAVORITES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_GCONF_FAVORITES, UnityGConfFavorites))
#define UNITY_GCONF_FAVORITES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_GCONF_FAVORITES, UnityGConfFavoritesClass))
#define UNITY_IS_GCONF_FAVORITES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_GCONF_FAVORITES))
#define UNITY_IS_GCONF_FAVORITES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_GCONF_FAVORITES))
#define UNITY_GCONF_FAVORITES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_GCONF_FAVORITES, UnityGConfFavoritesClass))

typedef struct _UnityGConfFavorites UnityGConfFavorites;
typedef struct _UnityGConfFavoritesClass UnityGConfFavoritesClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _UnityGConfFavoritesPrivate UnityGConfFavoritesPrivate;
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UnityFavorites {
	GObject parent_instance;
	UnityFavoritesPrivate * priv;
};

struct _UnityFavoritesClass {
	GObjectClass parent_class;
	GeeArrayList* (*get_favorites) (UnityFavorites* self);
	void (*add_favorite) (UnityFavorites* self, const char* uid);
	void (*remove_favorite) (UnityFavorites* self, const char* uid);
	gboolean (*is_favorite) (UnityFavorites* self, const char* uid);
	char* (*find_uid_for_desktop_file) (UnityFavorites* self, const char* desktop_file);
	char* (*get_string) (UnityFavorites* self, const char* uid, const char* name);
	void (*set_string) (UnityFavorites* self, const char* uid, const char* name, const char* value);
	gint* (*get_int) (UnityFavorites* self, const char* uid, const char* name);
	void (*set_int) (UnityFavorites* self, const char* uid, const char* name, gint value);
	float* (*get_float) (UnityFavorites* self, const char* uid, const char* name);
	void (*set_float) (UnityFavorites* self, const char* uid, const char* name, float value);
	gboolean* (*get_bool) (UnityFavorites* self, const char* uid, const char* name);
	void (*set_bool) (UnityFavorites* self, const char* uid, const char* name, gboolean value);
};

struct _UnityGConfFavorites {
	UnityFavorites parent_instance;
	UnityGConfFavoritesPrivate * priv;
};

struct _UnityGConfFavoritesClass {
	UnityFavoritesClass parent_class;
};

struct _UnityGConfFavoritesPrivate {
	GConfClient* client;
	GSList* fav_ids;
	GeeHashMap* notify_map;
};


extern UnityFavorites* unity_favorites_singleton;
UnityFavorites* unity_favorites_singleton = NULL;
static gpointer unity_favorites_parent_class = NULL;
static gpointer unity_gconf_favorites_parent_class = NULL;

GType unity_favorites_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_FAVORITES_DUMMY_PROPERTY
};
UnityFavorites* unity_favorites_get_default (void);
UnityGConfFavorites* unity_gconf_favorites_new (void);
UnityGConfFavorites* unity_gconf_favorites_construct (GType object_type);
GType unity_gconf_favorites_get_type (void) G_GNUC_CONST;
GeeArrayList* unity_favorites_get_favorites (UnityFavorites* self);
static GeeArrayList* unity_favorites_real_get_favorites (UnityFavorites* self);
void unity_favorites_add_favorite (UnityFavorites* self, const char* uid);
static void unity_favorites_real_add_favorite (UnityFavorites* self, const char* uid);
void unity_favorites_remove_favorite (UnityFavorites* self, const char* uid);
static void unity_favorites_real_remove_favorite (UnityFavorites* self, const char* uid);
gboolean unity_favorites_is_favorite (UnityFavorites* self, const char* uid);
static gboolean unity_favorites_real_is_favorite (UnityFavorites* self, const char* uid);
char* unity_favorites_find_uid_for_desktop_file (UnityFavorites* self, const char* desktop_file);
static char* unity_favorites_real_find_uid_for_desktop_file (UnityFavorites* self, const char* desktop_file);
char* unity_favorites_get_string (UnityFavorites* self, const char* uid, const char* name);
static char* unity_favorites_real_get_string (UnityFavorites* self, const char* uid, const char* name);
void unity_favorites_set_string (UnityFavorites* self, const char* uid, const char* name, const char* value);
static void unity_favorites_real_set_string (UnityFavorites* self, const char* uid, const char* name, const char* value);
gint* unity_favorites_get_int (UnityFavorites* self, const char* uid, const char* name);
static gint* unity_favorites_real_get_int (UnityFavorites* self, const char* uid, const char* name);
void unity_favorites_set_int (UnityFavorites* self, const char* uid, const char* name, gint value);
static void unity_favorites_real_set_int (UnityFavorites* self, const char* uid, const char* name, gint value);
float* unity_favorites_get_float (UnityFavorites* self, const char* uid, const char* name);
static float* unity_favorites_real_get_float (UnityFavorites* self, const char* uid, const char* name);
void unity_favorites_set_float (UnityFavorites* self, const char* uid, const char* name, float value);
static void unity_favorites_real_set_float (UnityFavorites* self, const char* uid, const char* name, float value);
gboolean* unity_favorites_get_bool (UnityFavorites* self, const char* uid, const char* name);
static gboolean* unity_favorites_real_get_bool (UnityFavorites* self, const char* uid, const char* name);
void unity_favorites_set_bool (UnityFavorites* self, const char* uid, const char* name, gboolean value);
static void unity_favorites_real_set_bool (UnityFavorites* self, const char* uid, const char* name, gboolean value);
UnityFavorites* unity_favorites_construct (GType object_type);
#define UNITY_GCONF_FAVORITES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_GCONF_FAVORITES, UnityGConfFavoritesPrivate))
enum  {
	UNITY_GCONF_FAVORITES_DUMMY_PROPERTY
};
static void _g_slist_free_g_free (GSList* self);
#define UNITY_GCONF_FAVORITES_path "/desktop/unity/launcher/favorites/"
static char* unity_gconf_favorites_real_find_uid_for_desktop_file (UnityFavorites* base, const char* desktop_file);
static GeeArrayList* unity_gconf_favorites_real_get_favorites (UnityFavorites* base);
static void unity_gconf_favorites_real_add_favorite (UnityFavorites* base, const char* uid);
static void unity_gconf_favorites_real_remove_favorite (UnityFavorites* base, const char* uid);
static gboolean unity_gconf_favorites_real_is_favorite (UnityFavorites* base, const char* uid);
static char* unity_gconf_favorites_real_get_string (UnityFavorites* base, const char* uid, const char* name);
static void unity_gconf_favorites_real_set_string (UnityFavorites* base, const char* uid, const char* name, const char* value);
static gint* unity_gconf_favorites_real_get_int (UnityFavorites* base, const char* uid, const char* name);
static gint* _int_dup (gint* self);
static void unity_gconf_favorites_real_set_int (UnityFavorites* base, const char* uid, const char* name, gint value);
static float* unity_gconf_favorites_real_get_float (UnityFavorites* base, const char* uid, const char* name);
static float* _float_dup (float* self);
static void unity_gconf_favorites_real_set_float (UnityFavorites* base, const char* uid, const char* name, float value);
static gboolean* unity_gconf_favorites_real_get_bool (UnityFavorites* base, const char* uid, const char* name);
static gboolean* _bool_dup (gboolean* self);
static void unity_gconf_favorites_real_set_bool (UnityFavorites* base, const char* uid, const char* name, gboolean value);
static void unity_gconf_favorites_compare_string_list (UnityGConfFavorites* self, GSList* old_list, GSList* new_list, GSList** added, GSList** removed);
static void unity_gconf_favorites_notify_on_favorites_list_changed (UnityGConfFavorites* self);
static void unity_gconf_favorites_on_favorite_added (UnityGConfFavorites* self, const char* uid);
static void unity_gconf_favorites_notify_on_favorite_changed (UnityGConfFavorites* self, GConfClient* _client, guint cnxn_id, GConfEntry* entry);
static void _unity_gconf_favorites_notify_on_favorite_changed_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self);
static void unity_gconf_favorites_on_favorite_removed (UnityGConfFavorites* self, const char* uid);
static void _unity_gconf_favorites_on_favorite_added_unity_favorites_favorite_added (UnityFavorites* _sender, const char* uid, gpointer self);
static void _unity_gconf_favorites_on_favorite_removed_unity_favorites_favorite_removed (UnityFavorites* _sender, const char* uid, gpointer self);
static void _unity_gconf_favorites_notify_on_favorites_list_changed_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self);
static GObject * unity_gconf_favorites_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_gconf_favorites_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


UnityFavorites* unity_favorites_get_default (void) {
	UnityFavorites* result = NULL;
	if (!UNITY_IS_FAVORITES (unity_favorites_singleton)) {
		UnityFavorites* _tmp0_;
		unity_favorites_singleton = (_tmp0_ = (UnityFavorites*) unity_gconf_favorites_new (), _g_object_unref0 (unity_favorites_singleton), _tmp0_);
	}
	result = _g_object_ref0 (unity_favorites_singleton);
	return result;
}


static GeeArrayList* unity_favorites_real_get_favorites (UnityFavorites* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_get_favorites'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeArrayList* unity_favorites_get_favorites (UnityFavorites* self) {
	return UNITY_FAVORITES_GET_CLASS (self)->get_favorites (self);
}


static void unity_favorites_real_add_favorite (UnityFavorites* self, const char* uid) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_add_favorite'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_favorites_add_favorite (UnityFavorites* self, const char* uid) {
	UNITY_FAVORITES_GET_CLASS (self)->add_favorite (self, uid);
}


static void unity_favorites_real_remove_favorite (UnityFavorites* self, const char* uid) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_remove_favorite'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_favorites_remove_favorite (UnityFavorites* self, const char* uid) {
	UNITY_FAVORITES_GET_CLASS (self)->remove_favorite (self, uid);
}


static gboolean unity_favorites_real_is_favorite (UnityFavorites* self, const char* uid) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_is_favorite'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean unity_favorites_is_favorite (UnityFavorites* self, const char* uid) {
	return UNITY_FAVORITES_GET_CLASS (self)->is_favorite (self, uid);
}


static char* unity_favorites_real_find_uid_for_desktop_file (UnityFavorites* self, const char* desktop_file) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_find_uid_for_desktop_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* unity_favorites_find_uid_for_desktop_file (UnityFavorites* self, const char* desktop_file) {
	return UNITY_FAVORITES_GET_CLASS (self)->find_uid_for_desktop_file (self, desktop_file);
}


static char* unity_favorites_real_get_string (UnityFavorites* self, const char* uid, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_get_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* unity_favorites_get_string (UnityFavorites* self, const char* uid, const char* name) {
	return UNITY_FAVORITES_GET_CLASS (self)->get_string (self, uid, name);
}


static void unity_favorites_real_set_string (UnityFavorites* self, const char* uid, const char* name, const char* value) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_set_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_favorites_set_string (UnityFavorites* self, const char* uid, const char* name, const char* value) {
	UNITY_FAVORITES_GET_CLASS (self)->set_string (self, uid, name, value);
}


static gint* unity_favorites_real_get_int (UnityFavorites* self, const char* uid, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_get_int'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gint* unity_favorites_get_int (UnityFavorites* self, const char* uid, const char* name) {
	return UNITY_FAVORITES_GET_CLASS (self)->get_int (self, uid, name);
}


static void unity_favorites_real_set_int (UnityFavorites* self, const char* uid, const char* name, gint value) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_set_int'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_favorites_set_int (UnityFavorites* self, const char* uid, const char* name, gint value) {
	UNITY_FAVORITES_GET_CLASS (self)->set_int (self, uid, name, value);
}


static float* unity_favorites_real_get_float (UnityFavorites* self, const char* uid, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_get_float'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


float* unity_favorites_get_float (UnityFavorites* self, const char* uid, const char* name) {
	return UNITY_FAVORITES_GET_CLASS (self)->get_float (self, uid, name);
}


static void unity_favorites_real_set_float (UnityFavorites* self, const char* uid, const char* name, float value) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_set_float'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_favorites_set_float (UnityFavorites* self, const char* uid, const char* name, float value) {
	UNITY_FAVORITES_GET_CLASS (self)->set_float (self, uid, name, value);
}


static gboolean* unity_favorites_real_get_bool (UnityFavorites* self, const char* uid, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_get_bool'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gboolean* unity_favorites_get_bool (UnityFavorites* self, const char* uid, const char* name) {
	return UNITY_FAVORITES_GET_CLASS (self)->get_bool (self, uid, name);
}


static void unity_favorites_real_set_bool (UnityFavorites* self, const char* uid, const char* name, gboolean value) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_favorites_set_bool'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_favorites_set_bool (UnityFavorites* self, const char* uid, const char* name, gboolean value) {
	UNITY_FAVORITES_GET_CLASS (self)->set_bool (self, uid, name, value);
}


UnityFavorites* unity_favorites_construct (GType object_type) {
	UnityFavorites * self;
	self = (UnityFavorites*) g_object_new (object_type, NULL);
	return self;
}


static void unity_favorites_class_init (UnityFavoritesClass * klass) {
	unity_favorites_parent_class = g_type_class_peek_parent (klass);
	UNITY_FAVORITES_CLASS (klass)->get_favorites = unity_favorites_real_get_favorites;
	UNITY_FAVORITES_CLASS (klass)->add_favorite = unity_favorites_real_add_favorite;
	UNITY_FAVORITES_CLASS (klass)->remove_favorite = unity_favorites_real_remove_favorite;
	UNITY_FAVORITES_CLASS (klass)->is_favorite = unity_favorites_real_is_favorite;
	UNITY_FAVORITES_CLASS (klass)->find_uid_for_desktop_file = unity_favorites_real_find_uid_for_desktop_file;
	UNITY_FAVORITES_CLASS (klass)->get_string = unity_favorites_real_get_string;
	UNITY_FAVORITES_CLASS (klass)->set_string = unity_favorites_real_set_string;
	UNITY_FAVORITES_CLASS (klass)->get_int = unity_favorites_real_get_int;
	UNITY_FAVORITES_CLASS (klass)->set_int = unity_favorites_real_set_int;
	UNITY_FAVORITES_CLASS (klass)->get_float = unity_favorites_real_get_float;
	UNITY_FAVORITES_CLASS (klass)->set_float = unity_favorites_real_set_float;
	UNITY_FAVORITES_CLASS (klass)->get_bool = unity_favorites_real_get_bool;
	UNITY_FAVORITES_CLASS (klass)->set_bool = unity_favorites_real_set_bool;
	g_signal_new ("favorite_added", UNITY_TYPE_FAVORITES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("favorite_removed", UNITY_TYPE_FAVORITES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("favorite_changed", UNITY_TYPE_FAVORITES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void unity_favorites_instance_init (UnityFavorites * self) {
}


GType unity_favorites_get_type (void) {
	static volatile gsize unity_favorites_type_id__volatile = 0;
	if (g_once_init_enter (&unity_favorites_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFavoritesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_favorites_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFavorites), 0, (GInstanceInitFunc) unity_favorites_instance_init, NULL };
		GType unity_favorites_type_id;
		unity_favorites_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFavorites", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&unity_favorites_type_id__volatile, unity_favorites_type_id);
	}
	return unity_favorites_type_id__volatile;
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


static char* unity_gconf_favorites_real_find_uid_for_desktop_file (UnityFavorites* base, const char* desktop_file) {
	UnityGConfFavorites * self;
	char* result = NULL;
	char* uid;
	self = (UnityGConfFavorites*) base;
	g_return_val_if_fail (desktop_file != NULL, NULL);
	uid = g_strdup ("");
	{
		GSList* id_collection;
		GSList* id_it;
		id_collection = self->priv->fav_ids;
		for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
			char* id;
			id = g_strdup ((const char*) id_it->data);
			{
				char* fav_desktop_file;
				fav_desktop_file = unity_favorites_get_string ((UnityFavorites*) self, id, "desktop_file");
				if (_vala_strcmp0 (fav_desktop_file, desktop_file) == 0) {
					char* _tmp0_;
					uid = (_tmp0_ = g_strdup (id), _g_free0 (uid), _tmp0_);
					_g_free0 (fav_desktop_file);
					_g_free0 (id);
					break;
				}
				_g_free0 (fav_desktop_file);
				_g_free0 (id);
			}
		}
	}
	result = uid;
	return result;
}


static GeeArrayList* unity_gconf_favorites_real_get_favorites (UnityFavorites* base) {
	UnityGConfFavorites * self;
	GeeArrayList* result = NULL;
	GeeArrayList* favorites;
	self = (UnityGConfFavorites*) base;
	favorites = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	{
		GSList* id_collection;
		GSList* id_it;
		id_collection = self->priv->fav_ids;
		for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
			char* id;
			id = g_strdup ((const char*) id_it->data);
			{
				gee_abstract_collection_add ((GeeAbstractCollection*) favorites, id);
				_g_free0 (id);
			}
		}
	}
	result = favorites;
	return result;
}


static void unity_gconf_favorites_real_add_favorite (UnityFavorites* base, const char* uid) {
	UnityGConfFavorites * self;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_if_fail (uid != NULL);
	if (!unity_favorites_is_favorite ((UnityFavorites*) self, uid)) {
		self->priv->fav_ids = g_slist_append (self->priv->fav_ids, g_strdup (uid));
		{
			gconf_client_set_list (self->priv->client, UNITY_GCONF_FAVORITES_path "favorites_list", GCONF_VALUE_STRING, self->priv->fav_ids, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
		}
		goto __finally17;
		__catch17_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("unity-favorites.vala:151: Could not set the favorites list: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally17:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_signal_emit_by_name ((UnityFavorites*) self, "favorite-added", uid);
	}
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void unity_gconf_favorites_real_remove_favorite (UnityFavorites* base, const char* uid) {
	UnityGConfFavorites * self;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_if_fail (uid != NULL);
	if (unity_favorites_is_favorite ((UnityFavorites*) self, uid)) {
		GSList* l;
		l = NULL;
		{
			gboolean _tmp0_;
			l = self->priv->fav_ids;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* id;
				if (!_tmp0_) {
					l = l->next;
				}
				_tmp0_ = FALSE;
				if (!(l != NULL)) {
					break;
				}
				id = g_strdup ((const char*) l->data);
				if (_vala_strcmp0 (id, uid) == 0) {
					self->priv->fav_ids = g_slist_remove (self->priv->fav_ids, (const char*) l->data);
					_g_free0 (id);
					break;
				}
				_g_free0 (id);
			}
		}
		self->priv->fav_ids = g_slist_remove (self->priv->fav_ids, uid);
		{
			gconf_client_set_list (self->priv->client, UNITY_GCONF_FAVORITES_path "favorites_list", GCONF_VALUE_STRING, self->priv->fav_ids, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch18_g_error;
			}
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("unity-favorites.vala:179: Could not set the favorites list: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally18:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_signal_emit_by_name ((UnityFavorites*) self, "favorite-removed", uid);
	} else {
		char* _tmp1_;
		g_warning ("unity-favorites.vala:186: %s", _tmp1_ = g_strconcat ("'", string_to_string (uid), "' is not a favorite", NULL));
		_g_free0 (_tmp1_);
	}
}


static gboolean unity_gconf_favorites_real_is_favorite (UnityFavorites* base, const char* uid) {
	UnityGConfFavorites * self;
	gboolean result = FALSE;
	self = (UnityGConfFavorites*) base;
	g_return_val_if_fail (uid != NULL, FALSE);
	{
		GSList* id_collection;
		GSList* id_it;
		id_collection = self->priv->fav_ids;
		for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
			char* id;
			id = g_strdup ((const char*) id_it->data);
			{
				if (_vala_strcmp0 (id, uid) == 0) {
					result = TRUE;
					_g_free0 (id);
					return result;
				}
				_g_free0 (id);
			}
		}
	}
	result = FALSE;
	return result;
}


static char* unity_gconf_favorites_real_get_string (UnityFavorites* base, const char* uid, const char* name) {
	UnityGConfFavorites * self;
	char* result = NULL;
	char* return_string;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	return_string = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		char* _tmp4_;
		char* _tmp5_;
		_tmp4_ = (_tmp3_ = gconf_client_get_string (self->priv->client, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), name, NULL), &_inner_error_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		return_string = (_tmp5_ = _tmp4_, _g_free0 (return_string), _tmp5_);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:211: GConf string lookup failed: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_free0 (return_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = return_string;
	return result;
}


static void unity_gconf_favorites_real_set_string (UnityFavorites* base, const char* uid, const char* name, const char* value) {
	UnityGConfFavorites * self;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_if_fail (uid != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gconf_client_set_string (self->priv->client, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), name, NULL), value, &_inner_error_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:224: GConf string setting failed: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static gint* unity_gconf_favorites_real_get_int (UnityFavorites* base, const char* uid, const char* name) {
	UnityGConfFavorites * self;
	gint* result = NULL;
	gint* return_val;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	return_val = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint* _tmp5_;
		_tmp4_ = (_tmp3_ = gconf_client_get_int (self->priv->client, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), name, NULL), &_inner_error_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		return_val = (_tmp5_ = __int_dup0 (&_tmp4_), _g_free0 (return_val), _tmp5_);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:237: GConf int lookup failed: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_free0 (return_val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = return_val;
	return result;
}


static void unity_gconf_favorites_real_set_int (UnityFavorites* base, const char* uid, const char* name, gint value) {
	UnityGConfFavorites * self;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_if_fail (uid != NULL);
	g_return_if_fail (name != NULL);
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gconf_client_set_int (self->priv->client, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), name, NULL), value, &_inner_error_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:250: GConf int setting failed: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally22:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static float* _float_dup (float* self) {
	float* dup;
	dup = g_new0 (float, 1);
	memcpy (dup, self, sizeof (float));
	return dup;
}


static gpointer __float_dup0 (gpointer self) {
	return self ? _float_dup (self) : NULL;
}


static float* unity_gconf_favorites_real_get_float (UnityFavorites* base, const char* uid, const char* name) {
	UnityGConfFavorites * self;
	float* result = NULL;
	float* return_val;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	return_val = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		double _tmp3_;
		double _tmp4_;
		float _tmp5_;
		float* _tmp6_;
		_tmp4_ = (_tmp3_ = gconf_client_get_float (self->priv->client, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), name, NULL), &_inner_error_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch23_g_error;
		}
		return_val = (_tmp6_ = __float_dup0 ((_tmp5_ = (float) _tmp4_, &_tmp5_)), _g_free0 (return_val), _tmp6_);
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:263: GConf float lookup failed: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_free0 (return_val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = return_val;
	return result;
}


static void unity_gconf_favorites_real_set_float (UnityFavorites* base, const char* uid, const char* name, float value) {
	UnityGConfFavorites * self;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_if_fail (uid != NULL);
	g_return_if_fail (name != NULL);
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gconf_client_set_float (self->priv->client, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), name, NULL), (double) value, &_inner_error_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:276: GConf float set failed: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally24:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


static gboolean* unity_gconf_favorites_real_get_bool (UnityFavorites* base, const char* uid, const char* name) {
	UnityGConfFavorites * self;
	gboolean* result = NULL;
	gboolean* return_val;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	return_val = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gboolean* _tmp5_;
		_tmp4_ = (_tmp3_ = gconf_client_get_bool (self->priv->client, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), name, NULL), &_inner_error_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
		return_val = (_tmp5_ = __bool_dup0 (&_tmp4_), _g_free0 (return_val), _tmp5_);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:289: GConf bool lookup failed: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_free0 (return_val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = return_val;
	return result;
}


static void unity_gconf_favorites_real_set_bool (UnityFavorites* base, const char* uid, const char* name, gboolean value) {
	UnityGConfFavorites * self;
	GError * _inner_error_ = NULL;
	self = (UnityGConfFavorites*) base;
	g_return_if_fail (uid != NULL);
	g_return_if_fail (name != NULL);
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		gconf_client_set_bool (self->priv->client, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), name, NULL), value, &_inner_error_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:302: GConf bool setting failed: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void unity_gconf_favorites_compare_string_list (UnityGConfFavorites* self, GSList* old_list, GSList* new_list, GSList** added, GSList** removed) {
	GSList* unchanged;
	g_return_if_fail (self != NULL);
	if (added != NULL) {
		*added = NULL;
	}
	if (removed != NULL) {
		*removed = NULL;
	}
	unchanged = NULL;
	{
		GSList* id_collection;
		GSList* id_it;
		id_collection = new_list;
		for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
			char* id;
			id = g_strdup ((const char*) id_it->data);
			{
				char* item;
				item = NULL;
				{
					GSList* old_item_collection;
					GSList* old_item_it;
					old_item_collection = old_list;
					for (old_item_it = old_item_collection; old_item_it != NULL; old_item_it = old_item_it->next) {
						char* old_item;
						old_item = g_strdup ((const char*) old_item_it->data);
						{
							if (_vala_strcmp0 (id, old_item) == 0) {
								char* _tmp0_;
								item = (_tmp0_ = g_strdup (old_item), _g_free0 (item), _tmp0_);
							}
							_g_free0 (old_item);
						}
					}
				}
				if (item != NULL) {
					unchanged = g_slist_append (unchanged, g_strdup (id));
				} else {
					*added = g_slist_append (*added, g_strdup (id));
				}
				_g_free0 (item);
				_g_free0 (id);
			}
		}
	}
	{
		GSList* id_collection;
		GSList* id_it;
		id_collection = old_list;
		for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
			char* id;
			id = g_strdup ((const char*) id_it->data);
			{
				char* item;
				item = NULL;
				{
					GSList* unchanged_item_collection;
					GSList* unchanged_item_it;
					unchanged_item_collection = unchanged;
					for (unchanged_item_it = unchanged_item_collection; unchanged_item_it != NULL; unchanged_item_it = unchanged_item_it->next) {
						char* unchanged_item;
						unchanged_item = g_strdup ((const char*) unchanged_item_it->data);
						{
							if (_vala_strcmp0 (unchanged_item, id) == 0) {
								char* _tmp1_;
								item = (_tmp1_ = g_strdup (unchanged_item), _g_free0 (item), _tmp1_);
							}
							_g_free0 (unchanged_item);
						}
					}
				}
				if (item == NULL) {
					*removed = g_slist_append (*removed, g_strdup (id));
				}
				_g_free0 (item);
				_g_free0 (id);
			}
		}
	}
	__g_slist_free_g_free0 (unchanged);
}


static void unity_gconf_favorites_notify_on_favorites_list_changed (UnityGConfFavorites* self) {
	GSList* items_added;
	GSList* items_removed;
	GSList* new_favs;
	GSList* _tmp2_ = NULL;
	GSList* _tmp3_;
	GSList* _tmp4_ = NULL;
	GSList* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	items_added = NULL;
	items_removed = NULL;
	new_favs = NULL;
	{
		GSList* _tmp0_;
		GSList* _tmp1_;
		_tmp0_ = gconf_client_get_list (self->priv->client, UNITY_GCONF_FAVORITES_path "favorites_list", GCONF_VALUE_STRING, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
		new_favs = (_tmp1_ = _tmp0_, __g_slist_free_g_free0 (new_favs), _tmp1_);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:365: Could not get favourite list from gconf %s", e->message);
			_g_error_free0 (e);
			__g_slist_free_g_free0 (new_favs);
			__g_slist_free_g_free0 (items_removed);
			__g_slist_free_g_free0 (items_added);
			return;
		}
	}
	__finally27:
	if (_inner_error_ != NULL) {
		__g_slist_free_g_free0 (new_favs);
		__g_slist_free_g_free0 (items_removed);
		__g_slist_free_g_free0 (items_added);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	(unity_gconf_favorites_compare_string_list (self, self->priv->fav_ids, new_favs, &_tmp2_, &_tmp4_), items_added = (_tmp3_ = _tmp2_, __g_slist_free_g_free0 (items_added), _tmp3_));
	items_removed = (_tmp5_ = _tmp4_, __g_slist_free_g_free0 (items_removed), _tmp5_);
	{
		GSList* id_collection;
		GSList* id_it;
		id_collection = items_added;
		for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
			char* id;
			id = g_strdup ((const char*) id_it->data);
			{
				g_signal_emit_by_name ((UnityFavorites*) self, "favorite-added", id);
				_g_free0 (id);
			}
		}
	}
	{
		GSList* id_collection;
		GSList* id_it;
		id_collection = items_removed;
		for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
			char* id;
			id = g_strdup ((const char*) id_it->data);
			{
				g_signal_emit_by_name ((UnityFavorites*) self, "favorite-removed", id);
				_g_free0 (id);
			}
		}
	}
	__g_slist_free_g_free0 (new_favs);
	__g_slist_free_g_free0 (items_removed);
	__g_slist_free_g_free0 (items_added);
}


static void _unity_gconf_favorites_notify_on_favorite_changed_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self) {
	unity_gconf_favorites_notify_on_favorite_changed (self, client, cnxn_id, entry);
}


static void unity_gconf_favorites_on_favorite_added (UnityGConfFavorites* self, const char* uid) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	{
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		guint _tmp4_;
		guint notify_id;
		gconf_client_add_dir (self->priv->client, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), GCONF_CLIENT_PRELOAD_NONE, &_inner_error_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
		notify_id = (_tmp4_ = gconf_client_notify_add (self->priv->client, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat (UNITY_GCONF_FAVORITES_path, uid, NULL), "/", NULL), _unity_gconf_favorites_notify_on_favorite_changed_gconf_client_notify_func, g_object_ref (self), g_object_unref, &_inner_error_), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _tmp4_);
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->notify_map, uid, GUINT_TO_POINTER (notify_id));
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-favorites.vala:393: Unable to monitor gconf for favorite changes" \
": %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void unity_gconf_favorites_on_favorite_removed (UnityGConfFavorites* self, const char* uid) {
	guint notify_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	notify_id = GPOINTER_TO_UINT (gee_abstract_map_get ((GeeAbstractMap*) self->priv->notify_map, uid));
	gconf_client_notify_remove (self->priv->client, notify_id);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->notify_map, uid, NULL);
	self->priv->fav_ids = g_slist_remove_all (self->priv->fav_ids, uid);
}


static void unity_gconf_favorites_notify_on_favorite_changed (UnityGConfFavorites* self, GConfClient* _client, guint cnxn_id, GConfEntry* entry) {
	char** _tmp0_;
	char** _tmp1_;
	gint _tmp1__length1;
	char** _tmp2_;
	char** _tmp3_;
	gint _tmp3__length1;
	char* _tmp4_;
	char* uid;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_client != NULL);
	g_return_if_fail (entry != NULL);
	uid = (_tmp4_ = g_strdup ((_tmp3_ = _tmp2_ = g_strsplit ((_tmp1_ = _tmp0_ = g_strsplit (entry->key, UNITY_GCONF_FAVORITES_path, 2), _tmp1__length1 = _vala_array_length (_tmp0_), _tmp1_)[1], "/", 2), _tmp3__length1 = _vala_array_length (_tmp2_), _tmp3_)[0]), _tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL), _tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL), _tmp4_);
	if (unity_favorites_is_favorite ((UnityFavorites*) self, uid)) {
		g_signal_emit_by_name ((UnityFavorites*) self, "favorite-changed", uid);
	} else {
		g_warning ("unity-favorites.vala:420: got strange uid %s: %s", uid, entry->key);
		_g_free0 (uid);
		return;
	}
	_g_free0 (uid);
}


UnityGConfFavorites* unity_gconf_favorites_construct (GType object_type) {
	UnityGConfFavorites * self;
	self = (UnityGConfFavorites*) unity_favorites_construct (object_type);
	return self;
}


UnityGConfFavorites* unity_gconf_favorites_new (void) {
	return unity_gconf_favorites_construct (UNITY_TYPE_GCONF_FAVORITES);
}


static void _unity_gconf_favorites_on_favorite_added_unity_favorites_favorite_added (UnityFavorites* _sender, const char* uid, gpointer self) {
	unity_gconf_favorites_on_favorite_added (self, uid);
}


static void _unity_gconf_favorites_on_favorite_removed_unity_favorites_favorite_removed (UnityFavorites* _sender, const char* uid, gpointer self) {
	unity_gconf_favorites_on_favorite_removed (self, uid);
}


static void _unity_gconf_favorites_notify_on_favorites_list_changed_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self) {
	unity_gconf_favorites_notify_on_favorites_list_changed (self);
}


static GObject * unity_gconf_favorites_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityGConfFavorites * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (unity_gconf_favorites_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_GCONF_FAVORITES (obj);
	_inner_error_ = NULL;
	{
		char* gconf_custom_dir;
		char* migration_script;
		gboolean _tmp0_ = FALSE;
		GConfClient* _tmp1_;
		GeeHashMap* _tmp2_;
		gconf_custom_dir = g_strconcat (g_get_home_dir (), "/.gconf/desktop/unity", NULL);
		migration_script = g_strdup (PREFIXDIR "/lib/unity/migrate_favorites.py");
		if (!g_file_test (gconf_custom_dir, G_FILE_TEST_IS_DIR)) {
			_tmp0_ = g_file_test (migration_script, G_FILE_TEST_IS_EXECUTABLE);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			{
				g_spawn_command_line_sync (migration_script, NULL, NULL, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_SPAWN_ERROR) {
						goto __catch29_g_spawn_error;
					}
					_g_free0 (migration_script);
					_g_free0 (gconf_custom_dir);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
				}
			}
			goto __finally29;
			__catch29_g_spawn_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (e);
				}
			}
			__finally29:
			if (_inner_error_ != NULL) {
				_g_free0 (migration_script);
				_g_free0 (gconf_custom_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
		}
		self->priv->client = (_tmp1_ = _g_object_ref0 (gconf_client_get_default ()), _g_object_unref0 (self->priv->client), _tmp1_);
		self->priv->notify_map = (_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL), _g_object_unref0 (self->priv->notify_map), _tmp2_);
		g_signal_connect_object ((UnityFavorites*) self, "favorite-added", (GCallback) _unity_gconf_favorites_on_favorite_added_unity_favorites_favorite_added, self, 0);
		g_signal_connect_object ((UnityFavorites*) self, "favorite-removed", (GCallback) _unity_gconf_favorites_on_favorite_removed_unity_favorites_favorite_removed, self, 0);
		{
			GSList* _tmp3_;
			GSList* _tmp4_;
			_tmp3_ = gconf_client_get_list (self->priv->client, UNITY_GCONF_FAVORITES_path "favorites_list", GCONF_VALUE_STRING, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch30_g_error;
			}
			self->priv->fav_ids = (_tmp4_ = _tmp3_, __g_slist_free_g_free0 (self->priv->fav_ids), _tmp4_);
		}
		goto __finally30;
		__catch30_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				GSList* _tmp5_;
				g_warning ("unity-favorites.vala:91: Could not grab favorites from gconf %s", e->message);
				self->priv->fav_ids = (_tmp5_ = NULL, __g_slist_free_g_free0 (self->priv->fav_ids), _tmp5_);
				_g_error_free0 (e);
			}
		}
		__finally30:
		if (_inner_error_ != NULL) {
			_g_free0 (migration_script);
			_g_free0 (gconf_custom_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		{
			gconf_client_add_dir (self->priv->client, UNITY_GCONF_FAVORITES_path "favorites_list", GCONF_CLIENT_PRELOAD_NONE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch31_g_error;
			}
			gconf_client_notify_add (self->priv->client, UNITY_GCONF_FAVORITES_path "favorites_list", _unity_gconf_favorites_notify_on_favorites_list_changed_gconf_client_notify_func, g_object_ref (self), g_object_unref, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch31_g_error;
			}
		}
		goto __finally31;
		__catch31_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("unity-favorites.vala:105: Unable to monitor gconf for favorites change" \
"s: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally31:
		if (_inner_error_ != NULL) {
			_g_free0 (migration_script);
			_g_free0 (gconf_custom_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_free0 (migration_script);
		_g_free0 (gconf_custom_dir);
	}
	return obj;
}


static void unity_gconf_favorites_class_init (UnityGConfFavoritesClass * klass) {
	unity_gconf_favorites_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityGConfFavoritesPrivate));
	UNITY_FAVORITES_CLASS (klass)->find_uid_for_desktop_file = unity_gconf_favorites_real_find_uid_for_desktop_file;
	UNITY_FAVORITES_CLASS (klass)->get_favorites = unity_gconf_favorites_real_get_favorites;
	UNITY_FAVORITES_CLASS (klass)->add_favorite = unity_gconf_favorites_real_add_favorite;
	UNITY_FAVORITES_CLASS (klass)->remove_favorite = unity_gconf_favorites_real_remove_favorite;
	UNITY_FAVORITES_CLASS (klass)->is_favorite = unity_gconf_favorites_real_is_favorite;
	UNITY_FAVORITES_CLASS (klass)->get_string = unity_gconf_favorites_real_get_string;
	UNITY_FAVORITES_CLASS (klass)->set_string = unity_gconf_favorites_real_set_string;
	UNITY_FAVORITES_CLASS (klass)->get_int = unity_gconf_favorites_real_get_int;
	UNITY_FAVORITES_CLASS (klass)->set_int = unity_gconf_favorites_real_set_int;
	UNITY_FAVORITES_CLASS (klass)->get_float = unity_gconf_favorites_real_get_float;
	UNITY_FAVORITES_CLASS (klass)->set_float = unity_gconf_favorites_real_set_float;
	UNITY_FAVORITES_CLASS (klass)->get_bool = unity_gconf_favorites_real_get_bool;
	UNITY_FAVORITES_CLASS (klass)->set_bool = unity_gconf_favorites_real_set_bool;
	G_OBJECT_CLASS (klass)->constructor = unity_gconf_favorites_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_gconf_favorites_finalize;
}


static void unity_gconf_favorites_instance_init (UnityGConfFavorites * self) {
	self->priv = UNITY_GCONF_FAVORITES_GET_PRIVATE (self);
}


static void unity_gconf_favorites_finalize (GObject* obj) {
	UnityGConfFavorites * self;
	self = UNITY_GCONF_FAVORITES (obj);
	_g_object_unref0 (self->priv->client);
	__g_slist_free_g_free0 (self->priv->fav_ids);
	_g_object_unref0 (self->priv->notify_map);
	G_OBJECT_CLASS (unity_gconf_favorites_parent_class)->finalize (obj);
}


GType unity_gconf_favorites_get_type (void) {
	static volatile gsize unity_gconf_favorites_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gconf_favorites_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityGConfFavoritesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_gconf_favorites_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGConfFavorites), 0, (GInstanceInitFunc) unity_gconf_favorites_instance_init, NULL };
		GType unity_gconf_favorites_type_id;
		unity_gconf_favorites_type_id = g_type_register_static (UNITY_TYPE_FAVORITES, "UnityGConfFavorites", &g_define_type_info, 0);
		g_once_init_leave (&unity_gconf_favorites_type_id__volatile, unity_gconf_favorites_type_id);
	}
	return unity_gconf_favorites_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




