var useragentswitcher_appName            = null;
var useragentswitcher_appVersion         = null;
var useragentswitcher_description        = null;
var useragentswitcher_optionsDataBoolean = new Array();
var useragentswitcher_optionsDataInteger = new Array();
var useragentswitcher_optionsDataString  = new Array();
var useragentswitcher_platform           = null;
var useragentswitcher_userAgent          = null;
var useragentswitcher_vendor             = null;
var useragentswitcher_vendorSub          = null;

// Adds a user agent
function useragentswitcher_addUserAgent()
{
    var pageDocument = document.getElementById("useragentswitcher-options-iframe").contentDocument;
    var userAgentBox = pageDocument.getElementById("useragentswitcher-listbox");

    window.openDialog("chrome://useragentswitcher/content/options/dialogs/user_agent.xul", "useragentswitcher-user-agent-dialog", "centerscreen,chrome,modal,resizable", "add");

    // If the description is set
    if(useragentswitcher_description)
    {
        var newItem = userAgentBox.appendItem(useragentswitcher_description, useragentswitcher_userAgent);

        newItem.setAttribute("appname", useragentswitcher_appName);
        newItem.setAttribute("appversion", useragentswitcher_appVersion);
        newItem.setAttribute("platform", useragentswitcher_platform);
        newItem.setAttribute("vendor", useragentswitcher_vendor);
        newItem.setAttribute("vendorsub", useragentswitcher_vendorSub);

        userAgentBox.selectItem(newItem);
        userAgentBox.ensureElementIsVisible(newItem);
    }
}

// Handles changing the options page
function useragentswitcher_changePage(pageList)
{
    useragentswitcher_storeOptions();

    document.getElementById("useragentswitcher-options-iframe").setAttribute("src", pageList.selectedItem.getAttribute("value"));
}

// Deletes a user agent
function useragentswitcher_deleteUserAgent()
{
    var pageDocument = document.getElementById("useragentswitcher-options-iframe").contentDocument;
    var userAgentBox = pageDocument.getElementById("useragentswitcher-listbox");
    var selectedItem = userAgentBox.selectedItem;

    // If an item is selected and the deletion is confirmed
    if(selectedItem && confirm(document.getElementById("useragentswitcher-string-bundle").getString("useragentswitcher_deleteConfirmation")))
    {
        userAgentBox.removeChild(selectedItem);
    }
}

// Edits a user agent
function useragentswitcher_editUserAgent()
{
    var pageDocument = document.getElementById("useragentswitcher-options-iframe").contentDocument;
    var userAgentBox = pageDocument.getElementById("useragentswitcher-listbox");
    var selectedItem = userAgentBox.selectedItem;

    // If an item is selected
    if(selectedItem)
    {
        var appName    = "";
        var appVersion = "";
        var platform   = "";
        var vendor     = "";
        var vendorSub  = "";

        // If the selected item has an app name attribute
        if(selectedItem.hasAttribute("appname"))
        {
            appName = selectedItem.getAttribute("appname");
        }

        // If the selected item has an app version attribute
        if(selectedItem.hasAttribute("appversion"))
        {
            appVersion = selectedItem.getAttribute("appversion");
        }

        // If the selected item has a platform attribute
        if(selectedItem.hasAttribute("platform"))
        {
            platform = selectedItem.getAttribute("platform");
        }

        // If the selected item has a vendor attribute
        if(selectedItem.hasAttribute("vendor"))
        {
            vendor = selectedItem.getAttribute("vendor");
        }

        // If the selected item has a vendorsub attribute
        if(selectedItem.hasAttribute("vendorsub"))
        {
            vendorSub = selectedItem.getAttribute("vendorsub");
        }

        window.openDialog("chrome://useragentswitcher/content/options/dialogs/user_agent.xul", "useragentswitcher-user-agent-dialog", "centerscreen,chrome,modal,resizable", "edit", appName, appVersion, selectedItem.label, platform, selectedItem.value, vendor, vendorSub);

        // If the description is set
        if(useragentswitcher_description)
        {
            selectedItem.label = useragentswitcher_description;
            selectedItem.value = useragentswitcher_userAgent;

            selectedItem.setAttribute("appname", useragentswitcher_appName);
            selectedItem.setAttribute("appversion", useragentswitcher_appVersion);
            selectedItem.setAttribute("platform", useragentswitcher_platform);
            selectedItem.setAttribute("vendor", useragentswitcher_vendor);
            selectedItem.setAttribute("vendorsub", useragentswitcher_vendorSub);

            userAgentBox.ensureElementIsVisible(selectedItem);
        }
    }
}

// Exports user agents to an XML file
function useragentswitcher_exportUserAgents()
{
    var filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    var result       = null;
    var stringBundle = document.getElementById("useragentswitcher-string-bundle");

    filePicker.defaultExtension = "xml";
    filePicker.defaultString    = "useragentswitcher.xml";

    filePicker.appendFilter(stringBundle.getString("useragentswitcher_xmlFileDescription"), "*.xml");
    filePicker.init(window, stringBundle.getString("useragentswitcher_exportUserAgentsTitle"), filePicker.modeSave);

    result = filePicker.show();

    // If the user selected a style sheet
    if(result == filePicker.returnOK || result == filePicker.returnReplace)
    {
        var element        = null;
        var file           = filePicker.file;
        var listItem       = null;
        var outputStream   = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
        var pageDocument   = document.getElementById("useragentswitcher-options-iframe").contentDocument;
        var userAgentBox   = pageDocument.getElementById("useragentswitcher-listbox");
        var userAgentCount = userAgentBox.getRowCount();
        var xmlDocument    = document.implementation.createDocument("", "", null);
        var rootElement    = xmlDocument.createElement("useragentswitcher");
        var xmlSerializer  = new XMLSerializer();

        // If the file does not exist
        if(!file.exists())
        {
            file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 00644);
        }

        // Loop through the possible user agents
        for(var i = 1; i <= userAgentCount; i++)
        {
            element  = xmlDocument.createElement("useragent");
            listItem = userAgentBox.getItemAtIndex(i - 1);

            element.setAttribute("description", listItem.label.trim());
            element.setAttribute("useragent", listItem.value.trim());

            // If the list item has an app name attribute
            if(listItem.hasAttribute("appname"))
            {
                element.setAttribute("appname", listItem.getAttribute("appname").trim());
            }

            // If the selected item has an app version attribute
            if(listItem.hasAttribute("appversion"))
            {
                element.setAttribute("appversion", listItem.getAttribute("appversion").trim());
            }

            // If the selected item has a platform attribute
            if(listItem.hasAttribute("platform"))
            {
                element.setAttribute("platform", listItem.getAttribute("platform").trim());
            }

            // If the selected item has a vendor attribute
            if(listItem.hasAttribute("vendor"))
            {
                element.setAttribute("vendor", listItem.getAttribute("vendor").trim());
            }

            // If the selected item has a vendorsub attribute
            if(listItem.hasAttribute("vendorsub"))
            {
                element.setAttribute("vendorsub", listItem.getAttribute("vendorsub").trim());
            }

            rootElement.appendChild(element);
        }

        xmlDocument.appendChild(rootElement);

        outputStream.init(file, 0x04 | 0x08 | 0x20, 00644, null);
        xmlSerializer.serializeToStream(xmlDocument, outputStream, "utf-8");
        outputStream.close();
    }
}

// Evaluates the specified xpath on the specified element returning an array of the matching elements
function useragentswitcher_evaluateXPath(expression, element)
{
    var evaluationResults = null;
    var matchingElement   = null;
    var matchingElements  = new Array();
    var ownerDocument     = element.ownerDocument;
    var xPathEvaluator    = new XPathEvaluator();
    var resolver          = xPathEvaluator.createNSResolver(element.documentElement);

    evaluationResults = xPathEvaluator.evaluate(expression, element, resolver, 0, null);

    // While there are more matching elements
    while((matchingElement = evaluationResults.iterateNext()) != null)
    {
        matchingElements.push(matchingElement);
    }

    return matchingElements;
}

// Imports user agents from an XML file
function useragentswitcher_importUserAgents()
{
    var filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    var stringBundle = document.getElementById("useragentswitcher-string-bundle");

    filePicker.appendFilter(stringBundle.getString("useragentswitcher_xmlFileDescription"), "*.xml");
    filePicker.init(window, stringBundle.getString("useragentswitcher_importUserAgentsTitle"), filePicker.modeOpen);

    // If the user selected an XML file
    if(filePicker.show() == filePicker.returnOK)
    {
        var file     = filePicker.file;
        var filePath = file.path;

        // If the file exists, is a file and is readable
        if(file.exists() && file.isFile() && file.isReadable())
        {
            var request     = new XMLHttpRequest();
            var xmlDocument = null;

            request.open("get", "file://" + filePath, false);
            request.send(null);

            xmlDocument = request.responseXML;

            // If the file could not be parsed correctly
            if(xmlDocument.documentElement.nodeName == "parsererror")
            {
                alert(stringBundle.getFormattedString("useragentswitcher_importParserError", [filePath]));
            }
            else
            {
                var appName          = null;
                var appVersion       = null;
                var newItem          = null;
                var pageDocument     = document.getElementById("useragentswitcher-options-iframe").contentDocument;
                var platform         = null;
                var userAgent        = null;
                var userAgentBox     = pageDocument.getElementById("useragentswitcher-listbox");
                var userAgentElement = null;
                var userAgents       = useragentswitcher_evaluateXPath("//useragent", xmlDocument);
                var vendor           = null;
                var vendorSub        = null;

                // If no user agents were found
                if(userAgents.length == 0)
                {
                    alert(stringBundle.getFormattedString("useragentswitcher_importParserError", [filePath]));
                }
                else if(pageDocument.getElementById("useragentswitcher.import.overwrite").checked)
                {
                    // While there are user agents
                    while(userAgentBox.getRowCount() > 0)
                    {
                        userAgentBox.removeItemAt(0);
                    }
                }

                // Loop through the user agents
                for(var i in userAgents)
                {
                    userAgentElement = userAgents[i];

                    // If the user agent has a description
                    if(userAgentElement.hasAttribute("description"))
                    {
                        appName    = "";
                        appVersion = "";
                        platform   = "";
                        userAgent  = "";
                        vendor     = "";
                        vendorSub  = "";

                        // If the user agent element has an app name attribute
                        if(userAgentElement.hasAttribute("appname"))
                        {
                            appName = userAgentElement.getAttribute("appname");
                        }

                        // If the user agent element has an app version attribute
                        if(userAgentElement.hasAttribute("appversion"))
                        {
                            appVersion = userAgentElement.getAttribute("appversion");
                        }

                        // If the user agent element has a platform attribute
                        if(userAgentElement.hasAttribute("platform"))
                        {
                            platform = userAgentElement.getAttribute("platform");
                        }

                        // If the user agent element has a useragent attribute
                        if(userAgentElement.hasAttribute("useragent"))
                        {
                            userAgent = userAgentElement.getAttribute("useragent");
                        }

                        // If the user agent element has a vendor attribute
                        if(userAgentElement.hasAttribute("vendor"))
                        {
                            vendor = userAgentElement.getAttribute("vendor");
                        }

                        // If the user agent element has a vendorsub attribute
                        if(userAgentElement.hasAttribute("vendorsub"))
                        {
                            vendorSub = userAgentElement.getAttribute("vendorsub");
                        }

                        newItem = userAgentBox.appendItem(userAgentElement.getAttribute("description"), userAgent);

                        newItem.setAttribute("appname", appName);
                        newItem.setAttribute("appversion", appVersion);
                        newItem.setAttribute("platform", platform);
                        newItem.setAttribute("vendor", vendor);
                        newItem.setAttribute("vendorsub", vendorSub);
                    }
                }

                userAgentBox.ensureIndexIsVisible(0);
            }
        }
        else
        {
            alert(stringBundle.getFormattedString("useragentswitcher_importFileFailed", [filePath]));
        }
    }
}

// Initializes the general page
function useragentswitcher_initializeGeneral()
{
    var pageDocument = document.getElementById("useragentswitcher-options-iframe").contentDocument;

    // If the hide menu preference is set
    if(typeof useragentswitcher_optionsDataBoolean["useragentswitcher.menu.hide"] != "undefined")
    {
        pageDocument.getElementById("useragentswitcher.menu.hide").checked = useragentswitcher_optionsDataBoolean["useragentswitcher.menu.hide"];
    }
    else if(useragentswitcher_isPreferenceSet("useragentswitcher.menu.hide"))
    {
        pageDocument.getElementById("useragentswitcher.menu.hide").checked = useragentswitcher_getBooleanPreference("useragentswitcher.menu.hide", true);
    }
    else
    {
        pageDocument.getElementById("useragentswitcher.menu.hide").checked = false;
    }
}

// Initializes the options dialog box
function useragentswitcher_initializeOptions()
{
    var selectedPage = document.getElementById("useragentswitcher-page-list").selectedItem.getAttribute("value");

    // If this is the general page
    if(selectedPage.indexOf("general") != -1)
    {
        useragentswitcher_initializeGeneral();
    }
    else if(selectedPage.indexOf("user_agents") != -1)
    {
        useragentswitcher_initializeUserAgents();
    }
}

// Initializes the user agents page
function useragentswitcher_initializeUserAgents()
{
    var appName          = null;
    var appNameValue     = null;
    var appVersion       = null;
    var appVersionValue  = null;
    var description      = null;
    var descriptionValue = null;
    var listItem         = null;
    var pageDocument     = document.getElementById("useragentswitcher-options-iframe").contentDocument;
    var platform         = null;
    var platformValue    = null;
    var userAgent        = null;
    var userAgentBox     = pageDocument.getElementById("useragentswitcher-listbox");
    var userAgentCount   = 0;
    var userAgentValue   = null;
    var vendor           = null;
    var vendorSub        = null;
    var vendorSubValue   = null;
    var vendorValue      = null;

    // If the user agents count preference is set
    if(typeof useragentswitcher_optionsDataInteger["useragentswitcher.user.agents.count"] != "undefined")
    {
        userAgentCount = useragentswitcher_optionsDataInteger["useragentswitcher.user.agents.count"];
    }
    else if(useragentswitcher_isPreferenceSet("useragentswitcher.user.agents.count"))
    {
        userAgentCount = useragentswitcher_getIntegerPreference("useragentswitcher.user.agents.count", true);
    }

    // Loop through the possible user agents
    for(var i = 1; i <= userAgentCount; i++)
    {
	    appName     = "useragentswitcher." + i + ".appname";
	    appVersion  = "useragentswitcher." + i + ".appversion";
	    description = "useragentswitcher." + i + ".description";
	    platform    = "useragentswitcher." + i + ".platform";
	    userAgent   = "useragentswitcher." + i + ".useragent";
	    vendor      = "useragentswitcher." + i + ".vendor";
	    vendorSub   = "useragentswitcher." + i + ".vendorsub";

        // If the app name is set
        if(typeof useragentswitcher_optionsDataString[appName] != "undefined")
        {
            appNameValue = useragentswitcher_optionsDataString[appName].trim();
        }
        else if(useragentswitcher_isPreferenceSet(appName))
        {
	        appNameValue = useragentswitcher_getStringPreference(appName, true);
        }
        else
        {
            appNameValue = null;
        }

        // If the app version is set
        if(typeof useragentswitcher_optionsDataString[appVersion] != "undefined")
        {
            appVersionValue = useragentswitcher_optionsDataString[appVersion].trim();
        }
        else if(useragentswitcher_isPreferenceSet(appVersion))
        {
	        appVersionValue = useragentswitcher_getStringPreference(appVersion, true);
        }
        else
        {
            appVersionValue = null;
        }

        // If the description is set
        if(typeof useragentswitcher_optionsDataString[description] != "undefined")
        {
            descriptionValue = useragentswitcher_optionsDataString[description].trim();
        }
        else if(useragentswitcher_isPreferenceSet(description))
        {
	        descriptionValue = useragentswitcher_getStringPreference(description, true);
        }
        else
        {
            descriptionValue = null;
        }

        // If the platform is set
        if(typeof useragentswitcher_optionsDataString[platform] != "undefined")
        {
            platformValue = useragentswitcher_optionsDataString[platform].trim();
        }
        else if(useragentswitcher_isPreferenceSet(platform))
        {
	        platformValue = useragentswitcher_getStringPreference(platform, true);
        }
        else
        {
            platformValue = null;
        }

        // If the user agent is set
        if(typeof useragentswitcher_optionsDataString[userAgent] != "undefined")
        {
            userAgentValue = useragentswitcher_optionsDataString[userAgent].trim();
        }
        else if(useragentswitcher_isPreferenceSet(userAgent))
        {
	        userAgentValue = useragentswitcher_getStringPreference(userAgent, true);
        }
        else
        {
            userAgentValue = null;
        }

        // If the vendor is set
        if(typeof useragentswitcher_optionsDataString[vendor] != "undefined")
        {
            vendorValue = useragentswitcher_optionsDataString[vendor].trim();
        }
        else if(useragentswitcher_isPreferenceSet(vendor))
        {
	        vendorValue = useragentswitcher_getStringPreference(vendor, true);
        }
        else
        {
            vendorValue = null;
        }

        // If the vendor sub is set
        if(typeof useragentswitcher_optionsDataString[vendorSub] != "undefined")
        {
            vendorSubValue = useragentswitcher_optionsDataString[vendorSub].trim();
        }
        else if(useragentswitcher_isPreferenceSet(vendorSub))
        {
	        vendorSubValue = useragentswitcher_getStringPreference(vendorSub, true);
        }
        else
        {
            vendorSubValue = null;
        }

        // If the description is set
        if(descriptionValue)
        {
            listItem = userAgentBox.appendItem(descriptionValue, userAgentValue);

            listItem.setAttribute("appname", appNameValue);
            listItem.setAttribute("appversion", appVersionValue);
            listItem.setAttribute("platform", platformValue);
            listItem.setAttribute("vendor", vendorValue);
            listItem.setAttribute("vendorsub", vendorSubValue);
        }
    }

    // If the import overwrite preference is set
    if(typeof useragentswitcher_optionsDataBoolean["useragentswitcher.import.overwrite"] != "undefined")
    {
        pageDocument.getElementById("useragentswitcher.import.overwrite").checked = useragentswitcher_optionsDataBoolean["useragentswitcher.import.overwrite"];
    }
    else if(useragentswitcher_isPreferenceSet("useragentswitcher.import.overwrite"))
    {
        pageDocument.getElementById("useragentswitcher.import.overwrite").checked = useragentswitcher_getBooleanPreference("useragentswitcher.import.overwrite", true);
    }
    else
    {
        pageDocument.getElementById("useragentswitcher.import.overwrite").checked = false;
    }

    useragentswitcher_userAgentBoxSelected();
}

// Moves the selected item down
function useragentswitcher_moveDown()
{
    var pageDocument   = document.getElementById("useragentswitcher-options-iframe").contentDocument;
    var userAgentBox   = pageDocument.getElementById("useragentswitcher-listbox");
    var selectedIndex  = userAgentBox.selectedIndex;
    var selectedItem   = userAgentBox.selectedItem;
    var userAgentCount = userAgentBox.getRowCount();

    // If an item is selected and it is not at the bottom
    if(selectedItem && selectedIndex != userAgentCount - 1)
    {
        userAgentBox.selectItem(userAgentBox.insertBefore(selectedItem, userAgentBox.getNextItem(selectedItem, 2)));
    }
}

// Moves the selected item up
function useragentswitcher_moveUp()
{
    var pageDocument  = document.getElementById("useragentswitcher-options-iframe").contentDocument;
    var userAgentBox  = pageDocument.getElementById("useragentswitcher-listbox");
    var selectedIndex = userAgentBox.selectedIndex;
    var selectedItem  = userAgentBox.selectedItem;

    // If an item is selected and it is not at the top
    if(selectedItem && selectedIndex != 0)
    {
        userAgentBox.selectItem(userAgentBox.insertBefore(selectedItem, userAgentBox.getPreviousItem(selectedItem, 1)));
    }
}

// Resets the user's options
function useragentswitcher_resetOptions()
{
    var promptServiceInterface = Components.interfaces.nsIPromptService;
    var stringBundle           = document.getElementById("useragentswitcher-string-bundle");

    // If the reset is confirmed
    if(Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(promptServiceInterface).confirmEx(null, stringBundle.getString("useragentswitcher_resetConfirmation"), stringBundle.getString("useragentswitcher_resetConfirmationMessage"), promptServiceInterface.BUTTON_TITLE_IS_STRING * promptServiceInterface.BUTTON_POS_0 + promptServiceInterface.BUTTON_TITLE_CANCEL * promptServiceInterface.BUTTON_POS_1, stringBundle.getString("useragentswitcher_reset"), null, null, null, {}) == 0)
    {
        useragentswitcher_localizedOptionsSetup = false;
        useragentswitcher_optionsDataBoolean    = new Array();
        useragentswitcher_optionsDataInteger    = new Array();
        useragentswitcher_optionsDataString     = new Array();

        useragentswitcher_deletePreferenceBranch("useragentswitcher.");

        useragentswitcher_setupLocalizedOptions();
        useragentswitcher_initializeOptions();
    }
}

// Saves the user's options
function useragentswitcher_saveOptions()
{
    var option      = null;
    var optionValue = null;

    // Make sure current page is stored
    useragentswitcher_storeOptions();

    // Loop through the boolean options
    for(option in useragentswitcher_optionsDataBoolean)
    {
        useragentswitcher_setBooleanPreference(option, useragentswitcher_optionsDataBoolean[option]);
    }

    // Loop through the integer options
    for(option in useragentswitcher_optionsDataInteger)
    {
        optionValue = useragentswitcher_optionsDataInteger[option];

        // If the option value is set
        if(optionValue)
        {
            useragentswitcher_setIntegerPreference(option, optionValue);
        }
        else if(useragentswitcher_isPreferenceSet(option))
        {
            useragentswitcher_deletePreference(option);
        }
    }

    // Loop through the string options
    for(option in useragentswitcher_optionsDataString)
    {
        optionValue = useragentswitcher_optionsDataString[option];

        // If the option value is set or the preference currently has a value
        if(optionValue || useragentswitcher_isPreferenceSet(option))
        {
            useragentswitcher_setStringPreference(option, optionValue);
        }
    }
}

// Stores the user's options to be saved later
function useragentswitcher_storeOptions()
{
    var iFrame       = document.getElementById("useragentswitcher-options-iframe");
    var iFrameSrc    = iFrame.getAttribute("src");
    var pageDocument = iFrame.contentDocument;

    // If this is the general page
    if(iFrameSrc.indexOf("general") != -1)
    {
        useragentswitcher_optionsDataBoolean["useragentswitcher.menu.hide"] = pageDocument.getElementById("useragentswitcher.menu.hide").checked;
    }
    else if(iFrameSrc.indexOf("user_agents") != -1)
    {
        var appName        = null;
        var appVersion     = null;
        var description    = null;
        var listItem       = null;
        var platform       = null;
        var userAgent      = null;
        var userAgentBox   = pageDocument.getElementById("useragentswitcher-listbox");
        var userAgentCount = 0;
        var vendor         = null;
        var vendorSub      = null;

        // If the user agents count preference is set
        if(useragentswitcher_isPreferenceSet("useragentswitcher.user.agents.count"))
        {
            userAgentCount = useragentswitcher_getIntegerPreference("useragentswitcher.user.agents.count", true);
        }

        // Loop through the previous user agents
        for(var i = 1; i <= userAgentCount; i++)
        {
            appName     = "useragentswitcher." + i + ".appname";
            appVersion  = "useragentswitcher." + i + ".appversion";
            description = "useragentswitcher." + i + ".description";
            platform    = "useragentswitcher." + i + ".platform";
            userAgent   = "useragentswitcher." + i + ".useragent";
            vendor      = "useragentswitcher." + i + ".vendor";
            vendorSub   = "useragentswitcher." + i + ".vendorsub";

            useragentswitcher_optionsDataString[appName]     = "";
            useragentswitcher_optionsDataString[appVersion]  = "";
            useragentswitcher_optionsDataString[description] = "";
            useragentswitcher_optionsDataString[platform]    = "";
            useragentswitcher_optionsDataString[userAgent]   = "";
            useragentswitcher_optionsDataString[vendor]      = "";
            useragentswitcher_optionsDataString[vendorSub]   = "";
        }

        userAgentCount = userAgentBox.getRowCount();

        // Loop through the possible user agents
        for(i = 1; i <= userAgentCount; i++)
        {
            appName     = "useragentswitcher." + i + ".appname";
            appVersion  = "useragentswitcher." + i + ".appversion";
            description = "useragentswitcher." + i + ".description";
            listItem    = userAgentBox.getItemAtIndex(i - 1);
            platform    = "useragentswitcher." + i + ".platform";
            userAgent   = "useragentswitcher." + i + ".useragent";
            vendor      = "useragentswitcher." + i + ".vendor";
            vendorSub   = "useragentswitcher." + i + ".vendorsub";

            // If the list item has an app name attribute
            if(listItem.hasAttribute("appname"))
            {
                useragentswitcher_optionsDataString[appName] = listItem.getAttribute("appname").trim();
            }

            // If the selected item has an app version attribute
            if(listItem.hasAttribute("appversion"))
            {
                useragentswitcher_optionsDataString[appVersion] = listItem.getAttribute("appversion").trim();
            }

            // If the selected item has a platform attribute
            if(listItem.hasAttribute("platform"))
            {
                useragentswitcher_optionsDataString[platform] = listItem.getAttribute("platform").trim();
            }

            // If the selected item has a vendor attribute
            if(listItem.hasAttribute("vendor"))
            {
                useragentswitcher_optionsDataString[vendor] = listItem.getAttribute("vendor").trim();
            }

            // If the selected item has a vendorsub attribute
            if(listItem.hasAttribute("vendorsub"))
            {
                useragentswitcher_optionsDataString[vendorSub] = listItem.getAttribute("vendorsub").trim();
            }

            useragentswitcher_optionsDataString[description] = listItem.label.trim();
            useragentswitcher_optionsDataString[userAgent]   = listItem.value.trim();
        }

        useragentswitcher_optionsDataBoolean["useragentswitcher.import.overwrite"]  = pageDocument.getElementById("useragentswitcher.import.overwrite").checked;
        useragentswitcher_optionsDataInteger["useragentswitcher.user.agents.count"] = userAgentCount;
    }
}

// Called whenever the user agent box is selected
function useragentswitcher_userAgentBoxSelected()
{
    var pageDocument   = document.getElementById("useragentswitcher-options-iframe").contentDocument;
    var deleteButton   = pageDocument.getElementById("useragentswitcher-delete");
    var editButton     = pageDocument.getElementById("useragentswitcher-edit");
    var listBox        = pageDocument.getElementById("useragentswitcher-listbox");
    var moveDownButton = pageDocument.getElementById("useragentswitcher-move-down");
    var moveUpButton   = pageDocument.getElementById("useragentswitcher-move-up");
    var selectedIndex  = listBox.selectedIndex;

    // If an item is selected
    if(listBox.selectedItem)
    {
        deleteButton.disabled   = false;
        editButton.disabled     = false;

        // If this is the first item
        if(selectedIndex == 0)
        {
            moveUpButton.disabled = true;
        }
        else
        {
            moveUpButton.disabled = false;
        }

        // If this is the last item
        if(selectedIndex == listBox.getRowCount() - 1)
        {
            moveDownButton.disabled = true;
        }
        else
        {
            moveDownButton.disabled = false;
        }
    }
    else
    {
        deleteButton.disabled   = true;
        editButton.disabled     = true;
        moveDownButton.disabled = true;
        moveUpButton.disabled   = true;
    }
}

// Views the default user agent
function useragentswitcher_viewDefault()
{
    window.openDialog("chrome://useragentswitcher/content/options/dialogs/user_agent.xul", "useragentswitcher-user-agent-dialog", "centerscreen,chrome,modal,resizable", "default");
}
