/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010 Canonical Ltd.
 * Copyright (C) 2010 Henrik Rydberg <rydberg@bitmath.org>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef _GRAIL_TOUCH_H
#define _GRAIL_TOUCH_H

#include <grail-bits.h>
#include <mtdev.h>

#define DIM_TOUCH 32
#define DIM_TOUCH_BYTES ((DIM_TOUCH + 7) >> 3)

typedef __u64 touch_time_t;

struct touch {
	int active;
	int slot;
	int id;
	int tool_type;
	int x, y;
	int touch_major;
	int touch_minor;
	int width_major;
	int width_minor;
	int orientation;
	int pressure;
};

struct touch_frame {
	int nactive;
	int ncreate, nmodify, ndestroy;
	touch_time_t time;
	grail_mask_t touches[DIM_TOUCH_BYTES];
	struct touch *active[DIM_TOUCH];
	struct touch touch[DIM_TOUCH];
};

struct touch_caps {
	float min_x, max_x;
	float min_y, max_y;
	float min_orient, max_orient;
	float min_press, max_press;
};

struct touch_dev {
	void (*event)(struct touch_dev *dev, const struct input_event *ev);
	void (*sync)(struct touch_dev *dev, const struct input_event *syn);
	void *priv;
	struct mtdev mtdev;
	struct touch_frame frame;
	struct touch_caps caps;
	int slot;
	int state;
};

int touch_caps_is_supported(struct touch_dev *dev, int fd);
void touch_caps_init(struct touch_dev *dev);
float touch_angle(const struct touch_dev *dev, int orientation);
float touch_pressure(const struct touch_dev *dev, int pressure);

int touch_dev_open(struct touch_dev *dev, int fd);
int touch_dev_idle(struct touch_dev *dev, int fd, int ms);
int touch_dev_pull(struct touch_dev *dev, int fd);
void touch_dev_close(struct touch_dev *dev, int fd);

#endif
