#!/bin/bash

case $1 in
  0) #ACCELERATION
     xset -q | grep acceleration |perl -ne 'print $2 if /(.*?)(\d+.\d+)/'
     ;;

  1) #THRESHOLD
     xset -q | grep threshold |perl -ne 'print $2 if /threshold:(.*?)(\d+)/'
     ;;

  2) #NUMPOINTER
     xmodmap -pp | grep pointer | perl -ne 'print $1 if /(\d+)/'
     ;;
  3) #POINTER
     xmodmap -pp | perl -ne 'print "$3 " if /(\d+)(\s+)(\d+)/'
     ;;
  4) #DataCount
     cat $2 | grep "DataCount" -m 1| perl -ne 'print $1 if /(\d+)/'
     ;;
  5) #grep
     grep $2 $3
     ;;
  6) #AC Adapter
     acpi -a -B |perl -ne 'print $2 if /AC Adapter(.*?)(\w+\-\w+)/'
     ;;
  7) #Battery
     acpi -b -A |perl -ne 'print $2 if /Battery(.*?)(\d+%)/'
     ;;
esac
exit 0
