// Opens the URL in a new tab
function webdeveloper_openURL(urlElement)
{
    var parentWindow = null;
    var url          = urlElement.firstChild.nodeValue;

    // If there is a parent window
    if(window.opener)
    {
        // If there is a grand parent window
        if(window.opener.opener)
        {
            parentWindow = window.opener.opener;
        }
        else
        {
            parentWindow = window.opener;
        }
    }

    // If a parent window was found
    if(parentWindow)
    {
        // If the open in windows preference is set to true
        if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs", true))
        {
            var newTab = parentWindow.getBrowser().addTab(url);

            // If the open tabs in background preference is not set or is set to false
            if(!webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
            {
                parentWindow.getBrowser().selectedTab = newTab;
            }
        }
        else
        {
            parentWindow.open(url);
        }

        window.close();
    }
}
