/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.HeadingMap;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class InlineConverter
extends ConverterHelper {
    private String sTabstop = " ";
    private boolean bHasPdfannotation = false;

    public InlineConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
        if (config.getTabstop().length() > 0) {
            this.sTabstop = config.getTabstop();
        }
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bHasPdfannotation) {
            decl.append("\\newcommand\\pdfannotation[1]").append("{\\ifx\\pdfoutput\\undefined\\marginpar{#1}\\else").append("\\pdfstringdef\\tempstring{#1}\\marginpar{").append("\\pdfannot width 5cm height 12pt depth 4cm ").append("{ /Subtype /Text /Open false /Contents(\\tempstring) /Color [1 0 0]}").append("}\\fi}").nl();
        }
    }

    public void traverseInlineText(Element node, LaTeXDocumentPortion ldp, Context oc, boolean styled) {
        String styleName;
        block19: {
            block18: {
                styleName = node.getAttribute("text:style-name");
                if (styled) {
                    String sDisplayName = this.ofr.getTextStyles().getDisplayName(styleName);
                    if (this.config.otherStyles() != 1 && !this.config.getTextStyleMap().contains(sDisplayName)) {
                        if (this.config.otherStyles() == 2) {
                            System.err.println("Warning: Text with style " + sDisplayName + " was ignored");
                        } else if (this.config.otherStyles() == 3) {
                            ldp.append("% Error in source document: Text with style ").append(this.palette.getI18n().convert(sDisplayName, false, oc.getLang())).append(" was ignored").nl();
                        }
                        return;
                    }
                }
                if (this.onlyNote(node)) break block18;
                if (OfficeReader.getCharacterCount(node) != 0) break block19;
            }
            styled = false;
        }
        if (oc.isVerbatim()) {
            styled = false;
        }
        boolean bNoFootnotes = false;
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getTextStyle(styleName)));
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        if (styled) {
            this.palette.getCharSc().applyTextStyle(styleName, ba, ic);
        }
        if (styled && !ic.isInFootnote()) {
            bNoFootnotes = true;
        }
        StyleWithProperties style = this.ofr.getTextStyle(styleName);
        if (this.ofr.isPackageFormat() && style != null && style.isAutomatic() && ic.isInHeaderFooter()) {
            styled = false;
        }
        if (styled) {
            if (bNoFootnotes) {
                ic.setNoFootnotes(true);
            }
            ldp.append(ba.getBefore());
        }
        if (ic.isVerbatim()) {
            this.traverseVerbatimInlineText(node, ldp, ic);
        } else {
            this.traverseOrdinaryInlineText(node, ldp, ic);
        }
        if (styled) {
            ldp.append(ba.getAfter());
            ic.setNoFootnotes(false);
            if (!ic.isInFootnote()) {
                this.palette.getNoteCv().flushFootnotes(ldp, oc);
            }
        }
        this.palette.getFieldCv().flushReferenceMarks(ldp, oc);
        this.palette.getIndexCv().flushIndexMarks(ldp, oc);
        this.palette.getI18n().popSpecialTable();
    }

    private void traverseOrdinaryInlineText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node childNode = nList.item(i);
                short nodeType = childNode.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = childNode.getNodeValue();
                        if (s.length() <= 0) break;
                        ldp.append(this.palette.getI18n().convert(s, false, oc.getLang()));
                        break;
                    }
                    case 1: {
                        Element child = (Element)childNode;
                        String sName = child.getTagName();
                        if (child.getNodeName().startsWith("draw:")) {
                            this.palette.getDrawCv().handleDrawElement(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:s")) {
                            if (this.config.ignoreDoubleSpaces()) {
                                ldp.append(" ");
                                break;
                            }
                            int count = Misc.getPosInteger(child.getAttribute("text:c"), 1);
                            String sSpace = this.config.ignoreDoubleSpaces() ? " " : "\\ ";
                            while (count > 0) {
                                ldp.append("\\ ");
                                --count;
                            }
                            break;
                        }
                        if (sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                            if (oc.isInHeaderFooter()) {
                                ldp.append("\\hfill ");
                                break;
                            }
                            ldp.append(this.sTabstop);
                            break;
                        }
                        if (sName.equals("text:line-break")) {
                            if (!oc.isInHeaderFooter() && !this.config.ignoreHardLineBreaks()) {
                                ldp.append("\\newline").nl();
                                break;
                            }
                            ldp.append(" ");
                            break;
                        }
                        if (sName.equals("text:span")) {
                            this.traverseInlineText(child, ldp, oc, true);
                            break;
                        }
                        if (sName.equals("text:a")) {
                            this.palette.getFieldCv().handleAnchor(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("office:annotation")) {
                            this.handleOfficeAnnotation(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:page-number")) {
                            this.palette.getFieldCv().handlePageNumber(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:page-count")) {
                            this.palette.getFieldCv().handlePageCount(child, ldp, oc);
                            break;
                        }
                        if (oc.isInHeaderFooter()) {
                            if (sName.equals("text:chapter")) {
                                this.handleChapterField(child, ldp, oc);
                                break;
                            }
                            if (!sName.startsWith("text:")) break;
                            this.traverseInlineText(child, ldp, oc, false);
                            break;
                        }
                        if (sName.equals("text:footnote")) {
                            this.palette.getNoteCv().handleFootnote(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:endnote")) {
                            this.palette.getNoteCv().handleEndnote(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:note")) {
                            if ("endnote".equals(child.getAttribute("text:note-class"))) {
                                this.palette.getNoteCv().handleEndnote(child, ldp, oc);
                                break;
                            }
                            this.palette.getNoteCv().handleFootnote(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:sequence")) {
                            this.palette.getFieldCv().handleSequence(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:sequence-ref")) {
                            this.palette.getFieldCv().handleSequenceRef(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:footnote-ref")) {
                            this.palette.getNoteCv().handleFootnoteRef(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:endnote-ref")) {
                            this.palette.getNoteCv().handleEndnoteRef(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:note-ref")) {
                            this.palette.getNoteCv().handleNoteRef(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:reference-mark")) {
                            this.palette.getFieldCv().handleReferenceMark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:reference-mark-start")) {
                            this.palette.getFieldCv().handleReferenceMark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:reference-ref")) {
                            this.palette.getFieldCv().handleReferenceRef(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:bookmark")) {
                            this.palette.getFieldCv().handleBookmark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:bookmark-start")) {
                            this.palette.getFieldCv().handleBookmark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:bookmark-ref")) {
                            this.palette.getFieldCv().handleBookmarkRef(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:bibliography-mark")) {
                            this.palette.getIndexCv().handleBibliographyMark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark-start")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, oc);
                            break;
                        }
                        if (!sName.startsWith("text:")) break;
                        this.traverseInlineText(child, ldp, oc, false);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void traversePlainInlineText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String styleName = node.getAttribute("text:style-name");
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getTextStyle(styleName)));
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node childNode = nList.item(i);
                short nodeType = childNode.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = childNode.getNodeValue();
                        if (s.length() <= 0) break;
                        int j = 0;
                        while (j < s.length()) {
                            if (s.charAt(j) != ']') {
                                ldp.append(this.palette.getI18n().convert(s.charAt(j), false, oc.getLang()));
                            } else {
                                ldp.append("{]}");
                            }
                            ++j;
                        }
                        break;
                    }
                    case 1: {
                        Element child = (Element)childNode;
                        String sName = child.getTagName();
                        if (sName.equals("text:s")) {
                            int count = Misc.getPosInteger(child.getAttribute("text:c"), 1);
                            while (count > 0) {
                                ldp.append("\\ ");
                                --count;
                            }
                            break;
                        }
                        if (sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                            ldp.append(this.sTabstop);
                            break;
                        }
                        if (OfficeReader.isNoteElement(child)) break;
                        if (!OfficeReader.isTextElement(child)) break;
                        this.traversePlainInlineText(child, ldp, oc);
                        break;
                    }
                }
                ++i;
            }
        }
        this.palette.getI18n().popSpecialTable();
    }

    private void traverseVerbatimInlineText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node childNode = nList.item(i);
                short nodeType = childNode.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = childNode.getNodeValue();
                        if (s.length() <= 0) break;
                        ldp.append(s);
                        break;
                    }
                    case 1: {
                        Element child = (Element)childNode;
                        String sName = child.getTagName();
                        if (sName.equals("text:s")) {
                            int count = Misc.getPosInteger(child.getAttribute("text:c"), 1);
                            while (count > 0) {
                                ldp.append(" ");
                                --count;
                            }
                            break;
                        }
                        if (sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                            ldp.append(this.sTabstop);
                            break;
                        }
                        if (sName.equals("text:line-break")) {
                            if (oc.isNoLineBreaks()) break;
                            ldp.nl();
                            break;
                        }
                        if (sName.equals("text:note") || sName.equals("text:footnote") || sName.equals("text:endnote")) break;
                        if (sName.equals("text:alphabetical-index-mark")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark-start")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:reference-mark")) {
                            this.palette.getFieldCv().handleReferenceMark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:reference-mark-start")) {
                            this.palette.getFieldCv().handleReferenceMark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:bookmark")) {
                            this.palette.getFieldCv().handleBookmark(child, ldp, oc);
                            break;
                        }
                        if (sName.equals("text:bookmark-start")) {
                            this.palette.getFieldCv().handleBookmark(child, ldp, oc);
                            break;
                        }
                        if (!sName.startsWith("text:")) break;
                        this.traverseVerbatimInlineText(child, ldp, oc);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void traversePCDATA(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                if (nl.item(i).getNodeType() == 3) {
                    ldp.append(this.palette.getI18n().convert(nl.item(i).getNodeValue(), false, oc.getLang()));
                }
                ++i;
            }
        }
    }

    private void handleChapterField(Element node, LaTeXDocumentPortion ldp, Context oc) {
        HeadingMap hm = this.config.getHeadingMap();
        int nLevel = Misc.getPosInteger(node.getAttribute("text:outline-level"), 1);
        if (nLevel <= hm.getMaxLevel()) {
            int nLaTeXLevel = hm.getLevel(nLevel);
            if (nLaTeXLevel == 1) {
                this.palette.getPageSc().setChapterField1(node.getAttribute("text:display"));
                ldp.append("{\\leftmark}");
            } else if (nLaTeXLevel == 2) {
                this.palette.getPageSc().setChapterField2(node.getAttribute("text:display"));
                ldp.append("{\\rightmark}");
            }
        }
    }

    private void handleOfficeAnnotation(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Element paragraph = Misc.getChildByTagName(node, "text:p");
        if (paragraph == null) {
            return;
        }
        String sCommand = null;
        switch (this.config.notes()) {
            case 0: {
                return;
            }
            case 1: {
                ldp.append("%").nl().append("%");
                this.traversePCDATA(paragraph, ldp, oc);
                ldp.nl();
                return;
            }
            case 2: {
                this.bHasPdfannotation = true;
                sCommand = "\\pdfannotation";
                break;
            }
            case 3: {
                sCommand = "\\marginpar";
                break;
            }
            case 4: {
                sCommand = this.config.getNotesCommand();
            }
        }
        ldp.append(sCommand).append("{");
        this.traversePCDATA(paragraph, ldp, oc);
        ldp.append("}");
    }

    private boolean onlyNote(Node node) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList nList = node.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nList.item(i);
            short nType = child.getNodeType();
            switch (nType) {
                case 3: {
                    return false;
                }
                case 1: {
                    if (OfficeReader.isNoteElement(child)) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

