/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.mozilla.javascript.tools.debugger.Main;

class MyTableModel
extends AbstractTableModel {
    Main db;
    Vector expressions;
    Vector values;

    MyTableModel(Main main) {
        this.db = main;
        this.expressions = new Vector();
        this.values = new Vector();
        this.expressions.addElement("");
        this.values.addElement("");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.expressions.size();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Expression";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.expressions.elementAt(n);
            }
            case 1: {
                return this.values.elementAt(n);
            }
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                String string = object.toString();
                this.expressions.setElementAt(string, n);
                String string2 = "";
                if (string.length() > 0 && (string2 = this.db.eval(string)) == null) {
                    string2 = "";
                }
                this.values.setElementAt(string2, n);
                this.updateModel();
                if (n + 1 != this.expressions.size()) break;
                this.expressions.addElement("");
                this.values.addElement("");
                this.fireTableRowsInserted(n + 1, n + 1);
                break;
            }
            case 1: {
                this.fireTableDataChanged();
            }
        }
    }

    void updateModel() {
        int n = 0;
        while (n < this.expressions.size()) {
            Object e = this.expressions.elementAt(n);
            String string = e.toString();
            String string2 = "";
            if (string.length() > 0) {
                string2 = this.db.eval(string);
                if (string2 == null) {
                    string2 = "";
                }
            } else {
                string2 = "";
            }
            string2 = string2.replace('\n', ' ');
            this.values.setElementAt(string2, n);
            ++n;
        }
        this.fireTableDataChanged();
    }
}

